# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['blendmodes']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=8.0.1,<10', 'data-science-types>=0.2.19,<2', 'numpy>=1.19.3,<3']

setup_kwargs = {
    'name': 'blendmodes',
    'version': '2020.3.0',
    'description': 'Use this module to apply a number of blending modes to a background and foreground image',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/BlendModes.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/7df4678b2a2145119898ce3a9be8b5fc.svg?style=for-the-badge)](https://www.codacy.com/gh/FHPythonUtils/BlendModes)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/BlendModes.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/BlendModes.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/BlendModes.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/BlendModes.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/BlendModes.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/blendmodes.svg?style=for-the-badge)](https://pypi.org/project/blendmodes/)\n[![PyPI Version](https://img.shields.io/pypi/v/blendmodes.svg?style=for-the-badge)](https://pypi.org/project/blendmodes/)\n\n<!-- omit in TOC -->\n# BlendModes\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nUse this module to apply a number of blending modes to a background and\nforeground image.\n\n## Credits\n\nCredits to:\n\n### MIT License Copyright (c) 2019 Paul Jewell\nFor implementing blending from the Open Raster Image Spec\n\n### MIT License Copyright (c) 2018 Addison Elliott\nFor implementing blending from Paint.NET\n\n### MIT License Copyright (c) 2017 pashango\nFor implementing a number of blending functions used by other popular image\neditors\n\n- [Credits](#credits)\n\t- [MIT License Copyright (c) 2019 Paul Jewell](#mit-license-copyright-c-2019-paul-jewell)\n\t- [MIT License Copyright (c) 2018 Addison Elliott](#mit-license-copyright-c-2018-addison-elliott)\n\t- [MIT License Copyright (c) 2017 pashango](#mit-license-copyright-c-2017-pashango)\n- [Docs](#docs)\n- [Examples](#examples)\n\t- [Normal](#normal)\n\t- [Multiply](#multiply)\n\t- [Additive](#additive)\n\t- [ColourBurn](#colourburn)\n\t- [ColourDodge](#colourdodge)\n\t- [Reflect](#reflect)\n\t- [Glow](#glow)\n\t- [Overlay](#overlay)\n\t- [Difference](#difference)\n\t- [Negation](#negation)\n\t- [Lighten](#lighten)\n\t- [Darken](#darken)\n\t- [Screen](#screen)\n\t- [XOR](#xor)\n\t- [SoftLight](#softlight)\n\t- [HardLight](#hardlight)\n\t- [GrainExtract](#grainextract)\n\t- [GrainMerge](#grainmerge)\n\t- [Divide](#divide)\n\t- [Hue](#hue)\n\t- [Saturation](#saturation)\n\t- [Colour](#colour)\n\t- [Luminosity](#luminosity)\n\t- [PinLight](#pinlight)\n\t- [VividLight](#vividlight)\n\t- [Exclusion](#exclusion)\n\t- [DestIn](#destin)\n\t- [DestOut](#destout)\n\t- [DestAtop](#destatop)\n\t- [SrcAtop](#srcatop)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download](#download-1)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\n## Docs\nSee the [Docs](/DOCS.md) for more information.\n\n\n\n## Examples\n\nBe sure to include the following for the functions below\n```python\nfrom blendmodes.blend import blendLayers, BlendType\n\nbackground = Image.open(THISDIR + "/background.png")\nforeground = Image.open(THISDIR + "/foreground.png")\n```\n\n### Normal\n\n```python\nblendLayers(background, foreground, BlendType.NORMAL)\n```\n![Normal](test/normal_expected.png)\n\n### Multiply\n\n```python\nblendLayers(background, foreground, BlendType.MULTIPLY)\n```\n![Multiply](test/multiply_expected.png)\n\n### Additive\n\n```python\nblendLayers(background, foreground, BlendType.ADDITIVE)\n```\n![Additive](test/additive_expected.png)\n\n### ColourBurn\n\n```python\nblendLayers(background, foreground, BlendType.COLOURBURN)\n```\n![ColourBurn](test/colourburn_expected.png)\n\n### ColourDodge\n\n```python\nblendLayers(background, foreground, BlendType.COLOURDODGE)\n```\n![ColourDodge](test/colourdodge_expected.png)\n\n### Reflect\n\n```python\nblendLayers(background, foreground, BlendType.REFLECT)\n```\n![Reflect](test/reflect_expected.png)\n\n### Glow\n\n```python\nblendLayers(background, foreground, BlendType.GLOW)\n```\n![Glow](test/glow_expected.png)\n\n### Overlay\n\n```python\nblendLayers(background, foreground, BlendType.OVERLAY)\n```\n![Overlay](test/overlay_expected.png)\n\n### Difference\n\n```python\nblendLayers(background, foreground, BlendType.DIFFERENCE)\n```\n![Difference](test/difference_expected.png)\n\n### Negation\n\n```python\nblendLayers(background, foreground, BlendType.NEGATION)\n```\n![Negation](test/negation_expected.png)\n\n### Lighten\n\n```python\nblendLayers(background, foreground, BlendType.LIGHTEN)\n```\n![Lighten](test/lighten_expected.png)\n\n### Darken\n\n```python\nblendLayers(background, foreground, BlendType.DARKEN)\n```\n![Darken](test/darken_expected.png)\n\n### Screen\n\n```python\nblendLayers(background, foreground, BlendType.SCREEN)\n```\n![Screen](test/screen_expected.png)\n\n### XOR\n\n```python\nblendLayers(background, foreground, BlendType.XOR)\n```\n![XOR](test/xor_expected.png)\n\n### SoftLight\n\n```python\nblendLayers(background, foreground, BlendType.SOFTLIGHT)\n```\n![SoftLight](test/softlight_expected.png)\n\n### HardLight\n\n```python\nblendLayers(background, foreground, BlendType.HARDLIGHT)\n```\n![HardLight](test/hardlight_expected.png)\n\n### GrainExtract\n\n```python\nblendLayers(background, foreground, BlendType.GRAINEXTRACT)\n```\n![GrainExtract](test/grainextract_expected.png)\n\n### GrainMerge\n\n```python\nblendLayers(background, foreground, BlendType.GRAINMERGE)\n```\n![GrainMerge](test/grainmerge_expected.png)\n\n### Divide\n\n```python\nblendLayers(background, foreground, BlendType.DIVIDE)\n```\n![Divide](test/divide_expected.png)\n\n### Hue\n\n```python\nblendLayers(background, foreground, BlendType.HUE)\n```\n![Hue](test/hue_expected.png)\n\n### Saturation\n\n```python\nblendLayers(background, foreground, BlendType.SATURATION)\n```\n![Saturation](test/saturation_expected.png)\n\n### Colour\n\n```python\nblendLayers(background, foreground, BlendType.COLOUR)\n```\n![Colour](test/colour_expected.png)\n\n### Luminosity\n\n```python\nblendLayers(background, foreground, BlendType.LUMINOSITY)\n```\n![Luminosity](test/luminosity_expected.png)\n\n### PinLight\n\n```python\nblendLayers(background, foreground, BlendType.PINLIGHT)\n```\n![PinLight](test/pinlight_expected.png)\n\n### VividLight\n\n```python\nblendLayers(background, foreground, BlendType.VIVIDLIGHT)\n```\n![VividLight](test/vividlight_expected.png)\n\n### Exclusion\n\n```python\nblendLayers(background, foreground, BlendType.EXCLUSION)\n```\n![Exclusion](test/exclusion_expected.png)\n\n### DestIn\n\n```python\nblendLayers(background, foreground, BlendType.DESTIN)\n```\n![Exclusion](test/destin_expected.png)\n\n### DestOut\n\n```python\nblendLayers(background, foreground, BlendType.DESTOUT)\n```\n![Exclusion](test/destout_expected.png)\n\n### DestAtop\n\n```python\nblendLayers(background, foreground, BlendType.DESTATOP)\n```\n![Exclusion](test/destatop_expected.png)\n\n### SrcAtop\n\n```python\nblendLayers(background, foreground, BlendType.SRCATOP)\n```\n![Exclusion](test/srcatop_expected.png)\n\n## Install With PIP\n\n```python\npip install blendmodes\n```\n\nHead to https://pypi.org/project/blendmodes/ for more info\n\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n\n## Download\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/BlendModes\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nIn the interest of fostering an open and welcoming environment, we\nas contributors and maintainers pledge to make participation in our\nproject and our community a harassment-free experience for everyone.\nPlease see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md) for more information.\n\n### Contributing\nContributions are welcome, please see the [Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md) for more information.\n\n### Security\nThank you for improving the security of the project, please see the [Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md) for more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/BlendModes',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
