import { S as SvelteComponent, i as init, s as safe_not_equal, a as svg_element, b as attr, c as insert, d as append, n as noop, e as detach, f as element, H as src_url_equal, A as createEventDispatcher, a9 as onMount, D as binding_callbacks, aa as add_render_callback, af as create_bidirectional_transition, Y as set_style, l as listen, r as run_all, m as space, ad as add_resize_listener, v as transition_in, y as group_outros, w as transition_out, z as check_outros, o as destroy_each, E as onDestroy, q as create_component, u as mount_component, x as destroy_component, t as toggle_class, a6 as tick, k as empty, J as bind, G as add_flush_callback, h as text, j as set_data, K as component_subscribe, X, L as assign, M as StatusTracker, N as get_spread_update, O as get_spread_object, F as bubble } from './index.69cfcd36.js';
import { B as BlockLabel } from './BlockLabel.0cfb47b7.js';
import { I as Image } from './Image.48203ca3.js';
import { C as Cropper, i as index, U as Undo, W as Webcam } from './Webcam.ead44ab7.js';
import { f as fade } from './index.bd3ec8eb.js';
import { I as IconButton, C as Clear, M as ModifyUpload } from './ModifyUpload.d7180a2c.js';
import { U as Upload } from './Upload.2f1e591c.js';
import { B as Block } from './Block.889f4a1a.js';
export { E as ExampleComponent } from './Image.c2ed19e9.js';
import './styles.c72835fa.js';

/* Users/aliabid/projects/gradio/ui/packages/icons/src/Sketch.svelte generated by Svelte v3.49.0 */

function create_fragment$6(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "d", "M17 3a2.828 2.828 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5L17 3z");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "width", "100%");
			attr(svg, "height", "100%");
			attr(svg, "viewBox", "0 0 24 24");
			attr(svg, "fill", "none");
			attr(svg, "stroke", "currentColor");
			attr(svg, "stroke-width", "1.5");
			attr(svg, "stroke-linecap", "round");
			attr(svg, "stroke-linejoin", "round");
			attr(svg, "class", "feather feather-edit-2");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

class Sketch$1 extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, null, create_fragment$6, safe_not_equal, {});
	}
}

/* Users/aliabid/projects/gradio/ui/packages/image/src/Cropper.svelte generated by Svelte v3.49.0 */

function create_fragment$5(ctx) {
	let img;
	let img_src_value;

	return {
		c() {
			img = element("img");
			if (!src_url_equal(img.src, img_src_value = /*image*/ ctx[0])) attr(img, "src", img_src_value);
			attr(img, "alt", "");
		},
		m(target, anchor) {
			insert(target, img, anchor);
			/*img_binding*/ ctx[2](img);
		},
		p(ctx, [dirty]) {
			if (dirty & /*image*/ 1 && !src_url_equal(img.src, img_src_value = /*image*/ ctx[0])) {
				attr(img, "src", img_src_value);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(img);
			/*img_binding*/ ctx[2](null);
		}
	};
}

function instance$5($$self, $$props, $$invalidate) {
	let { image } = $$props;
	let el;
	const dispatch = createEventDispatcher();

	onMount(() => {
		const cropper = new Cropper(el,
		{
				autoCropArea: 1,
				cropend() {
					const image_data = cropper.getCroppedCanvas().toDataURL();
					dispatch("crop", image_data);
				}
			});

		dispatch("crop", image);

		return () => {
			cropper.destroy();
		};
	});

	function img_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(1, el);
		});
	}

	$$self.$$set = $$props => {
		if ('image' in $$props) $$invalidate(0, image = $$props.image);
	};

	return [image, el, img_binding];
}

class Cropper_1 extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$5, create_fragment$5, safe_not_equal, { image: 0 });
	}
}

class Point {
  /**
   *
   * @param {number} x
   * @param {number} y
   */
  constructor(x, y) {
    this.x = x;
    this.y = y;
  }
}

class LazyPoint extends Point {
  /**
   * Update the x and y values
   *
   * @param {Point} point
   */
  update (point) {
    this.x = point.x;
    this.y = point.y;
  }

  /**
   * Move the point to another position using an angle and distance
   *
   * @param {number} angle The angle in radians
   * @param {number} distance How much the point should be moved
   */
  moveByAngle (angle, distance) {
    // Rotate the angle based on the browser coordinate system ([0,0] in the top left)
    const angleRotated = angle + (Math.PI / 2);

    this.x = this.x + (Math.sin(angleRotated) * distance),
    this.y = this.y - (Math.cos(angleRotated) * distance);
  }

  /**
   * Check if this point is the same as another point
   *
   * @param {Point} point
   * @returns {boolean}
   */
  equalsTo (point) {
    return this.x === point.x && this.y === point.y
  }

  /**
   * Get the difference for x and y axis to another point
   *
   * @param {Point} point
   * @returns {Point}
   */
  getDifferenceTo (point) {
    return new Point(this.x - point.x, this.y - point.y)
  }

  /**
   * Calculate distance to another point
   *
   * @param {Point} point
   * @returns {Point}
   */
  getDistanceTo (point) {
    const diff = this.getDifferenceTo(point);

    return Math.sqrt(Math.pow(diff.x, 2) + Math.pow(diff.y, 2))
  }

  /**
   * Calculate the angle to another point
   *
   * @param {Point} point
   * @returns {Point}
   */
  getAngleTo (point) {
    const diff = this.getDifferenceTo(point);

    return Math.atan2(diff.y, diff.x)
  }

  /**
   * Return a simple object with x and y properties
   *
   * @returns {object}
   */
  toObject () {
    return {
      x: this.x,
      y: this.y
    }
  }
}

const RADIUS_DEFAULT = 30;

class LazyBrush {
  /**
   * constructor
   *
   * @param {object} settings
   * @param {number} settings.radius The radius for the lazy area
   * @param {boolean} settings.enabled
   */
  constructor ({ radius = RADIUS_DEFAULT, enabled = true, initialPoint = { x: 0, y: 0 }} = {}) {
    this.radius = radius;
    this._isEnabled = enabled;

    this.pointer = new LazyPoint(initialPoint.x, initialPoint.y);
    this.brush = new LazyPoint(initialPoint.x, initialPoint.y);

    this.angle = 0;
    this.distance = 0;
    this._hasMoved = false;
  }

  /**
   * Enable lazy brush calculations.
   *
   */
  enable () {
    this._isEnabled = true;
  }

  /**
   * Disable lazy brush calculations.
   *
   */
  disable () {
    this._isEnabled = false;
  }

  /**
   * @returns {boolean}
   */
  isEnabled () {
    return this._isEnabled
  }

  /**
   * Update the radius
   *
   * @param {number} radius
   */
  setRadius (radius) {
    this.radius = radius;
  }

  /**
   * Return the current radius
   *
   * @returns {number}
   */
  getRadius () {
    return this.radius
  }

  /**
   * Return the brush coordinates as a simple object
   *
   * @returns {object}
   */
  getBrushCoordinates () {
    return this.brush.toObject()
  }

  /**
   * Return the pointer coordinates as a simple object
   *
   * @returns {object}
   */
  getPointerCoordinates () {
    return this.pointer.toObject()
  }

  /**
   * Return the brush as a LazyPoint
   *
   * @returns {LazyPoint}
   */
  getBrush () {
    return this.brush
  }

  /**
   * Return the pointer as a LazyPoint
   *
   * @returns {LazyPoint}
   */
  getPointer () {
    return this.pointer
  }

  /**
   * Return the angle between pointer and brush
   *
   * @returns {number} Angle in radians
   */
  getAngle () {
    return this.angle
  }

  /**
   * Return the distance between pointer and brush
   *
   * @returns {number} Distance in pixels
   */
  getDistance () {
    return this.distance
  }

  /**
   * Return if the previous update has moved the brush.
   *
   * @returns {boolean} Whether the brush moved previously.
   */
  brushHasMoved () {
    return this._hasMoved
  }

  /**
   * Updates the pointer point and calculates the new brush point.
   *
   * @param {Point} newPointerPoint
   * @param {Object} options
   * @param {Boolean} options.both Force update pointer and brush
   * @returns {Boolean} Whether any of the two points changed
   */
  update (newPointerPoint, { both = false } = {}) {
    this._hasMoved = false;
    if (this.pointer.equalsTo(newPointerPoint) && !both) {
      return false
    }

    this.pointer.update(newPointerPoint);

    if (both) {
      this._hasMoved = true;
      this.brush.update(newPointerPoint);
      return true
    }

    if (this._isEnabled) {
      this.distance = this.pointer.getDistanceTo(this.brush);
      this.angle = this.pointer.getAngleTo(this.brush);

      if (this.distance > this.radius) {
        this.brush.moveByAngle(this.angle, this.distance - this.radius);
        this._hasMoved = true;
      }
    } else {
      this.distance = 0;
      this.angle = 0;
      this.brush.update(newPointerPoint);
      this._hasMoved = true;
    }

    return true
  }
}

/* Users/aliabid/projects/gradio/ui/packages/image/src/Sketch.svelte generated by Svelte v3.49.0 */

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[49] = list[i].name;
	child_ctx[50] = list[i].zIndex;
	child_ctx[51] = list;
	child_ctx[52] = i;
	return child_ctx;
}

// (466:1) {#if line_count === 0}
function create_if_block$3(ctx) {
	let div;
	let div_transition;
	let current;

	return {
		c() {
			div = element("div");
			div.textContent = "Start drawing";
			attr(div, "class", "absolute inset-0 flex items-center justify-center z-40 pointer-events-none touch-none text-gray-400 md:text-xl");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			current = true;
		},
		i(local) {
			if (current) return;

			add_render_callback(() => {
				if (!div_transition) div_transition = create_bidirectional_transition(div, fade, { duration: 50 }, true);
				div_transition.run(1);
			});

			current = true;
		},
		o(local) {
			if (!div_transition) div_transition = create_bidirectional_transition(div, fade, { duration: 50 }, false);
			div_transition.run(0);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			if (detaching && div_transition) div_transition.end();
		}
	};
}

// (474:1) {#each canvas_types as { name, zIndex }}
function create_each_block(ctx) {
	let canvas_1;
	let canvas_1_key_value;
	let name = /*name*/ ctx[49];
	let mounted;
	let dispose;
	const assign_canvas_1 = () => /*canvas_1_binding*/ ctx[19](canvas_1, name);
	const unassign_canvas_1 = () => /*canvas_1_binding*/ ctx[19](null, name);

	return {
		c() {
			canvas_1 = element("canvas");
			attr(canvas_1, "key", canvas_1_key_value = /*name*/ ctx[49]);
			attr(canvas_1, "class", "inset-0 m-auto");
			set_style(canvas_1, "display", "block");
			set_style(canvas_1, "position", "absolute");
			set_style(canvas_1, "z-index", /*zIndex*/ ctx[50]);

			set_style(canvas_1, "width", (/*mode*/ ctx[0] === 'sketch'
			? /*canvas_width*/ ctx[3]
			: /*width*/ ctx[1]) + "px");

			set_style(canvas_1, "height", (/*mode*/ ctx[0] === 'sketch'
			? /*canvas_height*/ ctx[4]
			: /*height*/ ctx[2]) + "px");
		},
		m(target, anchor) {
			insert(target, canvas_1, anchor);
			assign_canvas_1();

			if (!mounted) {
				dispose = [
					listen(canvas_1, "mousedown", /*name*/ ctx[49] === "interface"
					? /*handle_draw_start*/ ctx[9]
					: undefined),
					listen(canvas_1, "mousemove", /*name*/ ctx[49] === "interface"
					? /*handle_draw_move*/ ctx[10]
					: undefined),
					listen(canvas_1, "mouseup", /*name*/ ctx[49] === "interface"
					? /*handle_draw_end*/ ctx[11]
					: undefined),
					listen(canvas_1, "mouseout", /*name*/ ctx[49] === "interface"
					? /*handle_draw_end*/ ctx[11]
					: undefined),
					listen(canvas_1, "blur", /*name*/ ctx[49] === "interface"
					? /*handle_draw_end*/ ctx[11]
					: undefined),
					listen(canvas_1, "touchstart", /*name*/ ctx[49] === "interface"
					? /*handle_draw_start*/ ctx[9]
					: undefined),
					listen(canvas_1, "touchmove", /*name*/ ctx[49] === "interface"
					? /*handle_draw_move*/ ctx[10]
					: undefined),
					listen(canvas_1, "touchend", /*name*/ ctx[49] === "interface"
					? /*handle_draw_end*/ ctx[11]
					: undefined),
					listen(canvas_1, "touchcancel", /*name*/ ctx[49] === "interface"
					? /*handle_draw_end*/ ctx[11]
					: undefined)
				];

				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty[0] & /*mode, canvas_width, width*/ 11) {
				set_style(canvas_1, "width", (/*mode*/ ctx[0] === 'sketch'
				? /*canvas_width*/ ctx[3]
				: /*width*/ ctx[1]) + "px");
			}

			if (dirty[0] & /*mode, canvas_height, height*/ 21) {
				set_style(canvas_1, "height", (/*mode*/ ctx[0] === 'sketch'
				? /*canvas_height*/ ctx[4]
				: /*height*/ ctx[2]) + "px");
			}

			if (name !== /*name*/ ctx[49]) {
				unassign_canvas_1();
				name = /*name*/ ctx[49];
				assign_canvas_1();
			}
		},
		d(detaching) {
			if (detaching) detach(canvas_1);
			unassign_canvas_1();
			mounted = false;
			run_all(dispose);
		}
	};
}

function create_fragment$4(ctx) {
	let div;
	let t;
	let div_resize_listener;
	let current;
	let if_block = /*line_count*/ ctx[7] === 0 && create_if_block$3();
	let each_value = /*canvas_types*/ ctx[8];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	return {
		c() {
			div = element("div");
			if (if_block) if_block.c();
			t = space();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(div, "class", "touch-none relative h-full w-full");
			add_render_callback(() => /*div_elementresize_handler*/ ctx[21].call(div));
		},
		m(target, anchor) {
			insert(target, div, anchor);
			if (if_block) if_block.m(div, null);
			append(div, t);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}

			/*div_binding*/ ctx[20](div);
			div_resize_listener = add_resize_listener(div, /*div_elementresize_handler*/ ctx[21].bind(div));
			current = true;
		},
		p(ctx, dirty) {
			if (/*line_count*/ ctx[7] === 0) {
				if (if_block) {
					if (dirty[0] & /*line_count*/ 128) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block$3();
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(div, t);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			if (dirty[0] & /*canvas_types, mode, canvas_width, width, canvas_height, height, canvas, handle_draw_start, handle_draw_move, handle_draw_end*/ 3903) {
				each_value = /*canvas_types*/ ctx[8];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			if (if_block) if_block.d();
			destroy_each(each_blocks, detaching);
			/*div_binding*/ ctx[20](null);
			div_resize_listener();
		}
	};
}

let catenary_color = "#aaa";

function mid_point(p1, p2) {
	return {
		x: p1.x + (p2.x - p1.x) / 2,
		y: p1.y + (p2.y - p1.y) / 2
	};
}

function instance$4($$self, $$props, $$invalidate) {
	const dispatch = createEventDispatcher();
	let { value } = $$props;
	let { mode = "sketch" } = $$props;
	let { brush_color = "#0b0f19" } = $$props;
	let { brush_radius = 50 } = $$props;
	let { width = undefined } = $$props;
	let { height = undefined } = $$props;
	let mounted;
	let canvas_width = width || 400;
	let canvas_height = height || 400;

	const canvas_types = [
		{ name: "interface", zIndex: 15 },
		{ name: "drawing", zIndex: 11 },
		{ name: "temp", zIndex: 12 },
		{ name: "mask", zIndex: -1 },
		{ name: "temp_fake", zIndex: -2 }
	];

	let canvas = {};
	let ctx = {};
	let points = [];
	let lines = [];
	let mouse_has_moved = true;
	let values_changed = true;
	let is_drawing = false;
	let is_pressing = false;
	let lazy = null;
	let chain_length = null;
	let canvas_container = null;
	let canvas_observer = null;
	let line_count = 0;
	let display_natural_ratio = 1;

	function calculate_ratio() {
		const x = canvas.interface.getBoundingClientRect();
		display_natural_ratio = width / x.width;
	}

	onMount(() => {
		Object.keys(canvas).forEach(key => {
			ctx[key] = canvas[key].getContext("2d");
		});

		lazy = new LazyBrush({
				radius: brush_radius / 1.5,
				enabled: true,
				initialPoint: {
					x: window.innerWidth / 2,
					y: window.innerHeight / 2
				}
			});

		chain_length = brush_radius;

		canvas_observer = new index((entries, observer) => {
				handle_canvas_resize(entries, observer);
				calculate_ratio();
			});

		canvas_observer.observe(canvas_container);
		loop();
		$$invalidate(18, mounted = true);

		window.setTimeout(
			() => {
				const initX = window.innerWidth / 2;
				const initY = window.innerHeight / 2;
				lazy.update({ x: initX - chain_length / 4, y: initY }, { both: true });
				lazy.update({ x: initX + chain_length / 4, y: initY }, { both: false });
				mouse_has_moved = true;
				values_changed = true;
				clear();
			},
			100
		);

		calculate_ratio();
	});

	onDestroy(() => {
		$$invalidate(18, mounted = false);
		canvas_observer.unobserve(canvas_container);
	});

	function undo() {
		const _lines = lines.slice(0, -1);
		clear();
		draw_lines({ lines: _lines });
		$$invalidate(7, line_count = lines.length);
		trigger_on_change();
	}

	let get_save_data = () => {
		return JSON.stringify({
			lines,
			width: canvas_width,
			height: canvas_height
		});
	};

	let load_save_data = save_data => {
		if (typeof save_data !== "string") {
			throw new Error("save_data needs to be of type string!");
		}

		const { lines, width, height } = JSON.parse(save_data);

		if (!lines || typeof lines.push !== "function") {
			throw new Error("save_data.lines needs to be an array!");
		}

		clear();

		if (width === canvas_width && height === canvas_height) {
			draw_lines({ lines });
		} else {
			const scaleX = canvas_width / width;
			const scaleY = canvas_height / height;

			draw_lines({
				lines: lines.map(line => ({
					...line,
					points: line.points.map(p => ({ x: p.x * scaleX, y: p.y * scaleY })),
					brush_radius: line.brush_radius
				}))
			});
		}
	};

	let draw_lines = ({ lines }) => {
		lines.forEach(line => {
			const { points: _points, brush_color, brush_radius } = line;

			draw_points({
				points: _points,
				brush_color,
				brush_radius
			});

			if (mode === "mask") {
				draw_fake_points({ points, brush_color, brush_radius });
			}

			points = _points;
			saveLine();

			if (mode === "mask") {
				save_mask_line();
			}

			return;
		});
	};

	let handle_draw_start = e => {
		e.preventDefault();
		is_pressing = true;
		const { x, y } = get_pointer_pos(e);

		if (e.touches && e.touches.length > 0) {
			lazy.update({ x, y }, { both: true });
		}

		handle_pointer_move(x, y);
		$$invalidate(7, line_count += 1);
	};

	let handle_draw_move = e => {
		e.preventDefault();
		const { x, y } = get_pointer_pos(e);
		handle_pointer_move(x, y);
	};

	let handle_draw_end = e => {
		e.preventDefault();
		handle_draw_move(e);
		is_drawing = false;
		is_pressing = false;
		saveLine();

		if (mode === "mask") {
			save_mask_line();
		}
	};

	let handle_canvas_resize = entries => {
		const save_data = get_save_data();

		for (const entry of entries) {
			const { width, height } = entry.contentRect;
			set_canvas_size(canvas.interface, width, height);
			set_canvas_size(canvas.drawing, width, height);
			set_canvas_size(canvas.temp, width, height);
			set_canvas_size(canvas.temp_fake, width, height);
			set_canvas_size(canvas.mask, width, height);
			loop({ once: true });
		}

		load_save_data(save_data);
	};

	let set_canvas_size = (canvas, _width, _height) => {
		canvas.width = width || _width * 3;
		canvas.height = height || _height * 3;

		canvas.style.width = mode === "mask" ? "auto" : _width;
		canvas.style.height = mode === "mask" ? "100%" : _height;
	};

	let get_pointer_pos = e => {
		const rect = canvas.interface.getBoundingClientRect();
		let clientX = e.clientX;
		let clientY = e.clientY;

		if (e.changedTouches && e.changedTouches.length > 0) {
			clientX = e.changedTouches[0].clientX;
			clientY = e.changedTouches[0].clientY;
		}

		return {
			x: clientX - rect.left,
			y: clientY - rect.top
		};
	};

	let handle_pointer_move = (x, y) => {
		lazy.update(mode === "sketch"
		? { x: x * 3, y: y * 3 }
		: {
				x: x * display_natural_ratio,
				y: y * display_natural_ratio
			});

		const is_disabled = !lazy.isEnabled();

		if (is_pressing && !is_drawing || is_disabled && is_pressing) {
			is_drawing = true;
			points.push(lazy.brush.toObject());
		}

		if (is_drawing) {
			points.push(lazy.brush.toObject());
			draw_points({ points, brush_color, brush_radius });

			if (mode === "mask") {
				draw_fake_points({ points, brush_color, brush_radius });
			}
		}

		mouse_has_moved = true;
	};

	let draw_points = ({ points, brush_color, brush_radius }) => {
		ctx.temp.lineJoin = "round";
		ctx.temp.lineCap = "round";
		ctx.temp.strokeStyle = brush_color;
		ctx.temp.clearRect(0, 0, ctx.temp.canvas.width, ctx.temp.canvas.height);
		ctx.temp.lineWidth = brush_radius;
		let p1 = points[0];
		let p2 = points[1];
		ctx.temp.moveTo(p2.x, p2.y);
		ctx.temp.beginPath();

		for (var i = 1, len = points.length; i < len; i++) {
			var midPoint = mid_point(p1, p2);
			ctx.temp.quadraticCurveTo(p1.x, p1.y, midPoint.x, midPoint.y);
			p1 = points[i];
			p2 = points[i + 1];
		}

		ctx.temp.lineTo(p1.x, p1.y);
		ctx.temp.stroke();
	};

	let draw_fake_points = ({ points, brush_color, brush_radius }) => {
		ctx.temp_fake.lineJoin = "round";
		ctx.temp_fake.lineCap = "round";
		ctx.temp_fake.strokeStyle = "#fff";
		ctx.temp_fake.clearRect(0, 0, ctx.temp.canvas.width, ctx.temp.canvas.height);
		ctx.temp_fake.lineWidth = brush_radius;
		let p1 = points[0];
		let p2 = points[1];
		ctx.temp_fake.moveTo(p2.x, p2.y);
		ctx.temp_fake.beginPath();

		for (var i = 1, len = points.length; i < len; i++) {
			var midPoint = mid_point(p1, p2);
			ctx.temp_fake.quadraticCurveTo(p1.x, p1.y, midPoint.x, midPoint.y);
			p1 = points[i];
			p2 = points[i + 1];
		}

		ctx.temp_fake.lineTo(p1.x, p1.y);
		ctx.temp_fake.stroke();
	};

	let save_mask_line = () => {
		// if (points.length < 2) return;
		lines.push({
			points: [...points],
			brush_color: "#fff",
			brush_radius
		});

		points.length = 0;
		const width = canvas.temp_fake.width;
		const height = canvas.temp_fake.height;
		ctx.mask.drawImage(canvas.temp_fake, 0, 0, width, height);
		ctx.temp_fake.clearRect(0, 0, width, height);
		trigger_on_change();
	};

	let saveLine = () => {
		if (points.length < 2) return;

		lines.push({
			points: [...points],
			brush_color,
			brush_radius
		});

		points.length = 0;
		const width = canvas.temp.width;
		const height = canvas.temp.height;
		ctx.drawing.drawImage(canvas.temp, 0, 0, width, height);
		ctx.temp.clearRect(0, 0, width, height);
		trigger_on_change();
	};

	let trigger_on_change = () => {
		dispatch("change", get_image_data());
	};

	function clear() {
		lines = [];
		values_changed = true;
		ctx.drawing.clearRect(0, 0, canvas.drawing.width, canvas.drawing.height);
		ctx.temp.clearRect(0, 0, canvas.temp.width, canvas.temp.height);
		ctx.drawing.fillStyle = mode === "sketch" ? "#FFFFFF" : "transparent";
		ctx.drawing.fillRect(0, 0, canvas.drawing.width, canvas.drawing.height);

		if (mode === "mask") {
			ctx.temp_fake.clearRect(0, 0, canvas.temp_fake.width, canvas.temp_fake.height);
			ctx.mask.clearRect(0, 0, canvas.temp_fake.width, canvas.temp_fake.height);
			ctx.mask.fillStyle = "#000";
			ctx.mask.fillRect(0, 0, canvas.mask.width, canvas.mask.height);
		}

		$$invalidate(7, line_count = 0);
	}

	let loop = ({ once = false } = {}) => {
		if (mouse_has_moved || values_changed) {
			const pointer = lazy.getPointerCoordinates();
			const brush = lazy.getBrushCoordinates();
			draw_interface(ctx.interface, pointer, brush);
			mouse_has_moved = false;
			values_changed = false;
		}

		if (!once) {
			window.requestAnimationFrame(() => {
				loop();
			});
		}
	};

	let draw_interface = (ctx, pointer, brush) => {
		ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		// brush preview
		ctx.beginPath();

		ctx.fillStyle = brush_color;
		ctx.arc(brush.x, brush.y, brush_radius / 2, 0, Math.PI * 2, true);
		ctx.fill();

		// mouse point dangler
		ctx.beginPath();

		ctx.fillStyle = catenary_color;
		ctx.arc(pointer.x, pointer.y, 4, 0, Math.PI * 2, true);
		ctx.fill();

		//  catenary
		if (lazy.isEnabled()) {
			ctx.beginPath();
			ctx.lineWidth = 2;
			ctx.lineCap = "round";
			ctx.setLineDash([2, 4]);
			ctx.strokeStyle = catenary_color;
			ctx.stroke();
		}

		// tiny brush point dot
		ctx.beginPath();

		ctx.fillStyle = catenary_color;
		ctx.arc(brush.x, brush.y, 2, 0, Math.PI * 2, true);
		ctx.fill();
	};

	function get_image_data() {
		return mode === "mask"
		? canvas.mask.toDataURL("image/png")
		: canvas.drawing.toDataURL("image/png");
	}

	function canvas_1_binding($$value, name) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			canvas[name] = $$value;
			$$invalidate(5, canvas);
		});
	}

	function div_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			canvas_container = $$value;
			$$invalidate(6, canvas_container);
		});
	}

	function div_elementresize_handler() {
		canvas_width = this.offsetWidth;
		canvas_height = this.offsetHeight;
		$$invalidate(3, canvas_width);
		$$invalidate(4, canvas_height);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(12, value = $$props.value);
		if ('mode' in $$props) $$invalidate(0, mode = $$props.mode);
		if ('brush_color' in $$props) $$invalidate(13, brush_color = $$props.brush_color);
		if ('brush_radius' in $$props) $$invalidate(14, brush_radius = $$props.brush_radius);
		if ('width' in $$props) $$invalidate(1, width = $$props.width);
		if ('height' in $$props) $$invalidate(2, height = $$props.height);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*mounted, value*/ 266240) {
			mounted && !value && clear();
		}
	};

	return [
		mode,
		width,
		height,
		canvas_width,
		canvas_height,
		canvas,
		canvas_container,
		line_count,
		canvas_types,
		handle_draw_start,
		handle_draw_move,
		handle_draw_end,
		value,
		brush_color,
		brush_radius,
		undo,
		clear,
		get_image_data,
		mounted,
		canvas_1_binding,
		div_binding,
		div_elementresize_handler
	];
}

class Sketch extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance$4,
			create_fragment$4,
			safe_not_equal,
			{
				value: 12,
				mode: 0,
				brush_color: 13,
				brush_radius: 14,
				width: 1,
				height: 2,
				undo: 15,
				clear: 16,
				get_image_data: 17
			},
			null,
			[-1, -1]
		);
	}

	get undo() {
		return this.$$.ctx[15];
	}

	get clear() {
		return this.$$.ctx[16];
	}

	get get_image_data() {
		return this.$$.ctx[17];
	}
}

/* Users/aliabid/projects/gradio/ui/packages/image/src/ModifySketch.svelte generated by Svelte v3.49.0 */

function create_fragment$3(ctx) {
	let div;
	let iconbutton0;
	let t;
	let iconbutton1;
	let current;
	iconbutton0 = new IconButton({ props: { Icon: Undo } });
	iconbutton0.$on("click", /*click_handler*/ ctx[1]);
	iconbutton1 = new IconButton({ props: { Icon: Clear } });
	iconbutton1.$on("click", /*click_handler_1*/ ctx[2]);

	return {
		c() {
			div = element("div");
			create_component(iconbutton0.$$.fragment);
			t = space();
			create_component(iconbutton1.$$.fragment);
			attr(div, "class", "z-50 top-2 right-2 justify-end flex gap-1 absolute");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			mount_component(iconbutton0, div, null);
			append(div, t);
			mount_component(iconbutton1, div, null);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(iconbutton0.$$.fragment, local);
			transition_in(iconbutton1.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(iconbutton0.$$.fragment, local);
			transition_out(iconbutton1.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			destroy_component(iconbutton0);
			destroy_component(iconbutton1);
		}
	};
}

function instance$3($$self) {
	const dispatch = createEventDispatcher();
	const click_handler = () => dispatch("undo");
	const click_handler_1 = () => dispatch("clear");
	return [dispatch, click_handler, click_handler_1];
}

class ModifySketch extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$3, create_fragment$3, safe_not_equal, {});
	}
}

/* Users/aliabid/projects/gradio/ui/packages/image/src/Image.svelte generated by Svelte v3.49.0 */

function create_else_block$2(ctx) {
	let img;
	let img_src_value;

	return {
		c() {
			img = element("img");
			attr(img, "class", "w-full h-full object-contain");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) attr(img, "src", img_src_value);
			attr(img, "alt", "");
			toggle_class(img, "scale-x-[-1]", /*source*/ ctx[4] === "webcam" && /*mirror_webcam*/ ctx[10]);
		},
		m(target, anchor) {
			insert(target, img, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) {
				attr(img, "src", img_src_value);
			}

			if (dirty & /*source, mirror_webcam*/ 1040) {
				toggle_class(img, "scale-x-[-1]", /*source*/ ctx[4] === "webcam" && /*mirror_webcam*/ ctx[10]);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(img);
		}
	};
}

// (125:47) 
function create_if_block_6(ctx) {
	let img;
	let img_src_value;
	let t;
	let if_block_anchor;
	let current;
	let mounted;
	let dispose;
	let if_block = /*img_width*/ ctx[14] > 0 && create_if_block_7(ctx);

	return {
		c() {
			img = element("img");
			t = space();
			if (if_block) if_block.c();
			if_block_anchor = empty();
			attr(img, "class", "absolute w-full h-full object-contain");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[0].image)) attr(img, "src", img_src_value);
			attr(img, "alt", "");
			toggle_class(img, "scale-x-[-1]", /*source*/ ctx[4] === "webcam" && /*mirror_webcam*/ ctx[10]);
		},
		m(target, anchor) {
			insert(target, img, anchor);
			insert(target, t, anchor);
			if (if_block) if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;

			if (!mounted) {
				dispose = listen(img, "load", /*handle_image_load*/ ctx[18]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (!current || dirty & /*value*/ 1 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[0].image)) {
				attr(img, "src", img_src_value);
			}

			if (dirty & /*source, mirror_webcam*/ 1040) {
				toggle_class(img, "scale-x-[-1]", /*source*/ ctx[4] === "webcam" && /*mirror_webcam*/ ctx[10]);
			}

			if (/*img_width*/ ctx[14] > 0) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*img_width*/ 16384) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block_7(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(img);
			if (detaching) detach(t);
			if (if_block) if_block.d(detaching);
			if (detaching) detach(if_block_anchor);
			mounted = false;
			dispose();
		}
	};
}

// (112:29) 
function create_if_block_5(ctx) {
	let modifyupload;
	let t;
	let img;
	let img_src_value;
	let current;
	modifyupload = new ModifyUpload({ props: { editable: true } });
	modifyupload.$on("edit", /*edit_handler*/ ctx[26]);
	modifyupload.$on("clear", /*handle_clear*/ ctx[16]);

	return {
		c() {
			create_component(modifyupload.$$.fragment);
			t = space();
			img = element("img");
			attr(img, "class", "w-full h-full object-contain");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) attr(img, "src", img_src_value);
			attr(img, "alt", "");
			toggle_class(img, "scale-x-[-1]", /*source*/ ctx[4] === "webcam" && /*mirror_webcam*/ ctx[10]);
		},
		m(target, anchor) {
			mount_component(modifyupload, target, anchor);
			insert(target, t, anchor);
			insert(target, img, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (!current || dirty & /*value*/ 1 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) {
				attr(img, "src", img_src_value);
			}

			if (dirty & /*source, mirror_webcam*/ 1040) {
				toggle_class(img, "scale-x-[-1]", /*source*/ ctx[4] === "webcam" && /*mirror_webcam*/ ctx[10]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(modifyupload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(modifyupload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(modifyupload, detaching);
			if (detaching) detach(t);
			if (detaching) detach(img);
		}
	};
}

// (109:29) 
function create_if_block_4(ctx) {
	let cropper;
	let t;
	let modifyupload;
	let current;
	cropper = new Cropper_1({ props: { image: /*value*/ ctx[0] } });
	cropper.$on("crop", /*handle_save*/ ctx[17]);
	modifyupload = new ModifyUpload({});
	modifyupload.$on("clear", /*clear_handler_1*/ ctx[25]);

	return {
		c() {
			create_component(cropper.$$.fragment);
			t = space();
			create_component(modifyupload.$$.fragment);
		},
		m(target, anchor) {
			mount_component(cropper, target, anchor);
			insert(target, t, anchor);
			mount_component(modifyupload, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const cropper_changes = {};
			if (dirty & /*value*/ 1) cropper_changes.image = /*value*/ ctx[0];
			cropper.$set(cropper_changes);
		},
		i(local) {
			if (current) return;
			transition_in(cropper.$$.fragment, local);
			transition_in(modifyupload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(cropper.$$.fragment, local);
			transition_out(modifyupload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(cropper, detaching);
			if (detaching) detach(t);
			destroy_component(modifyupload, detaching);
		}
	};
}

// (86:39) 
function create_if_block_1(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_2, create_if_block_3];
	const if_blocks = [];

	function select_block_type_1(ctx, dirty) {
		if (/*source*/ ctx[4] === "upload") return 0;
		if (/*source*/ ctx[4] === "webcam") return 1;
		return -1;
	}

	if (~(current_block_type_index = select_block_type_1(ctx))) {
		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(target, anchor);
			}

			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_1(ctx);

			if (current_block_type_index === previous_block_index) {
				if (~current_block_type_index) {
					if_blocks[current_block_type_index].p(ctx, dirty);
				}
			} else {
				if (if_block) {
					group_outros();

					transition_out(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros();
				}

				if (~current_block_type_index) {
					if_block = if_blocks[current_block_type_index];

					if (!if_block) {
						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block.c();
					} else {
						if_block.p(ctx, dirty);
					}

					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				} else {
					if_block = null;
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d(detaching);
			}

			if (detaching) detach(if_block_anchor);
		}
	};
}

// (80:1) {#if source === "canvas"}
function create_if_block$2(ctx) {
	let modifysketch;
	let t;
	let sketch_1;
	let current;
	modifysketch = new ModifySketch({});
	modifysketch.$on("undo", /*undo_handler*/ ctx[21]);
	modifysketch.$on("clear", /*clear_handler*/ ctx[22]);
	let sketch_1_props = { value: /*value*/ ctx[0] };
	sketch_1 = new Sketch({ props: sketch_1_props });
	/*sketch_1_binding*/ ctx[23](sketch_1);
	sketch_1.$on("change", /*handle_save*/ ctx[17]);

	return {
		c() {
			create_component(modifysketch.$$.fragment);
			t = space();
			create_component(sketch_1.$$.fragment);
		},
		m(target, anchor) {
			mount_component(modifysketch, target, anchor);
			insert(target, t, anchor);
			mount_component(sketch_1, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const sketch_1_changes = {};
			if (dirty & /*value*/ 1) sketch_1_changes.value = /*value*/ ctx[0];
			sketch_1.$set(sketch_1_changes);
		},
		i(local) {
			if (current) return;
			transition_in(modifysketch.$$.fragment, local);
			transition_in(sketch_1.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(modifysketch.$$.fragment, local);
			transition_out(sketch_1.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(modifysketch, detaching);
			if (detaching) detach(t);
			/*sketch_1_binding*/ ctx[23](null);
			destroy_component(sketch_1, detaching);
		}
	};
}

// (133:2) {#if img_width > 0}
function create_if_block_7(ctx) {
	let sketch_1;
	let t;
	let modifysketch;
	let current;

	let sketch_1_props = {
		value: /*value*/ ctx[0],
		brush_radius: 25,
		brush_color: "rgba(255, 255, 255, 0.65)",
		mode: "mask",
		width: /*img_width*/ ctx[14],
		height: /*img_height*/ ctx[13]
	};

	sketch_1 = new Sketch({ props: sketch_1_props });
	/*sketch_1_binding_1*/ ctx[27](sketch_1);
	sketch_1.$on("change", /*handle_mask_save*/ ctx[19]);
	modifysketch = new ModifySketch({});
	modifysketch.$on("undo", /*undo_handler_1*/ ctx[28]);
	modifysketch.$on("clear", /*handle_mask_clear*/ ctx[20]);

	return {
		c() {
			create_component(sketch_1.$$.fragment);
			t = space();
			create_component(modifysketch.$$.fragment);
		},
		m(target, anchor) {
			mount_component(sketch_1, target, anchor);
			insert(target, t, anchor);
			mount_component(modifysketch, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const sketch_1_changes = {};
			if (dirty & /*value*/ 1) sketch_1_changes.value = /*value*/ ctx[0];
			if (dirty & /*img_width*/ 16384) sketch_1_changes.width = /*img_width*/ ctx[14];
			if (dirty & /*img_height*/ 8192) sketch_1_changes.height = /*img_height*/ ctx[13];
			sketch_1.$set(sketch_1_changes);
		},
		i(local) {
			if (current) return;
			transition_in(sketch_1.$$.fragment, local);
			transition_in(modifysketch.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(sketch_1.$$.fragment, local);
			transition_out(modifysketch.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			/*sketch_1_binding_1*/ ctx[27](null);
			destroy_component(sketch_1, detaching);
			if (detaching) detach(t);
			destroy_component(modifysketch, detaching);
		}
	};
}

// (100:32) 
function create_if_block_3(ctx) {
	let webcam;
	let current;

	webcam = new Webcam({
			props: {
				streaming: /*streaming*/ ctx[8],
				pending: /*pending*/ ctx[9],
				mirror_webcam: /*mirror_webcam*/ ctx[10]
			}
		});

	webcam.$on("capture", /*handle_save*/ ctx[17]);
	webcam.$on("stream", /*handle_save*/ ctx[17]);

	return {
		c() {
			create_component(webcam.$$.fragment);
		},
		m(target, anchor) {
			mount_component(webcam, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const webcam_changes = {};
			if (dirty & /*streaming*/ 256) webcam_changes.streaming = /*streaming*/ ctx[8];
			if (dirty & /*pending*/ 512) webcam_changes.pending = /*pending*/ ctx[9];
			if (dirty & /*mirror_webcam*/ 1024) webcam_changes.mirror_webcam = /*mirror_webcam*/ ctx[10];
			webcam.$set(webcam_changes);
		},
		i(local) {
			if (current) return;
			transition_in(webcam.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(webcam.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(webcam, detaching);
		}
	};
}

// (87:2) {#if source === "upload"}
function create_if_block_2(ctx) {
	let upload;
	let updating_dragging;
	let current;

	function upload_dragging_binding(value) {
		/*upload_dragging_binding*/ ctx[24](value);
	}

	let upload_props = {
		filetype: "image/x-png,image/gif,image/jpeg",
		include_file_metadata: false,
		$$slots: { default: [create_default_slot$1] },
		$$scope: { ctx }
	};

	if (/*dragging*/ ctx[11] !== void 0) {
		upload_props.dragging = /*dragging*/ ctx[11];
	}

	upload = new Upload({ props: upload_props });
	binding_callbacks.push(() => bind(upload, 'dragging', upload_dragging_binding));
	upload.$on("load", /*handle_upload*/ ctx[15]);

	return {
		c() {
			create_component(upload.$$.fragment);
		},
		m(target, anchor) {
			mount_component(upload, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const upload_changes = {};

			if (dirty & /*$$scope, upload_text, or_text, drop_text*/ 1073742048) {
				upload_changes.$$scope = { dirty, ctx };
			}

			if (!updating_dragging && dirty & /*dragging*/ 2048) {
				updating_dragging = true;
				upload_changes.dragging = /*dragging*/ ctx[11];
				add_flush_callback(() => updating_dragging = false);
			}

			upload.$set(upload_changes);
		},
		i(local) {
			if (current) return;
			transition_in(upload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(upload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(upload, detaching);
		}
	};
}

// (88:3) <Upload     bind:dragging     filetype="image/x-png,image/gif,image/jpeg"     on:load={handle_upload}     include_file_metadata={false}    >
function create_default_slot$1(ctx) {
	let div;
	let t0;
	let t1;
	let span;
	let t2;
	let t3;
	let t4;
	let t5;
	let t6;

	return {
		c() {
			div = element("div");
			t0 = text(/*drop_text*/ ctx[5]);
			t1 = space();
			span = element("span");
			t2 = text("- ");
			t3 = text(/*or_text*/ ctx[6]);
			t4 = text(" -");
			t5 = space();
			t6 = text(/*upload_text*/ ctx[7]);
			attr(span, "class", "text-gray-300");
			attr(div, "class", "flex flex-col");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t0);
			append(div, t1);
			append(div, span);
			append(span, t2);
			append(span, t3);
			append(span, t4);
			append(div, t5);
			append(div, t6);
		},
		p(ctx, dirty) {
			if (dirty & /*drop_text*/ 32) set_data(t0, /*drop_text*/ ctx[5]);
			if (dirty & /*or_text*/ 64) set_data(t3, /*or_text*/ ctx[6]);
			if (dirty & /*upload_text*/ 128) set_data(t6, /*upload_text*/ ctx[7]);
		},
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function create_fragment$2(ctx) {
	let blocklabel;
	let t;
	let div;
	let current_block_type_index;
	let if_block;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[3],
				Icon: /*source*/ ctx[4] === "canvas" ? Sketch$1 : Image,
				label: /*label*/ ctx[2] || (/*source*/ ctx[4] === "canvas" ? "Sketch" : "Image")
			}
		});

	const if_block_creators = [
		create_if_block$2,
		create_if_block_1,
		create_if_block_4,
		create_if_block_5,
		create_if_block_6,
		create_else_block$2
	];

	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*source*/ ctx[4] === "canvas") return 0;
		if (/*value*/ ctx[0] === null || /*streaming*/ ctx[8]) return 1;
		if (/*tool*/ ctx[1] === "select") return 2;
		if (/*tool*/ ctx[1] === "editor") return 3;
		if (/*tool*/ ctx[1] === "sketch" && /*value*/ ctx[0] !== null) return 4;
		return 5;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t = space();
			div = element("div");
			if_block.c();
			attr(div, "data-testid", "image");
			toggle_class(div, "bg-gray-200", /*value*/ ctx[0]);
			toggle_class(div, "h-60", /*source*/ ctx[4] !== "webcam" || /*tool*/ ctx[1] === "sketch");
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t, anchor);
			insert(target, div, anchor);
			if_blocks[current_block_type_index].m(div, null);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 8) blocklabel_changes.show_label = /*show_label*/ ctx[3];
			if (dirty & /*source*/ 16) blocklabel_changes.Icon = /*source*/ ctx[4] === "canvas" ? Sketch$1 : Image;
			if (dirty & /*label, source*/ 20) blocklabel_changes.label = /*label*/ ctx[2] || (/*source*/ ctx[4] === "canvas" ? "Sketch" : "Image");
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(div, null);
			}

			if (dirty & /*value*/ 1) {
				toggle_class(div, "bg-gray-200", /*value*/ ctx[0]);
			}

			if (dirty & /*source, tool*/ 18) {
				toggle_class(div, "h-60", /*source*/ ctx[4] !== "webcam" || /*tool*/ ctx[1] === "sketch");
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach(t);
			if (detaching) detach(div);
			if_blocks[current_block_type_index].d();
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { value } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	let { source = "upload" } = $$props;
	let { tool = "editor" } = $$props;
	let { drop_text = "Drop an image file" } = $$props;
	let { or_text = "or" } = $$props;
	let { upload_text = "click to upload" } = $$props;
	let { streaming = false } = $$props;
	let { pending = false } = $$props;
	let { mirror_webcam } = $$props;
	let sketch;

	if (value && (source === "upload" || source === "webcam") && tool === "sketch") {
		value = { image: value, mask: null };
	}

	function handle_upload({ detail }) {
		$$invalidate(0, value = (source === "upload" || source === "webcam") && tool === "sketch"
		? { image: detail, mask: null }
		: detail);
	}

	function handle_clear({ detail }) {
		$$invalidate(0, value = null);
		dispatch("clear");
	}

	async function handle_save({ detail }) {
		$$invalidate(0, value = (source === "upload" || source === "webcam") && tool === "sketch"
		? { image: detail, mask: null }
		: detail);

		await tick();
		dispatch(streaming ? "stream" : "edit");
	}

	const dispatch = createEventDispatcher();
	let dragging = false;

	function handle_image_load(event) {
		const element = event.composedPath()[0];
		$$invalidate(14, img_width = element.naturalWidth);
		$$invalidate(13, img_height = element.naturalHeight);
	}

	function handle_mask_save({ detail }) {
		$$invalidate(0, value = {
			image: typeof value === "string" ? value : value?.image || null,
			mask: detail
		});
	}

	async function handle_mask_clear() {
		sketch.clear();
		await tick();
		$$invalidate(0, value = null);
	}

	let img_height = 0;
	let img_width = 0;
	const undo_handler = () => sketch.undo();
	const clear_handler = () => sketch.clear();

	function sketch_1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			sketch = $$value;
			$$invalidate(12, sketch);
		});
	}

	function upload_dragging_binding(value) {
		dragging = value;
		$$invalidate(11, dragging);
	}

	const clear_handler_1 = e => (handle_clear(e), $$invalidate(1, tool = "editor"));
	const edit_handler = () => $$invalidate(1, tool = "select");

	function sketch_1_binding_1($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			sketch = $$value;
			$$invalidate(12, sketch);
		});
	}

	const undo_handler_1 = () => sketch.undo();

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(3, show_label = $$props.show_label);
		if ('source' in $$props) $$invalidate(4, source = $$props.source);
		if ('tool' in $$props) $$invalidate(1, tool = $$props.tool);
		if ('drop_text' in $$props) $$invalidate(5, drop_text = $$props.drop_text);
		if ('or_text' in $$props) $$invalidate(6, or_text = $$props.or_text);
		if ('upload_text' in $$props) $$invalidate(7, upload_text = $$props.upload_text);
		if ('streaming' in $$props) $$invalidate(8, streaming = $$props.streaming);
		if ('pending' in $$props) $$invalidate(9, pending = $$props.pending);
		if ('mirror_webcam' in $$props) $$invalidate(10, mirror_webcam = $$props.mirror_webcam);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			dispatch("change", value);
		}

		if ($$self.$$.dirty & /*dragging*/ 2048) {
			dispatch("drag", dragging);
		}
	};

	return [
		value,
		tool,
		label,
		show_label,
		source,
		drop_text,
		or_text,
		upload_text,
		streaming,
		pending,
		mirror_webcam,
		dragging,
		sketch,
		img_height,
		img_width,
		handle_upload,
		handle_clear,
		handle_save,
		handle_image_load,
		handle_mask_save,
		handle_mask_clear,
		undo_handler,
		clear_handler,
		sketch_1_binding,
		upload_dragging_binding,
		clear_handler_1,
		edit_handler,
		sketch_1_binding_1,
		undo_handler_1
	];
}

class Image_1$2 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$2, create_fragment$2, safe_not_equal, {
			value: 0,
			label: 2,
			show_label: 3,
			source: 4,
			tool: 1,
			drop_text: 5,
			or_text: 6,
			upload_text: 7,
			streaming: 8,
			pending: 9,
			mirror_webcam: 10
		});
	}
}

/* Users/aliabid/projects/gradio/ui/packages/image/src/StaticImage.svelte generated by Svelte v3.49.0 */

function create_else_block$1(ctx) {
	let img;
	let img_src_value;

	return {
		c() {
			img = element("img");
			attr(img, "class", "w-full h-full object-contain");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) attr(img, "src", img_src_value);
			attr(img, "alt", "");
		},
		m(target, anchor) {
			insert(target, img, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) {
				attr(img, "src", img_src_value);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(img);
		}
	};
}

// (12:0) {#if value === null}
function create_if_block$1(ctx) {
	let div1;
	let div0;
	let image;
	let current;
	image = new Image({});

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			create_component(image.$$.fragment);
			attr(div0, "class", "h-5 dark:text-white opacity-50");
			attr(div1, "class", "h-full min-h-[15rem] flex justify-center items-center");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			mount_component(image, div0, null);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(image.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(image.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			destroy_component(image);
		}
	};
}

function create_fragment$1(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[2],
				Icon: Image,
				label: /*label*/ ctx[1] || "Image"
			}
		});

	const if_block_creators = [create_if_block$1, create_else_block$1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0] === null) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 4) blocklabel_changes.show_label = /*show_label*/ ctx[2];
			if (dirty & /*label*/ 2) blocklabel_changes.label = /*label*/ ctx[1] || "Image";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { value } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	const dispatch = createEventDispatcher();

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			value && dispatch("change", value);
		}
	};

	return [value, label, show_label];
}

class StaticImage extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { value: 0, label: 1, show_label: 2 });
	}
}

/* src/components/Image/Image.svelte generated by Svelte v3.49.0 */

function create_else_block(ctx) {
	let image;
	let updating_value;
	let current;

	function image_value_binding(value) {
		/*image_value_binding*/ ctx[15](value);
	}

	let image_props = {
		source: /*source*/ ctx[3],
		tool: /*tool*/ ctx[4],
		label: /*label*/ ctx[5],
		show_label: /*show_label*/ ctx[6],
		pending: /*pending*/ ctx[8],
		streaming: /*streaming*/ ctx[7],
		drop_text: /*$_*/ ctx[14]("interface.drop_image"),
		or_text: /*$_*/ ctx[14]("or"),
		upload_text: /*$_*/ ctx[14]("interface.click_to_upload"),
		mirror_webcam: /*mirror_webcam*/ ctx[10]
	};

	if (/*value*/ ctx[0] !== void 0) {
		image_props.value = /*value*/ ctx[0];
	}

	image = new Image_1$2({ props: image_props });
	binding_callbacks.push(() => bind(image, 'value', image_value_binding));
	image.$on("edit", /*edit_handler*/ ctx[16]);
	image.$on("clear", /*clear_handler*/ ctx[17]);
	image.$on("change", /*change_handler*/ ctx[18]);
	image.$on("stream", /*stream_handler*/ ctx[19]);
	image.$on("drag", /*drag_handler*/ ctx[20]);

	return {
		c() {
			create_component(image.$$.fragment);
		},
		m(target, anchor) {
			mount_component(image, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const image_changes = {};
			if (dirty & /*source*/ 8) image_changes.source = /*source*/ ctx[3];
			if (dirty & /*tool*/ 16) image_changes.tool = /*tool*/ ctx[4];
			if (dirty & /*label*/ 32) image_changes.label = /*label*/ ctx[5];
			if (dirty & /*show_label*/ 64) image_changes.show_label = /*show_label*/ ctx[6];
			if (dirty & /*pending*/ 256) image_changes.pending = /*pending*/ ctx[8];
			if (dirty & /*streaming*/ 128) image_changes.streaming = /*streaming*/ ctx[7];
			if (dirty & /*$_*/ 16384) image_changes.drop_text = /*$_*/ ctx[14]("interface.drop_image");
			if (dirty & /*$_*/ 16384) image_changes.or_text = /*$_*/ ctx[14]("or");
			if (dirty & /*$_*/ 16384) image_changes.upload_text = /*$_*/ ctx[14]("interface.click_to_upload");
			if (dirty & /*mirror_webcam*/ 1024) image_changes.mirror_webcam = /*mirror_webcam*/ ctx[10];

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				image_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			image.$set(image_changes);
		},
		i(local) {
			if (current) return;
			transition_in(image.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(image.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(image, detaching);
		}
	};
}

// (36:1) {#if mode === "static"}
function create_if_block(ctx) {
	let staticimage;
	let current;

	staticimage = new StaticImage({
			props: {
				value: /*value*/ ctx[0],
				label: /*label*/ ctx[5],
				show_label: /*show_label*/ ctx[6]
			}
		});

	return {
		c() {
			create_component(staticimage.$$.fragment);
		},
		m(target, anchor) {
			mount_component(staticimage, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const staticimage_changes = {};
			if (dirty & /*value*/ 1) staticimage_changes.value = /*value*/ ctx[0];
			if (dirty & /*label*/ 32) staticimage_changes.label = /*label*/ ctx[5];
			if (dirty & /*show_label*/ 64) staticimage_changes.show_label = /*show_label*/ ctx[6];
			staticimage.$set(staticimage_changes);
		},
		i(local) {
			if (current) return;
			transition_in(staticimage.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(staticimage.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(staticimage, detaching);
		}
	};
}

// (25:0) <Block  {visible}  variant={mode === "dynamic" && value === null && source === "upload"   ? "dashed"   : "solid"}  color={dragging ? "green" : "grey"}  padding={false}  {elem_id}  style={{ rounded: style.rounded, height: style.height, width: style.width }} >
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[11]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });
	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*mode*/ ctx[12] === "static") return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 2048)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[11])])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[2],
				variant: /*mode*/ ctx[12] === "dynamic" && /*value*/ ctx[0] === null && /*source*/ ctx[3] === "upload"
				? "dashed"
				: "solid",
				color: /*dragging*/ ctx[13] ? "green" : "grey",
				padding: false,
				elem_id: /*elem_id*/ ctx[1],
				style: {
					rounded: /*style*/ ctx[9].rounded,
					height: /*style*/ ctx[9].height,
					width: /*style*/ ctx[9].width
				},
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];

			if (dirty & /*mode, value, source*/ 4105) block_changes.variant = /*mode*/ ctx[12] === "dynamic" && /*value*/ ctx[0] === null && /*source*/ ctx[3] === "upload"
			? "dashed"
			: "solid";

			if (dirty & /*dragging*/ 8192) block_changes.color = /*dragging*/ ctx[13] ? "green" : "grey";
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];

			if (dirty & /*style*/ 512) block_changes.style = {
				rounded: /*style*/ ctx[9].rounded,
				height: /*style*/ ctx[9].height,
				width: /*style*/ ctx[9].width
			};

			if (dirty & /*$$scope, value, label, show_label, mode, source, tool, pending, streaming, $_, mirror_webcam, dragging, loading_status*/ 4226553) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let $_;
	component_subscribe($$self, X, $$value => $$invalidate(14, $_ = $$value));
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = null } = $$props;
	let { source = "upload" } = $$props;
	let { tool = "editor" } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	let { streaming } = $$props;
	let { pending } = $$props;
	let { style = {} } = $$props;
	let { mirror_webcam } = $$props;
	let { loading_status } = $$props;
	let { mode } = $$props;
	const dispatch = createEventDispatcher();
	let dragging;

	function image_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function edit_handler(event) {
		bubble.call(this, $$self, event);
	}

	function clear_handler(event) {
		bubble.call(this, $$self, event);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function stream_handler(event) {
		bubble.call(this, $$self, event);
	}

	const drag_handler = ({ detail }) => $$invalidate(13, dragging = detail);

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('source' in $$props) $$invalidate(3, source = $$props.source);
		if ('tool' in $$props) $$invalidate(4, tool = $$props.tool);
		if ('label' in $$props) $$invalidate(5, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('streaming' in $$props) $$invalidate(7, streaming = $$props.streaming);
		if ('pending' in $$props) $$invalidate(8, pending = $$props.pending);
		if ('style' in $$props) $$invalidate(9, style = $$props.style);
		if ('mirror_webcam' in $$props) $$invalidate(10, mirror_webcam = $$props.mirror_webcam);
		if ('loading_status' in $$props) $$invalidate(11, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(12, mode = $$props.mode);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			$$invalidate(0, value = !value ? null : value);
		}

		if ($$self.$$.dirty & /*value*/ 1) {
			(dispatch("change"));
		}
	};

	return [
		value,
		elem_id,
		visible,
		source,
		tool,
		label,
		show_label,
		streaming,
		pending,
		style,
		mirror_webcam,
		loading_status,
		mode,
		dragging,
		$_,
		image_value_binding,
		edit_handler,
		clear_handler,
		change_handler,
		stream_handler,
		drag_handler
	];
}

class Image_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 0,
			source: 3,
			tool: 4,
			label: 5,
			show_label: 6,
			streaming: 7,
			pending: 8,
			style: 9,
			mirror_webcam: 10,
			loading_status: 11,
			mode: 12
		});
	}
}

var Image_1$1 = Image_1;

const modes = ["static", "dynamic"];

export { Image_1$1 as Component, modes };
