import { S as SvelteComponent, i as init, s as safe_not_equal, a as svg_element, b as attr, c as insert, d as append, n as noop, e as detach, f as element, m as space, t as toggle_class, y as group_outros, w as transition_out, z as check_outros, v as transition_in, h as text, j as set_data, k as empty, q as create_component, u as mount_component, x as destroy_component, o as destroy_each, l as listen, a7 as add_render_callback, ae as create_in_transition, af as create_out_transition, E as onDestroy, A as createEventDispatcher, L as assign, M as StatusTracker, N as get_spread_update, O as get_spread_object } from './index.f6fa633d.js';
import { f as fade } from './index.062b6ddf.js';
import { B as Block } from './Block.e5eb98d1.js';
import { B as BlockLabel } from './BlockLabel.c21e41ab.js';
import './styles.db46e346.js';

/* Users/aliabid/projects/gradio/ui/packages/icons/src/JSON.svelte generated by Svelte v3.47.0 */

function create_fragment$3(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr(path, "fill", "currentColor");
			attr(path, "d", "M5 3h2v2H5v5a2 2 0 0 1-2 2a2 2 0 0 1 2 2v5h2v2H5c-1.07-.27-2-.9-2-2v-4a2 2 0 0 0-2-2H0v-2h1a2 2 0 0 0 2-2V5a2 2 0 0 1 2-2m14 0a2 2 0 0 1 2 2v4a2 2 0 0 0 2 2h1v2h-1a2 2 0 0 0-2 2v4a2 2 0 0 1-2 2h-2v-2h2v-5a2 2 0 0 1 2-2a2 2 0 0 1-2-2V5h-2V3h2m-7 12a1 1 0 0 1 1 1a1 1 0 0 1-1 1a1 1 0 0 1-1-1a1 1 0 0 1 1-1m-4 0a1 1 0 0 1 1 1a1 1 0 0 1-1 1a1 1 0 0 1-1-1a1 1 0 0 1 1-1m8 0a1 1 0 0 1 1 1a1 1 0 0 1-1 1a1 1 0 0 1-1-1a1 1 0 0 1 1-1Z");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "xmlns:xlink", "http://www.w3.org/1999/xlink");
			attr(svg, "aria-hidden", "true");
			attr(svg, "role", "img");
			attr(svg, "class", "iconify iconify--mdi");
			attr(svg, "width", "100%");
			attr(svg, "height", "100%");
			attr(svg, "preserveAspectRatio", "xMidYMid meet");
			attr(svg, "viewBox", "0 0 24 24");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

class JSON$1 extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, null, create_fragment$3, safe_not_equal, {});
	}
}

/* Users/aliabid/projects/gradio/ui/packages/json/src/JSONNode.svelte generated by Svelte v3.47.0 */

function get_each_context_1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[5] = list[i];
	child_ctx[7] = i;
	return child_ctx;
}

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[5] = list[i];
	child_ctx[7] = i;
	return child_ctx;
}

// (82:1) {:else}
function create_else_block_2(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[1]);
			attr(div, "class", "json-item inline");
			attr(div, "item-type", "other");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 2) set_data(t, /*value*/ ctx[1]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (78:37) 
function create_if_block_9(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[1]);
			attr(div, "class", "json-item inline text-blue-500");
			attr(div, "item-type", "number");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 2) set_data(t, /*value*/ ctx[1]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (74:38) 
function create_if_block_8(ctx) {
	let div;
	let t_value = /*value*/ ctx[1].toLocaleString() + "";
	let t;

	return {
		c() {
			div = element("div");
			t = text(t_value);
			attr(div, "class", "json-item inline text-red-500");
			attr(div, "item-type", "boolean");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 2 && t_value !== (t_value = /*value*/ ctx[1].toLocaleString() + "")) set_data(t, t_value);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (70:37) 
function create_if_block_7(ctx) {
	let div;
	let t0;
	let t1;
	let t2;

	return {
		c() {
			div = element("div");
			t0 = text("\"");
			t1 = text(/*value*/ ctx[1]);
			t2 = text("\"");
			attr(div, "class", "json-item inline text-green-500");
			attr(div, "item-type", "string");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t0);
			append(div, t1);
			append(div, t2);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 2) set_data(t1, /*value*/ ctx[1]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (63:26) 
function create_if_block_6(ctx) {
	let div;

	return {
		c() {
			div = element("div");
			div.textContent = "null";
			attr(div, "class", "json-item inline text-gray-500 dark:text-gray-400");
			attr(div, "item-type", "null");
		},
		m(target, anchor) {
			insert(target, div, anchor);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (36:35) 
function create_if_block_3(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_4, create_else_block_1];
	const if_blocks = [];

	function select_block_type_2(ctx, dirty) {
		if (/*collapsed*/ ctx[0]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type_2(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_2(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

// (10:1) {#if value instanceof Array}
function create_if_block$2(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_1$1, create_else_block$1];
	const if_blocks = [];

	function select_block_type_1(ctx, dirty) {
		if (/*collapsed*/ ctx[0]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type_1(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_1(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

// (45:2) {:else}
function create_else_block_1(ctx) {
	let t0;
	let div;
	let t1;
	let current;
	let each_value_1 = Object.entries(/*value*/ ctx[1]);
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1(get_each_context_1(ctx, each_value_1, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			t0 = text("{\n\t\t\t");
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t1 = text("\n\t\t\t}");
			attr(div, "class", "json-children pl-4");
		},
		m(target, anchor) {
			insert(target, t0, anchor);
			insert(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}

			insert(target, t1, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (dirty & /*Object, value, depth*/ 6) {
				each_value_1 = Object.entries(/*value*/ ctx[1]);
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block_1(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(div, null);
					}
				}

				group_outros();

				for (i = each_value_1.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value_1.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) detach(t0);
			if (detaching) detach(div);
			destroy_each(each_blocks, detaching);
			if (detaching) detach(t1);
		}
	};
}

// (37:2) {#if collapsed}
function create_if_block_4(ctx) {
	let button;
	let t0;
	let t1_value = Object.keys(/*value*/ ctx[1]).length + "";
	let t1;
	let t2;
	let mounted;
	let dispose;

	return {
		c() {
			button = element("button");
			t0 = text("{+");
			t1 = text(t1_value);
			t2 = text(" items}");
		},
		m(target, anchor) {
			insert(target, button, anchor);
			append(button, t0);
			append(button, t1);
			append(button, t2);

			if (!mounted) {
				dispose = listen(button, "click", /*click_handler_1*/ ctx[4]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 2 && t1_value !== (t1_value = Object.keys(/*value*/ ctx[1]).length + "")) set_data(t1, t1_value);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(button);
			mounted = false;
			dispose();
		}
	};
}

// (55:15) {#if i !== Object.keys(value).length - 1}
function create_if_block_5(ctx) {
	let t;

	return {
		c() {
			t = text(",");
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

// (48:4) {#each Object.entries(value) as node, i}
function create_each_block_1(ctx) {
	let div;
	let t0_value = /*node*/ ctx[5][0] + "";
	let t0;
	let t1;
	let jsonnode;
	let show_if = /*i*/ ctx[7] !== Object.keys(/*value*/ ctx[1]).length - 1;
	let t2;
	let current;

	jsonnode = new JSONNode({
			props: {
				value: /*node*/ ctx[5][1],
				depth: /*depth*/ ctx[2] + 1,
				key: /*i*/ ctx[7]
			}
		});

	let if_block = show_if && create_if_block_5();

	return {
		c() {
			div = element("div");
			t0 = text(t0_value);
			t1 = text(": ");
			create_component(jsonnode.$$.fragment);
			if (if_block) if_block.c();
			t2 = space();
			attr(div, "class", "json-item");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t0);
			append(div, t1);
			mount_component(jsonnode, div, null);
			if (if_block) if_block.m(div, null);
			append(div, t2);
			current = true;
		},
		p(ctx, dirty) {
			if ((!current || dirty & /*value*/ 2) && t0_value !== (t0_value = /*node*/ ctx[5][0] + "")) set_data(t0, t0_value);
			const jsonnode_changes = {};
			if (dirty & /*value*/ 2) jsonnode_changes.value = /*node*/ ctx[5][1];
			if (dirty & /*depth*/ 4) jsonnode_changes.depth = /*depth*/ ctx[2] + 1;
			jsonnode.$set(jsonnode_changes);
			if (dirty & /*value*/ 2) show_if = /*i*/ ctx[7] !== Object.keys(/*value*/ ctx[1]).length - 1;

			if (show_if) {
				if (if_block) ; else {
					if_block = create_if_block_5();
					if_block.c();
					if_block.m(div, t2);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		i(local) {
			if (current) return;
			transition_in(jsonnode.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(jsonnode.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			destroy_component(jsonnode);
			if (if_block) if_block.d();
		}
	};
}

// (22:2) {:else}
function create_else_block$1(ctx) {
	let t0;
	let div;
	let t1;
	let current;
	let each_value = /*value*/ ctx[1];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			t0 = text("[\n\t\t\t");
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t1 = text("\n\t\t\t]");
			attr(div, "class", "json-children pl-4");
		},
		m(target, anchor) {
			insert(target, t0, anchor);
			insert(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}

			insert(target, t1, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (dirty & /*value, depth*/ 6) {
				each_value = /*value*/ ctx[1];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(div, null);
					}
				}

				group_outros();

				for (i = each_value.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) detach(t0);
			if (detaching) detach(div);
			destroy_each(each_blocks, detaching);
			if (detaching) detach(t1);
		}
	};
}

// (11:2) {#if collapsed}
function create_if_block_1$1(ctx) {
	let button;
	let span;
	let t0;
	let t1_value = /*value*/ ctx[1].length + "";
	let t1;
	let t2;
	let mounted;
	let dispose;

	return {
		c() {
			button = element("button");
			span = element("span");
			t0 = text("expand ");
			t1 = text(t1_value);
			t2 = text(" children");
			attr(span, "class", "bg-gray-50 hover:bg-gray-100 px-1 border rounded text-gray-700 dark:hover:bg-gray-800");
		},
		m(target, anchor) {
			insert(target, button, anchor);
			append(button, span);
			append(span, t0);
			append(span, t1);
			append(span, t2);

			if (!mounted) {
				dispose = listen(button, "click", /*click_handler*/ ctx[3]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 2 && t1_value !== (t1_value = /*value*/ ctx[1].length + "")) set_data(t1, t1_value);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(button);
			mounted = false;
			dispose();
		}
	};
}

// (28:6) {#if i !== value.length - 1}
function create_if_block_2(ctx) {
	let t;

	return {
		c() {
			t = text(",");
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

// (25:4) {#each value as node, i}
function create_each_block(ctx) {
	let div;
	let t0;
	let t1;
	let jsonnode;
	let t2;
	let t3;
	let current;

	jsonnode = new JSONNode({
			props: {
				value: /*node*/ ctx[5],
				depth: /*depth*/ ctx[2] + 1
			}
		});

	let if_block = /*i*/ ctx[7] !== /*value*/ ctx[1].length - 1 && create_if_block_2();

	return {
		c() {
			div = element("div");
			t0 = text(/*i*/ ctx[7]);
			t1 = text(": ");
			create_component(jsonnode.$$.fragment);
			t2 = space();
			if (if_block) if_block.c();
			t3 = space();
			attr(div, "class", "json-item");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t0);
			append(div, t1);
			mount_component(jsonnode, div, null);
			append(div, t2);
			if (if_block) if_block.m(div, null);
			append(div, t3);
			current = true;
		},
		p(ctx, dirty) {
			const jsonnode_changes = {};
			if (dirty & /*value*/ 2) jsonnode_changes.value = /*node*/ ctx[5];
			if (dirty & /*depth*/ 4) jsonnode_changes.depth = /*depth*/ ctx[2] + 1;
			jsonnode.$set(jsonnode_changes);

			if (/*i*/ ctx[7] !== /*value*/ ctx[1].length - 1) {
				if (if_block) ; else {
					if_block = create_if_block_2();
					if_block.c();
					if_block.m(div, t3);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		i(local) {
			if (current) return;
			transition_in(jsonnode.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(jsonnode.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			destroy_component(jsonnode);
			if (if_block) if_block.d();
		}
	};
}

function create_fragment$2(ctx) {
	let span;
	let t;
	let div;
	let current_block_type_index;
	let if_block;
	let current;

	const if_block_creators = [
		create_if_block$2,
		create_if_block_3,
		create_if_block_6,
		create_if_block_7,
		create_if_block_8,
		create_if_block_9,
		create_else_block_2
	];

	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[1] instanceof Array) return 0;
		if (/*value*/ ctx[1] instanceof Object) return 1;
		if (/*value*/ ctx[1] === null) return 2;
		if (typeof /*value*/ ctx[1] === "string") return 3;
		if (typeof /*value*/ ctx[1] === "boolean") return 4;
		if (typeof /*value*/ ctx[1] === "number") return 5;
		return 6;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			span = element("span");
			t = space();
			div = element("div");
			if_block.c();
			attr(span, "class", "inline-block h-0 w-0");
			toggle_class(span, "mt-10", /*depth*/ ctx[2] === 0);
			attr(div, "class", "json-node inline text-sm font-mono leading-tight dark:text-slate-200");
		},
		m(target, anchor) {
			insert(target, span, anchor);
			insert(target, t, anchor);
			insert(target, div, anchor);
			if_blocks[current_block_type_index].m(div, null);
			current = true;
		},
		p(ctx, [dirty]) {
			if (dirty & /*depth*/ 4) {
				toggle_class(span, "mt-10", /*depth*/ ctx[2] === 0);
			}

			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(div, null);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(span);
			if (detaching) detach(t);
			if (detaching) detach(div);
			if_blocks[current_block_type_index].d();
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { value } = $$props;
	let { depth } = $$props;
	let { collapsed = depth > 4 } = $$props;

	const click_handler = () => {
		$$invalidate(0, collapsed = false);
	};

	const click_handler_1 = () => {
		$$invalidate(0, collapsed = false);
	};

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(1, value = $$props.value);
		if ('depth' in $$props) $$invalidate(2, depth = $$props.depth);
		if ('collapsed' in $$props) $$invalidate(0, collapsed = $$props.collapsed);
	};

	return [collapsed, value, depth, click_handler, click_handler_1];
}

class JSONNode extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$2, create_fragment$2, safe_not_equal, { value: 1, depth: 2, collapsed: 0 });
	}
}

/* Users/aliabid/projects/gradio/ui/packages/json/src/JSON.svelte generated by Svelte v3.47.0 */

function create_if_block$1(ctx) {
	let span;
	let span_intro;
	let span_outro;
	let current;

	return {
		c() {
			span = element("span");
			span.textContent = "COPIED";
			attr(span, "class", "font-bold dark:text-green-400 text-green-600 py-1 px-2 absolute block w-full text-left bg-white dark:bg-gray-900");
		},
		m(target, anchor) {
			insert(target, span, anchor);
			current = true;
		},
		i(local) {
			if (current) return;

			add_render_callback(() => {
				if (span_outro) span_outro.end(1);
				span_intro = create_in_transition(span, fade, { duration: 100 });
				span_intro.start();
			});

			current = true;
		},
		o(local) {
			if (span_intro) span_intro.invalidate();
			span_outro = create_out_transition(span, fade, { duration: 350 });
			current = false;
		},
		d(detaching) {
			if (detaching) detach(span);
			if (detaching && span_outro) span_outro.end();
		}
	};
}

function create_fragment$1(ctx) {
	let button;
	let span;
	let t1;
	let t2;
	let jsonnode;
	let current;
	let mounted;
	let dispose;
	let if_block = /*copied*/ ctx[1] && create_if_block$1();

	jsonnode = new JSONNode({
			props: { value: /*value*/ ctx[0], depth: 0 }
		});

	return {
		c() {
			button = element("button");
			span = element("span");
			span.textContent = "copy to clipboard";
			t1 = space();
			if (if_block) if_block.c();
			t2 = space();
			create_component(jsonnode.$$.fragment);
			attr(span, "class", "py-1 px-2");
			attr(button, "class", "transition-color overflow-hidden font-sans absolute right-0 top-0 rounded-bl-lg shadow-sm text-xs text-gray-500 flex items-center bg-white z-20 border-l border-b border-gray-100 dark:text-slate-200");
		},
		m(target, anchor) {
			insert(target, button, anchor);
			append(button, span);
			append(button, t1);
			if (if_block) if_block.m(button, null);
			insert(target, t2, anchor);
			mount_component(jsonnode, target, anchor);
			current = true;

			if (!mounted) {
				dispose = listen(button, "click", /*handle_copy*/ ctx[2]);
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (/*copied*/ ctx[1]) {
				if (if_block) {
					if (dirty & /*copied*/ 2) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block$1();
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(button, null);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			const jsonnode_changes = {};
			if (dirty & /*value*/ 1) jsonnode_changes.value = /*value*/ ctx[0];
			jsonnode.$set(jsonnode_changes);
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			transition_in(jsonnode.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			transition_out(jsonnode.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(button);
			if (if_block) if_block.d();
			if (detaching) detach(t2);
			destroy_component(jsonnode, detaching);
			mounted = false;
			dispose();
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { value = {} } = $$props;
	let copied = false;
	let timer;

	function copy_feedback() {
		$$invalidate(1, copied = true);
		if (timer) clearTimeout(timer);

		timer = setTimeout(
			() => {
				$$invalidate(1, copied = false);
			},
			1000
		);
	}

	async function handle_copy() {
		if ("clipboard" in navigator) {
			await navigator.clipboard.writeText(JSON.stringify(value, null, 2));
			copy_feedback();
		}
	}

	onDestroy(() => {
		if (timer) clearTimeout(timer);
	});

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value, copied, handle_copy];
}

class JSON_1 extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { value: 0 });
	}
}

/* src/components/Json/Json.svelte generated by Svelte v3.47.0 */

function create_if_block_1(ctx) {
	let blocklabel;
	let current;

	blocklabel = new BlockLabel({
			props: {
				Icon: JSON$1,
				label: /*label*/ ctx[4],
				disable: typeof /*style*/ ctx[5].container === "boolean" && !/*style*/ ctx[5].container
			}
		});

	return {
		c() {
			create_component(blocklabel.$$.fragment);
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const blocklabel_changes = {};
			if (dirty & /*label*/ 16) blocklabel_changes.label = /*label*/ ctx[4];
			if (dirty & /*style*/ 32) blocklabel_changes.disable = typeof /*style*/ ctx[5].container === "boolean" && !/*style*/ ctx[5].container;
			blocklabel.$set(blocklabel_changes);
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
		}
	};
}

// (34:1) {:else}
function create_else_block(ctx) {
	let div1;
	let div0;
	let jsonicon;
	let current;
	jsonicon = new JSON$1({});

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			create_component(jsonicon.$$.fragment);
			attr(div0, "class", "h-7 dark:text-white opacity-50");
			attr(div1, "class", "h-full min-h-[6rem] flex justify-center items-center");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			mount_component(jsonicon, div0, null);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(jsonicon.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(jsonicon.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			destroy_component(jsonicon);
		}
	};
}

// (32:1) {#if value && value !== '""'}
function create_if_block(ctx) {
	let json;
	let current;
	json = new JSON_1({ props: { value: /*value*/ ctx[2] } });

	return {
		c() {
			create_component(json.$$.fragment);
		},
		m(target, anchor) {
			mount_component(json, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const json_changes = {};
			if (dirty & /*value*/ 4) json_changes.value = /*value*/ ctx[2];
			json.$set(json_changes);
		},
		i(local) {
			if (current) return;
			transition_in(json.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(json.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(json, detaching);
		}
	};
}

// (16:0) <Block  {visible}  test_id="json"  {elem_id}  disable={typeof style.container === "boolean" && !style.container} >
function create_default_slot(ctx) {
	let t0;
	let statustracker;
	let t1;
	let current_block_type_index;
	let if_block1;
	let if_block1_anchor;
	let current;
	let if_block0 = /*label*/ ctx[4] && create_if_block_1(ctx);
	const statustracker_spread_levels = [/*loading_status*/ ctx[3]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });
	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[2] && /*value*/ ctx[2] !== '""') return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block1 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			if (if_block0) if_block0.c();
			t0 = space();
			create_component(statustracker.$$.fragment);
			t1 = space();
			if_block1.c();
			if_block1_anchor = empty();
		},
		m(target, anchor) {
			if (if_block0) if_block0.m(target, anchor);
			insert(target, t0, anchor);
			mount_component(statustracker, target, anchor);
			insert(target, t1, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block1_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (/*label*/ ctx[4]) {
				if (if_block0) {
					if_block0.p(ctx, dirty);

					if (dirty & /*label*/ 16) {
						transition_in(if_block0, 1);
					}
				} else {
					if_block0 = create_if_block_1(ctx);
					if_block0.c();
					transition_in(if_block0, 1);
					if_block0.m(t0.parentNode, t0);
				}
			} else if (if_block0) {
				group_outros();

				transition_out(if_block0, 1, 1, () => {
					if_block0 = null;
				});

				check_outros();
			}

			const statustracker_changes = (dirty & /*loading_status*/ 8)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[3])])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block1 = if_blocks[current_block_type_index];

				if (!if_block1) {
					if_block1 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block1.c();
				} else {
					if_block1.p(ctx, dirty);
				}

				transition_in(if_block1, 1);
				if_block1.m(if_block1_anchor.parentNode, if_block1_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block0);
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block1);
			current = true;
		},
		o(local) {
			transition_out(if_block0);
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block1);
			current = false;
		},
		d(detaching) {
			if (if_block0) if_block0.d(detaching);
			if (detaching) detach(t0);
			destroy_component(statustracker, detaching);
			if (detaching) detach(t1);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block1_anchor);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[1],
				test_id: "json",
				elem_id: /*elem_id*/ ctx[0],
				disable: typeof /*style*/ ctx[5].container === "boolean" && !/*style*/ ctx[5].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 2) block_changes.visible = /*visible*/ ctx[1];
			if (dirty & /*elem_id*/ 1) block_changes.elem_id = /*elem_id*/ ctx[0];
			if (dirty & /*style*/ 32) block_changes.disable = typeof /*style*/ ctx[5].container === "boolean" && !/*style*/ ctx[5].container;

			if (dirty & /*$$scope, value, loading_status, label, style*/ 188) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value } = $$props;
	let { loading_status } = $$props;
	let { label } = $$props;
	let { style = {} } = $$props;
	const dispatch = createEventDispatcher();

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(0, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(1, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(2, value = $$props.value);
		if ('loading_status' in $$props) $$invalidate(3, loading_status = $$props.loading_status);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('style' in $$props) $$invalidate(5, style = $$props.style);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 4) {
			(dispatch("change"));
		}
	};

	return [elem_id, visible, value, loading_status, label, style];
}

class Json extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 0,
			visible: 1,
			value: 2,
			loading_status: 3,
			label: 4,
			style: 5
		});
	}
}

var Json$1 = Json;

const modes = ["static"];

export { Json$1 as Component, modes };
