import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-steplist {\n    position: relative;\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n    overflow-x: auto;\n}\n\n.p-step {\n    position: relative;\n    display: flex;\n    flex: 1 1 auto;\n    align-items: center;\n    gap: ".concat(dt('stepper.step.gap'), ";\n    padding: ").concat(dt('stepper.step.padding'), ";\n}\n\n.p-step:last-of-type {\n    flex: initial;\n}\n\n.p-step-header {\n    border: 0 none;\n    display: inline-flex;\n    align-items: center;\n    text-decoration: none;\n    cursor: pointer;\n    transition: background ").concat(dt('stepper.transition.duration'), ", color ").concat(dt('stepper.transition.duration'), ", border-color ").concat(dt('stepper.transition.duration'), ", outline-color ").concat(dt('stepper.transition.duration'), ", box-shadow ").concat(dt('stepper.transition.duration'), ";\n    border-radius: ").concat(dt('stepper.step.header.border.radius'), ";\n    outline-color: transparent;\n    background: transparent;\n    padding: ").concat(dt('stepper.step.header.padding'), ";\n    gap: ").concat(dt('stepper.step.header.gap'), ";\n}\n\n.p-step-header:focus-visible {\n    box-shadow: ").concat(dt('stepper.step.header.focus.ring.shadow'), ";\n    outline: ").concat(dt('stepper.step.header.focus.ring.width'), " ").concat(dt('stepper.step.header.focus.ring.style'), " ").concat(dt('stepper.step.header.focus.ring.color'), ";\n    outline-offset: ").concat(dt('stepper.step.header.focus.ring.offset'), ";\n}\n\n.p-stepper.p-stepper-readonly .p-step {\n    cursor: auto;\n}\n\n.p-step-title {\n    display: block;\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    max-width: 100%;\n    color: ").concat(dt('stepper.step.title.color'), ";\n    font-weight: ").concat(dt('stepper.step.title.font.weight'), ";\n    transition: background ").concat(dt('stepper.transition.duration'), ", color ").concat(dt('stepper.transition.duration'), ", border-color ").concat(dt('stepper.transition.duration'), ", box-shadow ").concat(dt('stepper.transition.duration'), ", outline-color ").concat(dt('stepper.transition.duration'), ";\n}\n\n.p-step-number {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    color: ").concat(dt('stepper.step.number.color'), ";\n    border: 2px solid ").concat(dt('stepper.step.number.border.color'), ";\n    background: ").concat(dt('stepper.step.number.background'), ";\n    min-width: ").concat(dt('stepper.step.number.size'), ";\n    height: ").concat(dt('stepper.step.number.size'), ";\n    line-height: ").concat(dt('stepper.step.number.size'), ";\n    font-size: ").concat(dt('stepper.step.number.font.size'), ";\n    z-index: 1;\n    border-radius: ").concat(dt('stepper.step.number.border.radius'), ";\n    position: relative;\n    font-weight: ").concat(dt('stepper.step.number.font.weight'), ";\n}\n\n.p-step-number::after {\n    content: \" \";\n    position: absolute;\n    width: 100%;\n    height: 100%;\n    border-radius: ").concat(dt('stepper.step.number.border.radius'), ";\n    box-shadow: ").concat(dt('stepper.step.number.shadow'), ";\n}\n\n.p-step-active .p-step-header {\n    cursor: default;\n}\n\n.p-step-active .p-step-number {\n    background: ").concat(dt('stepper.step.number.active.background'), ";\n    border-color: ").concat(dt('stepper.step.number.active.border.color'), ";\n    color: ").concat(dt('stepper.step.number.active.color'), ";\n}\n\n.p-step-active .p-step-title {\n    color: ").concat(dt('stepper.step.title.active.color'), ";\n}\n\n.p-step:not(.p-disabled):focus-visible {\n    outline: ").concat(dt('focus.ring.width'), " ").concat(dt('focus.ring.style'), " ").concat(dt('focus.ring.color'), ";\n    outline-offset: ").concat(dt('focus.ring.offset'), ";\n}\n\n.p-step:has(~ .p-step-active) .p-stepper-separator {\n    background: ").concat(dt('stepper.separator.active.background'), ";\n}\n\n.p-stepper-separator {\n    flex: 1 1 0;\n    background: ").concat(dt('stepper.separator.background'), ";\n    width: 100%;\n    height: ").concat(dt('stepper.separator.size'), ";\n    transition: background ").concat(dt('stepper.transition.duration'), ", color ").concat(dt('stepper.transition.duration'), ", border-color ").concat(dt('stepper.transition.duration'), ", box-shadow ").concat(dt('stepper.transition.duration'), ", outline-color ").concat(dt('stepper.transition.duration'), ";\n}\n\n.p-steppanels {\n    padding: ").concat(dt('stepper.steppanels.padding'), ";\n}\n\n.p-steppanel {\n    background: ").concat(dt('stepper.steppanel.background'), ";\n    color: ").concat(dt('stepper.steppanel.color'), ";\n}\n\n.p-stepper:has(.p-stepitem) {\n    display: flex;\n    flex-direction: column;\n}\n\n.p-stepitem {\n    display: flex;\n    flex-direction: column;\n    flex: initial;\n}\n\n.p-stepitem.p-stepitem-active {\n    flex: 1 1 auto;\n}\n\n.p-stepitem .p-step {\n    flex: initial;\n}\n\n.p-stepitem .p-steppanel-content {\n    width: 100%;\n    padding: ").concat(dt('stepper.steppanel.padding'), ";\n    margin-inline-start: 1rem;\n}\n\n.p-stepitem .p-steppanel {\n    display: flex;\n    flex: 1 1 auto;\n}\n\n.p-stepitem .p-stepper-separator {\n    flex: 0 0 auto;\n    width: ").concat(dt('stepper.separator.size'), ";\n    height: auto;\n    margin: ").concat(dt('stepper.separator.margin'), ";\n    position: relative;\n    left: calc(-1 * ").concat(dt('stepper.separator.size'), ");\n}\n\n.p-stepitem .p-stepper-separator:dir(rtl) {\n    left: calc(-9 * ").concat(dt('stepper.separator.size'), ");\n}\n\n.p-stepitem:has(~ .p-stepitem-active) .p-stepper-separator {\n    background: ").concat(dt('stepper.separator.active.background'), ";\n}\n\n.p-stepitem:last-of-type .p-steppanel {\n    padding-inline-start: ").concat(dt('stepper.step.number.size'), ";\n}\n");
};
var classes = {
  root: function root(_ref2) {
    var props = _ref2.props;
    return ['p-stepper p-component', {
      'p-readonly': props.linear
    }];
  },
  separator: 'p-stepper-separator'
};
var StepperStyle = BaseStyle.extend({
  name: 'stepper',
  theme: theme,
  classes: classes
});

export { StepperStyle as default };
//# sourceMappingURL=index.mjs.map
