import { S as SvelteComponent, i as init, s as safe_not_equal, q as create_component, m as space, k as empty, u as mount_component, c as insert, y as group_outros, w as transition_out, z as check_outros, v as transition_in, x as destroy_component, e as detach, f as element, b as attr, d as append, n as noop, h as text, j as set_data, A as createEventDispatcher, a5 as tick, D as binding_callbacks, J as bind, G as add_flush_callback, K as component_subscribe, X, L as assign, M as StatusTracker, N as get_spread_update, O as get_spread_object, F as bubble } from './index.84deab0e.js';
import { B as BlockLabel } from './BlockLabel.ce76d00d.js';
import { F as File } from './File.3867c820.js';
import { U as Upload } from './Upload.e791326b.js';
import { M as ModifyUpload } from './ModifyUpload.8136c6d4.js';
import { B as Block } from './Block.aa3159d5.js';
import { n as normalise_file } from './utils.49185b04.js';
import './styles.db46e346.js';

const prettyBytes = (bytes) => {
  let units = ["B", "KB", "MB", "GB", "PB"];
  let i = 0;
  while (bytes > 1024) {
    bytes /= 1024;
    i++;
  }
  let unit = units[i];
  return bytes.toFixed(1) + " " + unit;
};
const display_file_name = (value) => {
  var str;
  if (Array.isArray(value)) {
    if (value.length > 1) {
      return value.length + " files";
    } else {
      str = value[0].name;
    }
  } else {
    str = value.name;
  }
  if (str.length > 30) {
    return `${str.substr(0, 30)}...`;
  } else
    return str;
};
const download_files = (value) => {
  return Array.isArray(value) ? value[0].data : value.data;
};
const display_file_size = (value) => {
  var total_size = 0;
  if (Array.isArray(value)) {
    for (var file of value) {
      total_size += file.size;
    }
  } else {
    total_size = value.size;
  }
  return prettyBytes(total_size || 0);
};

/* home/runner/work/gradio/gradio/ui/packages/file/src/File.svelte generated by Svelte v3.47.0 */

function create_else_block$2(ctx) {
	let div1;
	let div0;
	let file;
	let current;
	file = new File({});

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			create_component(file.$$.fragment);
			attr(div0, "class", "h-5 dark:text-white opacity-50");
			attr(div1, "class", "h-full min-h-[15rem] flex justify-center items-center");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			mount_component(file, div0, null);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(file.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(file.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			destroy_component(file);
		}
	};
}

// (11:0) {#if value}
function create_if_block$2(ctx) {
	let div3;
	let div0;
	let t0_value = display_file_name(/*value*/ ctx[0]) + "";
	let t0;
	let t1;
	let div1;
	let t2_value = display_file_size(/*value*/ ctx[0]) + "";
	let t2;
	let t3;
	let div2;
	let a;
	let t4;
	let a_href_value;

	return {
		c() {
			div3 = element("div");
			div0 = element("div");
			t0 = text(t0_value);
			t1 = space();
			div1 = element("div");
			t2 = text(t2_value);
			t3 = space();
			div2 = element("div");
			a = element("a");
			t4 = text("Download");
			attr(div0, "class", "file-name p-2");
			attr(div1, "class", "file-size p-2");
			attr(a, "href", a_href_value = download_files(/*value*/ ctx[0]));
			attr(a, "download", "");
			attr(a, "class", "text-indigo-600 hover:underline dark:text-indigo-300");
			attr(div2, "class", "file-size p-2 hover:underline");
			attr(div3, "class", "file-preview w-full flex flex-row justify-between overflow-y-auto mt-7 dark:text-slate-200");
		},
		m(target, anchor) {
			insert(target, div3, anchor);
			append(div3, div0);
			append(div0, t0);
			append(div3, t1);
			append(div3, div1);
			append(div1, t2);
			append(div3, t3);
			append(div3, div2);
			append(div2, a);
			append(a, t4);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && t0_value !== (t0_value = display_file_name(/*value*/ ctx[0]) + "")) set_data(t0, t0_value);
			if (dirty & /*value*/ 1 && t2_value !== (t2_value = display_file_size(/*value*/ ctx[0]) + "")) set_data(t2, t2_value);

			if (dirty & /*value*/ 1 && a_href_value !== (a_href_value = download_files(/*value*/ ctx[0]))) {
				attr(a, "href", a_href_value);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div3);
		}
	};
}

function create_fragment$2(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[2],
				Icon: File,
				label: /*label*/ ctx[1] || "File"
			}
		});

	const if_block_creators = [create_if_block$2, create_else_block$2];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 4) blocklabel_changes.show_label = /*show_label*/ ctx[2];
			if (dirty & /*label*/ 2) blocklabel_changes.label = /*label*/ ctx[1] || "File";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { value } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
	};

	return [value, label, show_label];
}

class File_1$2 extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$2, create_fragment$2, safe_not_equal, { value: 0, label: 1, show_label: 2 });
	}
}

/* home/runner/work/gradio/gradio/ui/packages/file/src/FileUpload.svelte generated by Svelte v3.47.0 */

function create_else_block$1(ctx) {
	let div3;
	let modifyupload;
	let t0;
	let div0;
	let t1_value = display_file_name(/*value*/ ctx[0]) + "";
	let t1;
	let t2;
	let div1;
	let t3_value = display_file_size(/*value*/ ctx[0]) + "";
	let t3;
	let t4;
	let div2;
	let a;
	let t5;
	let a_href_value;
	let current;
	modifyupload = new ModifyUpload({ props: { absolute: true } });
	modifyupload.$on("clear", /*handle_clear*/ ctx[9]);

	return {
		c() {
			div3 = element("div");
			create_component(modifyupload.$$.fragment);
			t0 = space();
			div0 = element("div");
			t1 = text(t1_value);
			t2 = space();
			div1 = element("div");
			t3 = text(t3_value);
			t4 = space();
			div2 = element("div");
			a = element("a");
			t5 = text("Download");
			attr(div0, "class", "file-name p-2");
			attr(div1, "class", "file-size p-2");
			attr(a, "href", a_href_value = download_files(/*value*/ ctx[0]));
			attr(a, "download", "");
			attr(a, "class", "text-indigo-600 hover:underline dark:text-indigo-300");
			attr(div2, "class", "file-size p-2 hover:underline");
			attr(div3, "class", "file-preview w-full flex flex-row justify-between overflow-y-auto mt-7 dark:text-slate-200");
		},
		m(target, anchor) {
			insert(target, div3, anchor);
			mount_component(modifyupload, div3, null);
			append(div3, t0);
			append(div3, div0);
			append(div0, t1);
			append(div3, t2);
			append(div3, div1);
			append(div1, t3);
			append(div3, t4);
			append(div3, div2);
			append(div2, a);
			append(a, t5);
			current = true;
		},
		p(ctx, dirty) {
			if ((!current || dirty & /*value*/ 1) && t1_value !== (t1_value = display_file_name(/*value*/ ctx[0]) + "")) set_data(t1, t1_value);
			if ((!current || dirty & /*value*/ 1) && t3_value !== (t3_value = display_file_size(/*value*/ ctx[0]) + "")) set_data(t3, t3_value);

			if (!current || dirty & /*value*/ 1 && a_href_value !== (a_href_value = download_files(/*value*/ ctx[0]))) {
				attr(a, "href", a_href_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in(modifyupload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(modifyupload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div3);
			destroy_component(modifyupload);
		}
	};
}

// (36:25) 
function create_if_block_1(ctx) {
	let upload;
	let updating_dragging;
	let current;

	function upload_dragging_binding_1(value) {
		/*upload_dragging_binding_1*/ ctx[11](value);
	}

	let upload_props = {
		filetype: "file",
		file_count: /*file_count*/ ctx[6],
		$$slots: { default: [create_default_slot_1] },
		$$scope: { ctx }
	};

	if (/*dragging*/ ctx[7] !== void 0) {
		upload_props.dragging = /*dragging*/ ctx[7];
	}

	upload = new Upload({ props: upload_props });
	binding_callbacks.push(() => bind(upload, 'dragging', upload_dragging_binding_1));
	upload.$on("load", /*handle_upload*/ ctx[8]);

	return {
		c() {
			create_component(upload.$$.fragment);
		},
		m(target, anchor) {
			mount_component(upload, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const upload_changes = {};
			if (dirty & /*file_count*/ 64) upload_changes.file_count = /*file_count*/ ctx[6];

			if (dirty & /*$$scope, upload_text, or_text, drop_text*/ 8206) {
				upload_changes.$$scope = { dirty, ctx };
			}

			if (!updating_dragging && dirty & /*dragging*/ 128) {
				updating_dragging = true;
				upload_changes.dragging = /*dragging*/ ctx[7];
				add_flush_callback(() => updating_dragging = false);
			}

			upload.$set(upload_changes);
		},
		i(local) {
			if (current) return;
			transition_in(upload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(upload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(upload, detaching);
		}
	};
}

// (30:0) {#if value === null && file_count === "single"}
function create_if_block$1(ctx) {
	let upload;
	let updating_dragging;
	let current;

	function upload_dragging_binding(value) {
		/*upload_dragging_binding*/ ctx[10](value);
	}

	let upload_props = {
		filetype: "file",
		$$slots: { default: [create_default_slot$1] },
		$$scope: { ctx }
	};

	if (/*dragging*/ ctx[7] !== void 0) {
		upload_props.dragging = /*dragging*/ ctx[7];
	}

	upload = new Upload({ props: upload_props });
	binding_callbacks.push(() => bind(upload, 'dragging', upload_dragging_binding));
	upload.$on("load", /*handle_upload*/ ctx[8]);

	return {
		c() {
			create_component(upload.$$.fragment);
		},
		m(target, anchor) {
			mount_component(upload, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const upload_changes = {};

			if (dirty & /*$$scope, upload_text, or_text, drop_text*/ 8206) {
				upload_changes.$$scope = { dirty, ctx };
			}

			if (!updating_dragging && dirty & /*dragging*/ 128) {
				updating_dragging = true;
				upload_changes.dragging = /*dragging*/ ctx[7];
				add_flush_callback(() => updating_dragging = false);
			}

			upload.$set(upload_changes);
		},
		i(local) {
			if (current) return;
			transition_in(upload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(upload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(upload, detaching);
		}
	};
}

// (37:1) <Upload on:load={handle_upload} filetype="file" {file_count} bind:dragging>
function create_default_slot_1(ctx) {
	let t0;
	let t1;
	let br0;
	let t2;
	let t3;
	let t4;
	let br1;
	let t5;
	let t6;

	return {
		c() {
			t0 = text(/*drop_text*/ ctx[1]);
			t1 = space();
			br0 = element("br");
			t2 = text("- ");
			t3 = text(/*or_text*/ ctx[2]);
			t4 = text(" -");
			br1 = element("br");
			t5 = space();
			t6 = text(/*upload_text*/ ctx[3]);
		},
		m(target, anchor) {
			insert(target, t0, anchor);
			insert(target, t1, anchor);
			insert(target, br0, anchor);
			insert(target, t2, anchor);
			insert(target, t3, anchor);
			insert(target, t4, anchor);
			insert(target, br1, anchor);
			insert(target, t5, anchor);
			insert(target, t6, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*drop_text*/ 2) set_data(t0, /*drop_text*/ ctx[1]);
			if (dirty & /*or_text*/ 4) set_data(t3, /*or_text*/ ctx[2]);
			if (dirty & /*upload_text*/ 8) set_data(t6, /*upload_text*/ ctx[3]);
		},
		d(detaching) {
			if (detaching) detach(t0);
			if (detaching) detach(t1);
			if (detaching) detach(br0);
			if (detaching) detach(t2);
			if (detaching) detach(t3);
			if (detaching) detach(t4);
			if (detaching) detach(br1);
			if (detaching) detach(t5);
			if (detaching) detach(t6);
		}
	};
}

// (31:1) <Upload on:load={handle_upload} filetype="file" bind:dragging>
function create_default_slot$1(ctx) {
	let t0;
	let t1;
	let br0;
	let t2;
	let t3;
	let t4;
	let br1;
	let t5;
	let t6;

	return {
		c() {
			t0 = text(/*drop_text*/ ctx[1]);
			t1 = space();
			br0 = element("br");
			t2 = text("- ");
			t3 = text(/*or_text*/ ctx[2]);
			t4 = text(" -");
			br1 = element("br");
			t5 = space();
			t6 = text(/*upload_text*/ ctx[3]);
		},
		m(target, anchor) {
			insert(target, t0, anchor);
			insert(target, t1, anchor);
			insert(target, br0, anchor);
			insert(target, t2, anchor);
			insert(target, t3, anchor);
			insert(target, t4, anchor);
			insert(target, br1, anchor);
			insert(target, t5, anchor);
			insert(target, t6, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*drop_text*/ 2) set_data(t0, /*drop_text*/ ctx[1]);
			if (dirty & /*or_text*/ 4) set_data(t3, /*or_text*/ ctx[2]);
			if (dirty & /*upload_text*/ 8) set_data(t6, /*upload_text*/ ctx[3]);
		},
		d(detaching) {
			if (detaching) detach(t0);
			if (detaching) detach(t1);
			if (detaching) detach(br0);
			if (detaching) detach(t2);
			if (detaching) detach(t3);
			if (detaching) detach(t4);
			if (detaching) detach(br1);
			if (detaching) detach(t5);
			if (detaching) detach(t6);
		}
	};
}

function create_fragment$1(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[5],
				Icon: File,
				label: /*label*/ ctx[4] || "File"
			}
		});

	const if_block_creators = [create_if_block$1, create_if_block_1, create_else_block$1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0] === null && /*file_count*/ ctx[6] === "single") return 0;
		if (/*value*/ ctx[0] === null) return 1;
		return 2;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 32) blocklabel_changes.show_label = /*show_label*/ ctx[5];
			if (dirty & /*label*/ 16) blocklabel_changes.label = /*label*/ ctx[4] || "File";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { value } = $$props;
	let { drop_text = "Drop a file" } = $$props;
	let { or_text = "or" } = $$props;
	let { upload_text = "click to upload" } = $$props;
	let { label = "" } = $$props;
	let { show_label } = $$props;
	let { file_count } = $$props;

	async function handle_upload({ detail }) {
		$$invalidate(0, value = detail);
		await tick();
		dispatch("change", value);
	}

	function handle_clear({ detail }) {
		$$invalidate(0, value = null);
		dispatch("change", value);
		dispatch("clear");
	}

	const dispatch = createEventDispatcher();
	let dragging = false;

	function upload_dragging_binding(value) {
		dragging = value;
		$$invalidate(7, dragging);
	}

	function upload_dragging_binding_1(value) {
		dragging = value;
		$$invalidate(7, dragging);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('drop_text' in $$props) $$invalidate(1, drop_text = $$props.drop_text);
		if ('or_text' in $$props) $$invalidate(2, or_text = $$props.or_text);
		if ('upload_text' in $$props) $$invalidate(3, upload_text = $$props.upload_text);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('file_count' in $$props) $$invalidate(6, file_count = $$props.file_count);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*dragging*/ 128) {
			dispatch("drag", dragging);
		}
	};

	return [
		value,
		drop_text,
		or_text,
		upload_text,
		label,
		show_label,
		file_count,
		dragging,
		handle_upload,
		handle_clear,
		upload_dragging_binding,
		upload_dragging_binding_1
	];
}

class FileUpload extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			drop_text: 1,
			or_text: 2,
			upload_text: 3,
			label: 4,
			show_label: 5,
			file_count: 6
		});
	}
}

/* src/components/File/File.svelte generated by Svelte v3.47.0 */

function create_else_block(ctx) {
	let file;
	let current;

	file = new File_1$2({
			props: {
				value: /*_value*/ ctx[9],
				label: /*label*/ ctx[4],
				show_label: /*show_label*/ ctx[5]
			}
		});

	return {
		c() {
			create_component(file.$$.fragment);
		},
		m(target, anchor) {
			mount_component(file, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const file_changes = {};
			if (dirty & /*_value*/ 512) file_changes.value = /*_value*/ ctx[9];
			if (dirty & /*label*/ 16) file_changes.label = /*label*/ ctx[4];
			if (dirty & /*show_label*/ 32) file_changes.show_label = /*show_label*/ ctx[5];
			file.$set(file_changes);
		},
		i(local) {
			if (current) return;
			transition_in(file.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(file.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(file, detaching);
		}
	};
}

// (31:1) {#if mode === "dynamic"}
function create_if_block(ctx) {
	let fileupload;
	let current;

	fileupload = new FileUpload({
			props: {
				label: /*label*/ ctx[4],
				show_label: /*show_label*/ ctx[5],
				value: /*_value*/ ctx[9],
				file_count: /*file_count*/ ctx[7],
				drop_text: /*$_*/ ctx[11]("interface.drop_file"),
				or_text: /*$_*/ ctx[11]("or"),
				upload_text: /*$_*/ ctx[11]("interface.click_to_upload")
			}
		});

	fileupload.$on("change", /*change_handler_1*/ ctx[13]);
	fileupload.$on("drag", /*drag_handler*/ ctx[14]);
	fileupload.$on("change", /*change_handler*/ ctx[15]);
	fileupload.$on("clear", /*clear_handler*/ ctx[16]);

	return {
		c() {
			create_component(fileupload.$$.fragment);
		},
		m(target, anchor) {
			mount_component(fileupload, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const fileupload_changes = {};
			if (dirty & /*label*/ 16) fileupload_changes.label = /*label*/ ctx[4];
			if (dirty & /*show_label*/ 32) fileupload_changes.show_label = /*show_label*/ ctx[5];
			if (dirty & /*_value*/ 512) fileupload_changes.value = /*_value*/ ctx[9];
			if (dirty & /*file_count*/ 128) fileupload_changes.file_count = /*file_count*/ ctx[7];
			if (dirty & /*$_*/ 2048) fileupload_changes.drop_text = /*$_*/ ctx[11]("interface.drop_file");
			if (dirty & /*$_*/ 2048) fileupload_changes.or_text = /*$_*/ ctx[11]("or");
			if (dirty & /*$_*/ 2048) fileupload_changes.upload_text = /*$_*/ ctx[11]("interface.click_to_upload");
			fileupload.$set(fileupload_changes);
		},
		i(local) {
			if (current) return;
			transition_in(fileupload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(fileupload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(fileupload, detaching);
		}
	};
}

// (21:0) <Block  {visible}  variant={mode === "dynamic" && value === null ? "dashed" : "solid"}  color={dragging ? "green" : "grey"}  padding={false}  {elem_id}  style={{ rounded: style.rounded }} >
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[8]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });
	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*mode*/ ctx[3] === "dynamic") return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 256)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[8])])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[2],
				variant: /*mode*/ ctx[3] === "dynamic" && /*value*/ ctx[0] === null
				? "dashed"
				: "solid",
				color: /*dragging*/ ctx[10] ? "green" : "grey",
				padding: false,
				elem_id: /*elem_id*/ ctx[1],
				style: { rounded: /*style*/ ctx[6].rounded },
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];

			if (dirty & /*mode, value*/ 9) block_changes.variant = /*mode*/ ctx[3] === "dynamic" && /*value*/ ctx[0] === null
			? "dashed"
			: "solid";

			if (dirty & /*dragging*/ 1024) block_changes.color = /*dragging*/ ctx[10] ? "green" : "grey";
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*style*/ 64) block_changes.style = { rounded: /*style*/ ctx[6].rounded };

			if (dirty & /*$$scope, label, show_label, _value, file_count, $_, value, dragging, mode, loading_status*/ 135097) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let $_;
	component_subscribe($$self, X, $$value => $$invalidate(11, $_ = $$value));
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = null } = $$props;
	let { mode } = $$props;
	let { root } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	let { style = {} } = $$props;
	let { file_count } = $$props;
	let { loading_status } = $$props;
	let _value;
	let dragging = false;
	const change_handler_1 = ({ detail }) => $$invalidate(0, value = detail);
	const drag_handler = ({ detail }) => $$invalidate(10, dragging = detail);

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function clear_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('mode' in $$props) $$invalidate(3, mode = $$props.mode);
		if ('root' in $$props) $$invalidate(12, root = $$props.root);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('style' in $$props) $$invalidate(6, style = $$props.style);
		if ('file_count' in $$props) $$invalidate(7, file_count = $$props.file_count);
		if ('loading_status' in $$props) $$invalidate(8, loading_status = $$props.loading_status);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value, root*/ 4097) {
			$$invalidate(9, _value = normalise_file(value, root));
		}
	};

	return [
		value,
		elem_id,
		visible,
		mode,
		label,
		show_label,
		style,
		file_count,
		loading_status,
		_value,
		dragging,
		$_,
		root,
		change_handler_1,
		drag_handler,
		change_handler,
		clear_handler
	];
}

class File_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 0,
			mode: 3,
			root: 12,
			label: 4,
			show_label: 5,
			style: 6,
			file_count: 7,
			loading_status: 8
		});
	}
}

var File_1$1 = File_1;

const modes = ["static", "dynamic"];

export { File_1$1 as Component, modes };
