import { S as SvelteComponent, i as init, s as safe_not_equal, f as element, h as text, b as attr, c as insert, d as append, j as set_data, n as noop, e as detach, k as empty, a6 as onMount, D as binding_callbacks, H as src_url_equal, l as listen, g as is_function, r as run_all, m as space, o as destroy_each, v as transition_in, w as transition_out, A as createEventDispatcher, y as group_outros, x as destroy_component, z as check_outros, q as create_component, u as mount_component, t as toggle_class } from './index.6155978a.js';
import { E as ExampleImage } from './Image.a098ea0e.js';
import { E as ExampleModel3D } from './Model3D.4c4f9cdc.js';

/* src/components/Dataset/ExampleComponents/Number.svelte generated by Svelte v3.47.0 */

function create_fragment$b(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "gr-sample-number");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$b($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Number extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$b, create_fragment$b, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/Dropdown.svelte generated by Svelte v3.47.0 */

function create_fragment$a(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "gr-sample-dropdown");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$a($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Dropdown extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$a, create_fragment$a, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/Checkbox.svelte generated by Svelte v3.47.0 */

function create_fragment$9(ctx) {
	let div;
	let t_value = /*value*/ ctx[0].toLocaleString() + "";
	let t;

	return {
		c() {
			div = element("div");
			t = text(t_value);
			attr(div, "class", "gr-sample-checkbox");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1 && t_value !== (t_value = /*value*/ ctx[0].toLocaleString() + "")) set_data(t, t_value);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$9($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Checkbox extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$9, create_fragment$9, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/CheckboxGroup.svelte generated by Svelte v3.47.0 */

function create_fragment$8(ctx) {
	let div;
	let t_value = /*value*/ ctx[0].join(", ") + "";
	let t;

	return {
		c() {
			div = element("div");
			t = text(t_value);
			attr(div, "class", "gr-sample-checkboxgroup");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1 && t_value !== (t_value = /*value*/ ctx[0].join(", ") + "")) set_data(t, t_value);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$8($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class CheckboxGroup extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$8, create_fragment$8, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/Slider.svelte generated by Svelte v3.47.0 */

function create_fragment$7(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "gr-sample-slider");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$7($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Slider extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$7, create_fragment$7, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/Radio.svelte generated by Svelte v3.47.0 */

function create_fragment$6(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "gr-sample-radio");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$6($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Radio extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$6, create_fragment$6, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/Textbox.svelte generated by Svelte v3.47.0 */

function create_fragment$5(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "gr-sample-textbox");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$5($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Textbox extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$5, create_fragment$5, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/Audio.svelte generated by Svelte v3.47.0 */

function create_fragment$4(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "gr-sample-audio");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$4($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Audio extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$4, create_fragment$4, safe_not_equal, { value: 0 });
	}
}

const playable = (filename) => {
  return true;
};

/* src/components/Dataset/ExampleComponents/Video.svelte generated by Svelte v3.47.0 */

function create_else_block$1(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "gr-sample-video");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (18:0) {#if playable(value)}
function create_if_block$2(ctx) {
	let video_1;
	let video_1_src_value;
	let mounted;
	let dispose;

	return {
		c() {
			video_1 = element("video");
			video_1.muted = true;
			video_1.playsInline = true;
			attr(video_1, "class", "gr-sample-video");
			if (!src_url_equal(video_1.src, video_1_src_value = /*samples_dir*/ ctx[1] + /*value*/ ctx[0])) attr(video_1, "src", video_1_src_value);
		},
		m(target, anchor) {
			insert(target, video_1, anchor);
			/*video_1_binding*/ ctx[3](video_1);

			if (!mounted) {
				dispose = [
					listen(video_1, "mouseover", function () {
						if (is_function(/*video*/ ctx[2].play)) /*video*/ ctx[2].play.apply(this, arguments);
					}),
					listen(video_1, "mouseout", function () {
						if (is_function(/*video*/ ctx[2].pause)) /*video*/ ctx[2].pause.apply(this, arguments);
					})
				];

				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty & /*samples_dir, value*/ 3 && !src_url_equal(video_1.src, video_1_src_value = /*samples_dir*/ ctx[1] + /*value*/ ctx[0])) {
				attr(video_1, "src", video_1_src_value);
			}
		},
		d(detaching) {
			if (detaching) detach(video_1);
			/*video_1_binding*/ ctx[3](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function create_fragment$3(ctx) {
	let show_if;
	let if_block_anchor;

	function select_block_type(ctx, dirty) {
		if (dirty & /*value*/ 1) show_if = null;
		if (show_if == null) show_if = !!playable(/*value*/ ctx[0]);
		if (show_if) return create_if_block$2;
		return create_else_block$1;
	}

	let current_block_type = select_block_type(ctx, -1);
	let if_block = current_block_type(ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
		},
		p(ctx, [dirty]) {
			if (current_block_type === (current_block_type = select_block_type(ctx, dirty)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if_block.d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance$3($$self, $$props, $$invalidate) {
	let { value } = $$props;
	let { samples_dir } = $$props;
	let video;

	onMount(() => {
		$$invalidate(2, video.muted = true, video);
		$$invalidate(2, video.playsInline = true, video);
		$$invalidate(2, video.controls = false, video);
		video.setAttribute("muted", "");
		video.play();
		video.pause();
	});

	function video_1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			video = $$value;
			$$invalidate(2, video);
		});
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('samples_dir' in $$props) $$invalidate(1, samples_dir = $$props.samples_dir);
	};

	return [value, samples_dir, video, video_1_binding];
}

class Video extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$3, create_fragment$3, safe_not_equal, { value: 0, samples_dir: 1 });
	}
}

/* src/components/Dataset/ExampleComponents/File.svelte generated by Svelte v3.47.0 */

function create_fragment$2(ctx) {
	let div;
	let t;

	return {
		c() {
			div = element("div");
			t = text(/*value*/ ctx[0]);
			attr(div, "class", "truncate");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) set_data(t, /*value*/ ctx[0]);
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class File extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$2, create_fragment$2, safe_not_equal, { value: 0 });
	}
}

/* src/components/Dataset/ExampleComponents/Dataframe.svelte generated by Svelte v3.47.0 */

function get_each_context$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[1] = list[i];
	return child_ctx;
}

function get_each_context_1$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[4] = list[i];
	return child_ctx;
}

function get_each_context_2$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[7] = list[i];
	return child_ctx;
}

// (7:3) {#each row.slice(0, 3) as cell}
function create_each_block_2$1(ctx) {
	let td;
	let t_value = /*cell*/ ctx[7] + "";
	let t;

	return {
		c() {
			td = element("td");
			t = text(t_value);
			attr(td, "class", "p-2");
		},
		m(target, anchor) {
			insert(target, td, anchor);
			append(td, t);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && t_value !== (t_value = /*cell*/ ctx[7] + "")) set_data(t, t_value);
		},
		d(detaching) {
			if (detaching) detach(td);
		}
	};
}

// (10:3) {#if row.length > 3}
function create_if_block_1$1(ctx) {
	let td;

	return {
		c() {
			td = element("td");
			td.textContent = "...";
			attr(td, "class", "p-2");
		},
		m(target, anchor) {
			insert(target, td, anchor);
		},
		d(detaching) {
			if (detaching) detach(td);
		}
	};
}

// (5:1) {#each value.slice(0, 3) as row}
function create_each_block_1$1(ctx) {
	let tr;
	let t;
	let each_value_2 = /*row*/ ctx[4].slice(0, 3);
	let each_blocks = [];

	for (let i = 0; i < each_value_2.length; i += 1) {
		each_blocks[i] = create_each_block_2$1(get_each_context_2$1(ctx, each_value_2, i));
	}

	let if_block = /*row*/ ctx[4].length > 3 && create_if_block_1$1();

	return {
		c() {
			tr = element("tr");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t = space();
			if (if_block) if_block.c();
		},
		m(target, anchor) {
			insert(target, tr, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(tr, null);
			}

			append(tr, t);
			if (if_block) if_block.m(tr, null);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1) {
				each_value_2 = /*row*/ ctx[4].slice(0, 3);
				let i;

				for (i = 0; i < each_value_2.length; i += 1) {
					const child_ctx = get_each_context_2$1(ctx, each_value_2, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_2$1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(tr, t);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_2.length;
			}

			if (/*row*/ ctx[4].length > 3) {
				if (if_block) ; else {
					if_block = create_if_block_1$1();
					if_block.c();
					if_block.m(tr, null);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		d(detaching) {
			if (detaching) detach(tr);
			destroy_each(each_blocks, detaching);
			if (if_block) if_block.d();
		}
	};
}

// (15:1) {#if value.length > 3}
function create_if_block$1(ctx) {
	let tr;
	let each_value = Array(Math.min(4, /*value*/ ctx[0][0].length));
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));
	}

	return {
		c() {
			tr = element("tr");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}
		},
		m(target, anchor) {
			insert(target, tr, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(tr, null);
			}
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1) {
				each_value = Array(Math.min(4, /*value*/ ctx[0][0].length));
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$1(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$1();
						each_blocks[i].c();
						each_blocks[i].m(tr, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		d(detaching) {
			if (detaching) detach(tr);
			destroy_each(each_blocks, detaching);
		}
	};
}

// (17:3) {#each Array(Math.min(4, value[0].length)) as _}
function create_each_block$1(ctx) {
	let td;

	return {
		c() {
			td = element("td");
			td.textContent = "...";
			attr(td, "class", "p-2");
		},
		m(target, anchor) {
			insert(target, td, anchor);
		},
		p: noop,
		d(detaching) {
			if (detaching) detach(td);
		}
	};
}

function create_fragment$1(ctx) {
	let table;
	let t;
	let each_value_1 = /*value*/ ctx[0].slice(0, 3);
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1$1(get_each_context_1$1(ctx, each_value_1, i));
	}

	let if_block = /*value*/ ctx[0].length > 3 && create_if_block$1(ctx);

	return {
		c() {
			table = element("table");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t = space();
			if (if_block) if_block.c();
			attr(table, "class", "gr-sample-dataframe");
		},
		m(target, anchor) {
			insert(target, table, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(table, null);
			}

			append(table, t);
			if (if_block) if_block.m(table, null);
		},
		p(ctx, [dirty]) {
			if (dirty & /*value*/ 1) {
				each_value_1 = /*value*/ ctx[0].slice(0, 3);
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1$1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_1$1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(table, t);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_1.length;
			}

			if (/*value*/ ctx[0].length > 3) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block$1(ctx);
					if_block.c();
					if_block.m(table, null);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(table);
			destroy_each(each_blocks, detaching);
			if (if_block) if_block.d();
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { value } = $$props;

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
	};

	return [value];
}

class Dataframe extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { value: 0 });
	}
}

const component_map = {
  dropdown: Dropdown,
  checkbox: Checkbox,
  checkboxgroup: CheckboxGroup,
  number: Number,
  slider: Slider,
  radio: Radio,
  image: ExampleImage,
  textbox: Textbox,
  audio: Audio,
  video: Video,
  file: File,
  dataframe: Dataframe,
  model3d: ExampleModel3D
};

/* src/components/Dataset/Dataset.svelte generated by Svelte v3.47.0 */

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[19] = list[i];
	return child_ctx;
}

function get_each_context_2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[22] = list[i];
	child_ctx[24] = i;
	return child_ctx;
}

function get_each_context_3(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[26] = list[i];
	child_ctx[28] = i;
	return child_ctx;
}

function get_each_context_4(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[29] = list[i];
	return child_ctx;
}

function get_each_context_1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[22] = list[i];
	child_ctx[24] = i;
	return child_ctx;
}

// (81:1) {:else}
function create_else_block_1(ctx) {
	let div;
	let table;
	let thead;
	let tr;
	let t;
	let tbody;
	let current;
	let each_value_4 = /*headers*/ ctx[2];
	let each_blocks_1 = [];

	for (let i = 0; i < each_value_4.length; i += 1) {
		each_blocks_1[i] = create_each_block_4(get_each_context_4(ctx, each_value_4, i));
	}

	let each_value_2 = /*selected_samples*/ ctx[8];
	let each_blocks = [];

	for (let i = 0; i < each_value_2.length; i += 1) {
		each_blocks[i] = create_each_block_2(get_each_context_2(ctx, each_value_2, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			div = element("div");
			table = element("table");
			thead = element("thead");
			tr = element("tr");

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].c();
			}

			t = space();
			tbody = element("tbody");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(tr, "class", "border-b dark:border-gray-800 divide-x dark:divide-gray-800 shadow-sm");
			attr(table, "class", "gr-samples-table");
			attr(div, "class", "overflow-x-auto border table-auto rounded-lg w-full text-sm");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, table);
			append(table, thead);
			append(thead, tr);

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].m(tr, null);
			}

			append(table, t);
			append(table, tbody);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(tbody, null);
			}

			current = true;
		},
		p(ctx, dirty) {
			if (dirty[0] & /*headers*/ 4) {
				each_value_4 = /*headers*/ ctx[2];
				let i;

				for (i = 0; i < each_value_4.length; i += 1) {
					const child_ctx = get_each_context_4(ctx, each_value_4, i);

					if (each_blocks_1[i]) {
						each_blocks_1[i].p(child_ctx, dirty);
					} else {
						each_blocks_1[i] = create_each_block_4(child_ctx);
						each_blocks_1[i].c();
						each_blocks_1[i].m(tr, null);
					}
				}

				for (; i < each_blocks_1.length; i += 1) {
					each_blocks_1[i].d(1);
				}

				each_blocks_1.length = each_value_4.length;
			}

			if (dirty[0] & /*value, page, samples_per_page, dispatch, selected_samples, components, theme, samples_dir*/ 1907) {
				each_value_2 = /*selected_samples*/ ctx[8];
				let i;

				for (i = 0; i < each_value_2.length; i += 1) {
					const child_ctx = get_each_context_2(ctx, each_value_2, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block_2(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(tbody, null);
					}
				}

				group_outros();

				for (i = each_value_2.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value_2.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			destroy_each(each_blocks_1, detaching);
			destroy_each(each_blocks, detaching);
		}
	};
}

// (62:1) {#if gallery}
function create_if_block_2(ctx) {
	let div;
	let current;
	let each_value_1 = /*selected_samples*/ ctx[8];
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1(get_each_context_1(ctx, each_value_1, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(div, "class", "gr-samples-gallery");
		},
		m(target, anchor) {
			insert(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}

			current = true;
		},
		p(ctx, dirty) {
			if (dirty[0] & /*value, page, samples_per_page, dispatch, components, theme, selected_samples, samples_dir*/ 1907) {
				each_value_1 = /*selected_samples*/ ctx[8];
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block_1(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(div, null);
					}
				}

				group_outros();

				for (i = each_value_1.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value_1.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			destroy_each(each_blocks, detaching);
		}
	};
}

// (88:6) {#each headers as header}
function create_each_block_4(ctx) {
	let th;
	let t0_value = /*header*/ ctx[29] + "";
	let t0;
	let t1;

	return {
		c() {
			th = element("th");
			t0 = text(t0_value);
			t1 = space();
			attr(th, "class", "p-2 whitespace-nowrap min-w-lg text-left");
		},
		m(target, anchor) {
			insert(target, th, anchor);
			append(th, t0);
			append(th, t1);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*headers*/ 4 && t0_value !== (t0_value = /*header*/ ctx[29] + "")) set_data(t0, t0_value);
		},
		d(detaching) {
			if (detaching) detach(th);
		}
	};
}

// (104:7) {#each sample_row as sample_cell, j}
function create_each_block_3(ctx) {
	let td;
	let switch_instance;
	let current;
	var switch_value = component_map[/*components*/ ctx[1][/*j*/ ctx[28]]];

	function switch_props(ctx) {
		return {
			props: {
				theme: /*theme*/ ctx[5],
				value: /*sample_cell*/ ctx[26],
				samples_dir: /*samples_dir*/ ctx[10]
			}
		};
	}

	if (switch_value) {
		switch_instance = new switch_value(switch_props(ctx));
	}

	return {
		c() {
			td = element("td");
			if (switch_instance) create_component(switch_instance.$$.fragment);
			attr(td, "class", "p-2");
		},
		m(target, anchor) {
			insert(target, td, anchor);

			if (switch_instance) {
				mount_component(switch_instance, td, null);
			}

			current = true;
		},
		p(ctx, dirty) {
			const switch_instance_changes = {};
			if (dirty[0] & /*theme*/ 32) switch_instance_changes.theme = /*theme*/ ctx[5];
			if (dirty[0] & /*selected_samples*/ 256) switch_instance_changes.value = /*sample_cell*/ ctx[26];

			if (switch_value !== (switch_value = component_map[/*components*/ ctx[1][/*j*/ ctx[28]]])) {
				if (switch_instance) {
					group_outros();
					const old_component = switch_instance;

					transition_out(old_component.$$.fragment, 1, 0, () => {
						destroy_component(old_component, 1);
					});

					check_outros();
				}

				if (switch_value) {
					switch_instance = new switch_value(switch_props(ctx));
					create_component(switch_instance.$$.fragment);
					transition_in(switch_instance.$$.fragment, 1);
					mount_component(switch_instance, td, null);
				} else {
					switch_instance = null;
				}
			} else if (switch_value) {
				switch_instance.$set(switch_instance_changes);
			}
		},
		i(local) {
			if (current) return;
			if (switch_instance) transition_in(switch_instance.$$.fragment, local);
			current = true;
		},
		o(local) {
			if (switch_instance) transition_out(switch_instance.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(td);
			if (switch_instance) destroy_component(switch_instance);
		}
	};
}

// (96:5) {#each selected_samples as sample_row, i}
function create_each_block_2(ctx) {
	let tr;
	let t;
	let current;
	let mounted;
	let dispose;
	let each_value_3 = /*sample_row*/ ctx[22];
	let each_blocks = [];

	for (let i = 0; i < each_value_3.length; i += 1) {
		each_blocks[i] = create_each_block_3(get_each_context_3(ctx, each_value_3, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	function click_handler_1() {
		return /*click_handler_1*/ ctx[17](/*i*/ ctx[24]);
	}

	return {
		c() {
			tr = element("tr");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t = space();
			attr(tr, "class", "group cursor-pointer odd:bg-gray-50 border-b dark:border-gray-800 divide-x dark:divide-gray-800 last:border-none hover:bg-orange-50 hover:divide-orange-100 dark:hover:bg-gray-700");
		},
		m(target, anchor) {
			insert(target, tr, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(tr, null);
			}

			append(tr, t);
			current = true;

			if (!mounted) {
				dispose = listen(tr, "click", click_handler_1);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty[0] & /*components, theme, selected_samples, samples_dir*/ 1314) {
				each_value_3 = /*sample_row*/ ctx[22];
				let i;

				for (i = 0; i < each_value_3.length; i += 1) {
					const child_ctx = get_each_context_3(ctx, each_value_3, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block_3(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(tr, t);
					}
				}

				group_outros();

				for (i = each_value_3.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value_3.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) detach(tr);
			destroy_each(each_blocks, detaching);
			mounted = false;
			dispose();
		}
	};
}

// (64:3) {#each selected_samples as sample_row, i}
function create_each_block_1(ctx) {
	let button;
	let switch_instance;
	let t;
	let current;
	let mounted;
	let dispose;
	var switch_value = component_map[/*components*/ ctx[1][0]];

	function switch_props(ctx) {
		return {
			props: {
				theme: /*theme*/ ctx[5],
				value: /*sample_row*/ ctx[22][0],
				samples_dir: /*samples_dir*/ ctx[10]
			}
		};
	}

	if (switch_value) {
		switch_instance = new switch_value(switch_props(ctx));
	}

	function click_handler() {
		return /*click_handler*/ ctx[16](/*i*/ ctx[24]);
	}

	return {
		c() {
			button = element("button");
			if (switch_instance) create_component(switch_instance.$$.fragment);
			t = space();
			attr(button, "class", "group rounded-lg");
		},
		m(target, anchor) {
			insert(target, button, anchor);

			if (switch_instance) {
				mount_component(switch_instance, button, null);
			}

			append(button, t);
			current = true;

			if (!mounted) {
				dispose = listen(button, "click", click_handler);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			const switch_instance_changes = {};
			if (dirty[0] & /*theme*/ 32) switch_instance_changes.theme = /*theme*/ ctx[5];
			if (dirty[0] & /*selected_samples*/ 256) switch_instance_changes.value = /*sample_row*/ ctx[22][0];

			if (switch_value !== (switch_value = component_map[/*components*/ ctx[1][0]])) {
				if (switch_instance) {
					group_outros();
					const old_component = switch_instance;

					transition_out(old_component.$$.fragment, 1, 0, () => {
						destroy_component(old_component, 1);
					});

					check_outros();
				}

				if (switch_value) {
					switch_instance = new switch_value(switch_props(ctx));
					create_component(switch_instance.$$.fragment);
					transition_in(switch_instance.$$.fragment, 1);
					mount_component(switch_instance, button, t);
				} else {
					switch_instance = null;
				}
			} else if (switch_value) {
				switch_instance.$set(switch_instance_changes);
			}
		},
		i(local) {
			if (current) return;
			if (switch_instance) transition_in(switch_instance.$$.fragment, local);
			current = true;
		},
		o(local) {
			if (switch_instance) transition_out(switch_instance.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(button);
			if (switch_instance) destroy_component(switch_instance);
			mounted = false;
			dispose();
		}
	};
}

// (121:0) {#if paginate}
function create_if_block(ctx) {
	let div;
	let t;
	let each_value = /*visible_pages*/ ctx[7];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	return {
		c() {
			div = element("div");
			t = text("Pages:\n\t\t");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(div, "class", "flex gap-2 items-center justify-center text-sm");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}
		},
		p(ctx, dirty) {
			if (dirty[0] & /*visible_pages, page*/ 192) {
				each_value = /*visible_pages*/ ctx[7];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		d(detaching) {
			if (detaching) detach(div);
			destroy_each(each_blocks, detaching);
		}
	};
}

// (127:3) {:else}
function create_else_block(ctx) {
	let button;
	let t0_value = /*visible_page*/ ctx[19] + 1 + "";
	let t0;
	let t1;
	let mounted;
	let dispose;

	function click_handler_2() {
		return /*click_handler_2*/ ctx[18](/*visible_page*/ ctx[19]);
	}

	return {
		c() {
			button = element("button");
			t0 = text(t0_value);
			t1 = space();
			toggle_class(button, "font-bold", /*page*/ ctx[6] === /*visible_page*/ ctx[19]);
		},
		m(target, anchor) {
			insert(target, button, anchor);
			append(button, t0);
			append(button, t1);

			if (!mounted) {
				dispose = listen(button, "click", click_handler_2);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			if (dirty[0] & /*visible_pages*/ 128 && t0_value !== (t0_value = /*visible_page*/ ctx[19] + 1 + "")) set_data(t0, t0_value);

			if (dirty[0] & /*page, visible_pages*/ 192) {
				toggle_class(button, "font-bold", /*page*/ ctx[6] === /*visible_page*/ ctx[19]);
			}
		},
		d(detaching) {
			if (detaching) detach(button);
			mounted = false;
			dispose();
		}
	};
}

// (125:3) {#if visible_page === -1}
function create_if_block_1(ctx) {
	let div;

	return {
		c() {
			div = element("div");
			div.textContent = "...";
		},
		m(target, anchor) {
			insert(target, div, anchor);
		},
		p: noop,
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

// (124:2) {#each visible_pages as visible_page}
function create_each_block(ctx) {
	let if_block_anchor;

	function select_block_type_1(ctx, dirty) {
		if (/*visible_page*/ ctx[19] === -1) return create_if_block_1;
		return create_else_block;
	}

	let current_block_type = select_block_type_1(ctx);
	let if_block = current_block_type(ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type_1(ctx)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			}
		},
		d(detaching) {
			if_block.d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function create_fragment(ctx) {
	let div1;
	let div0;
	let t1;
	let current_block_type_index;
	let if_block0;
	let t2;
	let if_block1_anchor;
	let current;
	const if_block_creators = [create_if_block_2, create_else_block_1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*gallery*/ ctx[11]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block0 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	let if_block1 = /*paginate*/ ctx[12] && create_if_block(ctx);

	return {
		c() {
			div1 = element("div");
			div0 = element("div");

			div0.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="mr-1" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32"><path fill="currentColor" d="M10 6h18v2H10zm0 18h18v2H10zm0-9h18v2H10zm-6 0h2v2H4zm0-9h2v2H4zm0 18h2v2H4z"></path></svg>
		Examples`;

			t1 = space();
			if_block0.c();
			t2 = space();
			if (if_block1) if_block1.c();
			if_block1_anchor = empty();
			attr(div0, "class", "text-xs mb-2 flex items-center text-gray-500");
			attr(div1, "id", /*elem_id*/ ctx[3]);
			attr(div1, "class", "mt-4 inline-block max-w-full text-gray-700 w-full");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			append(div1, t1);
			if_blocks[current_block_type_index].m(div1, null);
			insert(target, t2, anchor);
			if (if_block1) if_block1.m(target, anchor);
			insert(target, if_block1_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if_block0.p(ctx, dirty);

			if (!current || dirty[0] & /*elem_id*/ 8) {
				attr(div1, "id", /*elem_id*/ ctx[3]);
			}

			if (/*paginate*/ ctx[12]) if_block1.p(ctx, dirty);
		},
		i(local) {
			if (current) return;
			transition_in(if_block0);
			current = true;
		},
		o(local) {
			transition_out(if_block0);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			if_blocks[current_block_type_index].d();
			if (detaching) detach(t2);
			if (if_block1) if_block1.d(detaching);
			if (detaching) detach(if_block1_anchor);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { components } = $$props;
	let { headers } = $$props;
	let { samples } = $$props;
	let { elem_id = "" } = $$props;
	let { value = null } = $$props;
	let { root } = $$props;
	let { samples_per_page = 10 } = $$props;
	let { theme } = $$props;
	const dispatch = createEventDispatcher();
	let samples_dir = root + "file/";
	let page = 0;
	let gallery = headers.length === 1;
	let paginate = samples.length > samples_per_page;
	let selected_samples;
	let page_count;
	let visible_pages = [];

	const click_handler = i => {
		$$invalidate(0, value = i + page * samples_per_page);
		dispatch("click", value);
	};

	const click_handler_1 = i => {
		$$invalidate(0, value = i + page * samples_per_page);
		dispatch("click", value);
	};

	const click_handler_2 = visible_page => $$invalidate(6, page = visible_page);

	$$self.$$set = $$props => {
		if ('components' in $$props) $$invalidate(1, components = $$props.components);
		if ('headers' in $$props) $$invalidate(2, headers = $$props.headers);
		if ('samples' in $$props) $$invalidate(13, samples = $$props.samples);
		if ('elem_id' in $$props) $$invalidate(3, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('root' in $$props) $$invalidate(14, root = $$props.root);
		if ('samples_per_page' in $$props) $$invalidate(4, samples_per_page = $$props.samples_per_page);
		if ('theme' in $$props) $$invalidate(5, theme = $$props.theme);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*samples, page, samples_per_page, page_count, visible_pages*/ 41168) {
			{
				if (paginate) {
					$$invalidate(7, visible_pages = []);
					$$invalidate(8, selected_samples = samples.slice(page * samples_per_page, (page + 1) * samples_per_page));
					$$invalidate(15, page_count = Math.ceil(samples.length / samples_per_page));

					[0, page, page_count - 1].forEach(anchor => {
						for (let i = anchor - 2; i <= anchor + 2; i++) {
							if (i >= 0 && i < page_count && !visible_pages.includes(i)) {
								if (visible_pages.length > 0 && i - visible_pages[visible_pages.length - 1] > 1) {
									visible_pages.push(-1);
								}

								visible_pages.push(i);
							}
						}
					});
				} else {
					$$invalidate(8, selected_samples = samples.slice());
				}
			}
		}
	};

	return [
		value,
		components,
		headers,
		elem_id,
		samples_per_page,
		theme,
		page,
		visible_pages,
		selected_samples,
		dispatch,
		samples_dir,
		gallery,
		paginate,
		samples,
		root,
		page_count,
		click_handler,
		click_handler_1,
		click_handler_2
	];
}

class Dataset extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance,
			create_fragment,
			safe_not_equal,
			{
				components: 1,
				headers: 2,
				samples: 13,
				elem_id: 3,
				value: 0,
				root: 14,
				samples_per_page: 4,
				theme: 5
			},
			null,
			[-1, -1]
		);
	}
}

var Dataset$1 = Dataset;

const modes = ["dynamic"];

export { Dataset$1 as Component, modes };
