import { S as SvelteComponent, i as init, s as safe_not_equal, k as empty, c as insert, e as detach, U as create_slot, f as element, m as space, b as attr, d as append, P as update_slot_base, Q as get_all_dirty_from_scope, R as get_slot_changes, v as transition_in, w as transition_out, o as destroy_each, K as component_subscribe, A as createEventDispatcher, Y as setContext, _ as writable, Z as set_store_value, h as text, l as listen, n as noop } from './index.51044db5.js';

/* home/runner/work/gradio/gradio/ui/packages/tabs/src/Tabs.svelte generated by Svelte v3.47.0 */

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[10] = list[i];
	child_ctx[12] = i;
	return child_ctx;
}

// (39:3) {:else}
function create_else_block(ctx) {
	let button;
	let t0_value = /*t*/ ctx[10].name + "";
	let t0;
	let t1;
	let mounted;
	let dispose;

	function click_handler() {
		return /*click_handler*/ ctx[8](/*t*/ ctx[10]);
	}

	return {
		c() {
			button = element("button");
			t0 = text(t0_value);
			t1 = space();
			attr(button, "class", "px-4 pb-2 pt-1.5 border-transparent text-gray-400 hover:text-gray-700 -mb-[2px] border-2 border-b-0");
		},
		m(target, anchor) {
			insert(target, button, anchor);
			append(button, t0);
			append(button, t1);

			if (!mounted) {
				dispose = listen(button, "click", click_handler);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
		},
		d(detaching) {
			if (detaching) detach(button);
			mounted = false;
			dispose();
		}
	};
}

// (33:3) {#if t.id === $selected_tab}
function create_if_block(ctx) {
	let button;
	let t0_value = /*t*/ ctx[10].name + "";
	let t0;
	let t1;

	return {
		c() {
			button = element("button");
			t0 = text(t0_value);
			t1 = space();
			attr(button, "class", "bg-white px-4 pb-2 pt-1.5 rounded-t-lg border-gray-200 -mb-[2px] border-2 border-b-0");
		},
		m(target, anchor) {
			insert(target, button, anchor);
			append(button, t0);
			append(button, t1);
		},
		p: noop,
		d(detaching) {
			if (detaching) detach(button);
		}
	};
}

// (32:2) {#each tabs as t, i}
function create_each_block(ctx) {
	let if_block_anchor;

	function select_block_type(ctx, dirty) {
		if (/*t*/ ctx[10].id === /*$selected_tab*/ ctx[1]) return create_if_block;
		return create_else_block;
	}

	let current_block_type = select_block_type(ctx);
	let if_block = current_block_type(ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type(ctx)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			}
		},
		d(detaching) {
			if_block.d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function create_fragment(ctx) {
	let div1;
	let div0;
	let t;
	let current;
	let each_value = /*tabs*/ ctx[2];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	const default_slot_template = /*#slots*/ ctx[7].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[6], null);

	return {
		c() {
			div1 = element("div");
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t = space();
			if (default_slot) default_slot.c();
			attr(div0, "class", "flex border-b-2 dark:border-gray-700");
			attr(div1, "class", "tabs flex flex-col my-4");
			attr(div1, "id", /*elem_id*/ ctx[0]);
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div0, null);
			}

			append(div1, t);

			if (default_slot) {
				default_slot.m(div1, null);
			}

			current = true;
		},
		p(ctx, [dirty]) {
			if (dirty & /*tabs, $selected_tab, handle_click*/ 22) {
				each_value = /*tabs*/ ctx[2];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (default_slot) {
				if (default_slot.p && (!current || dirty & /*$$scope*/ 64)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[6],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[6])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[6], dirty, null),
						null
					);
				}
			}

			if (!current || dirty & /*elem_id*/ 1) {
				attr(div1, "id", /*elem_id*/ ctx[0]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			destroy_each(each_blocks, detaching);
			if (default_slot) default_slot.d(detaching);
		}
	};
}

const TABS = {};

function instance($$self, $$props, $$invalidate) {
	let $selected_tab;
	let { $$slots: slots = {}, $$scope } = $$props;
	let { elem_id } = $$props;
	let { visible = true } = $$props;
	const tabs = [];
	const selected_tab = writable(false);
	component_subscribe($$self, selected_tab, value => $$invalidate(1, $selected_tab = value));
	const dispatch = createEventDispatcher();

	setContext(TABS, {
		register_tab: tab => {
			tabs.push({ name: tab.name, id: tab.id });
			selected_tab.update(current => current || tab.id);
		},
		unregister_tab: tab => {
			const i = tabs.findIndex(t => t.id === tab.id);
			tabs.splice(i, 1);

			selected_tab.update(current => current === tab.id
			? tabs[i]?.id || tabs[tabs.length - 1]?.id
			: current);
		},
		selected_tab
	});

	function handle_click(id) {
		set_store_value(selected_tab, $selected_tab = id, $selected_tab);
		dispatch("change");
	}

	const click_handler = t => handle_click(t.id);

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(0, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(5, visible = $$props.visible);
		if ('$$scope' in $$props) $$invalidate(6, $$scope = $$props.$$scope);
	};

	return [
		elem_id,
		$selected_tab,
		tabs,
		selected_tab,
		handle_click,
		visible,
		$$scope,
		slots,
		click_handler
	];
}

class Tabs extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance, create_fragment, safe_not_equal, { elem_id: 0, visible: 5 });
	}
}

export { Tabs as T, TABS as a };
