import { S as SvelteComponent, i as init, s as safe_not_equal, V as create_slot, f as element, m as space, b as attr, t as toggle_class, c as insert, d as append, l as listen, W as stop_propagation, p as prevent_default, Q as update_slot_base, R as get_all_dirty_from_scope, T as get_slot_changes, v as transition_in, w as transition_out, e as detach, r as run_all, A as createEventDispatcher, F as bubble, D as binding_callbacks } from './index.8a7211f1.js';

/* Users/aliabid/projects/gradio/ui/packages/upload/src/Upload.svelte generated by Svelte v3.49.0 */

function create_fragment(ctx) {
	let div;
	let t;
	let input;
	let input_multiple_value;
	let input_webkitdirectory_value;
	let input_mozdirectory_value;
	let div_class_value;
	let current;
	let mounted;
	let dispose;
	const default_slot_template = /*#slots*/ ctx[14].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[13], null);

	return {
		c() {
			div = element("div");
			if (default_slot) default_slot.c();
			t = space();
			input = element("input");
			attr(input, "class", "hidden-upload hidden");
			attr(input, "type", "file");
			attr(input, "accept", /*filetype*/ ctx[0]);
			input.multiple = input_multiple_value = /*file_count*/ ctx[4] === "multiple" || undefined;
			attr(input, "webkitdirectory", input_webkitdirectory_value = /*file_count*/ ctx[4] === "directory" || undefined);
			attr(input, "mozdirectory", input_mozdirectory_value = /*file_count*/ ctx[4] === "directory" || undefined);

			attr(div, "class", div_class_value = "w-full cursor-pointer h-full items-center justify-center text-gray-400 md:text-xl " + (/*boundedheight*/ ctx[1]
			? 'min-h-[10rem] md:min-h-[15rem] max-h-[15rem] xl:max-h-[18rem] 2xl:max-h-[20rem]'
			: ''));

			toggle_class(div, "text-center", /*center*/ ctx[2]);
			toggle_class(div, "flex", /*flex*/ ctx[3]);
		},
		m(target, anchor) {
			insert(target, div, anchor);

			if (default_slot) {
				default_slot.m(div, null);
			}

			append(div, t);
			append(div, input);
			/*input_binding*/ ctx[22](input);
			current = true;

			if (!mounted) {
				dispose = [
					listen(input, "change", /*loadFilesFromUpload*/ ctx[8]),
					listen(div, "drag", stop_propagation(prevent_default(/*drag_handler*/ ctx[15]))),
					listen(div, "dragstart", stop_propagation(prevent_default(/*dragstart_handler*/ ctx[16]))),
					listen(div, "dragend", stop_propagation(prevent_default(/*dragend_handler*/ ctx[17]))),
					listen(div, "dragover", stop_propagation(prevent_default(/*dragover_handler*/ ctx[18]))),
					listen(div, "dragenter", stop_propagation(prevent_default(/*dragenter_handler*/ ctx[19]))),
					listen(div, "dragleave", stop_propagation(prevent_default(/*dragleave_handler*/ ctx[20]))),
					listen(div, "drop", stop_propagation(prevent_default(/*drop_handler*/ ctx[21]))),
					listen(div, "click", /*openFileUpload*/ ctx[7]),
					listen(div, "drop", /*loadFilesFromDrop*/ ctx[9]),
					listen(div, "dragenter", /*updateDragging*/ ctx[6]),
					listen(div, "dragleave", /*updateDragging*/ ctx[6])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty & /*$$scope*/ 8192)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[13],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[13])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[13], dirty, null),
						null
					);
				}
			}

			if (!current || dirty & /*filetype*/ 1) {
				attr(input, "accept", /*filetype*/ ctx[0]);
			}

			if (!current || dirty & /*file_count*/ 16 && input_multiple_value !== (input_multiple_value = /*file_count*/ ctx[4] === "multiple" || undefined)) {
				input.multiple = input_multiple_value;
			}

			if (!current || dirty & /*file_count*/ 16 && input_webkitdirectory_value !== (input_webkitdirectory_value = /*file_count*/ ctx[4] === "directory" || undefined)) {
				attr(input, "webkitdirectory", input_webkitdirectory_value);
			}

			if (!current || dirty & /*file_count*/ 16 && input_mozdirectory_value !== (input_mozdirectory_value = /*file_count*/ ctx[4] === "directory" || undefined)) {
				attr(input, "mozdirectory", input_mozdirectory_value);
			}

			if (!current || dirty & /*boundedheight*/ 2 && div_class_value !== (div_class_value = "w-full cursor-pointer h-full items-center justify-center text-gray-400 md:text-xl " + (/*boundedheight*/ ctx[1]
			? 'min-h-[10rem] md:min-h-[15rem] max-h-[15rem] xl:max-h-[18rem] 2xl:max-h-[20rem]'
			: ''))) {
				attr(div, "class", div_class_value);
			}

			if (dirty & /*boundedheight, center*/ 6) {
				toggle_class(div, "text-center", /*center*/ ctx[2]);
			}

			if (dirty & /*boundedheight, flex*/ 10) {
				toggle_class(div, "flex", /*flex*/ ctx[3]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div);
			if (default_slot) default_slot.d(detaching);
			/*input_binding*/ ctx[22](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	let { filetype = undefined } = $$props;
	let { include_file_metadata = true } = $$props;
	let { dragging = false } = $$props;
	let { boundedheight = true } = $$props;
	let { click = true } = $$props;
	let { center = true } = $$props;
	let { flex = true } = $$props;
	let { file_count = "single" } = $$props;
	let hidden_upload;
	const dispatch = createEventDispatcher();

	const updateDragging = () => {
		$$invalidate(10, dragging = !dragging);
	};

	const openFileUpload = () => {
		if (!click) return;
		hidden_upload.click();
	};

	const loadFiles = files => {
		let _files = Array.from(files);

		if (!files.length || !window.FileReader) {
			return;
		}

		if (file_count === "single") {
			_files = [files[0]];
		}

		var all_file_data = [];

		_files.forEach((f, i) => {
			let ReaderObj = new FileReader();
			ReaderObj.readAsDataURL(f);

			ReaderObj.onloadend = function () {
				all_file_data[i] = include_file_metadata
				? {
						name: f.name,
						size: f.size,
						data: this.result
					}
				: this.result;

				if (all_file_data.filter(x => x !== undefined).length === files.length) {
					dispatch("load", file_count == "single"
					? all_file_data[0]
					: all_file_data);
				}
			};
		});
	};

	const loadFilesFromUpload = e => {
		const target = e.target;
		if (!target.files) return;
		loadFiles(target.files);
	};

	const loadFilesFromDrop = e => {
		$$invalidate(10, dragging = false);
		if (!e.dataTransfer?.files) return;
		loadFiles(e.dataTransfer.files);
	};

	function drag_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragstart_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragend_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragover_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragenter_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragleave_handler(event) {
		bubble.call(this, $$self, event);
	}

	function drop_handler(event) {
		bubble.call(this, $$self, event);
	}

	function input_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			hidden_upload = $$value;
			$$invalidate(5, hidden_upload);
		});
	}

	$$self.$$set = $$props => {
		if ('filetype' in $$props) $$invalidate(0, filetype = $$props.filetype);
		if ('include_file_metadata' in $$props) $$invalidate(11, include_file_metadata = $$props.include_file_metadata);
		if ('dragging' in $$props) $$invalidate(10, dragging = $$props.dragging);
		if ('boundedheight' in $$props) $$invalidate(1, boundedheight = $$props.boundedheight);
		if ('click' in $$props) $$invalidate(12, click = $$props.click);
		if ('center' in $$props) $$invalidate(2, center = $$props.center);
		if ('flex' in $$props) $$invalidate(3, flex = $$props.flex);
		if ('file_count' in $$props) $$invalidate(4, file_count = $$props.file_count);
		if ('$$scope' in $$props) $$invalidate(13, $$scope = $$props.$$scope);
	};

	return [
		filetype,
		boundedheight,
		center,
		flex,
		file_count,
		hidden_upload,
		updateDragging,
		openFileUpload,
		loadFilesFromUpload,
		loadFilesFromDrop,
		dragging,
		include_file_metadata,
		click,
		$$scope,
		slots,
		drag_handler,
		dragstart_handler,
		dragend_handler,
		dragover_handler,
		dragenter_handler,
		dragleave_handler,
		drop_handler,
		input_binding
	];
}

class Upload extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			filetype: 0,
			include_file_metadata: 11,
			dragging: 10,
			boundedheight: 1,
			click: 12,
			center: 2,
			flex: 3,
			file_count: 4
		});
	}
}

export { Upload as U };
