`基本スケジューラー`ノードは、指定されたスケジューラ、モデル、およびノイズ除去パラメータに基づいて、拡散モデルのためのシグマ値のシーケンスを計算するように設計されています。デノイズファクターに基づいて総ステップ数を動的に調整し、拡散プロセスを微調整し、きめ細かい制御が必要な高度なサンプリングプロセス（段階的サンプリングなど）の異なる段階に対して精密な「レシピ」を提供します。

## 入力

| パラメータ      | データタイプ   | 入力タイプ | デフォルト | 範囲     | 比喩的説明              | 技術的目的              |
| ------------- | ------------- | --------- | --------- | ------- | ---------------------- | --------------------- |
| `モデル`        | MODEL         | Input     | -         | -       | **キャンバスタイプ**: 異なるキャンバス素材には異なる絵の具の配合が必要 | 拡散モデルオブジェクト、シグマ値計算の基盤を決定 |
| `スケジューラ` | COMBO[STRING] | Widget    | -         | 9オプション | **混合技法**: 絵の具の濃度がどのように変化するかを選択 | スケジューリングアルゴリズム、ノイズ減衰モードを制御 |
| `ステップ`      | INT           | Widget    | 20        | 1-10000 | **混合回数**: 20回 vs 50回の混合の精度の違い | サンプリングステップ、生成品質と速度に影響 |
| `ノイズ除去`    | FLOAT         | Widget    | 1.0       | 0.0-1.0 | **創作強度**: 微調整から再描画までの制御レベル | デノイズ強度、部分的な再描画シナリオをサポート |

### スケジューラタイプ

ソースコード `comfy.samplers.SCHEDULER_NAMES` に基づき、以下の9つのスケジューラをサポート:

| スケジューラ名          | 特性                     | 使用例                        | ノイズ減衰パターン           |
| -------------------- | ------------------------ | ---------------------------- | ------------------------ |
| **normal**           | 標準線形                  | 一般的なシナリオ、バランス型      | 均一減衰                  |
| **karras**           | 滑らかな遷移               | 高品質、詳細豊富                | 滑らかな非線形減衰         |
| **exponential**      | 指数減衰                  | 高速生成、効率重視               | 指数的高速減衰             |
| **sgm_uniform**      | SGM均一                  | 特定モデル最適化                 | SGM最適化減衰             |
| **simple**           | シンプルスケジューリング    | 高速テスト、基本使用              | 簡略化減衰                 |
| **ddim_uniform**     | DDIM均一                 | DDIMサンプリング最適化           | DDIM特有減衰               |
| **beta**             | ベータ分布                | 特殊分布ニーズ                  | ベータ関数減衰               |
| **linear_quadratic** | 線形二次                  | 複雑シナリオ最適化              | 二次関数減衰                 |
| **kl_optimal**       | KL最適                   | 理論的最適化                   | KLダイバージェンス最適化減衰 |

## 出力

| パラメータ  | データタイプ  | 出力タイプ | 比喩的説明                     | 技術的意味                      |
| --------- | ----------- | --------- | ---------------------------- | ----------------------------- |
| `シグマ`   | SIGMAS      | Output    | **絵の具レシピ表**: 段階的使用のための詳細な絵の具濃度リスト | ノイズレベルシーケンス、拡散モデルのノイズ除去プロセスをガイド |

## ノードの役割: アーティストの調色アシスタント

あなたが混沌とした絵の具（ノイズ）から鮮明な画像を作成するアーティストであることを想像してください。`基本スケジューラー`はあなたの**プロの調色アシスタント**として機能し、その仕事は一連の精密な絵の具濃度レシピを準備することです:

### ワークフロー

- **ステップ1**: 90%濃度の絵の具を使用（高ノイズレベル）
- **ステップ2**: 80%濃度の絵の具を使用  
- **ステップ3**: 70%濃度の絵の具を使用
- **...**
- **最終ステップ**: 0%濃度を使用（クリーンなキャンバス、ノイズなし）

### カラーアシスタントの特殊スキル

**異なる混合方法 (スケジューラ)**:

- **"karras"混合法**: 絵の具の濃度が非常に滑らかに変化、プロアーティストのグラデーション技法のように
- **"exponential"混合法**: 絵の具の濃度が急速に減少、高速創作に適している
- **"linear"混合法**: 絵の具の濃度が均等に減少、安定で制御可能

**細かい制御 (ステップ)**:

- **20回混合**: 高速描画、効率重視
- **50回混合**: 精密描画、品質重視

**創作強度 (ノイズ除去)**:

- **1.0 = 完全な新規創作**: 完全に白紙のキャンバスから開始
- **0.5 = 半変換**: 元の絵の半分を保持、半分を変換
- **0.2 = 微調整**: 元の絵に微細な調整のみを行う

### 他のノードとの連携

`基本スケジューラー`（カラーアシスタント）→ レシピ準備 → `SamplerCustom`（アーティスト）→ 実際の描画 → 完成作品
