`기본 스케줄러` 노드는 제공된 스케줄러, 모델 및 디노이즈 매개변수를 기반으로 확산 모델을 위한 시그마 값의 시퀀스를 계산하도록 설계되었습니다. 디노이즈 계수를 기반으로 총 단계 수를 동적으로 조정하여 확산 과정을 미세 조정하며, 세밀한 제어가 필요한 고급 샘플링 프로세스(단계별 샘플링 등)의 다양한 단계에 대해 정밀한 "레시피"를 제공합니다.

## 입력

| 매개변수    | 데이터 타입    | 입력 타입 | 기본값 | 범위     | 은유적 설명                    | 기술적 목적                      |
| --------- | ----------- | ------- | ---- | ------- | --------------------------- | ------------------------------ |
| `모델`      | MODEL         | Input    | -     | -       | **캔버스 타입**: 다른 캔버스 재료는 다른 물감 배합이 필요 | 확산 모델 객체, 시그마 값 계산 기반 결정 |
| `스케줄러`  | COMBO[STRING] | Widget   | -     | 9 옵션   | **혼합 기법**: 물감 농도가 어떻게 변화하는지 선택 | 스케줄링 알고리즘, 노이즈 감쇠 모드 제어 |
| `스텝 수`   | INT           | Widget   | 20    | 1-10000 | **혼합 횟수**: 20회 vs 50회 혼합의 정밀도 차이 | 샘플링 단계, 생성 품질과 속도에 영향 |
| `노이즈 제거량` | FLOAT         | Widget   | 1.0   | 0.0-1.0 | **창작 강도**: 미세 조정부터 재그리기까지의 제어 수준 | 디노이즈 강도, 부분 재그리기 시나리오 지원 |

### 스케줄러 타입

소스 코드 `comfy.samplers.SCHEDULER_NAMES`를 기반으로 다음 9개의 스케줄러를 지원:

| 스케줄러 이름           | 특성            | 사용 사례                 | 노이즈 감쇠 패턴     |
| -------------------- | ------------- | ----------------------- | ---------------- |
| **normal**           | 표준 선형       | 일반적인 시나리오, 균형적      | 균등 감쇠          |
| **karras**           | 부드러운 전환    | 고품질, 세부사항 풍부         | 부드러운 비선형 감쇠   |
| **exponential**      | 지수 감쇠       | 빠른 생성, 효율성 우선        | 지수적 빠른 감쇠     |
| **sgm_uniform**      | SGM 균등      | 특정 모델 최적화              | SGM 최적화 감쇠     |
| **simple**           | 단순 스케줄링   | 빠른 테스트, 기본 사용         | 단순화된 감쇠        |
| **ddim_uniform**     | DDIM 균등     | DDIM 샘플링 최적화           | DDIM 특유 감쇠      |
| **beta**             | 베타 분포      | 특수 분포 요구사항            | 베타 함수 감쇠       |
| **linear_quadratic** | 선형 이차      | 복잡한 시나리오 최적화         | 이차 함수 감쇠       |
| **kl_optimal**       | KL 최적       | 이론적 최적화                | KL 발산 최적화 감쇠  |

## 출력

| 매개변수   | 데이터 타입  | 출력 타입  | 은유적 설명                   | 기술적 의미                        |
| ------- | ---------- | -------- | -------------------------- | --------------------------------- |
| `시그마` | SIGMAS     | Output   | **물감 레시피 표**: 단계별 사용을 위한 상세한 물감 농도 목록 | 노이즈 레벨 시퀀스, 확산 모델의 디노이즈 프로세스 가이드 |

## 노드 역할: 아티스트의 색상 조합 도우미

당신이 혼돈스러운 물감(노이즈)에서 선명한 이미지를 창조하는 아티스트라고 상상해보세요. `기본 스케줄러`는 **전문 색상 조합 도우미**로서 작동하며, 그 역할은 일련의 정밀한 물감 농도 레시피를 준비하는 것입니다:

### 작업 흐름

- **1단계**: 90% 농도 물감 사용 (높은 노이즈 레벨)
- **2단계**: 80% 농도 물감 사용  
- **3단계**: 70% 농도 물감 사용
- **...**
- **최종 단계**: 0% 농도 사용 (깨끗한 캔버스, 노이즈 없음)

### 컬러 도우미의 특별한 기능

**다양한 혼합 방법 (스케줄러)**:

- **"karras" 혼합법**: 물감 농도가 매우 부드럽게 변화, 전문 아티스트의 그라데이션 기법처럼
- **"exponential" 혼합법**: 물감 농도가 급속히 감소, 빠른 창작에 적합
- **"linear" 혼합법**: 물감 농도가 균등하게 감소, 안정적이고 제어 가능

**세밀한 제어 (스텝 수)**:

- **20회 혼합**: 빠른 그리기, 효율성 우선
- **50회 혼합**: 정밀한 그리기, 품질 우선

**창작 강도 (노이즈 제거량)**:

- **1.0 = 완전 새로운 창작**: 완전히 빈 캔버스에서 시작
- **0.5 = 절반 변환**: 원본 그림의 절반을 유지, 절반을 변환
- **0.2 = 미세 조정**: 원본 그림에 미묘한 조정만 수행

### 다른 노드와의 협업

`기본 스케줄러` (컬러 도우미) → 레시피 준비 → `사용자 정의 샘플러` (아티스트) → 실제 그리기 → 완성 작품
