Узел `Основной scheduler` предназначен для вычисления последовательности значений сигма для моделей диффузии на основе предоставленного планировщика, модели и параметров шумоподавления. Он динамически корректирует общее количество шагов на основе коэффициента шумоподавления для тонкой настройки процесса диффузии, предоставляя точные "рецепты" для различных этапов в продвинутых процессах выборки, требующих тонкого контроля (таких как поэтапная выборка).

## Входные Параметры

| Параметр          | Тип Данных    | Тип Ввода | По Умолчанию | Диапазон | Метафорическое Описание      | Техническое Назначение       |
| --------------- | ------------- | --------- | ------------ | -------- | ---------------------------- | ---------------------------- |
| `модель`        | MODEL         | Input     | -            | -        | **Тип Холста**: Разные материалы холста требуют разных формул красок | Объект модели диффузии, определяет основу расчета сигма |
| `scheduler`     | COMBO[STRING] | Widget    | -            | 9 опций  | **Техника Смешивания**: Выбор изменения концентрации краски | Алгоритм планирования, контролирует режим затухания шума |
| `шаги`          | INT           | Widget    | 20           | 1-10000  | **Количество Смешиваний**: Разница точности между 20 и 50 смешиваниями | Шаги выборки, влияет на качество и скорость генерации |
| `шумоподавление`| FLOAT         | Widget    | 1.0          | 0.0-1.0  | **Интенсивность Создания**: Уровень контроля от тонкой настройки до перерисовки | Сила шумоподавления, поддерживает сценарии частичной перерисовки |

### Типы Планировщиков

На основе исходного кода `comfy.samplers.SCHEDULER_NAMES`, поддерживает следующие 9 планировщиков:

| Название Планировщика | Характеристики             | Случаи Использования                        | Паттерн Затухания Шума                    |
| --------------------- | -------------------------- | ------------------------------------------- | ----------------------------------------- |
| **normal**            | Стандартная линейная       | Общие сценарии, сбалансированный            | Равномерное затухание                     |
| **karras**            | Плавный переход            | Высокое качество, богатый деталями          | Плавное нелинейное затухание              |
| **exponential**       | Экспоненциальное затухание | Быстрая генерация, приоритет эффективности  | Экспоненциальное быстрое затухание        |
| **sgm_uniform**       | SGM равномерный            | Оптимизация конкретной модели               | SGM оптимизированное затухание            |
| **simple**            | Простое планирование       | Быстрое тестирование, базовое использование | Упрощенное затухание                      |
| **ddim_uniform**      | DDIM равномерный           | Оптимизация DDIM выборки                    | DDIM специфическое затухание              |
| **beta**              | Бета распределение         | Потребности специального распределения      | Затухание бета функции                    |
| **linear_quadratic**  | Линейная квадратичная      | Оптимизация сложных сценариев               | Затухание квадратичной функции            |
| **kl_optimal**        | KL оптимальный             | Теоретическая оптимизация                   | KL дивергенция оптимизированное затухание |

## Результаты Вывода

| Параметр | Тип Данных | Тип Вывода | Метафорическое Описание        | Техническое Значение           |
| -------- | ---------- | ---------- | ------------------------------ | ------------------------------ |
| `СИГМЫ`  | SIGMAS     | Output     | **Таблица Рецептов Красок**: Подробный список концентрации красок для пошагового использования | Последовательность уровней шума, направляет процесс шумоподавления модели диффузии |

## Роль Узла: Помощник по Смешиванию Красок Художника

Представьте, что вы художник, создающий четкое изображение из хаотичной смеси красок (шума). `Основной scheduler` действует как ваш **профессиональный помощник по смешиванию красок**, чья работа заключается в подготовке серии точных рецептов концентрации красок:

### Рабочий Процесс

- **Шаг 1**: Использовать краску 90% концентрации (высокий уровень шума)
- **Шаг 2**: Использовать краску 80% концентрации  
- **Шаг 3**: Использовать краску 70% концентрации
- **...**
- **Финальный Шаг**: Использовать 0% концентрации (чистый холст, без шума)

### Специальные Навыки Цветового Помощника

**Различные методы смешивания (scheduler)**:

- **Метод смешивания "karras"**: Концентрация краски изменяется очень плавно, как техника градиента профессионального художника
- **Метод смешивания "exponential"**: Концентрация краски быстро уменьшается, подходит для быстрого создания
- **Метод смешивания "linear"**: Концентрация краски уменьшается равномерно, стабильно и контролируемо

**Тонкий контроль (шаги)**:

- **20 смешиваний**: Быстрая живопись, приоритет эффективности
- **50 смешиваний**: Точная живопись, приоритет качества

**Интенсивность создания (шумоподавление)**:

- **1.0 = Полностью новое создание**: Начинать полностью с чистого холста
- **0.5 = Половинная трансформация**: Сохранить половину оригинальной картины, трансформировать половину
- **0.2 = Тонкая настройка**: Делать только тонкие корректировки оригинальной картины

### Сотрудничество с Другими Узлами

`Основной scheduler` (Цветовой Помощник) → Подготовка Рецепта → `SamplerCustom` (Художник) → Фактическая Живопись → Завершенная Работа
