`BasicScheduler` 节点旨在根据提供的调度器、模型和去噪参数为扩散模型计算一系列 sigma 值。它根据去噪因子动态调整总步骤数，以微调扩散过程，在一些需要精细控制的高级的采样过程（比如分步采样）等等提供了精细的不同阶段的“配方”

## 输入

| 参数名称      | 数据类型       | 输入类型  | 默认值  | 范围     | 比喻说明                                        | 技术作用                        |
| ----------- | ------------- | -------- | ------ | ------- | ---------------------------------------------- | ------------------------------ |
| `模型`     | MODEL         | Input    | -      | -       | **画布类型**：不同材质的画布需要不同的颜料配方        | 扩散模型对象，决定sigma值的计算基础 |
| `调度器` | COMBO[STRING] | Widget   | -      | 9种选项  | **调色技法**：选择颜料浓度变化的方式                | 调度算法，控制噪声衰减模式          |
| `步数`     | INT           | Widget   | 20     | 1-10000 | **调色次数**：调色20次 vs 50次的精细度差异          | 采样步数，影响生成质量与速度        |
| `降噪`   | FLOAT         | Widget   | 1.0    | 0.0-1.0 | **创作强度**：从微调到重绘的控制力度                | 去噪强度，支持部分重绘场景          |

### 调度器类型详解

基于源码 `comfy.samplers.SCHEDULER_NAMES`，支持以下9种调度器：

| 调度器名称             | 特点         | 适用场景               | 噪声衰减特性     |
| -------------------- | ------------ | -------------------- | -------------- |
| **normal**           | 标准线性调度   | 通用场景，平衡效果      | 均匀递减         |
| **karras**           | 平滑过渡调度   | 高质量生成，细节丰富    | 平滑非线性递减    |
| **exponential**      | 指数递减调度   | 快速生成，效率优先      | 指数型快速递减    |
| **sgm_uniform**      | SGM均匀调度   | 特定模型优化           | SGM优化递减      |
| **simple**           | 简单调度      | 快速测试，基础应用      | 简化递减         |
| **ddim_uniform**     | DDIM均匀调度  | DDIM采样优化          | DDIM特定递减     |
| **beta**             | Beta分布调度  | 特殊分布需求          | Beta函数递减      |
| **linear_quadratic** | 线性二次调度   | 复杂场景优化          | 二次函数递减     |
| **kl_optimal**       | KL最优调度    | 理论最优化            | KL散度优化递减   |

## 输出结果

| 参数名称   | 数据类型  | 输出类型   | 比喻说明                                           | 技术含义                         |
| -------- | -------- | -------- | -------------------------------------------------- | ------------------------------ |
| `sigmas` | SIGMAS   | Output   | **调色配方表**：详细的颜料浓度清单，供画家逐步使用         | 噪声水平序列，指导扩散模型的去噪过程 |

## 节点角色：画家的调色助手

想象你是一位画家，正在从一团混乱的颜料（噪声）创作清晰的图像。`BasicScheduler` 就像是的**专业调色助手**，它的工作是为您准备一系列精确的颜料浓度配方：

### 工作流程

- **第1步**：使用90%浓度的颜料（高噪声水平）
- **第2步**：使用80%浓度的颜料  
- **第3步**：使用70%浓度的颜料
- **...**
- **最后一步**：使用0%浓度（纯净画布，无噪声）

### 调色助手的特殊技能

**不同的调色方法（scheduler）**：

- **"karras"调色法**：颜料浓度变化非常平滑，像专业画家的渐变技巧
- **"exponential"调色法**：颜料浓度快速递减，适合快速创作
- **"linear"调色法**：颜料浓度均匀递减，稳定可控

**精细控制（steps）**：

- **20次调色**：快速作画，效率优先
- **50次调色**：精细作画，质量优先

**创作强度（denoise）**：

- **1.0 = 全新创作**：完全从空白画布开始
- **0.5 = 半改造**：保留原画一半，改造一半
- **0.2 = 微调优化**：只对原画进行细微调整

### 与其他节点的配合

`BasicScheduler`（调色助手）→ 准备配方 → `SamplerCustom`（画家）→ 实际绘画 → 完成作品
