写真からすべてのエッジラインを抽出します。ペンで写真の輪郭を描くように、オブジェクトの輪郭と詳細の境界を描き出します。

## 動作原理

あなたがペンで写真の輪郭を描く必要があるアーティストだと想像してください。Cannyノードは知的なアシスタントのように機能し、どこに線（エッジ）を描くべきか、どこに描くべきではないかを決定するのを手助けします。

このプロセスは選別作業のようなものです：

- **高い閾値**は「必ず線を描く基準」：人物の顔の輪郭や建物の枠など、非常に明確ではっきりした輪郭線のみが描かれます
- **低い閾値**は「絶対に線を描かない基準」：弱すぎるエッジは無視され、ノイズや意味のない線を描くことを避けます
- **中間領域**：2つの基準の間にあるエッジは、「必須の線」に接続している場合は一緒に描かれ、孤立している場合は描かれません

最終出力は白黒画像で、白い部分が検出されたエッジライン、黒い部分がエッジのない領域です。

## 入力

| パラメータ名 | データ型 | 入力方法 | デフォルト値 | 値の範囲 | 機能説明 |
|-------------|----------|----------|-------------|----------|----------|
| イメージ | IMAGE | 接続 | - | - | エッジ抽出が必要な元の写真 |
| 低い閾値 | FLOAT | 手動入力 | 0.4 | 0.01-0.99 | 低い閾値、無視する弱いエッジの程度を決定。値が低いほど詳細が保持されるが、ノイズが発生する可能性 |
| 高い閾値 | FLOAT | 手動入力 | 0.8 | 0.01-0.99 | 高い閾値、保持する強いエッジの程度を決定。値が高いほど最も明確な輪郭線のみが保持される |

## 出力

| 出力名 | データ型 | 説明 |
|--------|----------|------|
| イメージ | IMAGE | 白黒エッジ画像、白い線が検出されたエッジ、黒い領域がエッジのない部分 |

## パラメータ比較

![元画像](./asset/input.webp)

![パラメータ比較](./asset/compare.webp)

**よくある問題：**

- エッジが途切れ途切れ：高い閾値を下げてみてください
- ノイズが多すぎる：低い閾値を上げてください
- 重要な詳細が失われる：低い閾値を下げてください
- エッジが粗すぎる：入力画像の品質と解像度を確認してください
