从照片中提取所有边缘线条，就像用钢笔为照片描边一样，把物体的轮廓和细节边界都画出来。

## 工作原理

想象您是一位画家，要用钢笔为一张照片描边。Canny节点就像一个智能助手，帮您决定哪些地方需要画线（边缘），哪些地方不需要。

这个过程就像筛选工作：

- **高阈值**是"必须画线的标准"：只有非常明显、清晰的轮廓线才会被画出来，比如人物脸部轮廓、建筑物边框
- **低阈值**是"完全不画线的标准"：太微弱的边缘会被忽略，避免画出噪点和无意义的线条
- **中间区域**：介于两个标准之间的边缘，如果连着"必须画的线"就一起画出来，如果是孤立的就不画

最终输出一张黑白图像，白色部分是检测到的边缘线条，黑色部分是没有边缘的区域。

## 输入

| 参数名称 | 数据类型 | 输入方式 | 默认值 | 取值范围  | 功能说明                                                           |
| -------- | -------- | -------- | ------ | --------- | ---------------------------------------------------------- |
| 图像     | IMAGE    | 连接     | -      | -         | 需要提取边缘的原始照片                                             |
| 低阈值   | FLOAT    | 手动输入 | 0.4    | 0.01-0.99 | 低阈值，决定忽略多弱的边缘。数值越小保留的细节越多，但可能产生噪点 |
| 高阈值   | FLOAT    | 手动输入 | 0.8    | 0.01-0.99 | 高阈值，决定保留多强的边缘。数值越大只保留最明显的轮廓线           |

## 输出

| 输出名称 | 数据类型 | 说明                                                       |
| -------- | -------- | ---------------------------------------------------------- |
| 图像    | IMAGE    | 黑白边缘图像，白色线条为检测到的边缘，黑色区域为无边缘部分 |

## 参数对比

![原图](./asset/input.webp)

![参数对比](./asset/compare.webp)

**常见问题：**

- 边缘断断续续：尝试降低高阈值
- 出现很多噪点：提高低阈值
- 丢失重要细节：降低低阈值
- 边缘太粗糙：检查输入图像质量和分辨率
