これは、指定された場所からモデルファイルを読み込み、主要な3つのコンポーネント（メインモデル、テキストエンコーダー、画像エンコーダー/デコーダー）に分解するモデルローダーノードです。

このノードは、`ComfyUI/models/checkpoints`フォルダー内のすべてのモデルファイルと、`extra_model_paths.yaml`ファイルで設定された追加パスを自動的に検出します。

1. **モデル互換性**：選択したモデルがワークフローと互換性があることを確認してください。異なるモデルタイプ（SD1.5、SDXL、Fluxなど）は、対応するサンプラーや他のノードと組み合わせる必要があります
2. **ファイル管理**：モデルファイルを`ComfyUI/models/checkpoints`フォルダーに配置するか、extra_model_paths.yamlを通じて他のパスを設定してください
3. **インターフェース更新**：ComfyUIの実行中に新しいモデルファイルが追加された場合、ブラウザーを更新（Ctrl+R）してドロップダウンリストに新しいファイルを表示する必要があります

## 入力

| パラメータ名 | データ型 | 入力方法 | デフォルト値 | 値の範囲 | 説明 |
|-------------|----------|----------|--------------|----------|------|
| ckpt名 | STRING | ドロップダウン選択 | null | checkpointsフォルダー内のすべてのモデルファイル | 読み込むチェックポイントモデルファイル名を選択し、後続の画像生成で使用するAIモデルを決定します |

## 出力

| 出力名 | データ型 | 説明 |
|--------|----------|------|
| モデル | MODEL | 画像のノイズ除去生成に使用される主要な拡散モデル、AI画像作成の中核コンポーネント |
| CLIP | CLIP | テキストプロンプトのエンコードに使用されるモデル、テキスト記述をAIが理解できる情報に変換します |
| VAE | VAE | 画像のエンコードとデコードに使用されるモデル、ピクセル空間と潜在空間の間の変換を担当します |
