这是一个模型加载器节点，用于从指定位置加载模型文件，并将其分解为三个核心组件：主模型、文本编码器和图像编解码器。

这个节点会自动检测`ComfyUI/models/checkpoints`文件夹下的所有模型文件，以及你在extra_model_paths.yaml文件中配置的额外路径。

1. **模型兼容性**：确保所选模型与你的工作流程兼容，不同类型的模型（如SD1.5、SDXL、Flux等）需要配合相应的采样器和其他节点
2. **文件管理**：将模型文件放在`ComfyUI/models/checkpoints`文件夹中，或通过extra_model_paths.yaml配置其他路径
3. **界面刷新**：如果在ComfyUI运行期间添加了新的模型文件，需要刷新浏览器（Ctrl+R）才能在下拉列表中看到新文件

## 输入

| 参数名称 | 数据类型 | 输入方式 | 默认值 | 取值范围 | 功能说明 |
|----------|----------|----------|---------|----------|----------|
| checkpoint名称 | STRING | 下拉选择 | null | checkpoints文件夹中的所有模型文件 | 选择要加载的检查点模型文件名称，决定了后续生图使用的AI模型 |

## 输出

| 输出名称 | 数据类型 | 说明 |
|----------|----------|------|
| 模型 | MODEL | 用于图像去噪生成的主要扩散模型，是AI绘画的核心组件 |
| CLIP | CLIP | 用于编码文本提示词的模型，将文字描述转换为AI能理解的信息 |
| VAE | VAE | 用于图像编解码的模型，负责在像素空间和潜在空间之间转换 |
