Узел `Сохранить checkpoint` предназначен для сохранения полной модели Stable Diffusion (включая компоненты UNet, CLIP и VAE) в формате **.safetensors**.

Этот узел в основном используется в рабочих процессах объединения моделей. После создания новой объединенной модели с помощью узлов, таких как `ModelMergeSimple`, `ModelMergeBlocks` и т.д., вы можете использовать этот узел для сохранения результата в виде многоразового checkpoint файла.

## Входные параметры

| Название параметра | Тип данных | Описание |
|-------------------|------------|-----------|
| `модель` | MODEL | Представляет основную модель, состояние которой нужно сохранить. Важно для фиксации текущего состояния модели для будущего восстановления или анализа. |
| `clip` | CLIP | Параметры модели CLIP, связанной с основной моделью, позволяющие сохранить её состояние вместе с основной моделью. |
| `vae` | VAE | Параметры модели Variational Autoencoder (VAE), позволяющие сохранить её состояние вместе с основной моделью и CLIP для будущего использования или анализа. |
| `префикс_названия_файла` | STRING | Определяет префикс имени файла для сохраняемого checkpoint. |

Кроме того, узел имеет два скрытых входных параметра для метаданных:

**prompt (PROMPT)**: Информация о рабочем процессе
**extra_pnginfo (EXTRA_PNGINFO)**: Дополнительная информация PNG

## Выходные данные

Этот узел создаст файл checkpoint, который будет сохранен в директории `output/checkpoints/`

## Совместимость с архитектурами

- Полная поддержка: SDXL, SD3, SVD и другие основные архитектуры, см. [исходный код](https://github.com/comfyanonymous/ComfyUI/blob/master/comfy_extras/nodes_model_merging.py#L176-L189)
- Базовая поддержка: Другие архитектуры могут быть сохранены, но без стандартизированной метаинформации

## Связанные ссылки

Исходный код: [nodes_model_merging.py#L227](https://github.com/comfyanonymous/ComfyUI/blob/master/comfy_extras/nodes_model_merging.py#L227)
