Этот узел в основном используется для независимой загрузки текстовых энкодеров CLIP.
Файлы моделей могут быть обнаружены по следующим путям:

- "ComfyUI/models/text_encoders/"
- "ComfyUI/models/clip/"

> Если вы сохранили модель после запуска ComfyUI, вам нужно будет обновить фронтенд ComfyUI, чтобы получить актуальный список путей к файлам моделей

Поддерживаемые форматы моделей:

- `.ckpt`
- `.pt`
- `.pt2`
- `.bin`
- `.pth`
- `.safetensors`
- `.pkl`
- `.sft`

Для получения более подробной информации о загрузке последних файлов моделей, пожалуйста, обратитесь к [folder_paths](https://github.com/comfyanonymous/ComfyUI/blob/master/folder_paths.py)

## Входные параметры

| Параметр        | Тип данных    | Описание |
|-----------------|---------------|-----------|
| `название_clip` | COMBO[STRING] | Указывает имя загружаемой модели CLIP. Это имя используется для поиска файла модели в предопределенной структуре каталогов. |
| `тип`          | COMBO[STRING] | Определяет тип загружаемой модели CLIP. По мере того как ComfyUI поддерживает больше моделей, здесь будут добавляться новые типы. Подробности смотрите в определении класса `CLIPLoader` в [node.py](https://github.com/comfyanonymous/ComfyUI/blob/master/nodes.py). |
| `устройство`   | COMBO[STRING] | Выбор устройства для загрузки модели CLIP. `default` запустит модель на GPU, а выбор `CPU` принудительно загрузит на CPU. |

### Объяснение параметров устройства

**Когда выбирать "default":**

- Достаточно памяти GPU
- Нужна максимальная производительность
- Позволить системе автоматически оптимизировать использование памяти

**Когда выбирать "cpu":**

- Недостаточно памяти GPU
- Необходимо зарезервировать память GPU для других моделей (например, UNet)
- Работа в среде с низким объемом VRAM
- Отладка или специальные цели

**Влияние на производительность**

Работа на CPU будет значительно медленнее, чем на GPU, но это может сэкономить ценную память GPU для других важных компонентов модели. В средах с ограниченной памятью размещение модели CLIP на CPU является распространенной стратегией оптимизации.

### Поддерживаемые комбинации

| Тип модели | Соответствующий энкодер |
|------------|------------------------|
| stable_diffusion | clip-l |
| stable_cascade | clip-g |
| sd3 | t5 xxl/ clip-g / clip-l |
| stable_audio | t5 base |
| mochi | t5 xxl |
| cosmos | old t5 xxl |
| lumina2 | gemma 2 2B |
| wan | umt5 xxl |

По мере обновления ComfyUI эти комбинации могут расширяться. Подробности смотрите в определении класса `CLIPLoader` в [node.py](https://github.com/comfyanonymous/ComfyUI/blob/master/nodes.py)

## Выходные параметры

| Параметр | Тип данных | Описание |
|----------|------------|----------|
| `clip`   | CLIP       | Загруженная модель CLIP, готовая к использованию в последующих задачах или дальнейшей обработке. |

## Дополнительные примечания

Модели CLIP играют ключевую роль как текстовые энкодеры в ComfyUI, отвечая за преобразование текстовых подсказок в числовые представления, которые могут понимать модели диффузии. Их можно рассматривать как переводчиков, отвечающих за перевод вашего текста на язык, который могут понимать большие модели. Конечно, у разных моделей есть свои "диалекты", поэтому между различными архитектурами требуются разные энкодеры CLIP для завершения процесса кодирования текста.
