`CLIP 병합 (단순)`은 지정된 비율에 따라 두 개의 CLIP 텍스트 인코더 모델을 결합하는 고급 모델 병합 노드입니다.

이 노드는 지정된 비율에 따라 두 개의 CLIP 모델을 병합하여 그들의 특성을 효과적으로 혼합합니다. 위치 ID와 로그 스케일과 같은 특정 구성 요소를 제외하고 한 모델에서 다른 모델로 패치를 선택적으로 적용하여 두 소스 모델의 기능을 결합한 하이브리드 모델을 만듭니다.

## 입력

| 매개변수 | 데이터 유형 | 설명 |
|-----------|-------------|-------------|
| CLIP1     | CLIP      | 병합될 첫 번째 CLIP 모델입니다. 병합 과정의 기본 모델로 사용됩니다. |
| CLIP2     | CLIP      | 병합될 두 번째 CLIP 모델입니다. 위치 ID와 로그 스케일을 제외한 주요 패치가 지정된 비율에 따라 첫 번째 모델에 적용됩니다. |
| 비율      | FLOAT     | 범위 `0.0 - 1.0`, 두 번째 모델의 기능을 첫 번째 모델에 혼합할 비율을 결정합니다. 비율이 1.0이면 두 번째 모델의 기능을 완전히 채택하고, 0.0이면 첫 번째 모델의 기능만 유지합니다. |

## 출력

| 매개변수 | 데이터 유형 | 설명 |
|-----------|-------------|-------------|
| clip      | CLIP      | 지정된 비율에 따라 두 입력 모델의 기능을 통합한 결과 병합된 CLIP 모델입니다. |

## 병합 메커니즘 설명

### 병합 알고리즘

이 노드는 두 모델을 병합하기 위해 가중 평균을 사용합니다:

1. **기본 모델 복제**: 먼저 CLIP1을 기본 모델로 복제합니다
2. **패치 획득**: CLIP2에서 모든 주요 패치를 획득합니다
3. **특수 키 필터링**: `.position_ids`와 `.logit_scale`로 끝나는 키를 건너뜁니다
4. **가중 병합 적용**: `(1.0 - 비율) * CLIP1 + 비율 * CLIP2` 공식을 사용합니다

### 비율 매개변수 설명

- **비율 = 0.0**: CLIP1을 완전히 사용하고 CLIP2를 무시합니다
- **비율 = 0.5**: 각 모델에서 50%의 기여도
- **비율 = 1.0**: CLIP2를 완전히 사용하고 CLIP1을 무시합니다

## 사용 사례

1. **모델 스타일 융합**: 서로 다른 데이터로 학습된 CLIP 모델의 특성 결합
2. **성능 최적화**: 서로 다른 모델의 장단점 균형 조정
3. **실험적 연구**: 다양한 CLIP 인코더의 조합 탐색
