`CLIP融合简易` 是一个高级模型合并节点，用于将两个 CLIP 文本编码器模型按指定比例进行合并.

此节点专门用于根据指定比例合并两个CLIP模型，有效地混合它们的特性。它有选择性地将一个模型的补丁应用到另一个模型上，排除像位置ID和对数尺度这样的特定组件，以创建一个结合了两个源模型特征的混合模型。

## 输入

| 参数名称 | 数据类型 | 作用 |
|----------|----------|------|
| `clip1`  | CLIP     | 要合并的第一个CLIP模型。它作为合并过程的基础模型。 |
| `clip2`  | CLIP     | 要合并的第二个CLIP模型。根据指定的比例，除位置ID和对数尺度外，其关键补丁将应用于第一个模型。 |
| `比例`  | FLOAT    | 取值范围 `0.0 - 1.0` 确定从第二个模型融合到第一个模型中的特性比例。比例为1.0意味着完全采用第二个模型的特性，而0.0则仅保留第一个模型的特性。 |

## 输出

| 参数名称 | 数据类型 | 作用 |
|----------|----------|------|
| `clip`   | CLIP     | 结果合并的CLIP模型，根据指定的比例整合了两个输入模型的特性。 |

## 合并机制详解

### 合并算法

节点使用加权平均的方式合并两个模型：

1. **克隆基础模型**: 首先克隆 `clip1` 作为基础模型
2. **获取补丁**: 从 `clip2` 获取所有键值补丁 (key patches)
3. **过滤特殊键**: 跳过 `.position_ids` 和 `.logit_scale` 结尾的键
4. **应用加权合并**: 使用公式 `(1.0 - 比例) * clip1 + 比例 * clip2` 

### 比例 参数说明

- **比例 = 0.0**: 完全使用 clip1，忽略 clip2
- **比例 = 0.5**: 两个模型各占 50%
- **比例 = 1.0**: 完全使用 clip2，忽略 clip1

## 使用场景

1. **模型风格融合**: 结合不同训练数据的 CLIP 模型特点
2. **性能优化**: 平衡不同模型的优缺点
3. **实验研究**: 探索不同 CLIP 编码器的组合效果
