`CLIPテキストエンコード (プロンプト)` は、通訳者のように機能し、あなたの文章による創作アイデアをAIが理解できる特別な"言語"に変換し、AIがあなたの望む画像を正確に理解できるようにサポートします。

## 動作原理

外国人のアーティストとコミュニケーションを取る場面を想像してください。あなたが望む作品を正確に伝えるために通訳者が必要なように、このノードは通訳者として機能します。CLIP モデル（大量の画像とテキストのペアで訓練されたAIモデル）を使用して、あなたのテキストの説明を理解し、AIアートモデルが理解できる"指示"に変換します。

## 入力

| パラメータ | データ型 | 入力方法 | デフォルト値 | 範囲 | 説明 |
|------------|----------|------------|--------------|--------|--------|
| text | STRING | テキスト入力 | 空 | 任意のテキスト | アーティストへの詳細な指示のように、ここに生成したい画像の説明を入力します。複数行のテキストで詳細な効果を記述できます。 |
| クリップ | CLIP | モデル選択 | なし | 読み込み済みのCLIPモデル | 特定の通訳者を選ぶように、異なるCLIPモデルは芸術スタイルの理解が少しずつ異なる通訳者のようなものです。 |

## 出力

| 出力名 | データ型 | 説明 |
|---------|----------|--------|
| 条件付け | CONDITIONING | これは変換された"描画指示"で、AIモデルが理解できる詳細な創作ガイダンスが含まれています。これらの指示がAIモデルに、あなたの説明に合った画像をどのように生成するかを伝えます。 |

## 使用のヒント

1. **テキストプロンプトの基本的な使い方**
   - 短い作文を書くように、詳細な説明を書きましょう
   - より具体的な説明により、より正確な結果が得られます
   - 英語のカンマを使用して異なる説明要素を区切ります

2. **特別な機能：埋め込みモデルの使用**
   - 埋め込みモデルは、プリセットのアートスタイルパッケージのように、特定の芸術効果を素早く適用できます
   - 現在、.safetensors、.pt、.binの3つのファイル形式をサポートしており、完全なモデル名を使用する必要はありません
   - 使用方法：
     1. 埋め込みモデルファイル（.pt形式）を`ComfyUI/models/embeddings`フォルダに配置
     2. テキスト内で`embedding:モデル名`を使用
     例：`EasyNegative.pt`というモデルがある場合、次のように使用できます：

     ```
     a beautiful landscape, embedding:EasyNegative, high quality
     ```

3. **プロンプトの重み付け調整**
   - 括弧を使用して特定の説明の重要度を調整できます
   - 例：`(beautiful:1.2)`は"beautiful"という特徴をより強調します
   - 通常の括弧`()`のデフォルトの重みは1.1です
   - キーボードショートカット `ctrl + 上/下矢印` で重みを素早く調整できます
   - 重み調整のステップサイズは設定で変更可能です

4. **重要な注意点**
   - CLIPモデルが正しく読み込まれていることを確認してください
   - ポジティブで明確なテキスト説明を使用してください
   - 埋め込みモデルを使用する場合は、ファイル名が正しく、現在のメインモデルのアーキテクチャと互換性があることを確認してください
