`CLIP 텍스트 인코딩 (프롬프트)` 는 통역사처럼 작동하여, 당신의 문장으로 된 창작 아이디어를 AI가 이해할 수 있는 특별한 "언어"로 변환하여 AI가 당신이 원하는 이미지를 정확하게 이해할 수 있도록 도와줍니다.

## 작동 원리

외국인 아티스트와 소통하는 상황을 상상해보세요. 당신이 원하는 작품을 정확하게 전달하기 위해 통역사가 필요한 것처럼, 이 노드는 통역사 역할을 합니다. CLIP 모델(대량의 이미지와 텍스트 쌍으로 훈련된 AI 모델)을 사용하여 당신의 텍스트 설명을 이해하고, AI 아트 모델이 이해할 수 있는 "지시사항"으로 변환합니다.

## 입력

| 매개변수 | 데이터 유형 | 입력 방식 | 기본값 | 범위 | 설명 |
|----------|------------|------------|---------|--------|--------|
| text | STRING | 텍스트 입력 | 없음 | 모든 텍스트 | 아티스트에게 주는 상세한 지시사항처럼, 여기에 생성하고 싶은 이미지에 대한 설명을 입력합니다. 여러 줄의 텍스트로 상세한 효과를 설명할 수 있습니다. |
| clip | CLIP | 모델 선택 | 없음 | 로드된 CLIP 모델 | 특정 통역사를 선택하는 것처럼, 서로 다른 CLIP 모델은 예술 스타일에 대한 이해가 조금씩 다른 통역사와 같습니다. |

## 출력

| 출력명 | 데이터 유형 | 설명 |
|--------|------------|--------|
| 조건 | CONDITIONING | 이것은 변환된 "그림 지시사항"으로, AI 모델이 이해할 수 있는 상세한 창작 가이드라인을 포함합니다. 이 지시사항들은 AI 모델에게 당신의 설명에 맞는 이미지를 어떻게 생성할지 알려줍니다. |

## 사용 팁

1. **텍스트 프롬프트 기본 사용법**
   - 짧은 글을 쓰듯이 상세한 설명을 작성하세요
   - 더 구체적인 설명일수록 더 정확한 결과를 얻을 수 있습니다
   - 영어 쉼표를 사용하여 다른 설명 요소들을 구분하세요

2. **특별 기능: 임베딩 모델 사용**
   - 임베딩 모델은 프리셋 아트 스타일 패키지와 같아서, 특정 예술 효과를 빠르게 적용할 수 있습니다
   - 현재 .safetensors, .pt, .bin 세 가지 파일 형식을 지원하며, 전체 모델 이름을 사용할 필요는 없습니다
   - 사용 방법:
     1. 임베딩 모델 파일(.pt 형식)을 `ComfyUI/models/embeddings` 폴더에 넣습니다
     2. 텍스트에서 `embedding:모델명`을 사용합니다
     예시: `EasyNegative.pt`라는 모델이 있다면, 다음과 같이 사용할 수 있습니다:

     ```
     a beautiful landscape, embedding:EasyNegative, high quality
     ```

3. **프롬프트 가중치 조정**
   - 괄호를 사용하여 특정 설명의 중요도를 조정할 수 있습니다
   - 예시: `(beautiful:1.2)`는 "beautiful" 특성을 더 강조합니다
   - 일반 괄호 `()`의 기본 가중치는 1.1입니다
   - 키보드 단축키 `ctrl + 위/아래 화살표`로 가중치를 빠르게 조정할 수 있습니다
   - 가중치 조정 단계 크기는 설정에서 변경할 수 있습니다

4. **주요 참고사항**
   - CLIP 모델이 올바르게 로드되었는지 확인하세요
   - 긍정적이고 명확한 텍스트 설명을 사용하세요
   - 임베딩 모델을 사용할 때는 파일 이름이 정확하고 현재 메인 모델의 아키텍처와 호환되는지 확인하세요
