`Кодирование текста CLIP (Запрос)` действует как переводчик, преобразуя ваши текстовые описания в специальный "язык", понятный ИИ, помогая ему точно интерпретировать, какое изображение вы хотите создать.

## Принцип работы

Представьте, что вы общаетесь с иностранным художником - вам нужен переводчик, чтобы точно передать, какую работу вы хотите получить. Этот узел действует как такой переводчик, используя модель CLIP (модель ИИ, обученную на огромном количестве пар изображений и текста) для понимания ваших текстовых описаний и преобразования их в "инструкции", которые модель ИИ может понять.

## Входы

| Параметр | Тип данных | Метод ввода | По умолчанию | Диапазон | Описание |
|----------|------------|-------------|---------------|-----------|-----------|
| text | STRING | Текстовый ввод | Пусто | Любой текст | Как подробные инструкции художнику, введите здесь описание желаемого изображения. Поддерживает многострочный текст для детальных описаний. |
| clip | CLIP | Выбор модели | Нет | Загруженные модели CLIP | Как выбор конкретного переводчика, разные модели CLIP подобны разным переводчикам с немного разным пониманием художественных стилей. |

## Выходы

| Название выхода | Тип данных | Описание |
|----------------|------------|-----------|
| КОНДИЦИОНИРОВАНИЕ | CONDITIONING | Это переведенные "инструкции для рисования", содержащие подробные творческие указания, которые модель ИИ может понять. Эти инструкции указывают модели ИИ, как создать изображение, соответствующее вашему описанию. |

## Советы по использованию

1. **Основное использование текстовых подсказок**
   - Пишите подробные описания, как если бы вы писали короткое эссе
   - Более конкретные описания приводят к более точным результатам
   - Используйте английские запятые для разделения различных описательных элементов

2. **Специальная функция: Использование моделей Embedding**
   - Модели Embedding подобны предустановленным пакетам художественных стилей, которые могут быстро применять определенные художественные эффекты
   - В настоящее время поддерживаются форматы файлов .safetensors, .pt и .bin, и вам не обязательно использовать полное имя модели
   - Как использовать:
     1. Поместите файл модели embedding (в формате .pt) в папку `ComfyUI/models/embeddings`
     2. Используйте `embedding:имя_модели` в вашем тексте
     Пример: Если у вас есть модель с названием `EasyNegative.pt`, вы можете использовать её так:

     ```
     a beautiful landscape, embedding:EasyNegative, high quality
     ```

3. **Настройка весов подсказок**
   - Используйте скобки для регулировки важности определенных описаний
   - Например: `(beautiful:1.2)` сделает характеристику "beautiful" более выраженной
   - Обычные скобки `()` имеют вес по умолчанию 1.1
   - Используйте сочетания клавиш `ctrl + стрелка вверх/вниз` для быстрой настройки весов
   - Шаг изменения веса можно изменить в настройках

4. **Важные примечания**
   - Убедитесь, что модель CLIP правильно загружена
   - Используйте позитивные и четкие текстовые описания
   - При использовании моделей embedding убедитесь, что имя файла правильное и совместимо с архитектурой вашей текущей основной модели
