
`CLIP文本编码 (CLIPTextEncode)` 这个节点就像一位翻译官，它能将你用文字描述的创作想法转换成AI能够理解的特殊"语言"，帮助AI准确理解你想要创作的图像内容。

想象你在和一位外国画家沟通，你需要一位翻译来帮助你准确传达你想要的画作效果。这个节点就像那位翻译，它使用CLIP模型（一个经过大量图文训练的AI模型）来理解你的文字描述，并将其转换成AI绘画模型能理解的"语言指令"。

## 输入

| 参数名称 | 数据类型 | 输入方式 | 默认值 | 取值范围 | 功能说明 |
|----------|----------|----------|---------|----------|----------|
| text | STRING | 文本输入框 | 空 | 任意文本 | 就像给画家的详细说明，在这里输入你想要生成的图像的文字描述。支持多行文本，可以非常详细地描述你想要的效果。 |
| clip | CLIP | 模型选择 | 无 | 已加载的CLIP模型 | 相当于选择特定的翻译官，不同的CLIP模型就像不同的翻译官，他们对艺术风格的理解略有不同。 |

## 输出

| 输出名称 | 数据类型 | 说明 |
|----------|----------|------|
| 条件 | CONDITIONING | 这是转换后的"绘画指令"，包含了AI能够理解的详细创作指引。这些指令会告诉AI模型应该如何绘制符合你描述的图像。 |

## 使用建议

1. **文本提示的基本用法**
   - 可以像写作文一样详细描述你想要的图像
   - 越具体的描述，生成的图像越符合预期
   - 可以使用英文逗号分隔不同的描述要素

2. **特殊功能：使用Embedding模型**
   - Embedding模型就像预设的艺术风格包，可以快速应用特定的艺术效果
   - 目前支持 .safetensors、.pt、.bin 这三种文件格式，你不一定需要在使用的时候用完整的模型名称
   - 使用方法：
     1. 将embedding模型文件(.pt格式)放入`ComfyUI/models/embeddings`文件夹
     2. 在文本中使用`embedding:模型名称`来调用
     例如：如果你有一个叫`EasyNegative.pt`的模型，可以这样使用：

     ```
     a beautiful landscape, embedding:EasyNegative, high quality
     ```

3. **提示词权重调整**
   - 可以用括号来调整某些描述的重要程度
   - 例如：`(beautiful:1.2)`会让"beautiful"这个特征更突出
   - 普通括号`()`的默认权重是1.1
   - 使用键盘快捷键 `ctrl + 上/下方向键` 头可以快速调整权重
   - 对应权重快速调整步长可以在设置中进行修改

4. **注意事项**
   - 确保CLIP模型已正确加载
   - 文本描述尽量使用正面、明确的词语
   - 如果使用embedding模型，确保文件名称输入正确并且和当前主模型的架构吻合
