此节点设计使用特别为SDXL架构定制的CLIP模型对文本输入进行编码。它专注于将文本描述转换为可以有效地用于生成或操作图像的格式，利用CLIP模型理解和处理视觉内容上下文中的文本的能力。

## 输入

| 参数名称   | 数据类型 | 作用                                                                                                       |
| ---------- | -------- | ---------------------------------------------------------------------------------------------------------- |
| `CLIP`     | `CLIP`   | 用于编码文本的CLIP模型实例。它在处理文本输入和将其转换为适合图像生成或操作任务的格式中起着至关重要的作用。 |
| `宽度`     | `INT`    | 指定图像的宽度（以像素为单位）。它决定了生成或操作的输出图像的尺寸。                                       |
| `高度`     | `INT`    | 指定图像的高度（以像素为单位）。它决定了生成或操作的输出图像的尺寸。                                       |
| `裁剪宽度` | `INT`    | 定义裁剪区域的宽度（以像素为单位）。此参数用于在处理之前将图像裁剪到特定的宽度。                           |
| `裁剪高度` | `INT`    | 定义裁剪区域的高度（以像素为单位）。此参数用于在处理之前将图像裁剪到特定的高度。                           |
| `目标宽度` | `INT`    | 处理后的输出图像的目标宽度。它允许将图像调整到所需的宽度。                                                 |
| `目标高度` | `INT`    | 处理后的输出图像的目标高度。它允许将图像调整到所需的高度。                                                 |
| `CLIP_G`   | `STRING` | 要编码的全局文本描述。此输入对于生成相应的视觉表示和理解所描述的内容至关重要。                             |
| `CLIP_L`   | `STRING` | 要编码的局部文本描述。此输入为全局描述提供额外的细节或上下文，增强了生成或操作的图像的特异性。             |

## 输出

| 参数名称 | 数据类型       | 作用                                                               |
| -------- | -------------- | ------------------------------------------------------------------ |
| `条件`   | `CONDITIONING` | 节点的输出，包括编码后的文本以及图像生成或操作任务所需的其他信息。 |
