このノードは、`ComfyUI/models/hypernetworks` フォルダーにあるモデルを検出し、また、extra_model_paths.yaml ファイルで設定された追加パスのモデルも読み込みます。場合によっては、**ComfyUIのインターフェースを更新する**必要があるかもしれませんので、対応するフォルダー内のモデルファイルを読み込むことができます。

HypernetworkLoaderノードは、ハイパーネットワークを適用することで、指定されたモデルの能力を強化または変更するために設計されています。指定されたハイパーネットワークをロードし、モデルに適用することで、その動作や性能を`strength`パラメータに基づいて変更する可能性があります。このプロセスにより、モデルのアーキテクチャやパラメータを動的に調整し、より柔軟で適応性のあるAIシステムを実現します。

## 入力

| フィールド                 | Comfy dtype       | 説明                                                                                  |
|-----------------------|-------------------|----------------------------------------------------------------------------------------------|
| `model`               | `MODEL`           | ハイパーネットワークが適用されるベースモデルで、強化または変更されるアーキテクチャを決定します。 |
| `hypernetwork_name`  | `COMBO[STRING]`   | ロードしてモデルに適用するハイパーネットワークの名前で、モデルの変更された動作や性能に影響を与えます。 |
| `strength`            | `FLOAT`           | モデルに対するハイパーネットワークの効果の強度を調整するスカラーで、変更の微調整を可能にします。 |

## 出力

| フィールド   | Data Type | 説明                                                              |
|---------|-------------|--------------------------------------------------------------------------|
| `model` | `MODEL`     | ハイパーネットワークが適用された後の変更されたモデルで、元のモデルに対するハイパーネットワークの影響を示します。 |
