"""Specify supported blend types."""

from __future__ import annotations

from aenum import MultiValueEnum


class BlendType(str, MultiValueEnum):
	"""Specify supported blend types.

	NORMAL = "bm:normal", "normal"
	MULTIPLY = "bm:multiply", "multiply"
	ADDITIVE = "bm:additive", "additive"
	COLOURBURN = "bm:colourburn", "colourburn"
	COLOURDODGE = "bm:colourdodge", "colourdodge"
	REFLECT = "bm:reflect", "reflect"
	GLOW = "bm:glow", "glow"
	OVERLAY = "bm:overlay", "overlay"
	DIFFERENCE = "bm:difference", "difference"
	NEGATION = "bm:negation", "negation"
	LIGHTEN = "bm:lighten", "lighten"
	DARKEN = "bm:darken", "darken"
	SCREEN = "bm:screen", "screen"
	XOR = "bm:xor", "xor"
	SOFTLIGHT = "bm:softlight", "softlight"
	HARDLIGHT = "bm:hardlight", "hardlight"
	GRAINEXTRACT = "bm:grainextract", "grainextract"
	GRAINMERGE = "bm:grainmerge", "grainmerge"
	DIVIDE = "bm:divide", "divide"
	HUE = "bm:hue", "hue"
	SATURATION = "bm:saturation", "saturation"
	COLOUR = "bm:colour", "colour"
	LUMINOSITY = "bm:luminosity", "luminosity"
	PINLIGHT = "bm:pinlight", "pinlight"
	VIVIDLIGHT = "bm:vividlight", "vividlight"
	EXCLUSION = "bm:exclusion", "exclusion"
	DESTIN = "bm:destin", "destin"
	DESTOUT = "bm:destout", "destout"
	SRCATOP = "bm:srcatop", "srcatop"
	DESTATOP = "bm:destatop", "destatop"
	"""

	NORMAL = "bm:normal", "normal"
	MULTIPLY = "bm:multiply", "multiply"
	ADDITIVE = "bm:additive", "additive"
	COLOURBURN = "bm:colourburn", "colourburn"
	COLOURDODGE = "bm:colourdodge", "colourdodge"
	REFLECT = "bm:reflect", "reflect"
	GLOW = "bm:glow", "glow"
	OVERLAY = "bm:overlay", "overlay"
	DIFFERENCE = "bm:difference", "difference"
	NEGATION = "bm:negation", "negation"
	LIGHTEN = "bm:lighten", "lighten"
	DARKEN = "bm:darken", "darken"
	SCREEN = "bm:screen", "screen"
	XOR = "bm:xor", "xor"
	SOFTLIGHT = "bm:softlight", "softlight"
	HARDLIGHT = "bm:hardlight", "hardlight"
	GRAINEXTRACT = "bm:grainextract", "grainextract"
	GRAINMERGE = "bm:grainmerge", "grainmerge"
	DIVIDE = "bm:divide", "divide"
	HUE = "bm:hue", "hue"
	SATURATION = "bm:saturation", "saturation"
	COLOUR = "bm:colour", "colour"
	LUMINOSITY = "bm:luminosity", "luminosity"
	PINLIGHT = "bm:pinlight", "pinlight"
	VIVIDLIGHT = "bm:vividlight", "vividlight"
	EXCLUSION = "bm:exclusion", "exclusion"
	DESTIN = "bm:destin", "destin"
	DESTOUT = "bm:destout", "destout"
	SRCATOP = "bm:srcatop", "srcatop"
	DESTATOP = "bm:destatop", "destatop"
