/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

/* Supports Unicode version 6.0.0. */

#define RE_MAGIC 20100116

#include "_regex_unicode.h"

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ATOMIC 6
#define RE_OP_BIG_BITSET 7
#define RE_OP_BIG_BITSET_REV 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CHARACTER 11
#define RE_OP_CHARACTER_IGN 12
#define RE_OP_CHARACTER_IGN_REV 13
#define RE_OP_CHARACTER_REV 14
#define RE_OP_DEFAULT_BOUNDARY 15
#define RE_OP_END 16
#define RE_OP_END_GREEDY_REPEAT 17
#define RE_OP_END_GROUP 18
#define RE_OP_END_LAZY_REPEAT 19
#define RE_OP_END_OF_LINE 20
#define RE_OP_END_OF_STRING 21
#define RE_OP_END_OF_STRING_LINE 22
#define RE_OP_GRAPHEME_BOUNDARY 23
#define RE_OP_GREEDY_REPEAT 24
#define RE_OP_GREEDY_REPEAT_ONE 25
#define RE_OP_GROUP 26
#define RE_OP_GROUP_EXISTS 27
#define RE_OP_LAZY_REPEAT 28
#define RE_OP_LAZY_REPEAT_ONE 29
#define RE_OP_LOOKAROUND 30
#define RE_OP_NEXT 31
#define RE_OP_PROPERTY 32
#define RE_OP_PROPERTY_REV 33
#define RE_OP_REF_GROUP 34
#define RE_OP_REF_GROUP_IGN 35
#define RE_OP_REF_GROUP_IGN_REV 36
#define RE_OP_REF_GROUP_REV 37
#define RE_OP_SEARCH_ANCHOR 38
#define RE_OP_SET 39
#define RE_OP_SET_REV 40
#define RE_OP_SMALL_BITSET 41
#define RE_OP_SMALL_BITSET_REV 42
#define RE_OP_START_GROUP 43
#define RE_OP_START_OF_LINE 44
#define RE_OP_START_OF_STRING 45
#define RE_OP_STRING 46
#define RE_OP_STRING_IGN 47
#define RE_OP_STRING_IGN_REV 48
#define RE_OP_STRING_REV 49
#define RE_OP_TAIL_GUARD 50

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BIG_BITSET",
    "RE_OP_BIG_BITSET_REV",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGN",
    "RE_OP_CHARACTER_IGN_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_DEFAULT_BOUNDARY",
    "RE_OP_END",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_GRAPHEME_BOUNDARY",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_PROPERTY",
    "RE_OP_PROPERTY_REV",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_IGN",
    "RE_OP_REF_GROUP_IGN_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET",
    "RE_OP_SET_REV",
    "RE_OP_SMALL_BITSET",
    "RE_OP_SMALL_BITSET_REV",
    "RE_OP_START_GROUP",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_STRING",
    "RE_OP_STRING",
    "RE_OP_STRING_IGN",
    "RE_OP_STRING_IGN_REV",
    "RE_OP_STRING_REV",
    "RE_OP_TAIL_GUARD",
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_NEW 0x100
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_WORD 0x800
