import { S as SvelteComponent, i as init, s as safe_not_equal, U as create_slot, f as element, b as attr, t as toggle_class, c as insert, l as listen, P as update_slot_base, Q as get_all_dirty_from_scope, R as get_slot_changes, v as transition_in, w as transition_out, e as detach, F as bubble, q as create_component, u as mount_component, x as destroy_component, K as component_subscribe, X, h as text, j as set_data } from './index.970c506c.js';
import { g as get_styles } from './styles.db46e346.js';

/* home/runner/work/gradio/gradio/ui/packages/button/src/Button.svelte generated by Svelte v3.47.0 */

function create_fragment$1(ctx) {
	let button;
	let button_class_value;
	let current;
	let mounted;
	let dispose;
	const default_slot_template = /*#slots*/ ctx[7].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[6], null);

	return {
		c() {
			button = element("button");
			if (default_slot) default_slot.c();
			attr(button, "class", button_class_value = "gr-button gr-button-" + /*size*/ ctx[3] + " gr-button-" + /*variant*/ ctx[2] + " self-start " + /*classes*/ ctx[4]);
			attr(button, "id", /*elem_id*/ ctx[0]);
			toggle_class(button, "hidden", /*visible*/ ctx[1] === false);
		},
		m(target, anchor) {
			insert(target, button, anchor);

			if (default_slot) {
				default_slot.m(button, null);
			}

			current = true;

			if (!mounted) {
				dispose = listen(button, "click", /*click_handler*/ ctx[8]);
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty & /*$$scope*/ 64)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[6],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[6])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[6], dirty, null),
						null
					);
				}
			}

			if (!current || dirty & /*size, variant, classes*/ 28 && button_class_value !== (button_class_value = "gr-button gr-button-" + /*size*/ ctx[3] + " gr-button-" + /*variant*/ ctx[2] + " self-start " + /*classes*/ ctx[4])) {
				attr(button, "class", button_class_value);
			}

			if (!current || dirty & /*elem_id*/ 1) {
				attr(button, "id", /*elem_id*/ ctx[0]);
			}

			if (dirty & /*size, variant, classes, visible*/ 30) {
				toggle_class(button, "hidden", /*visible*/ ctx[1] === false);
			}
		},
		i(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(button);
			if (default_slot) default_slot.d(detaching);
			mounted = false;
			dispose();
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let classes;
	let { $$slots: slots = {}, $$scope } = $$props;
	let { style = {} } = $$props;
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { variant = "secondary" } = $$props;
	let { size = "lg" } = $$props;

	function click_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('style' in $$props) $$invalidate(5, style = $$props.style);
		if ('elem_id' in $$props) $$invalidate(0, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(1, visible = $$props.visible);
		if ('variant' in $$props) $$invalidate(2, variant = $$props.variant);
		if ('size' in $$props) $$invalidate(3, size = $$props.size);
		if ('$$scope' in $$props) $$invalidate(6, $$scope = $$props.$$scope);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*style*/ 32) {
			$$invalidate(4, { classes } = get_styles(style, ["border", "full_width", "rounded", "margin"]), classes);
		}
	};

	return [elem_id, visible, variant, size, classes, style, $$scope, slots, click_handler];
}

class Button extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			style: 5,
			elem_id: 0,
			visible: 1,
			variant: 2,
			size: 3
		});
	}
}

/* src/components/Button/Button.svelte generated by Svelte v3.47.0 */

function create_default_slot(ctx) {
	let t_value = /*$_*/ ctx[5](/*value*/ ctx[3]) + "";
	let t;

	return {
		c() {
			t = text(t_value);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*$_, value*/ 40 && t_value !== (t_value = /*$_*/ ctx[5](/*value*/ ctx[3]) + "")) set_data(t, t_value);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

function create_fragment(ctx) {
	let button;
	let current;

	button = new Button({
			props: {
				variant: /*variant*/ ctx[4],
				elem_id: /*elem_id*/ ctx[1],
				visible: /*visible*/ ctx[2],
				style: /*style*/ ctx[0],
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	button.$on("click", /*click_handler*/ ctx[6]);

	return {
		c() {
			create_component(button.$$.fragment);
		},
		m(target, anchor) {
			mount_component(button, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const button_changes = {};
			if (dirty & /*variant*/ 16) button_changes.variant = /*variant*/ ctx[4];
			if (dirty & /*elem_id*/ 2) button_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*visible*/ 4) button_changes.visible = /*visible*/ ctx[2];
			if (dirty & /*style*/ 1) button_changes.style = /*style*/ ctx[0];

			if (dirty & /*$$scope, $_, value*/ 168) {
				button_changes.$$scope = { dirty, ctx };
			}

			button.$set(button_changes);
		},
		i(local) {
			if (current) return;
			transition_in(button.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(button.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(button, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let $_;
	component_subscribe($$self, X, $$value => $$invalidate(5, $_ = $$value));
	let { style = {} } = $$props;
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value } = $$props;
	let { variant = "primary" } = $$props;

	function click_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('style' in $$props) $$invalidate(0, style = $$props.style);
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(3, value = $$props.value);
		if ('variant' in $$props) $$invalidate(4, variant = $$props.variant);
	};

	return [style, elem_id, visible, value, variant, $_, click_handler];
}

class Button_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			style: 0,
			elem_id: 1,
			visible: 2,
			value: 3,
			variant: 4
		});
	}
}

var Button_1$1 = Button_1;

const modes = ["static"];

export { Button_1$1 as Component, modes };
