import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, c as create_component, a as space, b as attr, f as insert, m as mount_component, g as append, a3 as set_input_value, l as listen, j as transition_in, k as transition_out, n as detach, o as destroy_component, E as createEventDispatcher, t as text, h as set_data, a4 as flush, P as assign, Q as StatusTracker, H as binding_callbacks, N as bind, R as get_spread_update, T as get_spread_object, K as add_flush_callback, J as bubble } from './index.a5ead1e9.js';
import { B as Block } from './Block.b0d46d59.js';
import { g as get_styles } from './styles.c72835fa.js';
import { B as BlockTitle } from './BlockTitle.441c43dc.js';

/* home/runner/work/gradio/gradio/ui/packages/form/src/ColorPicker.svelte generated by Svelte v3.49.0 */

function create_default_slot$1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[1]);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*label*/ 2) set_data(t, /*label*/ ctx[1]);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

function create_fragment$1(ctx) {
	let label_1;
	let blocktitle;
	let t;
	let input;
	let input_class_value;
	let current;
	let mounted;
	let dispose;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[3],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			label_1 = element("label");
			create_component(blocktitle.$$.fragment);
			t = space();
			input = element("input");
			attr(input, "type", "color");
			attr(input, "class", input_class_value = "gr-box-unrounded " + /*classes*/ ctx[4]);
			input.disabled = /*disabled*/ ctx[2];
			attr(label_1, "class", "block");
		},
		m(target, anchor) {
			insert(target, label_1, anchor);
			mount_component(blocktitle, label_1, null);
			append(label_1, t);
			append(label_1, input);
			set_input_value(input, /*value*/ ctx[0]);
			current = true;

			if (!mounted) {
				dispose = listen(input, "input", /*input_input_handler*/ ctx[6]);
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			const blocktitle_changes = {};
			if (dirty & /*show_label*/ 8) blocktitle_changes.show_label = /*show_label*/ ctx[3];

			if (dirty & /*$$scope, label*/ 514) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (!current || dirty & /*classes*/ 16 && input_class_value !== (input_class_value = "gr-box-unrounded " + /*classes*/ ctx[4])) {
				attr(input, "class", input_class_value);
			}

			if (!current || dirty & /*disabled*/ 4) {
				input.disabled = /*disabled*/ ctx[2];
			}

			if (dirty & /*value*/ 1) {
				set_input_value(input, /*value*/ ctx[0]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocktitle.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocktitle.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(label_1);
			destroy_component(blocktitle);
			mounted = false;
			dispose();
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let classes;
	let { value = "#000000" } = $$props;
	let { style = {} } = $$props;
	let { label } = $$props;
	let { disabled = false } = $$props;
	let { show_label = true } = $$props;
	const dispatch = createEventDispatcher();

	function handle_change(val) {
		dispatch("change", val);
	}

	function input_input_handler() {
		value = this.value;
		$$invalidate(0, value);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(5, style = $$props.style);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('disabled' in $$props) $$invalidate(2, disabled = $$props.disabled);
		if ('show_label' in $$props) $$invalidate(3, show_label = $$props.show_label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) ;

		if ($$self.$$.dirty & /*value*/ 1) {
			handle_change(value);
		}

		if ($$self.$$.dirty & /*style*/ 32) {
			$$invalidate(4, { classes } = get_styles(style, ["rounded", "border"]), classes);
		}
	};

	return [value, label, disabled, show_label, classes, style, input_input_handler];
}

class ColorPicker extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 5,
			label: 1,
			disabled: 2,
			show_label: 3
		});
	}
}

/* src/components/ColorPicker/ColorPicker.svelte generated by Svelte v3.49.0 */

function create_default_slot(ctx) {
	let statustracker;
	let t;
	let colorpicker;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[6]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });

	function colorpicker_value_binding(value) {
		/*colorpicker_value_binding*/ ctx[8](value);
	}

	let colorpicker_props = {
		style: /*style*/ ctx[5],
		label: /*label*/ ctx[1],
		show_label: /*show_label*/ ctx[4],
		disabled: /*mode*/ ctx[7] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		colorpicker_props.value = /*value*/ ctx[0];
	}

	colorpicker = new ColorPicker({ props: colorpicker_props });
	binding_callbacks.push(() => bind(colorpicker, 'value', colorpicker_value_binding));
	colorpicker.$on("change", /*change_handler*/ ctx[9]);
	colorpicker.$on("submit", /*submit_handler*/ ctx[10]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(colorpicker.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			mount_component(colorpicker, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 64)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[6])])
			: {};

			statustracker.$set(statustracker_changes);
			const colorpicker_changes = {};
			if (dirty & /*style*/ 32) colorpicker_changes.style = /*style*/ ctx[5];
			if (dirty & /*label*/ 2) colorpicker_changes.label = /*label*/ ctx[1];
			if (dirty & /*show_label*/ 16) colorpicker_changes.show_label = /*show_label*/ ctx[4];
			if (dirty & /*mode*/ 128) colorpicker_changes.disabled = /*mode*/ ctx[7] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				colorpicker_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			colorpicker.$set(colorpicker_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(colorpicker.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(colorpicker.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			destroy_component(colorpicker, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[3],
				elem_id: /*elem_id*/ ctx[2],
				disable: typeof /*style*/ ctx[5].container === "boolean" && !/*style*/ ctx[5].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 8) block_changes.visible = /*visible*/ ctx[3];
			if (dirty & /*elem_id*/ 4) block_changes.elem_id = /*elem_id*/ ctx[2];
			if (dirty & /*style*/ 32) block_changes.disable = typeof /*style*/ ctx[5].container === "boolean" && !/*style*/ ctx[5].container;

			if (dirty & /*$$scope, style, label, show_label, mode, value, loading_status*/ 2291) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { label = "ColorPicker" } = $$props;
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value } = $$props;
	let { show_label } = $$props;
	let { style = {} } = $$props;
	let { loading_status } = $$props;
	let { mode } = $$props;

	function colorpicker_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function submit_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('elem_id' in $$props) $$invalidate(2, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(3, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('show_label' in $$props) $$invalidate(4, show_label = $$props.show_label);
		if ('style' in $$props) $$invalidate(5, style = $$props.style);
		if ('loading_status' in $$props) $$invalidate(6, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(7, mode = $$props.mode);
	};

	return [
		value,
		label,
		elem_id,
		visible,
		show_label,
		style,
		loading_status,
		mode,
		colorpicker_value_binding,
		change_handler,
		submit_handler
	];
}

class ColorPicker_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			label: 1,
			elem_id: 2,
			visible: 3,
			value: 0,
			show_label: 4,
			style: 5,
			loading_status: 6,
			mode: 7
		});
	}

	get label() {
		return this.$$.ctx[1];
	}

	set label(label) {
		this.$$set({ label });
		flush();
	}

	get elem_id() {
		return this.$$.ctx[2];
	}

	set elem_id(elem_id) {
		this.$$set({ elem_id });
		flush();
	}

	get visible() {
		return this.$$.ctx[3];
	}

	set visible(visible) {
		this.$$set({ visible });
		flush();
	}

	get value() {
		return this.$$.ctx[0];
	}

	set value(value) {
		this.$$set({ value });
		flush();
	}

	get show_label() {
		return this.$$.ctx[4];
	}

	set show_label(show_label) {
		this.$$set({ show_label });
		flush();
	}

	get style() {
		return this.$$.ctx[5];
	}

	set style(style) {
		this.$$set({ style });
		flush();
	}

	get loading_status() {
		return this.$$.ctx[6];
	}

	set loading_status(loading_status) {
		this.$$set({ loading_status });
		flush();
	}

	get mode() {
		return this.$$.ctx[7];
	}

	set mode(mode) {
		this.$$set({ mode });
		flush();
	}
}

var ColorPicker_1$1 = ColorPicker_1;

const modes = ["static", "dynamic"];

export { ColorPicker_1$1 as Component, modes };
