import BaseStyle from '@primevue/core/base/style';

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-toast {\n    width: ".concat(dt('toast.width'), ";\n    white-space: pre-line;\n    word-break: break-word;\n}\n\n.p-toast-message {\n    margin: 0 0 1rem 0;\n}\n\n.p-toast-message-icon {\n    flex-shrink: 0;\n    font-size: ").concat(dt('toast.icon.size'), ";\n    width: ").concat(dt('toast.icon.size'), ";\n    height: ").concat(dt('toast.icon.size'), ";\n}\n\n.p-toast-message-content {\n    display: flex;\n    align-items: flex-start;\n    padding: ").concat(dt('toast.content.padding'), ";\n    gap: ").concat(dt('toast.content.gap'), ";\n}\n\n.p-toast-message-text {\n    flex: 1 1 auto;\n    display: flex;\n    flex-direction: column;\n    gap: ").concat(dt('toast.text.gap'), ";\n}\n\n.p-toast-summary {\n    font-weight: ").concat(dt('toast.summary.font.weight'), ";\n    font-size: ").concat(dt('toast.summary.font.size'), ";\n}\n\n.p-toast-detail {\n    font-weight: ").concat(dt('toast.detail.font.weight'), ";\n    font-size: ").concat(dt('toast.detail.font.size'), ";\n}\n\n.p-toast-close-button {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n    position: relative;\n    cursor: pointer;\n    background: transparent;\n    transition: background ").concat(dt('toast.transition.duration'), ", color ").concat(dt('toast.transition.duration'), ", outline-color ").concat(dt('toast.transition.duration'), ", box-shadow ").concat(dt('toast.transition.duration'), ";\n    outline-color: transparent;\n    color: inherit;\n    width: ").concat(dt('toast.close.button.width'), ";\n    height: ").concat(dt('toast.close.button.height'), ";\n    border-radius: ").concat(dt('toast.close.button.border.radius'), ";\n    margin: -25% 0 0 0;\n    right: -25%;\n    padding: 0;\n    border: none;\n    user-select: none;\n}\n\n.p-toast-close-button:dir(rtl) {\n    margin: -25% 0 0 auto;\n    left: -25%;\n    right: auto;\n}\n\n.p-toast-message-info,\n.p-toast-message-success,\n.p-toast-message-warn,\n.p-toast-message-error,\n.p-toast-message-secondary,\n.p-toast-message-contrast {\n    border-width: ").concat(dt('toast.border.width'), ";\n    border-style: solid;\n    backdrop-filter: blur(").concat(dt('toast.blur'), ");\n    border-radius: ").concat(dt('toast.border.radius'), ";\n}\n\n.p-toast-close-icon {\n    font-size: ").concat(dt('toast.close.icon.size'), ";\n    width: ").concat(dt('toast.close.icon.size'), ";\n    height: ").concat(dt('toast.close.icon.size'), ";\n}\n\n.p-toast-close-button:focus-visible {\n    outline-width: ").concat(dt('focus.ring.width'), ";\n    outline-style: ").concat(dt('focus.ring.style'), ";\n    outline-offset: ").concat(dt('focus.ring.offset'), ";\n}\n\n.p-toast-message-info {\n    background: ").concat(dt('toast.info.background'), ";\n    border-color: ").concat(dt('toast.info.border.color'), ";\n    color: ").concat(dt('toast.info.color'), ";\n    box-shadow: ").concat(dt('toast.info.shadow'), ";\n}\n\n.p-toast-message-info .p-toast-detail {\n    color: ").concat(dt('toast.info.detail.color'), ";\n}\n\n.p-toast-message-info .p-toast-close-button:focus-visible {\n    outline-color: ").concat(dt('toast.info.close.button.focus.ring.color'), ";\n    box-shadow: ").concat(dt('toast.info.close.button.focus.ring.shadow'), ";\n}\n\n.p-toast-message-info .p-toast-close-button:hover {\n    background: ").concat(dt('toast.info.close.button.hover.background'), ";\n}\n\n.p-toast-message-success {\n    background: ").concat(dt('toast.success.background'), ";\n    border-color: ").concat(dt('toast.success.border.color'), ";\n    color: ").concat(dt('toast.success.color'), ";\n    box-shadow: ").concat(dt('toast.success.shadow'), ";\n}\n\n.p-toast-message-success .p-toast-detail {\n    color: ").concat(dt('toast.success.detail.color'), ";\n}\n\n.p-toast-message-success .p-toast-close-button:focus-visible {\n    outline-color: ").concat(dt('toast.success.close.button.focus.ring.color'), ";\n    box-shadow: ").concat(dt('toast.success.close.button.focus.ring.shadow'), ";\n}\n\n.p-toast-message-success .p-toast-close-button:hover {\n    background: ").concat(dt('toast.success.close.button.hover.background'), ";\n}\n\n.p-toast-message-warn {\n    background: ").concat(dt('toast.warn.background'), ";\n    border-color: ").concat(dt('toast.warn.border.color'), ";\n    color: ").concat(dt('toast.warn.color'), ";\n    box-shadow: ").concat(dt('toast.warn.shadow'), ";\n}\n\n.p-toast-message-warn .p-toast-detail {\n    color: ").concat(dt('toast.warn.detail.color'), ";\n}\n\n.p-toast-message-warn .p-toast-close-button:focus-visible {\n    outline-color: ").concat(dt('toast.warn.close.button.focus.ring.color'), ";\n    box-shadow: ").concat(dt('toast.warn.close.button.focus.ring.shadow'), ";\n}\n\n.p-toast-message-warn .p-toast-close-button:hover {\n    background: ").concat(dt('toast.warn.close.button.hover.background'), ";\n}\n\n.p-toast-message-error {\n    background: ").concat(dt('toast.error.background'), ";\n    border-color: ").concat(dt('toast.error.border.color'), ";\n    color: ").concat(dt('toast.error.color'), ";\n    box-shadow: ").concat(dt('toast.error.shadow'), ";\n}\n\n.p-toast-message-error .p-toast-detail {\n    color: ").concat(dt('toast.error.detail.color'), ";\n}\n\n.p-toast-message-error .p-toast-close-button:focus-visible {\n    outline-color: ").concat(dt('toast.error.close.button.focus.ring.color'), ";\n    box-shadow: ").concat(dt('toast.error.close.button.focus.ring.shadow'), ";\n}\n\n.p-toast-message-error .p-toast-close-button:hover {\n    background: ").concat(dt('toast.error.close.button.hover.background'), ";\n}\n\n.p-toast-message-secondary {\n    background: ").concat(dt('toast.secondary.background'), ";\n    border-color: ").concat(dt('toast.secondary.border.color'), ";\n    color: ").concat(dt('toast.secondary.color'), ";\n    box-shadow: ").concat(dt('toast.secondary.shadow'), ";\n}\n\n.p-toast-message-secondary .p-toast-detail {\n    color: ").concat(dt('toast.secondary.detail.color'), ";\n}\n\n.p-toast-message-secondary .p-toast-close-button:focus-visible {\n    outline-color: ").concat(dt('toast.secondary.close.button.focus.ring.color'), ";\n    box-shadow: ").concat(dt('toast.secondary.close.button.focus.ring.shadow'), ";\n}\n\n.p-toast-message-secondary .p-toast-close-button:hover {\n    background: ").concat(dt('toast.secondary.close.button.hover.background'), ";\n}\n\n.p-toast-message-contrast {\n    background: ").concat(dt('toast.contrast.background'), ";\n    border-color: ").concat(dt('toast.contrast.border.color'), ";\n    color: ").concat(dt('toast.contrast.color'), ";\n    box-shadow: ").concat(dt('toast.contrast.shadow'), ";\n}\n\n.p-toast-message-contrast .p-toast-detail {\n    color: ").concat(dt('toast.contrast.detail.color'), ";\n}\n\n.p-toast-message-contrast .p-toast-close-button:focus-visible {\n    outline-color: ").concat(dt('toast.contrast.close.button.focus.ring.color'), ";\n    box-shadow: ").concat(dt('toast.contrast.close.button.focus.ring.shadow'), ";\n}\n\n.p-toast-message-contrast .p-toast-close-button:hover {\n    background: ").concat(dt('toast.contrast.close.button.hover.background'), ";\n}\n\n.p-toast-top-center {\n    transform: translateX(-50%);\n}\n\n.p-toast-bottom-center {\n    transform: translateX(-50%);\n}\n\n.p-toast-center {\n    min-width: 20vw;\n    transform: translate(-50%, -50%);\n}\n\n.p-toast-message-enter-from {\n    opacity: 0;\n    transform: translateY(50%);\n}\n\n.p-toast-message-leave-from {\n    max-height: 1000px;\n}\n\n.p-toast .p-toast-message.p-toast-message-leave-to {\n    max-height: 0;\n    opacity: 0;\n    margin-bottom: 0;\n    overflow: hidden;\n}\n\n.p-toast-message-enter-active {\n    transition: transform 0.3s, opacity 0.3s;\n}\n\n.p-toast-message-leave-active {\n    transition: max-height 0.45s cubic-bezier(0, 1, 0, 1), opacity 0.3s, margin-bottom 0.3s;\n}\n");
};

// Position
var inlineStyles = {
  root: function root(_ref2) {
    var position = _ref2.position;
    return {
      position: 'fixed',
      top: position === 'top-right' || position === 'top-left' || position === 'top-center' ? '20px' : position === 'center' ? '50%' : null,
      right: (position === 'top-right' || position === 'bottom-right') && '20px',
      bottom: (position === 'bottom-left' || position === 'bottom-right' || position === 'bottom-center') && '20px',
      left: position === 'top-left' || position === 'bottom-left' ? '20px' : position === 'center' || position === 'top-center' || position === 'bottom-center' ? '50%' : null
    };
  }
};
var classes = {
  root: function root(_ref3) {
    var props = _ref3.props;
    return ['p-toast p-component p-toast-' + props.position];
  },
  message: function message(_ref4) {
    var props = _ref4.props;
    return ['p-toast-message', {
      'p-toast-message-info': props.message.severity === 'info' || props.message.severity === undefined,
      'p-toast-message-warn': props.message.severity === 'warn',
      'p-toast-message-error': props.message.severity === 'error',
      'p-toast-message-success': props.message.severity === 'success',
      'p-toast-message-secondary': props.message.severity === 'secondary',
      'p-toast-message-contrast': props.message.severity === 'contrast'
    }];
  },
  messageContent: 'p-toast-message-content',
  messageIcon: function messageIcon(_ref5) {
    var props = _ref5.props;
    return ['p-toast-message-icon', _defineProperty(_defineProperty(_defineProperty(_defineProperty({}, props.infoIcon, props.message.severity === 'info'), props.warnIcon, props.message.severity === 'warn'), props.errorIcon, props.message.severity === 'error'), props.successIcon, props.message.severity === 'success')];
  },
  messageText: 'p-toast-message-text',
  summary: 'p-toast-summary',
  detail: 'p-toast-detail',
  closeButton: 'p-toast-close-button',
  closeIcon: 'p-toast-close-icon'
};
var ToastStyle = BaseStyle.extend({
  name: 'toast',
  theme: theme,
  classes: classes,
  inlineStyles: inlineStyles
});

export { ToastStyle as default };
//# sourceMappingURL=index.mjs.map
