//! Rules from [flake8-boolean-trap](https://pypi.org/project/flake8-boolean-trap/0.1.0/).
pub(crate) mod rules;

#[cfg(test)]
mod tests {
    use std::convert::AsRef;
    use std::path::Path;

    use anyhow::Result;
    use test_case::test_case;

    use crate::linter::test_path;
    use crate::registry::RuleCode;
    use crate::settings;

    #[test_case(RuleCode::FBT001, Path::new("FBT.py"); "FBT001")]
    #[test_case(RuleCode::FBT002, Path::new("FBT.py"); "FBT002")]
    #[test_case(RuleCode::FBT003, Path::new("FBT.py"); "FBT003")]
    fn rules(rule_code: RuleCode, path: &Path) -> Result<()> {
        let snapshot = format!("{}_{}", rule_code.as_ref(), path.to_string_lossy());
        let diagnostics = test_path(
            Path::new("./resources/test/fixtures/flake8_boolean_trap")
                .join(path)
                .as_path(),
            &settings::Settings::for_rule(rule_code),
        )?;
        insta::assert_yaml_snapshot!(snapshot, diagnostics);
        Ok(())
    }
}
