//! Rules from [flake8-implicit-str-concat](https://pypi.org/project/flake8-implicit-str-concat/0.3.0/).
pub(crate) mod rules;

#[cfg(test)]
mod tests {
    use std::convert::AsRef;
    use std::path::Path;

    use anyhow::Result;
    use test_case::test_case;

    use crate::linter::test_path;
    use crate::registry::RuleCode;
    use crate::settings;

    #[test_case(RuleCode::ISC001, Path::new("ISC.py"); "ISC001")]
    #[test_case(RuleCode::ISC002, Path::new("ISC.py"); "ISC002")]
    #[test_case(RuleCode::ISC003, Path::new("ISC.py"); "ISC003")]
    fn rules(rule_code: RuleCode, path: &Path) -> Result<()> {
        let snapshot = format!("{}_{}", rule_code.as_ref(), path.to_string_lossy());
        let diagnostics = test_path(
            Path::new("./resources/test/fixtures/flake8_implicit_str_concat")
                .join(path)
                .as_path(),
            &settings::Settings::for_rule(rule_code),
        )?;
        insta::assert_yaml_snapshot!(snapshot, diagnostics);
        Ok(())
    }
}
