import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-select {\n    display: inline-flex;\n    cursor: pointer;\n    position: relative;\n    user-select: none;\n    background: ".concat(dt('select.background'), ";\n    border: 1px solid ").concat(dt('select.border.color'), ";\n    transition: background ").concat(dt('select.transition.duration'), ", color ").concat(dt('select.transition.duration'), ", border-color ").concat(dt('select.transition.duration'), ",\n        outline-color ").concat(dt('select.transition.duration'), ", box-shadow ").concat(dt('select.transition.duration'), ";\n    border-radius: ").concat(dt('select.border.radius'), ";\n    outline-color: transparent;\n    box-shadow: ").concat(dt('select.shadow'), ";\n}\n\n.p-select:not(.p-disabled):hover {\n    border-color: ").concat(dt('select.hover.border.color'), ";\n}\n\n.p-select:not(.p-disabled).p-focus {\n    border-color: ").concat(dt('select.focus.border.color'), ";\n    box-shadow: ").concat(dt('select.focus.ring.shadow'), ";\n    outline: ").concat(dt('select.focus.ring.width'), " ").concat(dt('select.focus.ring.style'), " ").concat(dt('select.focus.ring.color'), ";\n    outline-offset: ").concat(dt('select.focus.ring.offset'), ";\n}\n\n.p-select.p-variant-filled {\n    background: ").concat(dt('select.filled.background'), ";\n}\n\n.p-select.p-variant-filled:not(.p-disabled):hover {\n    background: ").concat(dt('select.filled.hover.background'), ";\n}\n\n.p-select.p-variant-filled:not(.p-disabled).p-focus {\n    background: ").concat(dt('select.filled.focus.background'), ";\n}\n\n.p-select.p-invalid {\n    border-color: ").concat(dt('select.invalid.border.color'), ";\n}\n\n.p-select.p-disabled {\n    opacity: 1;\n    background: ").concat(dt('select.disabled.background'), ";\n}\n\n.p-select-clear-icon {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n    color: ").concat(dt('select.clear.icon.color'), ";\n    inset-inline-end: ").concat(dt('select.dropdown.width'), ";\n}\n\n.p-select-dropdown {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    flex-shrink: 0;\n    background: transparent;\n    color: ").concat(dt('select.dropdown.color'), ";\n    width: ").concat(dt('select.dropdown.width'), ";\n    border-start-end-radius: ").concat(dt('select.border.radius'), ";\n    border-end-end-radius: ").concat(dt('select.border.radius'), ";\n}\n\n.p-select-label {\n    display: block;\n    white-space: nowrap;\n    overflow: hidden;\n    flex: 1 1 auto;\n    width: 1%;\n    padding: ").concat(dt('select.padding.y'), " ").concat(dt('select.padding.x'), ";\n    text-overflow: ellipsis;\n    cursor: pointer;\n    color: ").concat(dt('select.color'), ";\n    background: transparent;\n    border: 0 none;\n    outline: 0 none;\n}\n\n.p-select-label.p-placeholder {\n    color: ").concat(dt('select.placeholder.color'), ";\n}\n\n.p-select.p-invalid .p-select-label.p-placeholder {\n    color: ").concat(dt('select.invalid.placeholder.color'), ";\n}\n\n.p-select:has(.p-select-clear-icon) .p-select-label {\n    padding-inline-end: calc(1rem + ").concat(dt('select.padding.x'), ");\n}\n\n.p-select.p-disabled .p-select-label {\n    color: ").concat(dt('select.disabled.color'), ";\n}\n\n.p-select-label-empty {\n    overflow: hidden;\n    opacity: 0;\n}\n\ninput.p-select-label {\n    cursor: default;\n}\n\n.p-select .p-select-overlay {\n    min-width: 100%;\n}\n\n.p-select-overlay {\n    position: absolute;\n    top: 0;\n    left: 0;\n    background: ").concat(dt('select.overlay.background'), ";\n    color: ").concat(dt('select.overlay.color'), ";\n    border: 1px solid ").concat(dt('select.overlay.border.color'), ";\n    border-radius: ").concat(dt('select.overlay.border.radius'), ";\n    box-shadow: ").concat(dt('select.overlay.shadow'), ";\n}\n\n.p-select-header {\n    padding: ").concat(dt('select.list.header.padding'), ";\n}\n\n.p-select-filter {\n    width: 100%;\n}\n\n.p-select-list-container {\n    overflow: auto;\n}\n\n.p-select-option-group {\n    cursor: auto;\n    margin: 0;\n    padding: ").concat(dt('select.option.group.padding'), ";\n    background: ").concat(dt('select.option.group.background'), ";\n    color: ").concat(dt('select.option.group.color'), ";\n    font-weight: ").concat(dt('select.option.group.font.weight'), ";\n}\n\n.p-select-list {\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n    padding: ").concat(dt('select.list.padding'), ";\n    gap: ").concat(dt('select.list.gap'), ";\n    display: flex;\n    flex-direction: column;\n}\n\n.p-select-option {\n    cursor: pointer;\n    font-weight: normal;\n    white-space: nowrap;\n    position: relative;\n    overflow: hidden;\n    display: flex;\n    align-items: center;\n    padding: ").concat(dt('select.option.padding'), ";\n    border: 0 none;\n    color: ").concat(dt('select.option.color'), ";\n    background: transparent;\n    transition: background ").concat(dt('select.transition.duration'), ", color ").concat(dt('select.transition.duration'), ", border-color ").concat(dt('select.transition.duration'), ",\n            box-shadow ").concat(dt('select.transition.duration'), ", outline-color ").concat(dt('select.transition.duration'), ";\n    border-radius: ").concat(dt('select.option.border.radius'), ";\n}\n\n.p-select-option:not(.p-select-option-selected):not(.p-disabled).p-focus {\n    background: ").concat(dt('select.option.focus.background'), ";\n    color: ").concat(dt('select.option.focus.color'), ";\n}\n\n.p-select-option.p-select-option-selected {\n    background: ").concat(dt('select.option.selected.background'), ";\n    color: ").concat(dt('select.option.selected.color'), ";\n}\n\n.p-select-option.p-select-option-selected.p-focus {\n    background: ").concat(dt('select.option.selected.focus.background'), ";\n    color: ").concat(dt('select.option.selected.focus.color'), ";\n}\n\n.p-select-option-check-icon {\n    position: relative;\n    margin-inline-start: ").concat(dt('select.checkmark.gutter.start'), ";\n    margin-inline-end: ").concat(dt('select.checkmark.gutter.end'), ";\n    color: ").concat(dt('select.checkmark.color'), ";\n}\n\n.p-select-empty-message {\n    padding: ").concat(dt('select.empty.message.padding'), ";\n}\n\n.p-select-fluid {\n    display: flex;\n    width: 100%;\n}\n\n.p-select-sm .p-select-label {\n    font-size: ").concat(dt('select.sm.font.size'), ";\n    padding-block: ").concat(dt('select.sm.padding.y'), ";\n    padding-inline: ").concat(dt('select.sm.padding.x'), ";\n}\n\n.p-select-sm .p-select-dropdown .p-icon {\n    font-size: ").concat(dt('select.sm.font.size'), ";\n    width: ").concat(dt('select.sm.font.size'), ";\n    height: ").concat(dt('select.sm.font.size'), ";\n}\n\n.p-select-lg .p-select-label {\n    font-size: ").concat(dt('select.lg.font.size'), ";\n    padding-block: ").concat(dt('select.lg.padding.y'), ";\n    padding-inline: ").concat(dt('select.lg.padding.x'), ";\n}\n\n.p-select-lg .p-select-dropdown .p-icon {\n    font-size: ").concat(dt('select.lg.font.size'), ";\n    width: ").concat(dt('select.lg.font.size'), ";\n    height: ").concat(dt('select.lg.font.size'), ";\n}\n");
};
var classes = {
  root: function root(_ref2) {
    var instance = _ref2.instance,
      props = _ref2.props,
      state = _ref2.state;
    return ['p-select p-component p-inputwrapper', {
      'p-disabled': props.disabled,
      'p-invalid': instance.$invalid,
      'p-variant-filled': instance.$variant === 'filled',
      'p-focus': state.focused,
      'p-inputwrapper-filled': instance.$filled,
      'p-inputwrapper-focus': state.focused || state.overlayVisible,
      'p-select-open': state.overlayVisible,
      'p-select-fluid': instance.$fluid,
      'p-select-sm p-inputfield-sm': props.size === 'small',
      'p-select-lg p-inputfield-lg': props.size === 'large'
    }];
  },
  label: function label(_ref3) {
    var instance = _ref3.instance,
      props = _ref3.props;
    return ['p-select-label', {
      'p-placeholder': !props.editable && instance.label === props.placeholder,
      'p-select-label-empty': !props.editable && !instance.$slots['value'] && (instance.label === 'p-emptylabel' || instance.label.length === 0)
    }];
  },
  clearIcon: 'p-select-clear-icon',
  dropdown: 'p-select-dropdown',
  loadingicon: 'p-select-loading-icon',
  dropdownIcon: 'p-select-dropdown-icon',
  overlay: 'p-select-overlay p-component',
  header: 'p-select-header',
  pcFilter: 'p-select-filter',
  listContainer: 'p-select-list-container',
  list: 'p-select-list',
  optionGroup: 'p-select-option-group',
  optionGroupLabel: 'p-select-option-group-label',
  option: function option(_ref4) {
    var instance = _ref4.instance,
      props = _ref4.props,
      state = _ref4.state,
      _option = _ref4.option,
      focusedOption = _ref4.focusedOption;
    return ['p-select-option', {
      'p-select-option-selected': instance.isSelected(_option) && props.highlightOnSelect,
      'p-focus': state.focusedOptionIndex === focusedOption,
      'p-disabled': instance.isOptionDisabled(_option)
    }];
  },
  optionLabel: 'p-select-option-label',
  optionCheckIcon: 'p-select-option-check-icon',
  optionBlankIcon: 'p-select-option-blank-icon',
  emptyMessage: 'p-select-empty-message'
};
var SelectStyle = BaseStyle.extend({
  name: 'select',
  theme: theme,
  classes: classes
});

export { SelectStyle as default };
//# sourceMappingURL=index.mjs.map
