import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-imagecompare {\n    position: relative;\n    overflow: hidden;\n    width: 100%;\n    aspect-ratio: 16 / 9;\n}\n\n.p-imagecompare img {\n    width: 100%;\n    height: 100%;\n    position: absolute;\n}\n\n.p-imagecompare img + img {\n    clip-path: polygon(0 0, ".concat(dt('imagecompare.scope.x', '50%'), " 0, ").concat(dt('imagecompare.scope.x', '50%'), " 100%, 0 100%);\n}\n\n.p-imagecompare:dir(rtl) img + img {\n    clip-path: polygon(calc(100% - ").concat(dt('imagecompare.scope.x', '50%'), ") 0, 100% 0, 100% 100%, calc(100% - ").concat(dt('imagecompare.scope.x', '50%'), ") 100%);\n}\n\n.p-imagecompare-slider {\n    position: relative;\n    -webkit-appearance: none;\n    width: calc(100% + ").concat(dt('imagecompare.handle.size'), ");\n    height: 100%;\n    margin-inline-start: calc(-1 * calc(").concat(dt('imagecompare.handle.size'), " / 2));\n    background-color: transparent;\n    outline: none;\n    transition: all ").concat(dt('imagecompare.handle.transition.duration'), ";\n}\n\n.p-imagecompare-slider::-webkit-slider-thumb {\n    -webkit-appearance: none;\n    height: ").concat(dt('imagecompare.handle.size'), ";\n    width: ").concat(dt('imagecompare.handle.size'), ";\n    background: ").concat(dt('imagecompare.handle.background'), ";\n    border: ").concat(dt('imagecompare.handle.border.width'), " solid ").concat(dt('imagecompare.handle.border.color'), ";\n    border-radius: ").concat(dt('imagecompare.handle.border.radius'), ";\n    background-size: contain;\n    cursor: ew-resize;\n    transition: all ").concat(dt('imagecompare.handle.transition.duration'), ";\n}\n\n.p-imagecompare-slider::-moz-range-thumb {\n    height: ").concat(dt('imagecompare.handle.size'), ";\n    width: ").concat(dt('imagecompare.handle.size'), ";\n    background: ").concat(dt('imagecompare.handle.background'), ";\n    border: ").concat(dt('imagecompare.handle.border.width'), " ").concat(dt('imagecompare.handle.border.style'), " ").concat(dt('imagecompare.handle.border.color'), ";\n    border-radius: ").concat(dt('imagecompare.handle.border.radius'), ";\n    background-size: contain;\n    cursor: ew-resize;\n}\n\n.p-imagecompare-slider:focus-visible::-webkit-slider-thumb {\n    box-shadow: ").concat(dt('imagecompare.handle.focus.ring.shadow'), ";\n    outline: ").concat(dt('imagecompare.handle.focus.ring.width'), " ").concat(dt('imagecompare.handle.focus.ring.style'), " ").concat(dt('imagecompare.handle.focus.ring.color'), ";\n    outline-offset: ").concat(dt('imagecompare.handle.focus.ring.offset'), ";\n}\n\n.p-imagecompare-slider:focus-visible::-moz-range-thumb {\n    box-shadow: ").concat(dt('imagecompare.handle.focus.ring.shadow'), ";\n    outline: ").concat(dt('imagecompare.handle.focus.ring.width'), " ").concat(dt('imagecompare.handle.focus.ring.style'), " ").concat(dt('imagecompare.handle.focus.ring.color'), ";\n    outline-offset: ").concat(dt('imagecompare.handle.focus.ring.offset'), ";\n}\n\n.p-imagecompare-slider:hover {\n    width: calc(100% + ").concat(dt('imagecompare.handle.hover.size'), ");\n    margin-inline-start: calc(-1 * calc(").concat(dt('imagecompare.handle.hover.size'), " / 2));\n}\n\n.p-imagecompare-slider:hover::-webkit-slider-thumb {\n    background: ").concat(dt('imagecompare.handle.hover.background'), ";\n    border-color: ").concat(dt('imagecompare.handle.hover.border.color'), ";\n    height: ").concat(dt('imagecompare.handle.hover.size'), ";\n    width: ").concat(dt('imagecompare.handle.hover.size'), ";\n}\n\n.p-imagecompare-slider:hover::-moz-range-thumb {\n    background: ").concat(dt('imagecompare.handle.hover.background'), ";\n    border-color: ").concat(dt('imagecompare.handle.hover.border.color'), ";\n    height: ").concat(dt('imagecompare.handle.hover.size'), ";\n    width: ").concat(dt('imagecompare.handle.hover.size'), ";\n}\n");
};
var classes = {
  root: 'p-imagecompare',
  slider: 'p-imagecompare-slider'
};
var ImageCompareStyle = BaseStyle.extend({
  name: 'imagecompare',
  theme: theme,
  classes: classes
});

export { ImageCompareStyle as default };
//# sourceMappingURL=index.mjs.map
