# distutils: language=c++
# cython: language_level=3

'''Export enum values and constants from HiGHS.'''

from .HConst cimport (
    HIGHS_CONST_I_INF,
    HIGHS_CONST_INF,

    HighsDebugLevel_kHighsDebugLevelNone,
    HighsDebugLevel_kHighsDebugLevelCheap,

    HighsModelStatusNOTSET,
    HighsModelStatusLOAD_ERROR,
    HighsModelStatusMODEL_ERROR,
    HighsModelStatusMODEL_EMPTY,
    HighsModelStatusPRESOLVE_ERROR,
    HighsModelStatusSOLVE_ERROR,
    HighsModelStatusPOSTSOLVE_ERROR,
    HighsModelStatusINFEASIBLE,
    HighsModelStatus_UNBOUNDED_OR_INFEASIBLE,
    HighsModelStatusUNBOUNDED,
    HighsModelStatusOPTIMAL,
    HighsModelStatusREACHED_DUAL_OBJECTIVE_VALUE_UPPER_BOUND,
    HighsModelStatusREACHED_OBJECTIVE_TARGET,
    HighsModelStatusREACHED_TIME_LIMIT,
    HighsModelStatusREACHED_ITERATION_LIMIT,

    ObjSenseMINIMIZE,
    kContinuous,
    kInteger,
    kSemiContinuous,
    kSemiInteger,
    kImplicitInteger,
)
from .HighsIO cimport (
    kInfo,
    kDetailed,
    kVerbose,
    kWarning,
    kError,
)
from .SimplexConst cimport (
    # Simplex strategy
    SIMPLEX_STRATEGY_CHOOSE,
    SIMPLEX_STRATEGY_DUAL,
    SIMPLEX_STRATEGY_PRIMAL,

    # Crash strategy
    SIMPLEX_CRASH_STRATEGY_OFF,
    SIMPLEX_CRASH_STRATEGY_BIXBY,
    SIMPLEX_CRASH_STRATEGY_LTSF,

    # Edge weight strategy
    SIMPLEX_EDGE_WEIGHT_STRATEGY_CHOOSE,
    SIMPLEX_EDGE_WEIGHT_STRATEGY_DANTZIG,
    SIMPLEX_EDGE_WEIGHT_STRATEGY_DEVEX,
    SIMPLEX_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE,
    SIMPLEX_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE_UNIT_INITIAL,
)

# HConst
CONST_I_INF = HIGHS_CONST_I_INF
CONST_INF = HIGHS_CONST_INF

# Debug level
MESSAGE_LEVEL_NONE = HighsDebugLevel_kHighsDebugLevelNone
MESSAGE_LEVEL_MINIMAL = HighsDebugLevel_kHighsDebugLevelCheap

# HighsIO
LOG_TYPE_INFO = <int> kInfo
LOG_TYPE_DETAILED = <int> kDetailed
LOG_TYPE_VERBOSE = <int> kVerbose
LOG_TYPE_WARNING = <int> kWarning
LOG_TYPE_ERROR = <int> kError

# HighsLp
MODEL_STATUS_NOTSET = <int> HighsModelStatusNOTSET
MODEL_STATUS_LOAD_ERROR = <int> HighsModelStatusLOAD_ERROR
MODEL_STATUS_MODEL_ERROR = <int> HighsModelStatusMODEL_ERROR
MODEL_STATUS_PRESOLVE_ERROR = <int> HighsModelStatusPRESOLVE_ERROR
MODEL_STATUS_SOLVE_ERROR = <int> HighsModelStatusSOLVE_ERROR
MODEL_STATUS_POSTSOLVE_ERROR = <int> HighsModelStatusPOSTSOLVE_ERROR
MODEL_STATUS_MODEL_EMPTY = <int> HighsModelStatusMODEL_EMPTY
MODEL_STATUS_INFEASIBLE = <int> HighsModelStatusINFEASIBLE
MODEL_STATUS_UNBOUNDED_OR_INFEASIBLE = <int> HighsModelStatus_UNBOUNDED_OR_INFEASIBLE
MODEL_STATUS_UNBOUNDED = <int> HighsModelStatusUNBOUNDED
MODEL_STATUS_OPTIMAL = <int> HighsModelStatusOPTIMAL
MODEL_STATUS_REACHED_DUAL_OBJECTIVE_VALUE_UPPER_BOUND = <int> HighsModelStatusREACHED_DUAL_OBJECTIVE_VALUE_UPPER_BOUND
MODEL_STATUS_REACHED_OBJECTIVE_TARGET = <int> HighsModelStatusREACHED_OBJECTIVE_TARGET
MODEL_STATUS_REACHED_TIME_LIMIT = <int> HighsModelStatusREACHED_TIME_LIMIT
MODEL_STATUS_REACHED_ITERATION_LIMIT = <int> HighsModelStatusREACHED_ITERATION_LIMIT

# Simplex strategy
HIGHS_SIMPLEX_STRATEGY_CHOOSE = <int> SIMPLEX_STRATEGY_CHOOSE
HIGHS_SIMPLEX_STRATEGY_DUAL = <int> SIMPLEX_STRATEGY_DUAL
HIGHS_SIMPLEX_STRATEGY_PRIMAL = <int> SIMPLEX_STRATEGY_PRIMAL

# Crash strategy
HIGHS_SIMPLEX_CRASH_STRATEGY_OFF = <int> SIMPLEX_CRASH_STRATEGY_OFF
HIGHS_SIMPLEX_CRASH_STRATEGY_BIXBY = <int> SIMPLEX_CRASH_STRATEGY_BIXBY
HIGHS_SIMPLEX_CRASH_STRATEGY_LTSF = <int> SIMPLEX_CRASH_STRATEGY_LTSF

# Edge weight strategy
HIGHS_SIMPLEX_EDGE_WEIGHT_STRATEGY_CHOOSE = <int> SIMPLEX_EDGE_WEIGHT_STRATEGY_CHOOSE
HIGHS_SIMPLEX_EDGE_WEIGHT_STRATEGY_DANTZIG = <int> SIMPLEX_EDGE_WEIGHT_STRATEGY_DANTZIG
HIGHS_SIMPLEX_EDGE_WEIGHT_STRATEGY_DEVEX = <int> SIMPLEX_EDGE_WEIGHT_STRATEGY_DEVEX
HIGHS_SIMPLEX_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE = <int> SIMPLEX_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE
# HIGHS_SIMPLEX_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE_UNIT_INITIAL = <int> SIMPLEX_EDGE_WEIGHT_STRATEGY_STEEPEST_EDGE_UNIT_INITIAL

# Objective sense
HIGHS_OBJECTIVE_SENSE_MINIMIZE = <int> ObjSenseMINIMIZE

# Variable types
HIGHS_VAR_TYPE_CONTINUOUS = <int> kContinuous
HIGHS_VAR_TYPE_INTEGER = <int> kInteger
HIGHS_VAR_TYPE_SEMI_CONTINUOUS = <int> kSemiContinuous
HIGHS_VAR_TYPE_SEMI_INTEGER = <int> kSemiInteger
HIGHS_VAR_TYPE_IMPLICIT_INTEGER = <int> kImplicitInteger
