//! File automatically generated by examples/generate_check_code_prefix.rs.

use serde::{Deserialize, Serialize};
use strum_macros::EnumString;

use crate::checks::CheckCode;

#[derive(EnumString, Debug, PartialEq, Eq, PartialOrd, Ord, Clone, Serialize, Deserialize)]
pub enum CheckCodePrefix {
    A,
    A0,
    A00,
    A001,
    A002,
    A003,
    ANN,
    ANN0,
    ANN00,
    ANN001,
    ANN002,
    ANN003,
    ANN1,
    ANN10,
    ANN101,
    ANN102,
    ANN2,
    ANN20,
    ANN201,
    ANN202,
    ANN204,
    ANN205,
    ANN206,
    B,
    B0,
    B00,
    B002,
    B003,
    B004,
    B005,
    B006,
    B007,
    B008,
    B01,
    B011,
    B013,
    B014,
    B015,
    B016,
    B017,
    B018,
    B02,
    B025,
    C,
    C4,
    C40,
    C400,
    C401,
    C402,
    C403,
    C404,
    C405,
    C406,
    C408,
    C409,
    C41,
    C410,
    C411,
    C413,
    C414,
    C415,
    C416,
    C417,
    D,
    D1,
    D10,
    D100,
    D101,
    D102,
    D103,
    D104,
    D105,
    D106,
    D107,
    D2,
    D20,
    D200,
    D201,
    D202,
    D203,
    D204,
    D205,
    D206,
    D207,
    D208,
    D209,
    D21,
    D210,
    D211,
    D212,
    D213,
    D214,
    D215,
    D3,
    D30,
    D300,
    D4,
    D40,
    D400,
    D402,
    D403,
    D404,
    D405,
    D406,
    D407,
    D408,
    D409,
    D41,
    D410,
    D411,
    D412,
    D413,
    D414,
    D415,
    D416,
    D417,
    D418,
    D419,
    E,
    E4,
    E40,
    E402,
    E5,
    E50,
    E501,
    E7,
    E71,
    E711,
    E712,
    E713,
    E714,
    E72,
    E721,
    E722,
    E73,
    E731,
    E74,
    E741,
    E742,
    E743,
    E9,
    E90,
    E902,
    E99,
    E999,
    F,
    F4,
    F40,
    F401,
    F402,
    F403,
    F404,
    F405,
    F406,
    F407,
    F5,
    F54,
    F541,
    F6,
    F60,
    F601,
    F602,
    F62,
    F621,
    F622,
    F63,
    F631,
    F632,
    F633,
    F634,
    F7,
    F70,
    F701,
    F702,
    F704,
    F706,
    F707,
    F72,
    F722,
    F8,
    F82,
    F821,
    F822,
    F823,
    F83,
    F831,
    F84,
    F841,
    F9,
    F90,
    F901,
    M,
    M0,
    M00,
    M001,
    N,
    N8,
    N80,
    N801,
    N802,
    N803,
    N804,
    N805,
    N806,
    N807,
    N81,
    N811,
    N812,
    N813,
    N814,
    N815,
    N816,
    N817,
    N818,
    Q,
    Q0,
    Q00,
    Q000,
    Q001,
    Q002,
    Q003,
    RUF,
    RUF0,
    RUF00,
    RUF001,
    RUF002,
    T,
    T2,
    T20,
    T201,
    T203,
    U,
    U0,
    U00,
    U001,
    U002,
    U003,
    U004,
    U005,
    U006,
    U007,
    U008,
    U009,
    W,
    W2,
    W29,
    W292,
    W6,
    W60,
    W605,
}

#[derive(PartialEq, Eq, PartialOrd, Ord)]
pub enum PrefixSpecificity {
    Category,
    Hundreds,
    Tens,
    Explicit,
}

impl CheckCodePrefix {
    pub fn codes(&self) -> Vec<CheckCode> {
        match self {
            CheckCodePrefix::A => vec![CheckCode::A001, CheckCode::A002, CheckCode::A003],
            CheckCodePrefix::A0 => vec![CheckCode::A001, CheckCode::A002, CheckCode::A003],
            CheckCodePrefix::A00 => vec![CheckCode::A001, CheckCode::A002, CheckCode::A003],
            CheckCodePrefix::A001 => vec![CheckCode::A001],
            CheckCodePrefix::A002 => vec![CheckCode::A002],
            CheckCodePrefix::A003 => vec![CheckCode::A003],
            CheckCodePrefix::ANN => vec![
                CheckCode::ANN001,
                CheckCode::ANN002,
                CheckCode::ANN003,
                CheckCode::ANN101,
                CheckCode::ANN102,
                CheckCode::ANN201,
                CheckCode::ANN202,
                CheckCode::ANN204,
                CheckCode::ANN205,
                CheckCode::ANN206,
            ],
            CheckCodePrefix::ANN0 => vec![CheckCode::ANN001, CheckCode::ANN002, CheckCode::ANN003],
            CheckCodePrefix::ANN00 => vec![CheckCode::ANN001, CheckCode::ANN002, CheckCode::ANN003],
            CheckCodePrefix::ANN001 => vec![CheckCode::ANN001],
            CheckCodePrefix::ANN002 => vec![CheckCode::ANN002],
            CheckCodePrefix::ANN003 => vec![CheckCode::ANN003],
            CheckCodePrefix::ANN1 => vec![CheckCode::ANN101, CheckCode::ANN102],
            CheckCodePrefix::ANN10 => vec![CheckCode::ANN101, CheckCode::ANN102],
            CheckCodePrefix::ANN101 => vec![CheckCode::ANN101],
            CheckCodePrefix::ANN102 => vec![CheckCode::ANN102],
            CheckCodePrefix::ANN2 => vec![
                CheckCode::ANN201,
                CheckCode::ANN202,
                CheckCode::ANN204,
                CheckCode::ANN205,
                CheckCode::ANN206,
            ],
            CheckCodePrefix::ANN20 => vec![
                CheckCode::ANN201,
                CheckCode::ANN202,
                CheckCode::ANN204,
                CheckCode::ANN205,
                CheckCode::ANN206,
            ],
            CheckCodePrefix::ANN201 => vec![CheckCode::ANN201],
            CheckCodePrefix::ANN202 => vec![CheckCode::ANN202],
            CheckCodePrefix::ANN204 => vec![CheckCode::ANN204],
            CheckCodePrefix::ANN205 => vec![CheckCode::ANN205],
            CheckCodePrefix::ANN206 => vec![CheckCode::ANN206],
            CheckCodePrefix::B => vec![
                CheckCode::B002,
                CheckCode::B003,
                CheckCode::B004,
                CheckCode::B005,
                CheckCode::B006,
                CheckCode::B007,
                CheckCode::B008,
                CheckCode::B011,
                CheckCode::B013,
                CheckCode::B014,
                CheckCode::B015,
                CheckCode::B016,
                CheckCode::B017,
                CheckCode::B018,
                CheckCode::B025,
            ],
            CheckCodePrefix::B0 => vec![
                CheckCode::B002,
                CheckCode::B003,
                CheckCode::B004,
                CheckCode::B005,
                CheckCode::B006,
                CheckCode::B007,
                CheckCode::B008,
                CheckCode::B011,
                CheckCode::B013,
                CheckCode::B014,
                CheckCode::B015,
                CheckCode::B016,
                CheckCode::B017,
                CheckCode::B018,
                CheckCode::B025,
            ],
            CheckCodePrefix::B00 => vec![
                CheckCode::B002,
                CheckCode::B003,
                CheckCode::B004,
                CheckCode::B005,
                CheckCode::B006,
                CheckCode::B007,
                CheckCode::B008,
            ],
            CheckCodePrefix::B002 => vec![CheckCode::B002],
            CheckCodePrefix::B003 => vec![CheckCode::B003],
            CheckCodePrefix::B004 => vec![CheckCode::B004],
            CheckCodePrefix::B005 => vec![CheckCode::B005],
            CheckCodePrefix::B006 => vec![CheckCode::B006],
            CheckCodePrefix::B007 => vec![CheckCode::B007],
            CheckCodePrefix::B008 => vec![CheckCode::B008],
            CheckCodePrefix::B01 => vec![
                CheckCode::B011,
                CheckCode::B013,
                CheckCode::B014,
                CheckCode::B015,
                CheckCode::B016,
                CheckCode::B017,
                CheckCode::B018,
            ],
            CheckCodePrefix::B011 => vec![CheckCode::B011],
            CheckCodePrefix::B013 => vec![CheckCode::B013],
            CheckCodePrefix::B014 => vec![CheckCode::B014],
            CheckCodePrefix::B015 => vec![CheckCode::B015],
            CheckCodePrefix::B016 => vec![CheckCode::B016],
            CheckCodePrefix::B017 => vec![CheckCode::B017],
            CheckCodePrefix::B018 => vec![CheckCode::B018],
            CheckCodePrefix::B02 => vec![CheckCode::B025],
            CheckCodePrefix::B025 => vec![CheckCode::B025],
            CheckCodePrefix::C => vec![
                CheckCode::C400,
                CheckCode::C401,
                CheckCode::C402,
                CheckCode::C403,
                CheckCode::C404,
                CheckCode::C405,
                CheckCode::C406,
                CheckCode::C408,
                CheckCode::C409,
                CheckCode::C410,
                CheckCode::C411,
                CheckCode::C413,
                CheckCode::C414,
                CheckCode::C415,
                CheckCode::C416,
                CheckCode::C417,
            ],
            CheckCodePrefix::C4 => vec![
                CheckCode::C400,
                CheckCode::C401,
                CheckCode::C402,
                CheckCode::C403,
                CheckCode::C404,
                CheckCode::C405,
                CheckCode::C406,
                CheckCode::C408,
                CheckCode::C409,
                CheckCode::C410,
                CheckCode::C411,
                CheckCode::C413,
                CheckCode::C414,
                CheckCode::C415,
                CheckCode::C416,
                CheckCode::C417,
            ],
            CheckCodePrefix::C40 => vec![
                CheckCode::C400,
                CheckCode::C401,
                CheckCode::C402,
                CheckCode::C403,
                CheckCode::C404,
                CheckCode::C405,
                CheckCode::C406,
                CheckCode::C408,
                CheckCode::C409,
            ],
            CheckCodePrefix::C400 => vec![CheckCode::C400],
            CheckCodePrefix::C401 => vec![CheckCode::C401],
            CheckCodePrefix::C402 => vec![CheckCode::C402],
            CheckCodePrefix::C403 => vec![CheckCode::C403],
            CheckCodePrefix::C404 => vec![CheckCode::C404],
            CheckCodePrefix::C405 => vec![CheckCode::C405],
            CheckCodePrefix::C406 => vec![CheckCode::C406],
            CheckCodePrefix::C408 => vec![CheckCode::C408],
            CheckCodePrefix::C409 => vec![CheckCode::C409],
            CheckCodePrefix::C41 => vec![
                CheckCode::C410,
                CheckCode::C411,
                CheckCode::C413,
                CheckCode::C414,
                CheckCode::C415,
                CheckCode::C416,
                CheckCode::C417,
            ],
            CheckCodePrefix::C410 => vec![CheckCode::C410],
            CheckCodePrefix::C411 => vec![CheckCode::C411],
            CheckCodePrefix::C413 => vec![CheckCode::C413],
            CheckCodePrefix::C414 => vec![CheckCode::C414],
            CheckCodePrefix::C415 => vec![CheckCode::C415],
            CheckCodePrefix::C416 => vec![CheckCode::C416],
            CheckCodePrefix::C417 => vec![CheckCode::C417],
            CheckCodePrefix::D => vec![
                CheckCode::D100,
                CheckCode::D101,
                CheckCode::D102,
                CheckCode::D103,
                CheckCode::D104,
                CheckCode::D105,
                CheckCode::D106,
                CheckCode::D107,
                CheckCode::D200,
                CheckCode::D201,
                CheckCode::D202,
                CheckCode::D203,
                CheckCode::D204,
                CheckCode::D205,
                CheckCode::D206,
                CheckCode::D207,
                CheckCode::D208,
                CheckCode::D209,
                CheckCode::D210,
                CheckCode::D211,
                CheckCode::D212,
                CheckCode::D213,
                CheckCode::D214,
                CheckCode::D215,
                CheckCode::D300,
                CheckCode::D400,
                CheckCode::D402,
                CheckCode::D403,
                CheckCode::D404,
                CheckCode::D405,
                CheckCode::D406,
                CheckCode::D407,
                CheckCode::D408,
                CheckCode::D409,
                CheckCode::D410,
                CheckCode::D411,
                CheckCode::D412,
                CheckCode::D413,
                CheckCode::D414,
                CheckCode::D415,
                CheckCode::D416,
                CheckCode::D417,
                CheckCode::D418,
                CheckCode::D419,
            ],
            CheckCodePrefix::D1 => vec![
                CheckCode::D100,
                CheckCode::D101,
                CheckCode::D102,
                CheckCode::D103,
                CheckCode::D104,
                CheckCode::D105,
                CheckCode::D106,
                CheckCode::D107,
            ],
            CheckCodePrefix::D10 => vec![
                CheckCode::D100,
                CheckCode::D101,
                CheckCode::D102,
                CheckCode::D103,
                CheckCode::D104,
                CheckCode::D105,
                CheckCode::D106,
                CheckCode::D107,
            ],
            CheckCodePrefix::D100 => vec![CheckCode::D100],
            CheckCodePrefix::D101 => vec![CheckCode::D101],
            CheckCodePrefix::D102 => vec![CheckCode::D102],
            CheckCodePrefix::D103 => vec![CheckCode::D103],
            CheckCodePrefix::D104 => vec![CheckCode::D104],
            CheckCodePrefix::D105 => vec![CheckCode::D105],
            CheckCodePrefix::D106 => vec![CheckCode::D106],
            CheckCodePrefix::D107 => vec![CheckCode::D107],
            CheckCodePrefix::D2 => vec![
                CheckCode::D200,
                CheckCode::D201,
                CheckCode::D202,
                CheckCode::D203,
                CheckCode::D204,
                CheckCode::D205,
                CheckCode::D206,
                CheckCode::D207,
                CheckCode::D208,
                CheckCode::D209,
                CheckCode::D210,
                CheckCode::D211,
                CheckCode::D212,
                CheckCode::D213,
                CheckCode::D214,
                CheckCode::D215,
            ],
            CheckCodePrefix::D20 => vec![
                CheckCode::D200,
                CheckCode::D201,
                CheckCode::D202,
                CheckCode::D203,
                CheckCode::D204,
                CheckCode::D205,
                CheckCode::D206,
                CheckCode::D207,
                CheckCode::D208,
                CheckCode::D209,
            ],
            CheckCodePrefix::D200 => vec![CheckCode::D200],
            CheckCodePrefix::D201 => vec![CheckCode::D201],
            CheckCodePrefix::D202 => vec![CheckCode::D202],
            CheckCodePrefix::D203 => vec![CheckCode::D203],
            CheckCodePrefix::D204 => vec![CheckCode::D204],
            CheckCodePrefix::D205 => vec![CheckCode::D205],
            CheckCodePrefix::D206 => vec![CheckCode::D206],
            CheckCodePrefix::D207 => vec![CheckCode::D207],
            CheckCodePrefix::D208 => vec![CheckCode::D208],
            CheckCodePrefix::D209 => vec![CheckCode::D209],
            CheckCodePrefix::D21 => vec![
                CheckCode::D210,
                CheckCode::D211,
                CheckCode::D212,
                CheckCode::D213,
                CheckCode::D214,
                CheckCode::D215,
            ],
            CheckCodePrefix::D210 => vec![CheckCode::D210],
            CheckCodePrefix::D211 => vec![CheckCode::D211],
            CheckCodePrefix::D212 => vec![CheckCode::D212],
            CheckCodePrefix::D213 => vec![CheckCode::D213],
            CheckCodePrefix::D214 => vec![CheckCode::D214],
            CheckCodePrefix::D215 => vec![CheckCode::D215],
            CheckCodePrefix::D3 => vec![CheckCode::D300],
            CheckCodePrefix::D30 => vec![CheckCode::D300],
            CheckCodePrefix::D300 => vec![CheckCode::D300],
            CheckCodePrefix::D4 => vec![
                CheckCode::D400,
                CheckCode::D402,
                CheckCode::D403,
                CheckCode::D404,
                CheckCode::D405,
                CheckCode::D406,
                CheckCode::D407,
                CheckCode::D408,
                CheckCode::D409,
                CheckCode::D410,
                CheckCode::D411,
                CheckCode::D412,
                CheckCode::D413,
                CheckCode::D414,
                CheckCode::D415,
                CheckCode::D416,
                CheckCode::D417,
                CheckCode::D418,
                CheckCode::D419,
            ],
            CheckCodePrefix::D40 => vec![
                CheckCode::D400,
                CheckCode::D402,
                CheckCode::D403,
                CheckCode::D404,
                CheckCode::D405,
                CheckCode::D406,
                CheckCode::D407,
                CheckCode::D408,
                CheckCode::D409,
            ],
            CheckCodePrefix::D400 => vec![CheckCode::D400],
            CheckCodePrefix::D402 => vec![CheckCode::D402],
            CheckCodePrefix::D403 => vec![CheckCode::D403],
            CheckCodePrefix::D404 => vec![CheckCode::D404],
            CheckCodePrefix::D405 => vec![CheckCode::D405],
            CheckCodePrefix::D406 => vec![CheckCode::D406],
            CheckCodePrefix::D407 => vec![CheckCode::D407],
            CheckCodePrefix::D408 => vec![CheckCode::D408],
            CheckCodePrefix::D409 => vec![CheckCode::D409],
            CheckCodePrefix::D41 => vec![
                CheckCode::D410,
                CheckCode::D411,
                CheckCode::D412,
                CheckCode::D413,
                CheckCode::D414,
                CheckCode::D415,
                CheckCode::D416,
                CheckCode::D417,
                CheckCode::D418,
                CheckCode::D419,
            ],
            CheckCodePrefix::D410 => vec![CheckCode::D410],
            CheckCodePrefix::D411 => vec![CheckCode::D411],
            CheckCodePrefix::D412 => vec![CheckCode::D412],
            CheckCodePrefix::D413 => vec![CheckCode::D413],
            CheckCodePrefix::D414 => vec![CheckCode::D414],
            CheckCodePrefix::D415 => vec![CheckCode::D415],
            CheckCodePrefix::D416 => vec![CheckCode::D416],
            CheckCodePrefix::D417 => vec![CheckCode::D417],
            CheckCodePrefix::D418 => vec![CheckCode::D418],
            CheckCodePrefix::D419 => vec![CheckCode::D419],
            CheckCodePrefix::E => vec![
                CheckCode::E402,
                CheckCode::E501,
                CheckCode::E711,
                CheckCode::E712,
                CheckCode::E713,
                CheckCode::E714,
                CheckCode::E721,
                CheckCode::E722,
                CheckCode::E731,
                CheckCode::E741,
                CheckCode::E742,
                CheckCode::E743,
                CheckCode::E902,
                CheckCode::E999,
            ],
            CheckCodePrefix::E4 => vec![CheckCode::E402],
            CheckCodePrefix::E40 => vec![CheckCode::E402],
            CheckCodePrefix::E402 => vec![CheckCode::E402],
            CheckCodePrefix::E5 => vec![CheckCode::E501],
            CheckCodePrefix::E50 => vec![CheckCode::E501],
            CheckCodePrefix::E501 => vec![CheckCode::E501],
            CheckCodePrefix::E7 => vec![
                CheckCode::E711,
                CheckCode::E712,
                CheckCode::E713,
                CheckCode::E714,
                CheckCode::E721,
                CheckCode::E722,
                CheckCode::E731,
                CheckCode::E741,
                CheckCode::E742,
                CheckCode::E743,
            ],
            CheckCodePrefix::E71 => vec![
                CheckCode::E711,
                CheckCode::E712,
                CheckCode::E713,
                CheckCode::E714,
            ],
            CheckCodePrefix::E711 => vec![CheckCode::E711],
            CheckCodePrefix::E712 => vec![CheckCode::E712],
            CheckCodePrefix::E713 => vec![CheckCode::E713],
            CheckCodePrefix::E714 => vec![CheckCode::E714],
            CheckCodePrefix::E72 => vec![CheckCode::E721, CheckCode::E722],
            CheckCodePrefix::E721 => vec![CheckCode::E721],
            CheckCodePrefix::E722 => vec![CheckCode::E722],
            CheckCodePrefix::E73 => vec![CheckCode::E731],
            CheckCodePrefix::E731 => vec![CheckCode::E731],
            CheckCodePrefix::E74 => vec![CheckCode::E741, CheckCode::E742, CheckCode::E743],
            CheckCodePrefix::E741 => vec![CheckCode::E741],
            CheckCodePrefix::E742 => vec![CheckCode::E742],
            CheckCodePrefix::E743 => vec![CheckCode::E743],
            CheckCodePrefix::E9 => vec![CheckCode::E902, CheckCode::E999],
            CheckCodePrefix::E90 => vec![CheckCode::E902],
            CheckCodePrefix::E902 => vec![CheckCode::E902],
            CheckCodePrefix::E99 => vec![CheckCode::E999],
            CheckCodePrefix::E999 => vec![CheckCode::E999],
            CheckCodePrefix::F => vec![
                CheckCode::F401,
                CheckCode::F402,
                CheckCode::F403,
                CheckCode::F404,
                CheckCode::F405,
                CheckCode::F406,
                CheckCode::F407,
                CheckCode::F541,
                CheckCode::F601,
                CheckCode::F602,
                CheckCode::F621,
                CheckCode::F622,
                CheckCode::F631,
                CheckCode::F632,
                CheckCode::F633,
                CheckCode::F634,
                CheckCode::F701,
                CheckCode::F702,
                CheckCode::F704,
                CheckCode::F706,
                CheckCode::F707,
                CheckCode::F722,
                CheckCode::F821,
                CheckCode::F822,
                CheckCode::F823,
                CheckCode::F831,
                CheckCode::F841,
                CheckCode::F901,
            ],
            CheckCodePrefix::F4 => vec![
                CheckCode::F401,
                CheckCode::F402,
                CheckCode::F403,
                CheckCode::F404,
                CheckCode::F405,
                CheckCode::F406,
                CheckCode::F407,
            ],
            CheckCodePrefix::F40 => vec![
                CheckCode::F401,
                CheckCode::F402,
                CheckCode::F403,
                CheckCode::F404,
                CheckCode::F405,
                CheckCode::F406,
                CheckCode::F407,
            ],
            CheckCodePrefix::F401 => vec![CheckCode::F401],
            CheckCodePrefix::F402 => vec![CheckCode::F402],
            CheckCodePrefix::F403 => vec![CheckCode::F403],
            CheckCodePrefix::F404 => vec![CheckCode::F404],
            CheckCodePrefix::F405 => vec![CheckCode::F405],
            CheckCodePrefix::F406 => vec![CheckCode::F406],
            CheckCodePrefix::F407 => vec![CheckCode::F407],
            CheckCodePrefix::F5 => vec![CheckCode::F541],
            CheckCodePrefix::F54 => vec![CheckCode::F541],
            CheckCodePrefix::F541 => vec![CheckCode::F541],
            CheckCodePrefix::F6 => vec![
                CheckCode::F601,
                CheckCode::F602,
                CheckCode::F621,
                CheckCode::F622,
                CheckCode::F631,
                CheckCode::F632,
                CheckCode::F633,
                CheckCode::F634,
            ],
            CheckCodePrefix::F60 => vec![CheckCode::F601, CheckCode::F602],
            CheckCodePrefix::F601 => vec![CheckCode::F601],
            CheckCodePrefix::F602 => vec![CheckCode::F602],
            CheckCodePrefix::F62 => vec![CheckCode::F621, CheckCode::F622],
            CheckCodePrefix::F621 => vec![CheckCode::F621],
            CheckCodePrefix::F622 => vec![CheckCode::F622],
            CheckCodePrefix::F63 => vec![
                CheckCode::F631,
                CheckCode::F632,
                CheckCode::F633,
                CheckCode::F634,
            ],
            CheckCodePrefix::F631 => vec![CheckCode::F631],
            CheckCodePrefix::F632 => vec![CheckCode::F632],
            CheckCodePrefix::F633 => vec![CheckCode::F633],
            CheckCodePrefix::F634 => vec![CheckCode::F634],
            CheckCodePrefix::F7 => vec![
                CheckCode::F701,
                CheckCode::F702,
                CheckCode::F704,
                CheckCode::F706,
                CheckCode::F707,
                CheckCode::F722,
            ],
            CheckCodePrefix::F70 => vec![
                CheckCode::F701,
                CheckCode::F702,
                CheckCode::F704,
                CheckCode::F706,
                CheckCode::F707,
            ],
            CheckCodePrefix::F701 => vec![CheckCode::F701],
            CheckCodePrefix::F702 => vec![CheckCode::F702],
            CheckCodePrefix::F704 => vec![CheckCode::F704],
            CheckCodePrefix::F706 => vec![CheckCode::F706],
            CheckCodePrefix::F707 => vec![CheckCode::F707],
            CheckCodePrefix::F72 => vec![CheckCode::F722],
            CheckCodePrefix::F722 => vec![CheckCode::F722],
            CheckCodePrefix::F8 => vec![
                CheckCode::F821,
                CheckCode::F822,
                CheckCode::F823,
                CheckCode::F831,
                CheckCode::F841,
            ],
            CheckCodePrefix::F82 => vec![CheckCode::F821, CheckCode::F822, CheckCode::F823],
            CheckCodePrefix::F821 => vec![CheckCode::F821],
            CheckCodePrefix::F822 => vec![CheckCode::F822],
            CheckCodePrefix::F823 => vec![CheckCode::F823],
            CheckCodePrefix::F83 => vec![CheckCode::F831],
            CheckCodePrefix::F831 => vec![CheckCode::F831],
            CheckCodePrefix::F84 => vec![CheckCode::F841],
            CheckCodePrefix::F841 => vec![CheckCode::F841],
            CheckCodePrefix::F9 => vec![CheckCode::F901],
            CheckCodePrefix::F90 => vec![CheckCode::F901],
            CheckCodePrefix::F901 => vec![CheckCode::F901],
            CheckCodePrefix::M => vec![CheckCode::M001],
            CheckCodePrefix::M0 => vec![CheckCode::M001],
            CheckCodePrefix::M00 => vec![CheckCode::M001],
            CheckCodePrefix::M001 => vec![CheckCode::M001],
            CheckCodePrefix::N => vec![
                CheckCode::N801,
                CheckCode::N802,
                CheckCode::N803,
                CheckCode::N804,
                CheckCode::N805,
                CheckCode::N806,
                CheckCode::N807,
                CheckCode::N811,
                CheckCode::N812,
                CheckCode::N813,
                CheckCode::N814,
                CheckCode::N815,
                CheckCode::N816,
                CheckCode::N817,
                CheckCode::N818,
            ],
            CheckCodePrefix::N8 => vec![
                CheckCode::N801,
                CheckCode::N802,
                CheckCode::N803,
                CheckCode::N804,
                CheckCode::N805,
                CheckCode::N806,
                CheckCode::N807,
                CheckCode::N811,
                CheckCode::N812,
                CheckCode::N813,
                CheckCode::N814,
                CheckCode::N815,
                CheckCode::N816,
                CheckCode::N817,
                CheckCode::N818,
            ],
            CheckCodePrefix::N80 => vec![
                CheckCode::N801,
                CheckCode::N802,
                CheckCode::N803,
                CheckCode::N804,
                CheckCode::N805,
                CheckCode::N806,
                CheckCode::N807,
            ],
            CheckCodePrefix::N801 => vec![CheckCode::N801],
            CheckCodePrefix::N802 => vec![CheckCode::N802],
            CheckCodePrefix::N803 => vec![CheckCode::N803],
            CheckCodePrefix::N804 => vec![CheckCode::N804],
            CheckCodePrefix::N805 => vec![CheckCode::N805],
            CheckCodePrefix::N806 => vec![CheckCode::N806],
            CheckCodePrefix::N807 => vec![CheckCode::N807],
            CheckCodePrefix::N81 => vec![
                CheckCode::N811,
                CheckCode::N812,
                CheckCode::N813,
                CheckCode::N814,
                CheckCode::N815,
                CheckCode::N816,
                CheckCode::N817,
                CheckCode::N818,
            ],
            CheckCodePrefix::N811 => vec![CheckCode::N811],
            CheckCodePrefix::N812 => vec![CheckCode::N812],
            CheckCodePrefix::N813 => vec![CheckCode::N813],
            CheckCodePrefix::N814 => vec![CheckCode::N814],
            CheckCodePrefix::N815 => vec![CheckCode::N815],
            CheckCodePrefix::N816 => vec![CheckCode::N816],
            CheckCodePrefix::N817 => vec![CheckCode::N817],
            CheckCodePrefix::N818 => vec![CheckCode::N818],
            CheckCodePrefix::Q => vec![
                CheckCode::Q000,
                CheckCode::Q001,
                CheckCode::Q002,
                CheckCode::Q003,
            ],
            CheckCodePrefix::Q0 => vec![
                CheckCode::Q000,
                CheckCode::Q001,
                CheckCode::Q002,
                CheckCode::Q003,
            ],
            CheckCodePrefix::Q00 => vec![
                CheckCode::Q000,
                CheckCode::Q001,
                CheckCode::Q002,
                CheckCode::Q003,
            ],
            CheckCodePrefix::Q000 => vec![CheckCode::Q000],
            CheckCodePrefix::Q001 => vec![CheckCode::Q001],
            CheckCodePrefix::Q002 => vec![CheckCode::Q002],
            CheckCodePrefix::Q003 => vec![CheckCode::Q003],
            CheckCodePrefix::RUF => vec![CheckCode::RUF001, CheckCode::RUF002],
            CheckCodePrefix::RUF0 => vec![CheckCode::RUF001, CheckCode::RUF002],
            CheckCodePrefix::RUF00 => vec![CheckCode::RUF001, CheckCode::RUF002],
            CheckCodePrefix::RUF001 => vec![CheckCode::RUF001],
            CheckCodePrefix::RUF002 => vec![CheckCode::RUF002],
            CheckCodePrefix::T => vec![CheckCode::T201, CheckCode::T203],
            CheckCodePrefix::T2 => vec![CheckCode::T201, CheckCode::T203],
            CheckCodePrefix::T20 => vec![CheckCode::T201, CheckCode::T203],
            CheckCodePrefix::T201 => vec![CheckCode::T201],
            CheckCodePrefix::T203 => vec![CheckCode::T203],
            CheckCodePrefix::U => vec![
                CheckCode::U001,
                CheckCode::U002,
                CheckCode::U003,
                CheckCode::U004,
                CheckCode::U005,
                CheckCode::U006,
                CheckCode::U007,
                CheckCode::U008,
                CheckCode::U009,
            ],
            CheckCodePrefix::U0 => vec![
                CheckCode::U001,
                CheckCode::U002,
                CheckCode::U003,
                CheckCode::U004,
                CheckCode::U005,
                CheckCode::U006,
                CheckCode::U007,
                CheckCode::U008,
                CheckCode::U009,
            ],
            CheckCodePrefix::U00 => vec![
                CheckCode::U001,
                CheckCode::U002,
                CheckCode::U003,
                CheckCode::U004,
                CheckCode::U005,
                CheckCode::U006,
                CheckCode::U007,
                CheckCode::U008,
                CheckCode::U009,
            ],
            CheckCodePrefix::U001 => vec![CheckCode::U001],
            CheckCodePrefix::U002 => vec![CheckCode::U002],
            CheckCodePrefix::U003 => vec![CheckCode::U003],
            CheckCodePrefix::U004 => vec![CheckCode::U004],
            CheckCodePrefix::U005 => vec![CheckCode::U005],
            CheckCodePrefix::U006 => vec![CheckCode::U006],
            CheckCodePrefix::U007 => vec![CheckCode::U007],
            CheckCodePrefix::U008 => vec![CheckCode::U008],
            CheckCodePrefix::U009 => vec![CheckCode::U009],
            CheckCodePrefix::W => vec![CheckCode::W292, CheckCode::W605],
            CheckCodePrefix::W2 => vec![CheckCode::W292],
            CheckCodePrefix::W29 => vec![CheckCode::W292],
            CheckCodePrefix::W292 => vec![CheckCode::W292],
            CheckCodePrefix::W6 => vec![CheckCode::W605],
            CheckCodePrefix::W60 => vec![CheckCode::W605],
            CheckCodePrefix::W605 => vec![CheckCode::W605],
        }
    }
}

impl CheckCodePrefix {
    pub fn specificity(&self) -> PrefixSpecificity {
        match self {
            CheckCodePrefix::A => PrefixSpecificity::Category,
            CheckCodePrefix::A0 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::A00 => PrefixSpecificity::Tens,
            CheckCodePrefix::A001 => PrefixSpecificity::Explicit,
            CheckCodePrefix::A002 => PrefixSpecificity::Explicit,
            CheckCodePrefix::A003 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN => PrefixSpecificity::Category,
            CheckCodePrefix::ANN0 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::ANN00 => PrefixSpecificity::Tens,
            CheckCodePrefix::ANN001 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN002 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN003 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN1 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::ANN10 => PrefixSpecificity::Tens,
            CheckCodePrefix::ANN101 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN102 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN2 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::ANN20 => PrefixSpecificity::Tens,
            CheckCodePrefix::ANN201 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN202 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN204 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN205 => PrefixSpecificity::Explicit,
            CheckCodePrefix::ANN206 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B => PrefixSpecificity::Category,
            CheckCodePrefix::B0 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::B00 => PrefixSpecificity::Tens,
            CheckCodePrefix::B002 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B003 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B004 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B005 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B006 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B007 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B008 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B01 => PrefixSpecificity::Tens,
            CheckCodePrefix::B011 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B013 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B014 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B015 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B016 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B017 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B018 => PrefixSpecificity::Explicit,
            CheckCodePrefix::B02 => PrefixSpecificity::Tens,
            CheckCodePrefix::B025 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C => PrefixSpecificity::Category,
            CheckCodePrefix::C4 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::C40 => PrefixSpecificity::Tens,
            CheckCodePrefix::C400 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C401 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C402 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C403 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C404 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C405 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C406 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C408 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C409 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C41 => PrefixSpecificity::Tens,
            CheckCodePrefix::C410 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C411 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C413 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C414 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C415 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C416 => PrefixSpecificity::Explicit,
            CheckCodePrefix::C417 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D => PrefixSpecificity::Category,
            CheckCodePrefix::D1 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::D10 => PrefixSpecificity::Tens,
            CheckCodePrefix::D100 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D101 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D102 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D103 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D104 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D105 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D106 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D107 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D2 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::D20 => PrefixSpecificity::Tens,
            CheckCodePrefix::D200 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D201 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D202 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D203 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D204 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D205 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D206 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D207 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D208 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D209 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D21 => PrefixSpecificity::Tens,
            CheckCodePrefix::D210 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D211 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D212 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D213 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D214 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D215 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D3 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::D30 => PrefixSpecificity::Tens,
            CheckCodePrefix::D300 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D4 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::D40 => PrefixSpecificity::Tens,
            CheckCodePrefix::D400 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D402 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D403 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D404 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D405 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D406 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D407 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D408 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D409 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D41 => PrefixSpecificity::Tens,
            CheckCodePrefix::D410 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D411 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D412 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D413 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D414 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D415 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D416 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D417 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D418 => PrefixSpecificity::Explicit,
            CheckCodePrefix::D419 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E => PrefixSpecificity::Category,
            CheckCodePrefix::E4 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::E40 => PrefixSpecificity::Tens,
            CheckCodePrefix::E402 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E5 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::E50 => PrefixSpecificity::Tens,
            CheckCodePrefix::E501 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E7 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::E71 => PrefixSpecificity::Tens,
            CheckCodePrefix::E711 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E712 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E713 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E714 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E72 => PrefixSpecificity::Tens,
            CheckCodePrefix::E721 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E722 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E73 => PrefixSpecificity::Tens,
            CheckCodePrefix::E731 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E74 => PrefixSpecificity::Tens,
            CheckCodePrefix::E741 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E742 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E743 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E9 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::E90 => PrefixSpecificity::Tens,
            CheckCodePrefix::E902 => PrefixSpecificity::Explicit,
            CheckCodePrefix::E99 => PrefixSpecificity::Tens,
            CheckCodePrefix::E999 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F => PrefixSpecificity::Category,
            CheckCodePrefix::F4 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::F40 => PrefixSpecificity::Tens,
            CheckCodePrefix::F401 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F402 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F403 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F404 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F405 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F406 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F407 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F5 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::F54 => PrefixSpecificity::Tens,
            CheckCodePrefix::F541 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F6 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::F60 => PrefixSpecificity::Tens,
            CheckCodePrefix::F601 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F602 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F62 => PrefixSpecificity::Tens,
            CheckCodePrefix::F621 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F622 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F63 => PrefixSpecificity::Tens,
            CheckCodePrefix::F631 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F632 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F633 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F634 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F7 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::F70 => PrefixSpecificity::Tens,
            CheckCodePrefix::F701 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F702 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F704 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F706 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F707 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F72 => PrefixSpecificity::Tens,
            CheckCodePrefix::F722 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F8 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::F82 => PrefixSpecificity::Tens,
            CheckCodePrefix::F821 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F822 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F823 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F83 => PrefixSpecificity::Tens,
            CheckCodePrefix::F831 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F84 => PrefixSpecificity::Tens,
            CheckCodePrefix::F841 => PrefixSpecificity::Explicit,
            CheckCodePrefix::F9 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::F90 => PrefixSpecificity::Tens,
            CheckCodePrefix::F901 => PrefixSpecificity::Explicit,
            CheckCodePrefix::M => PrefixSpecificity::Category,
            CheckCodePrefix::M0 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::M00 => PrefixSpecificity::Tens,
            CheckCodePrefix::M001 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N => PrefixSpecificity::Category,
            CheckCodePrefix::N8 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::N80 => PrefixSpecificity::Tens,
            CheckCodePrefix::N801 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N802 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N803 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N804 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N805 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N806 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N807 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N81 => PrefixSpecificity::Tens,
            CheckCodePrefix::N811 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N812 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N813 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N814 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N815 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N816 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N817 => PrefixSpecificity::Explicit,
            CheckCodePrefix::N818 => PrefixSpecificity::Explicit,
            CheckCodePrefix::Q => PrefixSpecificity::Category,
            CheckCodePrefix::Q0 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::Q00 => PrefixSpecificity::Tens,
            CheckCodePrefix::Q000 => PrefixSpecificity::Explicit,
            CheckCodePrefix::Q001 => PrefixSpecificity::Explicit,
            CheckCodePrefix::Q002 => PrefixSpecificity::Explicit,
            CheckCodePrefix::Q003 => PrefixSpecificity::Explicit,
            CheckCodePrefix::RUF => PrefixSpecificity::Category,
            CheckCodePrefix::RUF0 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::RUF00 => PrefixSpecificity::Tens,
            CheckCodePrefix::RUF001 => PrefixSpecificity::Explicit,
            CheckCodePrefix::RUF002 => PrefixSpecificity::Explicit,
            CheckCodePrefix::T => PrefixSpecificity::Category,
            CheckCodePrefix::T2 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::T20 => PrefixSpecificity::Tens,
            CheckCodePrefix::T201 => PrefixSpecificity::Explicit,
            CheckCodePrefix::T203 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U => PrefixSpecificity::Category,
            CheckCodePrefix::U0 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::U00 => PrefixSpecificity::Tens,
            CheckCodePrefix::U001 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U002 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U003 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U004 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U005 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U006 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U007 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U008 => PrefixSpecificity::Explicit,
            CheckCodePrefix::U009 => PrefixSpecificity::Explicit,
            CheckCodePrefix::W => PrefixSpecificity::Category,
            CheckCodePrefix::W2 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::W29 => PrefixSpecificity::Tens,
            CheckCodePrefix::W292 => PrefixSpecificity::Explicit,
            CheckCodePrefix::W6 => PrefixSpecificity::Hundreds,
            CheckCodePrefix::W60 => PrefixSpecificity::Tens,
            CheckCodePrefix::W605 => PrefixSpecificity::Explicit,
        }
    }
}
