import { S as SvelteComponent, i as init, s as safe_not_equal, f as element, m as space, h as text, b as attr, t as toggle_class, c as insert, d as append, l as listen, j as set_data, n as noop, e as detach, A as createEventDispatcher, q as create_component, u as mount_component, v as transition_in, w as transition_out, x as destroy_component, L as assign, M as StatusTracker, D as binding_callbacks, J as bind, N as get_spread_update, O as get_spread_object, G as add_flush_callback, F as bubble } from './index.8ea4571f.js';
import { g as get_styles } from './styles.db46e346.js';
import { B as Block } from './Block.1ffab958.js';

/* home/runner/work/gradio/gradio/ui/packages/form/src/Checkbox.svelte generated by Svelte v3.49.0 */

function create_fragment$1(ctx) {
	let label_1;
	let input;
	let input_class_value;
	let t0;
	let span;
	let t1;
	let mounted;
	let dispose;

	return {
		c() {
			label_1 = element("label");
			input = element("input");
			t0 = space();
			span = element("span");
			t1 = text(/*label*/ ctx[2]);
			input.disabled = /*disabled*/ ctx[1];
			input.checked = /*value*/ ctx[0];
			attr(input, "type", "checkbox");
			attr(input, "name", "test");
			attr(input, "class", input_class_value = "gr-check-radio gr-checkbox " + /*rounded*/ ctx[4] + " " + /*border*/ ctx[3]);
			attr(span, "class", "ml-2");
			attr(label_1, "class", "flex items-center text-gray-700 text-sm space-x-2 rounded-lg cursor-pointer dark:bg-transparent ");
			toggle_class(label_1, "!cursor-not-allowed", /*disabled*/ ctx[1]);
		},
		m(target, anchor) {
			insert(target, label_1, anchor);
			append(label_1, input);
			append(label_1, t0);
			append(label_1, span);
			append(span, t1);

			if (!mounted) {
				dispose = listen(input, "change", /*change_handler*/ ctx[7]);
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (dirty & /*disabled*/ 2) {
				input.disabled = /*disabled*/ ctx[1];
			}

			if (dirty & /*value*/ 1) {
				input.checked = /*value*/ ctx[0];
			}

			if (dirty & /*rounded, border*/ 24 && input_class_value !== (input_class_value = "gr-check-radio gr-checkbox " + /*rounded*/ ctx[4] + " " + /*border*/ ctx[3])) {
				attr(input, "class", input_class_value);
			}

			if (dirty & /*label*/ 4) set_data(t1, /*label*/ ctx[2]);

			if (dirty & /*disabled*/ 2) {
				toggle_class(label_1, "!cursor-not-allowed", /*disabled*/ ctx[1]);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(label_1);
			mounted = false;
			dispose();
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let rounded;
	let border;
	let { value } = $$props;
	let { style = {} } = $$props;
	let { disabled = false } = $$props;
	let { label } = $$props;

	// export let show_label: boolean;
	const dispatch = createEventDispatcher();

	function handle_change(evt) {
		$$invalidate(0, value = evt.currentTarget.checked);
		dispatch("change", value);
	}

	const change_handler = evt => handle_change(evt);

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(6, style = $$props.style);
		if ('disabled' in $$props) $$invalidate(1, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*style*/ 64) {
			$$invalidate(4, { rounded, border } = get_styles(style, ["rounded", "border"]), rounded, ($$invalidate(3, border), $$invalidate(6, style)));
		}
	};

	return [value, disabled, label, border, rounded, handle_change, style, change_handler];
}

class Checkbox extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 6,
			disabled: 1,
			label: 2
		});
	}
}

/* src/components/Checkbox/Checkbox.svelte generated by Svelte v3.49.0 */

function create_default_slot(ctx) {
	let statustracker;
	let t;
	let checkbox;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[7]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });

	function checkbox_value_binding(value) {
		/*checkbox_value_binding*/ ctx[8](value);
	}

	let checkbox_props = {
		label: /*label*/ ctx[3],
		style: /*style*/ ctx[6],
		disabled: /*mode*/ ctx[4] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		checkbox_props.value = /*value*/ ctx[0];
	}

	checkbox = new Checkbox({ props: checkbox_props });
	binding_callbacks.push(() => bind(checkbox, 'value', checkbox_value_binding));
	checkbox.$on("change", /*change_handler*/ ctx[9]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(checkbox.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			mount_component(checkbox, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 128)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[7])])
			: {};

			statustracker.$set(statustracker_changes);
			const checkbox_changes = {};
			if (dirty & /*label*/ 8) checkbox_changes.label = /*label*/ ctx[3];
			if (dirty & /*style*/ 64) checkbox_changes.style = /*style*/ ctx[6];
			if (dirty & /*mode*/ 16) checkbox_changes.disabled = /*mode*/ ctx[4] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				checkbox_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			checkbox.$set(checkbox_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(checkbox.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(checkbox.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			destroy_component(checkbox, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[2],
				form_position: /*form_position*/ ctx[5],
				elem_id: /*elem_id*/ ctx[1],
				disable: typeof /*style*/ ctx[6].container === "boolean" && !/*style*/ ctx[6].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];
			if (dirty & /*form_position*/ 32) block_changes.form_position = /*form_position*/ ctx[5];
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*style*/ 64) block_changes.disable = typeof /*style*/ ctx[6].container === "boolean" && !/*style*/ ctx[6].container;

			if (dirty & /*$$scope, label, style, mode, value, loading_status*/ 1241) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = false } = $$props;
	let { label = "Checkbox" } = $$props;
	let { mode } = $$props;
	let { form_position = "single" } = $$props;
	let { style = {} } = $$props;
	let { loading_status } = $$props;

	function checkbox_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('mode' in $$props) $$invalidate(4, mode = $$props.mode);
		if ('form_position' in $$props) $$invalidate(5, form_position = $$props.form_position);
		if ('style' in $$props) $$invalidate(6, style = $$props.style);
		if ('loading_status' in $$props) $$invalidate(7, loading_status = $$props.loading_status);
	};

	return [
		value,
		elem_id,
		visible,
		label,
		mode,
		form_position,
		style,
		loading_status,
		checkbox_value_binding,
		change_handler
	];
}

class Checkbox_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 0,
			label: 3,
			mode: 4,
			form_position: 5,
			style: 6,
			loading_status: 7
		});
	}
}

var Checkbox_1$1 = Checkbox_1;

const modes = ["static", "dynamic"];

export { Checkbox_1$1 as Component, modes };
