import { S as SvelteComponent, i as init, s as safe_not_equal, a as svg_element, b as attr, c as insert, d as append, n as noop, e as detach, f as element, h as text, m as space, j as set_data, o as destroy_each, A as createEventDispatcher, a0 as beforeUpdate, a1 as afterUpdate, D as binding_callbacks, a2 as colors, q as create_component, u as mount_component, v as transition_in, w as transition_out, x as destroy_component, L as assign, M as StatusTracker, N as get_spread_update, O as get_spread_object, y as group_outros, z as check_outros, F as bubble } from './index.8ea4571f.js';
import { B as Block } from './Block.1ffab958.js';
import { B as BlockLabel } from './BlockLabel.48cbfc0c.js';
import './styles.db46e346.js';

/* home/runner/work/gradio/gradio/ui/packages/icons/src/Chat.svelte generated by Svelte v3.49.0 */

function create_fragment$2(ctx) {
	let svg;
	let path0;
	let path1;

	return {
		c() {
			svg = svg_element("svg");
			path0 = svg_element("path");
			path1 = svg_element("path");
			attr(path0, "fill", "currentColor");
			attr(path0, "d", "M17.74 30L16 29l4-7h6a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h9v2H6a4 4 0 0 1-4-4V8a4 4 0 0 1 4-4h20a4 4 0 0 1 4 4v12a4 4 0 0 1-4 4h-4.84Z");
			attr(path1, "fill", "currentColor");
			attr(path1, "d", "M8 10h16v2H8zm0 6h10v2H8z");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "xmlns:xlink", "http://www.w3.org/1999/xlink");
			attr(svg, "aria-hidden", "true");
			attr(svg, "role", "img");
			attr(svg, "class", "iconify iconify--carbon");
			attr(svg, "width", "100%");
			attr(svg, "height", "100%");
			attr(svg, "preserveAspectRatio", "xMidYMid meet");
			attr(svg, "viewBox", "0 0 32 32");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, path0);
			append(svg, path1);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

class Chat extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, null, create_fragment$2, safe_not_equal, {});
	}
}

/* home/runner/work/gradio/gradio/ui/packages/chatbot/src/ChatBot.svelte generated by Svelte v3.49.0 */

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[9] = list[i];
	return child_ctx;
}

// (38:2) {#each value as message}
function create_each_block(ctx) {
	let div0;
	let t0_value = /*message*/ ctx[9][0] + "";
	let t0;
	let div0_style_value;
	let t1;
	let div1;
	let t2_value = /*message*/ ctx[9][1] + "";
	let t2;
	let t3;
	let div1_style_value;

	return {
		c() {
			div0 = element("div");
			t0 = text(t0_value);
			t1 = space();
			div1 = element("div");
			t2 = text(t2_value);
			t3 = space();
			attr(div0, "data-testid", "user");
			attr(div0, "class", "px-3 py-2 rounded-[22px] rounded-br-none text-white text-sm");
			attr(div0, "style", div0_style_value = "background-color:" + /*_colors*/ ctx[2][0]);
			attr(div1, "data-testid", "bot");
			attr(div1, "class", "px-3 py-2 rounded-[22px] rounded-bl-none place-self-start text-white text-sm");
			attr(div1, "style", div1_style_value = "background-color:" + /*_colors*/ ctx[2][1]);
		},
		m(target, anchor) {
			insert(target, div0, anchor);
			append(div0, t0);
			insert(target, t1, anchor);
			insert(target, div1, anchor);
			append(div1, t2);
			append(div1, t3);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && t0_value !== (t0_value = /*message*/ ctx[9][0] + "")) set_data(t0, t0_value);

			if (dirty & /*_colors*/ 4 && div0_style_value !== (div0_style_value = "background-color:" + /*_colors*/ ctx[2][0])) {
				attr(div0, "style", div0_style_value);
			}

			if (dirty & /*value*/ 1 && t2_value !== (t2_value = /*message*/ ctx[9][1] + "")) set_data(t2, t2_value);

			if (dirty & /*_colors*/ 4 && div1_style_value !== (div1_style_value = "background-color:" + /*_colors*/ ctx[2][1])) {
				attr(div1, "style", div1_style_value);
			}
		},
		d(detaching) {
			if (detaching) detach(div0);
			if (detaching) detach(t1);
			if (detaching) detach(div1);
		}
	};
}

function create_fragment$1(ctx) {
	let div1;
	let div0;
	let each_value = /*value*/ ctx[0];
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	return {
		c() {
			div1 = element("div");
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(div0, "class", "flex flex-col items-end space-y-4 p-3");
			attr(div1, "class", "overflow-y-auto h-[40vh]");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div0, null);
			}

			/*div1_binding*/ ctx[4](div1);
		},
		p(ctx, [dirty]) {
			if (dirty & /*_colors, value*/ 5) {
				each_value = /*value*/ ctx[0];
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div1);
			destroy_each(each_blocks, detaching);
			/*div1_binding*/ ctx[4](null);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let _colors;
	let { value } = $$props;
	let { style = {} } = $$props;
	let div;
	let autoscroll;
	const dispatch = createEventDispatcher();

	beforeUpdate(() => {
		autoscroll = div && div.offsetHeight + div.scrollTop > div.scrollHeight - 20;
	});

	afterUpdate(() => {
		if (autoscroll) div.scrollTo(0, div.scrollHeight);
	});

	function get_color(c) {
		if (c in colors) {
			return colors[c].primary;
		} else {
			return c;
		}
	}

	function get_colors() {
		if (!style.color_map) {
			return ["#fb923c", "#9ca3af"];
		} else {
			return [get_color(style.color_map[0]), get_color(style.color_map[1])];
		}
	}

	function div1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			div = $$value;
			$$invalidate(1, div);
		});
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(3, style = $$props.style);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			value && dispatch("change");
		}
	};

	$$invalidate(2, _colors = get_colors());
	return [value, div, _colors, style, div1_binding];
}

class ChatBot extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { value: 0, style: 3 });
	}
}

/* src/components/Chatbot/Chatbot.svelte generated by Svelte v3.49.0 */

function create_if_block(ctx) {
	let blocklabel;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[5],
				Icon: Chat,
				label: /*label*/ ctx[4] || "Chatbot",
				disable: typeof /*style*/ ctx[0].container === "boolean" && !/*style*/ ctx[0].container
			}
		});

	return {
		c() {
			create_component(blocklabel.$$.fragment);
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 32) blocklabel_changes.show_label = /*show_label*/ ctx[5];
			if (dirty & /*label*/ 16) blocklabel_changes.label = /*label*/ ctx[4] || "Chatbot";
			if (dirty & /*style*/ 1) blocklabel_changes.disable = typeof /*style*/ ctx[0].container === "boolean" && !/*style*/ ctx[0].container;
			blocklabel.$set(blocklabel_changes);
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
		}
	};
}

// (18:0) <Block padding={false} {elem_id} {visible} style={{ rounded: style.rounded }}>
function create_default_slot(ctx) {
	let statustracker;
	let t0;
	let t1;
	let chatbot;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[6]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });
	let if_block = /*show_label*/ ctx[5] && create_if_block(ctx);

	chatbot = new ChatBot({
			props: {
				style: /*style*/ ctx[0],
				value: /*value*/ ctx[3]
			}
		});

	chatbot.$on("change", /*change_handler*/ ctx[8]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t0 = space();
			if (if_block) if_block.c();
			t1 = space();
			create_component(chatbot.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t0, anchor);
			if (if_block) if_block.m(target, anchor);
			insert(target, t1, anchor);
			mount_component(chatbot, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 64)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[6])])
			: {};

			statustracker.$set(statustracker_changes);

			if (/*show_label*/ ctx[5]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*show_label*/ 32) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(t1.parentNode, t1);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			const chatbot_changes = {};
			if (dirty & /*style*/ 1) chatbot_changes.style = /*style*/ ctx[0];
			if (dirty & /*value*/ 8) chatbot_changes.value = /*value*/ ctx[3];
			chatbot.$set(chatbot_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			transition_in(chatbot.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			transition_out(chatbot.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t0);
			if (if_block) if_block.d(detaching);
			if (detaching) detach(t1);
			destroy_component(chatbot, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				padding: false,
				elem_id: /*elem_id*/ ctx[1],
				visible: /*visible*/ ctx[2],
				style: { rounded: /*style*/ ctx[0].rounded },
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];
			if (dirty & /*style*/ 1) block_changes.style = { rounded: /*style*/ ctx[0].rounded };

			if (dirty & /*$$scope, style, value, show_label, label, loading_status*/ 633) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = [] } = $$props;
	let { style = {} } = $$props;
	let { label } = $$props;
	let { show_label = true } = $$props;
	let { color_map = {} } = $$props;
	let { loading_status } = $$props;

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(3, value = $$props.value);
		if ('style' in $$props) $$invalidate(0, style = $$props.style);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('color_map' in $$props) $$invalidate(7, color_map = $$props.color_map);
		if ('loading_status' in $$props) $$invalidate(6, loading_status = $$props.loading_status);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*style, color_map*/ 129) {
			if (!style.color_map && Object.keys(color_map).length) {
				$$invalidate(0, style.color_map = color_map, style);
			}
		}
	};

	return [
		style,
		elem_id,
		visible,
		value,
		label,
		show_label,
		loading_status,
		color_map,
		change_handler
	];
}

class Chatbot extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 3,
			style: 0,
			label: 4,
			show_label: 5,
			color_map: 7,
			loading_status: 6
		});
	}
}

var Chatbot$1 = Chatbot;

const modes = ["static"];

export { Chatbot$1 as Component, modes };
