import { S as SvelteComponent, i as init, s as safe_not_equal, f as element, q as create_component, m as space, h as text, b as attr, c as insert, d as append, u as mount_component, a3 as set_input_value, l as listen, j as set_data, v as transition_in, w as transition_out, e as detach, x as destroy_component, r as run_all, A as createEventDispatcher, aj as to_number, L as assign, M as StatusTracker, D as binding_callbacks, J as bind, N as get_spread_update, O as get_spread_object, G as add_flush_callback, F as bubble } from './index.7642b5d6.js';
import { B as Block } from './Block.c3963771.js';
import { c as create_classes } from './styles.db46e346.js';
import { B as BlockTitle } from './BlockTitle.7fc609aa.js';

/* home/runner/work/gradio/gradio/ui/packages/form/src/Range.svelte generated by Svelte v3.49.0 */

function create_default_slot$1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[6]);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*label*/ 64) set_data(t, /*label*/ ctx[6]);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

function create_fragment$1(ctx) {
	let div2;
	let div1;
	let label_1;
	let blocktitle;
	let t0;
	let div0;
	let t1;
	let div0_class_value;
	let t2;
	let input;
	let current;
	let mounted;
	let dispose;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[7],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			div2 = element("div");
			div1 = element("div");
			label_1 = element("label");
			create_component(blocktitle.$$.fragment);
			t0 = space();
			div0 = element("div");
			t1 = text(/*value*/ ctx[0]);
			t2 = space();
			input = element("input");
			attr(label_1, "for", /*id*/ ctx[8]);
			attr(div0, "class", div0_class_value = "font-medium dark:text-gray-300" + create_classes(/*style*/ ctx[1]));
			attr(div1, "class", "flex justify-between");
			attr(div2, "class", "w-full flex flex-col ");
			attr(input, "type", "range");
			attr(input, "id", /*id*/ ctx[8]);
			attr(input, "name", "cowbell");
			attr(input, "class", "w-full disabled:cursor-not-allowed");
			attr(input, "min", /*minimum*/ ctx[2]);
			attr(input, "max", /*maximum*/ ctx[3]);
			attr(input, "step", /*step*/ ctx[4]);
			input.disabled = /*disabled*/ ctx[5];
		},
		m(target, anchor) {
			insert(target, div2, anchor);
			append(div2, div1);
			append(div1, label_1);
			mount_component(blocktitle, label_1, null);
			append(div1, t0);
			append(div1, div0);
			append(div0, t1);
			insert(target, t2, anchor);
			insert(target, input, anchor);
			set_input_value(input, /*value*/ ctx[0]);
			current = true;

			if (!mounted) {
				dispose = [
					listen(input, "change", /*input_change_input_handler*/ ctx[9]),
					listen(input, "input", /*input_change_input_handler*/ ctx[9])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			const blocktitle_changes = {};
			if (dirty & /*show_label*/ 128) blocktitle_changes.show_label = /*show_label*/ ctx[7];

			if (dirty & /*$$scope, label*/ 2112) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);
			if (!current || dirty & /*value*/ 1) set_data(t1, /*value*/ ctx[0]);

			if (!current || dirty & /*style*/ 2 && div0_class_value !== (div0_class_value = "font-medium dark:text-gray-300" + create_classes(/*style*/ ctx[1]))) {
				attr(div0, "class", div0_class_value);
			}

			if (!current || dirty & /*minimum*/ 4) {
				attr(input, "min", /*minimum*/ ctx[2]);
			}

			if (!current || dirty & /*maximum*/ 8) {
				attr(input, "max", /*maximum*/ ctx[3]);
			}

			if (!current || dirty & /*step*/ 16) {
				attr(input, "step", /*step*/ ctx[4]);
			}

			if (!current || dirty & /*disabled*/ 32) {
				input.disabled = /*disabled*/ ctx[5];
			}

			if (dirty & /*value*/ 1) {
				set_input_value(input, /*value*/ ctx[0]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocktitle.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocktitle.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div2);
			destroy_component(blocktitle);
			if (detaching) detach(t2);
			if (detaching) detach(input);
			mounted = false;
			run_all(dispose);
		}
	};
}

let _id = 0;

function instance$1($$self, $$props, $$invalidate) {
	let { value = 0 } = $$props;
	let { style = {} } = $$props;
	let { minimum = 0 } = $$props;
	let { maximum = 100 } = $$props;
	let { step = 1 } = $$props;
	let { disabled = false } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	const id = `range_id_${_id++}`;
	const dispatch = createEventDispatcher();

	function input_change_input_handler() {
		value = to_number(this.value);
		$$invalidate(0, value);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(1, style = $$props.style);
		if ('minimum' in $$props) $$invalidate(2, minimum = $$props.minimum);
		if ('maximum' in $$props) $$invalidate(3, maximum = $$props.maximum);
		if ('step' in $$props) $$invalidate(4, step = $$props.step);
		if ('disabled' in $$props) $$invalidate(5, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(6, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(7, show_label = $$props.show_label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			dispatch("change", value);
		}
	};

	return [
		value,
		style,
		minimum,
		maximum,
		step,
		disabled,
		label,
		show_label,
		id,
		input_change_input_handler
	];
}

class Range extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 1,
			minimum: 2,
			maximum: 3,
			step: 4,
			disabled: 5,
			label: 6,
			show_label: 7
		});
	}
}

/* src/components/Slider/Slider.svelte generated by Svelte v3.49.0 */

function create_default_slot(ctx) {
	let statustracker;
	let t;
	let range;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[11]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });

	function range_value_binding(value) {
		/*range_value_binding*/ ctx[12](value);
	}

	let range_props = {
		label: /*label*/ ctx[3],
		show_label: /*show_label*/ ctx[10],
		minimum: /*minimum*/ ctx[5],
		maximum: /*maximum*/ ctx[6],
		step: /*step*/ ctx[7],
		style: /*style*/ ctx[4],
		disabled: /*mode*/ ctx[8] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		range_props.value = /*value*/ ctx[0];
	}

	range = new Range({ props: range_props });
	binding_callbacks.push(() => bind(range, 'value', range_value_binding));
	range.$on("change", /*change_handler*/ ctx[13]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(range.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			mount_component(range, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 2048)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[11])])
			: {};

			statustracker.$set(statustracker_changes);
			const range_changes = {};
			if (dirty & /*label*/ 8) range_changes.label = /*label*/ ctx[3];
			if (dirty & /*show_label*/ 1024) range_changes.show_label = /*show_label*/ ctx[10];
			if (dirty & /*minimum*/ 32) range_changes.minimum = /*minimum*/ ctx[5];
			if (dirty & /*maximum*/ 64) range_changes.maximum = /*maximum*/ ctx[6];
			if (dirty & /*step*/ 128) range_changes.step = /*step*/ ctx[7];
			if (dirty & /*style*/ 16) range_changes.style = /*style*/ ctx[4];
			if (dirty & /*mode*/ 256) range_changes.disabled = /*mode*/ ctx[8] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				range_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			range.$set(range_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(range.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(range.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			destroy_component(range, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[2],
				form_position: /*form_position*/ ctx[9],
				elem_id: /*elem_id*/ ctx[1],
				disable: typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];
			if (dirty & /*form_position*/ 512) block_changes.form_position = /*form_position*/ ctx[9];
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*style*/ 16) block_changes.disable = typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container;

			if (dirty & /*$$scope, label, show_label, minimum, maximum, step, style, mode, value, loading_status*/ 19961) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = 0 } = $$props;
	let { label = "Slider" } = $$props;
	let { style = {} } = $$props;
	let { minimum } = $$props;
	let { maximum } = $$props;
	let { step } = $$props;
	let { mode } = $$props;
	let { form_position = "single" } = $$props;
	let { show_label } = $$props;
	let { loading_status } = $$props;

	function range_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('style' in $$props) $$invalidate(4, style = $$props.style);
		if ('minimum' in $$props) $$invalidate(5, minimum = $$props.minimum);
		if ('maximum' in $$props) $$invalidate(6, maximum = $$props.maximum);
		if ('step' in $$props) $$invalidate(7, step = $$props.step);
		if ('mode' in $$props) $$invalidate(8, mode = $$props.mode);
		if ('form_position' in $$props) $$invalidate(9, form_position = $$props.form_position);
		if ('show_label' in $$props) $$invalidate(10, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(11, loading_status = $$props.loading_status);
	};

	return [
		value,
		elem_id,
		visible,
		label,
		style,
		minimum,
		maximum,
		step,
		mode,
		form_position,
		show_label,
		loading_status,
		range_value_binding,
		change_handler
	];
}

class Slider extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 0,
			label: 3,
			style: 4,
			minimum: 5,
			maximum: 6,
			step: 7,
			mode: 8,
			form_position: 9,
			show_label: 10,
			loading_status: 11
		});
	}
}

var Slider$1 = Slider;

const modes = ["static", "dynamic"];

export { Slider$1 as Component, modes };
