# Copyright 2019 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from jax.abstract_arrays import ShapedArray
from jax.core import Primitive
from jax.interpreters import xla
from ..interpreters import ad


def fft(x, fft_type, fft_lengths=None):
  if fft_lengths is None:
    fft_lengths = x.shape
  else:
    fft_lengths = tuple(fft_lengths)
  return fft_p.bind(x, fft_type=fft_type, fft_lengths=fft_lengths)

def fft_impl(x, fft_type, fft_lengths):
  return xla.apply_primitive(fft_p, x, fft_type=fft_type, fft_lengths=fft_lengths)

def fft_abstract_eval(x, fft_type, fft_lengths):
  return ShapedArray(x.shape, x.dtype)

def fft_translation_rule(c, x, fft_type, fft_lengths):
  return c.Fft(x, fft_type, fft_lengths)

def fft_transpose_rule(t, fft_type, fft_lengths):
  return fft(t, fft_type, fft_lengths),

fft_p = Primitive('fft')
fft_p.def_impl(fft_impl)
fft_p.def_abstract_eval(fft_abstract_eval)
xla.translations[fft_p] = fft_translation_rule
ad.deflinear(fft_p, fft_transpose_rule)
