import { S as SvelteComponentDev, i as init, s as safe_not_equal, d as dispatch_dev, v as validate_slots, y as createEventDispatcher, ab as tick, h as element, B as create_component, w as space, b as attr_dev, c as add_location, e as insert_dev, C as mount_component, f as append_dev, D as transition_in, E as transition_out, g as detach_dev, F as destroy_component, I as binding_callbacks, k as text, m as set_data_dev, aa as set_input_value, O as action_destroyer, l as listen_dev, a9 as prop_dev, j as is_function, r as run_all, aq as flush, R as StatusTracker, T as assign, L as bind, K as bubble, U as get_spread_update, V as get_spread_object, M as add_flush_callback } from './index.e70bf722.js';
import { B as Block } from './Block.78dd9cf7.js';
import { c as create_classes } from './styles.d87a390f.js';
import { B as BlockTitle } from './BlockTitle.3530aae0.js';

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/form/src/Textbox.svelte generated by Svelte v3.47.0 */
const file = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/form/src/Textbox.svelte";

// (66:1) <BlockTitle {show_label}>
function create_default_slot$1(ctx) {
	let t;

	const block = {
		c: function create() {
			t = text(/*label*/ ctx[4]);
		},
		m: function mount(target, anchor) {
			insert_dev(target, t, anchor);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*label*/ 16) set_data_dev(t, /*label*/ ctx[4]);
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(t);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot$1.name,
		type: "slot",
		source: "(66:1) <BlockTitle {show_label}>",
		ctx
	});

	return block;
}

// (78:1) {:else}
function create_else_block(ctx) {
	let textarea;
	let textarea_class_value;
	let text_area_resize_action;
	let mounted;
	let dispose;

	const block = {
		c: function create() {
			textarea = element("textarea");
			attr_dev(textarea, "class", textarea_class_value = "block gr-box gr-input w-full gr-text-input " + create_classes(/*style*/ ctx[1]));
			attr_dev(textarea, "placeholder", /*placeholder*/ ctx[3]);
			attr_dev(textarea, "rows", /*lines*/ ctx[2]);
			textarea.disabled = /*disabled*/ ctx[5];
			add_location(textarea, file, 78, 2, 2052);
		},
		m: function mount(target, anchor) {
			insert_dev(target, textarea, anchor);
			set_input_value(textarea, /*value*/ ctx[0]);
			/*textarea_binding*/ ctx[13](textarea);

			if (!mounted) {
				dispose = [
					action_destroyer(text_area_resize_action = /*text_area_resize*/ ctx[9].call(null, textarea, /*value*/ ctx[0])),
					listen_dev(textarea, "input", /*textarea_input_handler*/ ctx[12])
				];

				mounted = true;
			}
		},
		p: function update(ctx, dirty) {
			if (dirty & /*style*/ 2 && textarea_class_value !== (textarea_class_value = "block gr-box gr-input w-full gr-text-input " + create_classes(/*style*/ ctx[1]))) {
				attr_dev(textarea, "class", textarea_class_value);
			}

			if (dirty & /*placeholder*/ 8) {
				attr_dev(textarea, "placeholder", /*placeholder*/ ctx[3]);
			}

			if (dirty & /*lines*/ 4) {
				attr_dev(textarea, "rows", /*lines*/ ctx[2]);
			}

			if (dirty & /*disabled*/ 32) {
				prop_dev(textarea, "disabled", /*disabled*/ ctx[5]);
			}

			if (text_area_resize_action && is_function(text_area_resize_action.update) && dirty & /*value*/ 1) text_area_resize_action.update.call(null, /*value*/ ctx[0]);

			if (dirty & /*value*/ 1) {
				set_input_value(textarea, /*value*/ ctx[0]);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(textarea);
			/*textarea_binding*/ ctx[13](null);
			mounted = false;
			run_all(dispose);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block.name,
		type: "else",
		source: "(78:1) {:else}",
		ctx
	});

	return block;
}

// (68:1) {#if lines === 1 && max_lines === 1}
function create_if_block(ctx) {
	let input;
	let input_class_value;
	let mounted;
	let dispose;

	const block = {
		c: function create() {
			input = element("input");
			attr_dev(input, "type", "text");
			attr_dev(input, "class", input_class_value = "block gr-box gr-input w-full gr-text-input " + create_classes(/*style*/ ctx[1]));
			attr_dev(input, "placeholder", /*placeholder*/ ctx[3]);
			input.disabled = /*disabled*/ ctx[5];
			add_location(input, file, 68, 2, 1866);
		},
		m: function mount(target, anchor) {
			insert_dev(target, input, anchor);
			set_input_value(input, /*value*/ ctx[0]);
			/*input_binding*/ ctx[11](input);

			if (!mounted) {
				dispose = listen_dev(input, "input", /*input_input_handler*/ ctx[10]);
				mounted = true;
			}
		},
		p: function update(ctx, dirty) {
			if (dirty & /*style*/ 2 && input_class_value !== (input_class_value = "block gr-box gr-input w-full gr-text-input " + create_classes(/*style*/ ctx[1]))) {
				attr_dev(input, "class", input_class_value);
			}

			if (dirty & /*placeholder*/ 8) {
				attr_dev(input, "placeholder", /*placeholder*/ ctx[3]);
			}

			if (dirty & /*disabled*/ 32) {
				prop_dev(input, "disabled", /*disabled*/ ctx[5]);
			}

			if (dirty & /*value*/ 1 && input.value !== /*value*/ ctx[0]) {
				set_input_value(input, /*value*/ ctx[0]);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(input);
			/*input_binding*/ ctx[11](null);
			mounted = false;
			dispose();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block.name,
		type: "if",
		source: "(68:1) {#if lines === 1 && max_lines === 1}",
		ctx
	});

	return block;
}

function create_fragment$1(ctx) {
	let label_1;
	let blocktitle;
	let t;
	let current;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[6],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			},
			$$inline: true
		});

	function select_block_type(ctx, dirty) {
		if (/*lines*/ ctx[2] === 1 && /*max_lines*/ ctx[7] === 1) return create_if_block;
		return create_else_block;
	}

	let current_block_type = select_block_type(ctx);
	let if_block = current_block_type(ctx);

	const block = {
		c: function create() {
			label_1 = element("label");
			create_component(blocktitle.$$.fragment);
			t = space();
			if_block.c();
			attr_dev(label_1, "class", "block w-full");
			add_location(label_1, file, 64, 0, 1749);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, label_1, anchor);
			mount_component(blocktitle, label_1, null);
			append_dev(label_1, t);
			if_block.m(label_1, null);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const blocktitle_changes = {};
			if (dirty & /*show_label*/ 64) blocktitle_changes.show_label = /*show_label*/ ctx[6];

			if (dirty & /*$$scope, label*/ 262160) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (current_block_type === (current_block_type = select_block_type(ctx)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(label_1, null);
				}
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(blocktitle.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(blocktitle.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(label_1);
			destroy_component(blocktitle);
			if_block.d();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$1.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$1($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Textbox', slots, []);
	let { value = "" } = $$props;
	let { style = {} } = $$props;
	let { lines = 1 } = $$props;
	let { placeholder = "Type here..." } = $$props;
	let { label } = $$props;
	let { disabled = false } = $$props;
	let { show_label = true } = $$props;
	let { max_lines } = $$props;
	let el;
	const dispatch = createEventDispatcher();

	function handle_change(val) {
		dispatch("change", val);
	}

	async function handle_keypress(e) {
		await tick();

		if (e.key === "Enter" && lines === 1) {
			e.preventDefault();
			dispatch("submit");
		}
	}

	async function resize(event) {
		await tick();
		if (lines === max_lines) return;

		let max = max_lines === false
		? false
		: max_lines === undefined ? 20 * 11 : 20 * (max_lines + 1); // default

		let min = 20 * (lines + 1);
		const target = event.target;
		target.style.height = "1px";
		let scroll_height;

		if (max && target.scrollHeight > max) {
			scroll_height = max;
		} else if (target.scrollHeight < min) {
			scroll_height = min;
		} else {
			scroll_height = target.scrollHeight;
		}

		target.style.height = `${scroll_height}px`;
	}

	function text_area_resize(el, value) {
		if (lines === max_lines) return;
		el.style.overflow = "hidden";
		el.addEventListener("input", resize);
		if (!value.trim()) return;
		resize({ target: el });

		return {
			destroy: () => el.removeEventListener("input", resize)
		};
	}

	const writable_props = [
		'value',
		'style',
		'lines',
		'placeholder',
		'label',
		'disabled',
		'show_label',
		'max_lines'
	];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Textbox> was created with unknown prop '${key}'`);
	});

	function input_input_handler() {
		value = this.value;
		$$invalidate(0, value);
	}

	function input_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(8, el);
		});
	}

	function textarea_input_handler() {
		value = this.value;
		$$invalidate(0, value);
	}

	function textarea_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(8, el);
		});
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(1, style = $$props.style);
		if ('lines' in $$props) $$invalidate(2, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(3, placeholder = $$props.placeholder);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('disabled' in $$props) $$invalidate(5, disabled = $$props.disabled);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('max_lines' in $$props) $$invalidate(7, max_lines = $$props.max_lines);
	};

	$$self.$capture_state = () => ({
		createEventDispatcher,
		tick,
		create_classes,
		BlockTitle,
		value,
		style,
		lines,
		placeholder,
		label,
		disabled,
		show_label,
		max_lines,
		el,
		dispatch,
		handle_change,
		handle_keypress,
		resize,
		text_area_resize
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(1, style = $$props.style);
		if ('lines' in $$props) $$invalidate(2, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(3, placeholder = $$props.placeholder);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('disabled' in $$props) $$invalidate(5, disabled = $$props.disabled);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('max_lines' in $$props) $$invalidate(7, max_lines = $$props.max_lines);
		if ('el' in $$props) $$invalidate(8, el = $$props.el);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value, el, lines, max_lines*/ 389) {
			(el && lines !== max_lines && resize({ target: el }));
		}

		if ($$self.$$.dirty & /*value*/ 1) {
			handle_change(value);
		}
	};

	return [
		value,
		style,
		lines,
		placeholder,
		label,
		disabled,
		show_label,
		max_lines,
		el,
		text_area_resize,
		input_input_handler,
		input_binding,
		textarea_input_handler,
		textarea_binding
	];
}

class Textbox$2 extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 1,
			lines: 2,
			placeholder: 3,
			label: 4,
			disabled: 5,
			show_label: 6,
			max_lines: 7
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Textbox",
			options,
			id: create_fragment$1.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*label*/ ctx[4] === undefined && !('label' in props)) {
			console.warn("<Textbox> was created without expected prop 'label'");
		}

		if (/*max_lines*/ ctx[7] === undefined && !('max_lines' in props)) {
			console.warn("<Textbox> was created without expected prop 'max_lines'");
		}
	}

	get value() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get style() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set style(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get lines() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set lines(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get placeholder() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set placeholder(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get disabled() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set disabled(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get max_lines() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set max_lines(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* src/components/Textbox/Textbox.svelte generated by Svelte v3.47.0 */

// (19:0) <Block  {form_position}  {elem_id}  disable={typeof style.container === "boolean" && !style.container} >
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let textbox;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[9]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({
			props: statustracker_props,
			$$inline: true
		});

	function textbox_value_binding(value) {
		/*textbox_value_binding*/ ctx[11](value);
	}

	let textbox_props = {
		style: /*style*/ ctx[8],
		label: /*label*/ ctx[1],
		show_label: /*show_label*/ ctx[6],
		lines: /*lines*/ ctx[3],
		max_lines: !/*max_lines*/ ctx[7] && /*mode*/ ctx[10] === "static"
		? /*lines*/ ctx[3] + 1
		: /*max_lines*/ ctx[7],
		placeholder: /*placeholder*/ ctx[4],
		disabled: /*mode*/ ctx[10] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		textbox_props.value = /*value*/ ctx[0];
	}

	textbox = new Textbox$2({ props: textbox_props, $$inline: true });
	binding_callbacks.push(() => bind(textbox, 'value', textbox_value_binding));
	textbox.$on("change", /*change_handler*/ ctx[12]);
	textbox.$on("submit", /*submit_handler*/ ctx[13]);

	const block = {
		c: function create() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(textbox.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert_dev(target, t, anchor);
			mount_component(textbox, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 512)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[9])])
			: {};

			statustracker.$set(statustracker_changes);
			const textbox_changes = {};
			if (dirty & /*style*/ 256) textbox_changes.style = /*style*/ ctx[8];
			if (dirty & /*label*/ 2) textbox_changes.label = /*label*/ ctx[1];
			if (dirty & /*show_label*/ 64) textbox_changes.show_label = /*show_label*/ ctx[6];
			if (dirty & /*lines*/ 8) textbox_changes.lines = /*lines*/ ctx[3];

			if (dirty & /*max_lines, mode, lines*/ 1160) textbox_changes.max_lines = !/*max_lines*/ ctx[7] && /*mode*/ ctx[10] === "static"
			? /*lines*/ ctx[3] + 1
			: /*max_lines*/ ctx[7];

			if (dirty & /*placeholder*/ 16) textbox_changes.placeholder = /*placeholder*/ ctx[4];
			if (dirty & /*mode*/ 1024) textbox_changes.disabled = /*mode*/ ctx[10] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				textbox_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			textbox.$set(textbox_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(textbox.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(textbox.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach_dev(t);
			destroy_component(textbox, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot.name,
		type: "slot",
		source: "(19:0) <Block  {form_position}  {elem_id}  disable={typeof style.container === \\\"boolean\\\" && !style.container} >",
		ctx
	});

	return block;
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				form_position: /*form_position*/ ctx[5],
				elem_id: /*elem_id*/ ctx[2],
				disable: typeof /*style*/ ctx[8].container === "boolean" && !/*style*/ ctx[8].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			},
			$$inline: true
		});

	const block_1 = {
		c: function create() {
			create_component(block.$$.fragment);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*form_position*/ 32) block_changes.form_position = /*form_position*/ ctx[5];
			if (dirty & /*elem_id*/ 4) block_changes.elem_id = /*elem_id*/ ctx[2];
			if (dirty & /*style*/ 256) block_changes.disable = typeof /*style*/ ctx[8].container === "boolean" && !/*style*/ ctx[8].container;

			if (dirty & /*$$scope, style, label, show_label, lines, max_lines, mode, placeholder, value, loading_status*/ 18395) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(block, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block: block_1,
		id: create_fragment.name,
		type: "component",
		source: "",
		ctx
	});

	return block_1;
}

function instance($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Textbox', slots, []);
	let { label = "Textbox" } = $$props;
	let { elem_id = "" } = $$props;
	let { value = "" } = $$props;
	let { lines } = $$props;
	let { placeholder = "" } = $$props;
	let { form_position = "single" } = $$props;
	let { show_label } = $$props;
	let { max_lines } = $$props;
	let { style = {} } = $$props;
	let { loading_status } = $$props;
	let { mode } = $$props;

	const writable_props = [
		'label',
		'elem_id',
		'value',
		'lines',
		'placeholder',
		'form_position',
		'show_label',
		'max_lines',
		'style',
		'loading_status',
		'mode'
	];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Textbox> was created with unknown prop '${key}'`);
	});

	function textbox_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function submit_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('elem_id' in $$props) $$invalidate(2, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('lines' in $$props) $$invalidate(3, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(4, placeholder = $$props.placeholder);
		if ('form_position' in $$props) $$invalidate(5, form_position = $$props.form_position);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('max_lines' in $$props) $$invalidate(7, max_lines = $$props.max_lines);
		if ('style' in $$props) $$invalidate(8, style = $$props.style);
		if ('loading_status' in $$props) $$invalidate(9, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(10, mode = $$props.mode);
	};

	$$self.$capture_state = () => ({
		TextBox: Textbox$2,
		Block,
		StatusTracker,
		label,
		elem_id,
		value,
		lines,
		placeholder,
		form_position,
		show_label,
		max_lines,
		style,
		loading_status,
		mode
	});

	$$self.$inject_state = $$props => {
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('elem_id' in $$props) $$invalidate(2, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('lines' in $$props) $$invalidate(3, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(4, placeholder = $$props.placeholder);
		if ('form_position' in $$props) $$invalidate(5, form_position = $$props.form_position);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('max_lines' in $$props) $$invalidate(7, max_lines = $$props.max_lines);
		if ('style' in $$props) $$invalidate(8, style = $$props.style);
		if ('loading_status' in $$props) $$invalidate(9, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(10, mode = $$props.mode);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [
		value,
		label,
		elem_id,
		lines,
		placeholder,
		form_position,
		show_label,
		max_lines,
		style,
		loading_status,
		mode,
		textbox_value_binding,
		change_handler,
		submit_handler
	];
}

class Textbox extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance, create_fragment, safe_not_equal, {
			label: 1,
			elem_id: 2,
			value: 0,
			lines: 3,
			placeholder: 4,
			form_position: 5,
			show_label: 6,
			max_lines: 7,
			style: 8,
			loading_status: 9,
			mode: 10
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Textbox",
			options,
			id: create_fragment.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*lines*/ ctx[3] === undefined && !('lines' in props)) {
			console.warn("<Textbox> was created without expected prop 'lines'");
		}

		if (/*show_label*/ ctx[6] === undefined && !('show_label' in props)) {
			console.warn("<Textbox> was created without expected prop 'show_label'");
		}

		if (/*max_lines*/ ctx[7] === undefined && !('max_lines' in props)) {
			console.warn("<Textbox> was created without expected prop 'max_lines'");
		}

		if (/*loading_status*/ ctx[9] === undefined && !('loading_status' in props)) {
			console.warn("<Textbox> was created without expected prop 'loading_status'");
		}

		if (/*mode*/ ctx[10] === undefined && !('mode' in props)) {
			console.warn("<Textbox> was created without expected prop 'mode'");
		}
	}

	get label() {
		return this.$$.ctx[1];
	}

	set label(label) {
		this.$$set({ label });
		flush();
	}

	get elem_id() {
		return this.$$.ctx[2];
	}

	set elem_id(elem_id) {
		this.$$set({ elem_id });
		flush();
	}

	get value() {
		return this.$$.ctx[0];
	}

	set value(value) {
		this.$$set({ value });
		flush();
	}

	get lines() {
		return this.$$.ctx[3];
	}

	set lines(lines) {
		this.$$set({ lines });
		flush();
	}

	get placeholder() {
		return this.$$.ctx[4];
	}

	set placeholder(placeholder) {
		this.$$set({ placeholder });
		flush();
	}

	get form_position() {
		return this.$$.ctx[5];
	}

	set form_position(form_position) {
		this.$$set({ form_position });
		flush();
	}

	get show_label() {
		return this.$$.ctx[6];
	}

	set show_label(show_label) {
		this.$$set({ show_label });
		flush();
	}

	get max_lines() {
		return this.$$.ctx[7];
	}

	set max_lines(max_lines) {
		this.$$set({ max_lines });
		flush();
	}

	get style() {
		return this.$$.ctx[8];
	}

	set style(style) {
		this.$$set({ style });
		flush();
	}

	get loading_status() {
		return this.$$.ctx[9];
	}

	set loading_status(loading_status) {
		this.$$set({ loading_status });
		flush();
	}

	get mode() {
		return this.$$.ctx[10];
	}

	set mode(mode) {
		this.$$set({ mode });
		flush();
	}
}

var Textbox$1 = Textbox;

const modes = ["static", "dynamic"];

export { Textbox$1 as Component, modes };
