import { S as SvelteComponentDev, i as init, s as safe_not_equal, d as dispatch_dev, o as validate_each_argument, v as validate_slots, h as element, k as text, w as space, b as attr_dev, c as add_location, e as insert_dev, f as append_dev, m as set_data_dev, g as detach_dev, n as noop, u as destroy_each, a as svg_element, t as toggle_class, a7 as afterUpdate, N as src_url_equal, I as binding_callbacks, B as create_component, q as empty, C as mount_component, U as get_spread_update, V as get_spread_object, G as group_outros, E as transition_out, F as destroy_component, H as check_outros, D as transition_in, T as assign } from './index.e70bf722.js';

const getSaliencyColor = (value) => {
  var color = null;
  if (value < 0) {
    color = [52, 152, 219];
  } else {
    color = [231, 76, 60];
  }
  return colorToString(interpolate(Math.abs(value), [255, 255, 255], color));
};
const interpolate = (val, rgb1, rgb2) => {
  if (val > 1) {
    val = 1;
  }
  val = Math.sqrt(val);
  var rgb = [0, 0, 0];
  var i;
  for (i = 0; i < 3; i++) {
    rgb[i] = Math.round(rgb1[i] * (1 - val) + rgb2[i] * val);
  }
  return rgb;
};
const colorToString = (rgb) => {
  return "rgb(" + rgb[0] + ", " + rgb[1] + ", " + rgb[2] + ")";
};
const getObjectFitSize = (contains, containerWidth, containerHeight, width, height) => {
  var doRatio = width / height;
  var cRatio = containerWidth / containerHeight;
  var targetWidth = 0;
  var targetHeight = 0;
  var test = contains ? doRatio > cRatio : doRatio < cRatio;
  if (test) {
    targetWidth = containerWidth;
    targetHeight = targetWidth / doRatio;
  } else {
    targetHeight = containerHeight;
    targetWidth = targetHeight * doRatio;
  }
  return {
    width: targetWidth,
    height: targetHeight,
    x: (containerWidth - targetWidth) / 2,
    y: (containerHeight - targetHeight) / 2
  };
};

var Number_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Number.svelte generated by Svelte v3.47.0 */
const file$8 = "src/components/Interpretation/InterpretationComponents/Number.svelte";

function get_each_context$6(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[3] = list[i];
	return child_ctx;
}

// (9:2) {#each interpretation as interpret_value}
function create_each_block$6(ctx) {
	let div;
	let t0_value = /*interpret_value*/ ctx[3][0] + "";
	let t0;
	let t1;
	let div_style_value;

	const block = {
		c: function create() {
			div = element("div");
			t0 = text(t0_value);
			t1 = space();
			attr_dev(div, "class", "flex-1 s-uTdefN5mVHwT");
			attr_dev(div, "style", div_style_value = "background-color: " + getSaliencyColor(/*interpret_value*/ ctx[3][1]));
			add_location(div, file$8, 9, 3, 250);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
			append_dev(div, t0);
			append_dev(div, t1);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*interpretation*/ 1 && t0_value !== (t0_value = /*interpret_value*/ ctx[3][0] + "")) set_data_dev(t0, t0_value);

			if (dirty & /*interpretation*/ 1 && div_style_value !== (div_style_value = "background-color: " + getSaliencyColor(/*interpret_value*/ ctx[3][1]))) {
				attr_dev(div, "style", div_style_value);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block$6.name,
		type: "each",
		source: "(9:2) {#each interpretation as interpret_value}",
		ctx
	});

	return block;
}

function create_fragment$9(ctx) {
	let div1;
	let div0;
	let each_value = /*interpretation*/ ctx[0];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$6(get_each_context$6(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div1 = element("div");
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(div0, "class", "interpret_range flex s-uTdefN5mVHwT");
			add_location(div0, file$8, 7, 1, 168);
			attr_dev(div1, "class", "input-number s-uTdefN5mVHwT");
			add_location(div1, file$8, 6, 0, 140);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div1, anchor);
			append_dev(div1, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div0, null);
			}
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*getSaliencyColor, interpretation*/ 1) {
				each_value = /*interpretation*/ ctx[0];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$6(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$6(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div1);
			destroy_each(each_blocks, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$9.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$9($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Number', slots, []);
	let { original } = $$props;
	let { interpretation } = $$props;
	let { theme } = $$props;
	const writable_props = ['original', 'interpretation', 'theme'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Number> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('original' in $$props) $$invalidate(1, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
	};

	$$self.$capture_state = () => ({
		getSaliencyColor,
		original,
		interpretation,
		theme
	});

	$$self.$inject_state = $$props => {
		if ('original' in $$props) $$invalidate(1, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [interpretation, original, theme];
}

class Number extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$9, create_fragment$9, safe_not_equal, { original: 1, interpretation: 0, theme: 2 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Number",
			options,
			id: create_fragment$9.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*original*/ ctx[1] === undefined && !('original' in props)) {
			console.warn("<Number> was created without expected prop 'original'");
		}

		if (/*interpretation*/ ctx[0] === undefined && !('interpretation' in props)) {
			console.warn("<Number> was created without expected prop 'interpretation'");
		}

		if (/*theme*/ ctx[2] === undefined && !('theme' in props)) {
			console.warn("<Number> was created without expected prop 'theme'");
		}
	}

	get original() {
		throw new Error("<Number>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set original(value) {
		throw new Error("<Number>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get interpretation() {
		throw new Error("<Number>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Number>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Number>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Number>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Dropdown_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Dropdown.svelte generated by Svelte v3.47.0 */
const file$7 = "src/components/Interpretation/InterpretationComponents/Dropdown.svelte";

function get_each_context$5(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[4] = list[i];
	child_ctx[6] = i;
	return child_ctx;
}

// (10:2) {#each choices as choice, i}
function create_each_block$5(ctx) {
	let li;
	let t0_value = /*choice*/ ctx[4] + "";
	let t0;
	let t1;
	let li_style_value;

	const block = {
		c: function create() {
			li = element("li");
			t0 = text(t0_value);
			t1 = space();
			attr_dev(li, "class", "dropdown-item first:rounded-t transition last:rounded-b py-2 px-3 block whitespace-nowrap cursor-pointer s-Ql-wKMhxhqj8");
			attr_dev(li, "style", li_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[0][/*i*/ ctx[6]]));
			add_location(li, file$7, 10, 3, 259);
		},
		m: function mount(target, anchor) {
			insert_dev(target, li, anchor);
			append_dev(li, t0);
			append_dev(li, t1);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*choices*/ 4 && t0_value !== (t0_value = /*choice*/ ctx[4] + "")) set_data_dev(t0, t0_value);

			if (dirty & /*interpretation*/ 1 && li_style_value !== (li_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[0][/*i*/ ctx[6]]))) {
				attr_dev(li, "style", li_style_value);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(li);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block$5.name,
		type: "each",
		source: "(10:2) {#each choices as choice, i}",
		ctx
	});

	return block;
}

function create_fragment$8(ctx) {
	let div;
	let ul;
	let each_value = /*choices*/ ctx[2];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$5(get_each_context$5(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div = element("div");
			ul = element("ul");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(ul, "class", "dropdown-menu s-Ql-wKMhxhqj8");
			add_location(ul, file$7, 8, 1, 198);
			attr_dev(div, "class", "input-dropdown s-Ql-wKMhxhqj8");
			attr_dev(div, "theme", /*theme*/ ctx[1]);
			add_location(div, file$7, 7, 0, 160);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
			append_dev(div, ul);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(ul, null);
			}
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*getSaliencyColor, interpretation, choices*/ 5) {
				each_value = /*choices*/ ctx[2];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$5(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$5(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(ul, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*theme*/ 2) {
				attr_dev(div, "theme", /*theme*/ ctx[1]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			destroy_each(each_blocks, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$8.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$8($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Dropdown', slots, []);
	let { original } = $$props;
	let { interpretation } = $$props;
	let { theme } = $$props;
	let { choices } = $$props;
	const writable_props = ['original', 'interpretation', 'theme', 'choices'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Dropdown> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('original' in $$props) $$invalidate(3, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
		if ('choices' in $$props) $$invalidate(2, choices = $$props.choices);
	};

	$$self.$capture_state = () => ({
		getSaliencyColor,
		original,
		interpretation,
		theme,
		choices
	});

	$$self.$inject_state = $$props => {
		if ('original' in $$props) $$invalidate(3, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
		if ('choices' in $$props) $$invalidate(2, choices = $$props.choices);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [interpretation, theme, choices, original];
}

class Dropdown extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$8, create_fragment$8, safe_not_equal, {
			original: 3,
			interpretation: 0,
			theme: 1,
			choices: 2
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Dropdown",
			options,
			id: create_fragment$8.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*original*/ ctx[3] === undefined && !('original' in props)) {
			console.warn("<Dropdown> was created without expected prop 'original'");
		}

		if (/*interpretation*/ ctx[0] === undefined && !('interpretation' in props)) {
			console.warn("<Dropdown> was created without expected prop 'interpretation'");
		}

		if (/*theme*/ ctx[1] === undefined && !('theme' in props)) {
			console.warn("<Dropdown> was created without expected prop 'theme'");
		}

		if (/*choices*/ ctx[2] === undefined && !('choices' in props)) {
			console.warn("<Dropdown> was created without expected prop 'choices'");
		}
	}

	get original() {
		throw new Error("<Dropdown>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set original(value) {
		throw new Error("<Dropdown>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get interpretation() {
		throw new Error("<Dropdown>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Dropdown>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Dropdown>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Dropdown>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get choices() {
		throw new Error("<Dropdown>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set choices(value) {
		throw new Error("<Dropdown>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Checkbox_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Checkbox.svelte generated by Svelte v3.47.0 */
const file$6 = "src/components/Interpretation/InterpretationComponents/Checkbox.svelte";

function create_fragment$7(ctx) {
	let div2;
	let button;
	let div0;
	let div0_style_value;
	let t;
	let div1;
	let svg;
	let line0;
	let line1;
	let div1_style_value;

	const block = {
		c: function create() {
			div2 = element("div");
			button = element("button");
			div0 = element("div");
			t = space();
			div1 = element("div");
			svg = svg_element("svg");
			line0 = svg_element("line");
			line1 = svg_element("line");
			attr_dev(div0, "class", "checkbox w-4 h-4 bg-white flex items-center justify-center border border-gray-400 box-border s-JiGnucY2rT_2");
			attr_dev(div0, "style", div0_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][0]));
			add_location(div0, file$6, 11, 2, 300);
			attr_dev(line0, "x1", "-7.5");
			attr_dev(line0, "y1", "0");
			attr_dev(line0, "x2", "-2.5");
			attr_dev(line0, "y2", "5");
			attr_dev(line0, "stroke", "black");
			attr_dev(line0, "stroke-width", "4");
			attr_dev(line0, "stroke-linecap", "round");
			attr_dev(line0, "class", "s-JiGnucY2rT_2");
			add_location(line0, file$6, 20, 4, 728);
			attr_dev(line1, "x1", "-2.5");
			attr_dev(line1, "y1", "5");
			attr_dev(line1, "x2", "7.5");
			attr_dev(line1, "y2", "-7.5");
			attr_dev(line1, "stroke", "black");
			attr_dev(line1, "stroke-width", "4");
			attr_dev(line1, "stroke-linecap", "round");
			attr_dev(line1, "class", "s-JiGnucY2rT_2");
			add_location(line1, file$6, 29, 4, 869);
			attr_dev(svg, "class", "check h-3 w-4 s-JiGnucY2rT_2");
			attr_dev(svg, "viewBox", "-10 -10 20 20");
			add_location(svg, file$6, 19, 3, 672);
			attr_dev(div1, "class", "checkbox w-4 h-4 bg-white flex items-center justify-center border border-gray-400 box-border s-JiGnucY2rT_2");
			attr_dev(div1, "style", div1_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][1]));
			add_location(div1, file$6, 15, 2, 486);
			attr_dev(button, "class", "checkbox-item py-2 px-3 rounded cursor-pointer flex gap-1 s-JiGnucY2rT_2");
			toggle_class(button, "selected", /*original*/ ctx[0]);
			add_location(button, file$6, 7, 1, 191);
			attr_dev(div2, "class", "input-checkbox inline-block s-JiGnucY2rT_2");
			attr_dev(div2, "theme", /*theme*/ ctx[2]);
			add_location(div2, file$6, 6, 0, 140);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div2, anchor);
			append_dev(div2, button);
			append_dev(button, div0);
			append_dev(button, t);
			append_dev(button, div1);
			append_dev(div1, svg);
			append_dev(svg, line0);
			append_dev(svg, line1);
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*interpretation*/ 2 && div0_style_value !== (div0_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][0]))) {
				attr_dev(div0, "style", div0_style_value);
			}

			if (dirty & /*interpretation*/ 2 && div1_style_value !== (div1_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][1]))) {
				attr_dev(div1, "style", div1_style_value);
			}

			if (dirty & /*original*/ 1) {
				toggle_class(button, "selected", /*original*/ ctx[0]);
			}

			if (dirty & /*theme*/ 4) {
				attr_dev(div2, "theme", /*theme*/ ctx[2]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div2);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$7.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$7($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Checkbox', slots, []);
	let { original } = $$props;
	let { interpretation } = $$props;
	let { theme } = $$props;
	const writable_props = ['original', 'interpretation', 'theme'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Checkbox> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
	};

	$$self.$capture_state = () => ({
		getSaliencyColor,
		original,
		interpretation,
		theme
	});

	$$self.$inject_state = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [original, interpretation, theme];
}

class Checkbox extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$7, create_fragment$7, safe_not_equal, { original: 0, interpretation: 1, theme: 2 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Checkbox",
			options,
			id: create_fragment$7.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*original*/ ctx[0] === undefined && !('original' in props)) {
			console.warn("<Checkbox> was created without expected prop 'original'");
		}

		if (/*interpretation*/ ctx[1] === undefined && !('interpretation' in props)) {
			console.warn("<Checkbox> was created without expected prop 'interpretation'");
		}

		if (/*theme*/ ctx[2] === undefined && !('theme' in props)) {
			console.warn("<Checkbox> was created without expected prop 'theme'");
		}
	}

	get original() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set original(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get interpretation() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var CheckboxGroup_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/CheckboxGroup.svelte generated by Svelte v3.47.0 */
const file$5 = "src/components/Interpretation/InterpretationComponents/CheckboxGroup.svelte";

function get_each_context$4(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[4] = list[i];
	child_ctx[6] = i;
	return child_ctx;
}

// (9:1) {#each choices as choice, i}
function create_each_block$4(ctx) {
	let button;
	let div0;
	let div0_style_value;
	let t0;
	let div1;
	let svg;
	let line0;
	let line1;
	let div1_style_value;
	let t1;
	let t2_value = /*choice*/ ctx[4] + "";
	let t2;
	let t3;

	const block = {
		c: function create() {
			button = element("button");
			div0 = element("div");
			t0 = space();
			div1 = element("div");
			svg = svg_element("svg");
			line0 = svg_element("line");
			line1 = svg_element("line");
			t1 = space();
			t2 = text(t2_value);
			t3 = space();
			attr_dev(div0, "class", "checkbox w-4 h-4 bg-white flex items-center justify-center border border-gray-400 box-border s-RjVXlaqc02rO");
			attr_dev(div0, "style", div0_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][/*i*/ ctx[6]][0]));
			add_location(div0, file$5, 13, 3, 413);
			attr_dev(line0, "x1", "-7.5");
			attr_dev(line0, "y1", "0");
			attr_dev(line0, "x2", "-2.5");
			attr_dev(line0, "y2", "5");
			attr_dev(line0, "stroke", "black");
			attr_dev(line0, "stroke-width", "4");
			attr_dev(line0, "stroke-linecap", "round");
			attr_dev(line0, "class", "s-RjVXlaqc02rO");
			add_location(line0, file$5, 22, 5, 856);
			attr_dev(line1, "x1", "-2.5");
			attr_dev(line1, "y1", "5");
			attr_dev(line1, "x2", "7.5");
			attr_dev(line1, "y2", "-7.5");
			attr_dev(line1, "stroke", "black");
			attr_dev(line1, "stroke-width", "4");
			attr_dev(line1, "stroke-linecap", "round");
			attr_dev(line1, "class", "s-RjVXlaqc02rO");
			add_location(line1, file$5, 31, 5, 1006);
			attr_dev(svg, "class", "check h-3 w-4 s-RjVXlaqc02rO");
			attr_dev(svg, "viewBox", "-10 -10 20 20");
			add_location(svg, file$5, 21, 4, 799);
			attr_dev(div1, "class", "checkbox w-4 h-4 bg-white flex items-center justify-center border border-gray-400 box-border s-RjVXlaqc02rO");
			attr_dev(div1, "style", div1_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][/*i*/ ctx[6]][1]));
			add_location(div1, file$5, 17, 3, 606);
			attr_dev(button, "class", "checkbox-item py-2 px-3 font-semibold rounded cursor-pointer flex items-center gap-1 s-RjVXlaqc02rO");
			toggle_class(button, "selected", /*original*/ ctx[0].includes(/*choice*/ ctx[4]));
			add_location(button, file$5, 9, 2, 256);
		},
		m: function mount(target, anchor) {
			insert_dev(target, button, anchor);
			append_dev(button, div0);
			append_dev(button, t0);
			append_dev(button, div1);
			append_dev(div1, svg);
			append_dev(svg, line0);
			append_dev(svg, line1);
			append_dev(button, t1);
			append_dev(button, t2);
			append_dev(button, t3);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*interpretation*/ 2 && div0_style_value !== (div0_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][/*i*/ ctx[6]][0]))) {
				attr_dev(div0, "style", div0_style_value);
			}

			if (dirty & /*interpretation*/ 2 && div1_style_value !== (div1_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][/*i*/ ctx[6]][1]))) {
				attr_dev(div1, "style", div1_style_value);
			}

			if (dirty & /*choices*/ 4 && t2_value !== (t2_value = /*choice*/ ctx[4] + "")) set_data_dev(t2, t2_value);

			if (dirty & /*original, choices*/ 5) {
				toggle_class(button, "selected", /*original*/ ctx[0].includes(/*choice*/ ctx[4]));
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(button);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block$4.name,
		type: "each",
		source: "(9:1) {#each choices as choice, i}",
		ctx
	});

	return block;
}

function create_fragment$6(ctx) {
	let div;
	let each_value = /*choices*/ ctx[2];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$4(get_each_context$4(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(div, "class", "input-checkbox-group flex flex-wrap gap-2 s-RjVXlaqc02rO");
			attr_dev(div, "theme", /*theme*/ ctx[3]);
			add_location(div, file$5, 7, 0, 160);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*original, choices, getSaliencyColor, interpretation*/ 7) {
				each_value = /*choices*/ ctx[2];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$4(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$4(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*theme*/ 8) {
				attr_dev(div, "theme", /*theme*/ ctx[3]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			destroy_each(each_blocks, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$6.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$6($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('CheckboxGroup', slots, []);
	let { original } = $$props;
	let { interpretation } = $$props;
	let { choices } = $$props;
	let { theme } = $$props;
	const writable_props = ['original', 'interpretation', 'choices', 'theme'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<CheckboxGroup> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('choices' in $$props) $$invalidate(2, choices = $$props.choices);
		if ('theme' in $$props) $$invalidate(3, theme = $$props.theme);
	};

	$$self.$capture_state = () => ({
		getSaliencyColor,
		original,
		interpretation,
		choices,
		theme
	});

	$$self.$inject_state = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('choices' in $$props) $$invalidate(2, choices = $$props.choices);
		if ('theme' in $$props) $$invalidate(3, theme = $$props.theme);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [original, interpretation, choices, theme];
}

class CheckboxGroup extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$6, create_fragment$6, safe_not_equal, {
			original: 0,
			interpretation: 1,
			choices: 2,
			theme: 3
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "CheckboxGroup",
			options,
			id: create_fragment$6.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*original*/ ctx[0] === undefined && !('original' in props)) {
			console.warn("<CheckboxGroup> was created without expected prop 'original'");
		}

		if (/*interpretation*/ ctx[1] === undefined && !('interpretation' in props)) {
			console.warn("<CheckboxGroup> was created without expected prop 'interpretation'");
		}

		if (/*choices*/ ctx[2] === undefined && !('choices' in props)) {
			console.warn("<CheckboxGroup> was created without expected prop 'choices'");
		}

		if (/*theme*/ ctx[3] === undefined && !('theme' in props)) {
			console.warn("<CheckboxGroup> was created without expected prop 'theme'");
		}
	}

	get original() {
		throw new Error("<CheckboxGroup>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set original(value) {
		throw new Error("<CheckboxGroup>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get interpretation() {
		throw new Error("<CheckboxGroup>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<CheckboxGroup>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get choices() {
		throw new Error("<CheckboxGroup>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set choices(value) {
		throw new Error("<CheckboxGroup>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<CheckboxGroup>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<CheckboxGroup>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Slider_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Slider.svelte generated by Svelte v3.47.0 */
const file$4 = "src/components/Interpretation/InterpretationComponents/Slider.svelte";

function get_each_context$3(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[6] = list[i];
	return child_ctx;
}

// (21:2) {#each interpretation as interpret_value}
function create_each_block$3(ctx) {
	let div;
	let div_style_value;

	const block = {
		c: function create() {
			div = element("div");
			attr_dev(div, "class", "flex-1 h-4 s-NPdY_efjXDn5");
			attr_dev(div, "style", div_style_value = "background-color: " + getSaliencyColor(/*interpret_value*/ ctx[6]));
			add_location(div, file$4, 21, 3, 493);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*interpretation*/ 2 && div_style_value !== (div_style_value = "background-color: " + getSaliencyColor(/*interpret_value*/ ctx[6]))) {
				attr_dev(div, "style", div_style_value);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block$3.name,
		type: "each",
		source: "(21:2) {#each interpretation as interpret_value}",
		ctx
	});

	return block;
}

function create_fragment$5(ctx) {
	let div2;
	let input;
	let t0;
	let div0;
	let t1;
	let div1;
	let t2;
	let each_value = /*interpretation*/ ctx[1];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$3(get_each_context$3(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div2 = element("div");
			input = element("input");
			t0 = space();
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t1 = space();
			div1 = element("div");
			t2 = text(/*original*/ ctx[0]);
			attr_dev(input, "type", "range");
			attr_dev(input, "class", "range w-full appearance-none transition rounded h-4 bg-blue-400 s-NPdY_efjXDn5");
			input.disabled = true;
			attr_dev(input, "original", /*original*/ ctx[0]);
			attr_dev(input, "min", /*minimum*/ ctx[3]);
			attr_dev(input, "max", /*maximum*/ ctx[4]);
			attr_dev(input, "step", /*step*/ ctx[5]);
			add_location(input, file$4, 10, 1, 245);
			attr_dev(div0, "class", "interpret_range flex s-NPdY_efjXDn5");
			add_location(div0, file$4, 19, 1, 411);
			attr_dev(div1, "class", "original inline-block mx-auto mt-1 px-2 py-0.5 rounded s-NPdY_efjXDn5");
			add_location(div1, file$4, 27, 1, 615);
			attr_dev(div2, "class", "input-slider text-center s-NPdY_efjXDn5");
			attr_dev(div2, "theme", /*theme*/ ctx[2]);
			add_location(div2, file$4, 9, 0, 197);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div2, anchor);
			append_dev(div2, input);
			append_dev(div2, t0);
			append_dev(div2, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div0, null);
			}

			append_dev(div2, t1);
			append_dev(div2, div1);
			append_dev(div1, t2);
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*original*/ 1) {
				attr_dev(input, "original", /*original*/ ctx[0]);
			}

			if (dirty & /*minimum*/ 8) {
				attr_dev(input, "min", /*minimum*/ ctx[3]);
			}

			if (dirty & /*maximum*/ 16) {
				attr_dev(input, "max", /*maximum*/ ctx[4]);
			}

			if (dirty & /*step*/ 32) {
				attr_dev(input, "step", /*step*/ ctx[5]);
			}

			if (dirty & /*getSaliencyColor, interpretation*/ 2) {
				each_value = /*interpretation*/ ctx[1];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$3(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$3(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*original*/ 1) set_data_dev(t2, /*original*/ ctx[0]);

			if (dirty & /*theme*/ 4) {
				attr_dev(div2, "theme", /*theme*/ ctx[2]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div2);
			destroy_each(each_blocks, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$5.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$5($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Slider', slots, []);
	let { original } = $$props;
	let { interpretation } = $$props;
	let { theme } = $$props;
	let { minimum } = $$props;
	let { maximum } = $$props;
	let { step } = $$props;
	const writable_props = ['original', 'interpretation', 'theme', 'minimum', 'maximum', 'step'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Slider> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
		if ('minimum' in $$props) $$invalidate(3, minimum = $$props.minimum);
		if ('maximum' in $$props) $$invalidate(4, maximum = $$props.maximum);
		if ('step' in $$props) $$invalidate(5, step = $$props.step);
	};

	$$self.$capture_state = () => ({
		getSaliencyColor,
		original,
		interpretation,
		theme,
		minimum,
		maximum,
		step
	});

	$$self.$inject_state = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
		if ('minimum' in $$props) $$invalidate(3, minimum = $$props.minimum);
		if ('maximum' in $$props) $$invalidate(4, maximum = $$props.maximum);
		if ('step' in $$props) $$invalidate(5, step = $$props.step);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [original, interpretation, theme, minimum, maximum, step];
}

class Slider extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$5, create_fragment$5, safe_not_equal, {
			original: 0,
			interpretation: 1,
			theme: 2,
			minimum: 3,
			maximum: 4,
			step: 5
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Slider",
			options,
			id: create_fragment$5.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*original*/ ctx[0] === undefined && !('original' in props)) {
			console.warn("<Slider> was created without expected prop 'original'");
		}

		if (/*interpretation*/ ctx[1] === undefined && !('interpretation' in props)) {
			console.warn("<Slider> was created without expected prop 'interpretation'");
		}

		if (/*theme*/ ctx[2] === undefined && !('theme' in props)) {
			console.warn("<Slider> was created without expected prop 'theme'");
		}

		if (/*minimum*/ ctx[3] === undefined && !('minimum' in props)) {
			console.warn("<Slider> was created without expected prop 'minimum'");
		}

		if (/*maximum*/ ctx[4] === undefined && !('maximum' in props)) {
			console.warn("<Slider> was created without expected prop 'maximum'");
		}

		if (/*step*/ ctx[5] === undefined && !('step' in props)) {
			console.warn("<Slider> was created without expected prop 'step'");
		}
	}

	get original() {
		throw new Error("<Slider>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set original(value) {
		throw new Error("<Slider>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get interpretation() {
		throw new Error("<Slider>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Slider>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Slider>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Slider>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get minimum() {
		throw new Error("<Slider>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set minimum(value) {
		throw new Error("<Slider>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get maximum() {
		throw new Error("<Slider>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set maximum(value) {
		throw new Error("<Slider>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get step() {
		throw new Error("<Slider>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set step(value) {
		throw new Error("<Slider>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Radio_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Radio.svelte generated by Svelte v3.47.0 */
const file$3 = "src/components/Interpretation/InterpretationComponents/Radio.svelte";

function get_each_context$2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[4] = list[i];
	child_ctx[6] = i;
	return child_ctx;
}

// (9:1) {#each choices as choice, i}
function create_each_block$2(ctx) {
	let button;
	let div;
	let div_style_value;
	let t0;
	let t1_value = /*choice*/ ctx[4] + "";
	let t1;
	let t2;

	const block = {
		c: function create() {
			button = element("button");
			div = element("div");
			t0 = space();
			t1 = text(t1_value);
			t2 = space();
			attr_dev(div, "class", "radio-circle w-4 h-4 rounded-full box-border s-pVKicsqg3oyO");
			attr_dev(div, "style", div_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][/*i*/ ctx[6]]));
			add_location(div, file$3, 13, 3, 395);
			attr_dev(button, "class", "radio-item py-2 px-3 font-semibold rounded cursor-pointer flex items-center gap-2 s-pVKicsqg3oyO");
			toggle_class(button, "selected", /*original*/ ctx[0] === /*choice*/ ctx[4]);
			add_location(button, file$3, 9, 2, 247);
		},
		m: function mount(target, anchor) {
			insert_dev(target, button, anchor);
			append_dev(button, div);
			append_dev(button, t0);
			append_dev(button, t1);
			append_dev(button, t2);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*interpretation*/ 2 && div_style_value !== (div_style_value = "background-color: " + getSaliencyColor(/*interpretation*/ ctx[1][/*i*/ ctx[6]]))) {
				attr_dev(div, "style", div_style_value);
			}

			if (dirty & /*choices*/ 8 && t1_value !== (t1_value = /*choice*/ ctx[4] + "")) set_data_dev(t1, t1_value);

			if (dirty & /*original, choices*/ 9) {
				toggle_class(button, "selected", /*original*/ ctx[0] === /*choice*/ ctx[4]);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(button);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block$2.name,
		type: "each",
		source: "(9:1) {#each choices as choice, i}",
		ctx
	});

	return block;
}

function create_fragment$4(ctx) {
	let div;
	let each_value = /*choices*/ ctx[3];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$2(get_each_context$2(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(div, "class", "input-radio flex flex-wrap gap-2 s-pVKicsqg3oyO");
			attr_dev(div, "theme", /*theme*/ ctx[2]);
			add_location(div, file$3, 7, 0, 160);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*original, choices, getSaliencyColor, interpretation*/ 11) {
				each_value = /*choices*/ ctx[3];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$2(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$2(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*theme*/ 4) {
				attr_dev(div, "theme", /*theme*/ ctx[2]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			destroy_each(each_blocks, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$4.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$4($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Radio', slots, []);
	let { original } = $$props;
	let { interpretation } = $$props;
	let { theme } = $$props;
	let { choices } = $$props;
	const writable_props = ['original', 'interpretation', 'theme', 'choices'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Radio> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
		if ('choices' in $$props) $$invalidate(3, choices = $$props.choices);
	};

	$$self.$capture_state = () => ({
		getSaliencyColor,
		original,
		interpretation,
		theme,
		choices
	});

	$$self.$inject_state = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(1, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(2, theme = $$props.theme);
		if ('choices' in $$props) $$invalidate(3, choices = $$props.choices);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [original, interpretation, theme, choices];
}

class Radio extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$4, create_fragment$4, safe_not_equal, {
			original: 0,
			interpretation: 1,
			theme: 2,
			choices: 3
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Radio",
			options,
			id: create_fragment$4.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*original*/ ctx[0] === undefined && !('original' in props)) {
			console.warn("<Radio> was created without expected prop 'original'");
		}

		if (/*interpretation*/ ctx[1] === undefined && !('interpretation' in props)) {
			console.warn("<Radio> was created without expected prop 'interpretation'");
		}

		if (/*theme*/ ctx[2] === undefined && !('theme' in props)) {
			console.warn("<Radio> was created without expected prop 'theme'");
		}

		if (/*choices*/ ctx[3] === undefined && !('choices' in props)) {
			console.warn("<Radio> was created without expected prop 'choices'");
		}
	}

	get original() {
		throw new Error("<Radio>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set original(value) {
		throw new Error("<Radio>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get interpretation() {
		throw new Error("<Radio>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Radio>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Radio>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Radio>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get choices() {
		throw new Error("<Radio>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set choices(value) {
		throw new Error("<Radio>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Image_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Image.svelte generated by Svelte v3.47.0 */
const file$2 = "src/components/Interpretation/InterpretationComponents/Image.svelte";

function create_fragment$3(ctx) {
	let div2;
	let div1;
	let div0;
	let canvas;
	let t;
	let img;
	let img_src_value;

	const block = {
		c: function create() {
			div2 = element("div");
			div1 = element("div");
			div0 = element("div");
			canvas = element("canvas");
			t = space();
			img = element("img");
			attr_dev(canvas, "class", "s-AlCWw94wKh3x");
			add_location(canvas, file$2, 42, 3, 1492);
			attr_dev(div0, "class", "interpretation w-full h-full absolute top-0 left-0 flex justify-center items-center opacity-90 hover:opacity-20 transition s-AlCWw94wKh3x");
			add_location(div0, file$2, 39, 2, 1346);
			attr_dev(img, "class", "w-full h-full object-contain s-AlCWw94wKh3x");
			if (!src_url_equal(img.src, img_src_value = /*original*/ ctx[0])) attr_dev(img, "src", img_src_value);
			add_location(img, file$2, 45, 2, 1589);
			attr_dev(div1, "class", "image-preview w-full h-60 flex justify-center items-center bg-gray-200 dark:bg-gray-600 relative s-AlCWw94wKh3x");
			add_location(div1, file$2, 35, 1, 1181);
			attr_dev(div2, "class", "input-image s-AlCWw94wKh3x");
			add_location(div2, file$2, 34, 0, 1154);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div2, anchor);
			append_dev(div2, div1);
			append_dev(div1, div0);
			append_dev(div0, canvas);
			/*canvas_binding*/ ctx[5](canvas);
			append_dev(div1, t);
			append_dev(div1, img);
			/*img_binding*/ ctx[6](img);
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*original*/ 1 && !src_url_equal(img.src, img_src_value = /*original*/ ctx[0])) {
				attr_dev(img, "src", img_src_value);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div2);
			/*canvas_binding*/ ctx[5](null);
			/*img_binding*/ ctx[6](null);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$3.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$3($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Image', slots, []);
	let { original } = $$props;
	let { interpretation } = $$props;
	let { shape } = $$props;
	let saliency_layer;
	let image;

	const paintSaliency = (data, ctx, width, height) => {
		var cell_width = width / data[0].length;
		var cell_height = height / data.length;
		var r = 0;

		data.forEach(function (row) {
			var c = 0;

			row.forEach(function (cell) {
				ctx.fillStyle = getSaliencyColor(cell);
				ctx.fillRect(c * cell_width, r * cell_height, cell_width, cell_height);
				c++;
			});

			r++;
		});
	};

	afterUpdate(() => {
		let size = getObjectFitSize(true, image.width, image.height, image.naturalWidth, image.naturalHeight);

		if (shape) {
			size = getObjectFitSize(true, size.width, size.height, shape[0], shape[1]);
		}

		let width = size.width;
		let height = size.height;
		saliency_layer.setAttribute("height", `${height}`);
		saliency_layer.setAttribute("width", `${width}`);
		paintSaliency(interpretation, saliency_layer.getContext("2d"), width, height);
	});

	const writable_props = ['original', 'interpretation', 'shape'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Image> was created with unknown prop '${key}'`);
	});

	function canvas_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			saliency_layer = $$value;
			$$invalidate(1, saliency_layer);
		});
	}

	function img_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			image = $$value;
			$$invalidate(2, image);
		});
	}

	$$self.$$set = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(3, interpretation = $$props.interpretation);
		if ('shape' in $$props) $$invalidate(4, shape = $$props.shape);
	};

	$$self.$capture_state = () => ({
		getSaliencyColor,
		getObjectFitSize,
		afterUpdate,
		original,
		interpretation,
		shape,
		saliency_layer,
		image,
		paintSaliency
	});

	$$self.$inject_state = $$props => {
		if ('original' in $$props) $$invalidate(0, original = $$props.original);
		if ('interpretation' in $$props) $$invalidate(3, interpretation = $$props.interpretation);
		if ('shape' in $$props) $$invalidate(4, shape = $$props.shape);
		if ('saliency_layer' in $$props) $$invalidate(1, saliency_layer = $$props.saliency_layer);
		if ('image' in $$props) $$invalidate(2, image = $$props.image);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [
		original,
		saliency_layer,
		image,
		interpretation,
		shape,
		canvas_binding,
		img_binding
	];
}

class Image extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$3, create_fragment$3, safe_not_equal, { original: 0, interpretation: 3, shape: 4 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Image",
			options,
			id: create_fragment$3.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*original*/ ctx[0] === undefined && !('original' in props)) {
			console.warn("<Image> was created without expected prop 'original'");
		}

		if (/*interpretation*/ ctx[3] === undefined && !('interpretation' in props)) {
			console.warn("<Image> was created without expected prop 'interpretation'");
		}

		if (/*shape*/ ctx[4] === undefined && !('shape' in props)) {
			console.warn("<Image> was created without expected prop 'shape'");
		}
	}

	get original() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set original(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get interpretation() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get shape() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set shape(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Audio_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Audio.svelte generated by Svelte v3.47.0 */
const file$1 = "src/components/Interpretation/InterpretationComponents/Audio.svelte";

function get_each_context$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[2] = list[i];
	return child_ctx;
}

// (8:2) {#each interpretation as interpret_value}
function create_each_block$1(ctx) {
	let div;
	let div_style_value;

	const block = {
		c: function create() {
			div = element("div");
			attr_dev(div, "class", "flex-1 h-4 s-DXPuypThOt-p");
			attr_dev(div, "style", div_style_value = "background-color: " + getSaliencyColor(/*interpret_value*/ ctx[2]));
			add_location(div, file$1, 8, 3, 236);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*interpretation*/ 1 && div_style_value !== (div_style_value = "background-color: " + getSaliencyColor(/*interpret_value*/ ctx[2]))) {
				attr_dev(div, "style", div_style_value);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block$1.name,
		type: "each",
		source: "(8:2) {#each interpretation as interpret_value}",
		ctx
	});

	return block;
}

function create_fragment$2(ctx) {
	let div1;
	let div0;
	let each_value = /*interpretation*/ ctx[0];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div1 = element("div");
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(div0, "class", "interpret_range flex s-DXPuypThOt-p");
			add_location(div0, file$1, 6, 1, 154);
			attr_dev(div1, "class", "input-audio s-DXPuypThOt-p");
			attr_dev(div1, "theme", /*theme*/ ctx[1]);
			add_location(div1, file$1, 5, 0, 119);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div1, anchor);
			append_dev(div1, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div0, null);
			}
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*getSaliencyColor, interpretation*/ 1) {
				each_value = /*interpretation*/ ctx[0];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$1(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*theme*/ 2) {
				attr_dev(div1, "theme", /*theme*/ ctx[1]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div1);
			destroy_each(each_blocks, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$2.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$2($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Audio', slots, []);
	let { interpretation } = $$props;
	let { theme } = $$props;
	const writable_props = ['interpretation', 'theme'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Audio> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
	};

	$$self.$capture_state = () => ({ getSaliencyColor, interpretation, theme });

	$$self.$inject_state = $$props => {
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [interpretation, theme];
}

class Audio extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$2, create_fragment$2, safe_not_equal, { interpretation: 0, theme: 1 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Audio",
			options,
			id: create_fragment$2.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*interpretation*/ ctx[0] === undefined && !('interpretation' in props)) {
			console.warn("<Audio> was created without expected prop 'interpretation'");
		}

		if (/*theme*/ ctx[1] === undefined && !('theme' in props)) {
			console.warn("<Audio> was created without expected prop 'theme'");
		}
	}

	get interpretation() {
		throw new Error("<Audio>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Audio>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Audio>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Audio>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Textbox_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/InterpretationComponents/Textbox.svelte generated by Svelte v3.47.0 */
const file = "src/components/Interpretation/InterpretationComponents/Textbox.svelte";

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[2] = list[i][0];
	child_ctx[3] = list[i][1];
	return child_ctx;
}

// (7:1) {#each interpretation as [text, saliency]}
function create_each_block(ctx) {
	let span;
	let t0_value = /*text*/ ctx[2] + "";
	let t0;
	let t1;
	let span_style_value;

	const block = {
		c: function create() {
			span = element("span");
			t0 = text(t0_value);
			t1 = space();
			attr_dev(span, "class", "textspan p-1 bg-opacity-20 dark:bg-opacity-80 s-bU-RZ3mFqFKf");
			attr_dev(span, "style", span_style_value = "background-color: " + getSaliencyColor(/*saliency*/ ctx[3]));
			add_location(span, file, 7, 2, 239);
		},
		m: function mount(target, anchor) {
			insert_dev(target, span, anchor);
			append_dev(span, t0);
			append_dev(span, t1);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*interpretation*/ 1 && t0_value !== (t0_value = /*text*/ ctx[2] + "")) set_data_dev(t0, t0_value);

			if (dirty & /*interpretation*/ 1 && span_style_value !== (span_style_value = "background-color: " + getSaliencyColor(/*saliency*/ ctx[3]))) {
				attr_dev(span, "style", span_style_value);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(span);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block.name,
		type: "each",
		source: "(7:1) {#each interpretation as [text, saliency]}",
		ctx
	});

	return block;
}

function create_fragment$1(ctx) {
	let div;
	let each_value = /*interpretation*/ ctx[0];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(div, "class", "input-text w-full rounded box-border p-2 break-word s-bU-RZ3mFqFKf");
			attr_dev(div, "theme", /*theme*/ ctx[1]);
			add_location(div, file, 5, 0, 119);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*getSaliencyColor, interpretation*/ 1) {
				each_value = /*interpretation*/ ctx[0];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*theme*/ 2) {
				attr_dev(div, "theme", /*theme*/ ctx[1]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			destroy_each(each_blocks, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$1.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$1($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Textbox', slots, []);
	let { interpretation } = $$props;
	let { theme } = $$props;
	const writable_props = ['interpretation', 'theme'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Textbox> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
	};

	$$self.$capture_state = () => ({ getSaliencyColor, interpretation, theme });

	$$self.$inject_state = $$props => {
		if ('interpretation' in $$props) $$invalidate(0, interpretation = $$props.interpretation);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [interpretation, theme];
}

class Textbox extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { interpretation: 0, theme: 1 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Textbox",
			options,
			id: create_fragment$1.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*interpretation*/ ctx[0] === undefined && !('interpretation' in props)) {
			console.warn("<Textbox> was created without expected prop 'interpretation'");
		}

		if (/*theme*/ ctx[1] === undefined && !('theme' in props)) {
			console.warn("<Textbox> was created without expected prop 'theme'");
		}
	}

	get interpretation() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set interpretation(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Textbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Textbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

const component_map = {
  audio: Audio,
  dropdown: Dropdown,
  checkbox: Checkbox,
  checkboxgroup: CheckboxGroup,
  number: Number,
  slider: Slider,
  radio: Radio,
  image: Image,
  textbox: Textbox
};

var Interpretation_svelte_svelte_type_style_lang = '';

/* src/components/Interpretation/Interpretation.svelte generated by Svelte v3.47.0 */

// (7:0) {#if value}
function create_if_block(ctx) {
	let switch_instance;
	let switch_instance_anchor;
	let current;

	const switch_instance_spread_levels = [
		/*component_props*/ ctx[1],
		{ original: /*value*/ ctx[2].original },
		{
			interpretation: /*value*/ ctx[2].interpretation
		}
	];

	var switch_value = component_map[/*component*/ ctx[0]];

	function switch_props(ctx) {
		let switch_instance_props = {};

		for (let i = 0; i < switch_instance_spread_levels.length; i += 1) {
			switch_instance_props = assign(switch_instance_props, switch_instance_spread_levels[i]);
		}

		return {
			props: switch_instance_props,
			$$inline: true
		};
	}

	if (switch_value) {
		switch_instance = new switch_value(switch_props());
	}

	const block = {
		c: function create() {
			if (switch_instance) create_component(switch_instance.$$.fragment);
			switch_instance_anchor = empty();
		},
		m: function mount(target, anchor) {
			if (switch_instance) {
				mount_component(switch_instance, target, anchor);
			}

			insert_dev(target, switch_instance_anchor, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const switch_instance_changes = (dirty & /*component_props, value*/ 6)
			? get_spread_update(switch_instance_spread_levels, [
					dirty & /*component_props*/ 2 && get_spread_object(/*component_props*/ ctx[1]),
					dirty & /*value*/ 4 && { original: /*value*/ ctx[2].original },
					dirty & /*value*/ 4 && {
						interpretation: /*value*/ ctx[2].interpretation
					}
				])
			: {};

			if (switch_value !== (switch_value = component_map[/*component*/ ctx[0]])) {
				if (switch_instance) {
					group_outros();
					const old_component = switch_instance;

					transition_out(old_component.$$.fragment, 1, 0, () => {
						destroy_component(old_component, 1);
					});

					check_outros();
				}

				if (switch_value) {
					switch_instance = new switch_value(switch_props());
					create_component(switch_instance.$$.fragment);
					transition_in(switch_instance.$$.fragment, 1);
					mount_component(switch_instance, switch_instance_anchor.parentNode, switch_instance_anchor);
				} else {
					switch_instance = null;
				}
			} else if (switch_value) {
				switch_instance.$set(switch_instance_changes);
			}
		},
		i: function intro(local) {
			if (current) return;
			if (switch_instance) transition_in(switch_instance.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			if (switch_instance) transition_out(switch_instance.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(switch_instance_anchor);
			if (switch_instance) destroy_component(switch_instance, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block.name,
		type: "if",
		source: "(7:0) {#if value}",
		ctx
	});

	return block;
}

function create_fragment(ctx) {
	let if_block_anchor;
	let current;
	let if_block = /*value*/ ctx[2] && create_if_block(ctx);

	const block = {
		c: function create() {
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			if (/*value*/ ctx[2]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*value*/ 4) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			if (if_block) if_block.d(detaching);
			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Interpretation', slots, []);
	let { component } = $$props;
	let { component_props } = $$props;
	let { value } = $$props;
	const writable_props = ['component', 'component_props', 'value'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Interpretation> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('component' in $$props) $$invalidate(0, component = $$props.component);
		if ('component_props' in $$props) $$invalidate(1, component_props = $$props.component_props);
		if ('value' in $$props) $$invalidate(2, value = $$props.value);
	};

	$$self.$capture_state = () => ({
		component_map,
		component,
		component_props,
		value
	});

	$$self.$inject_state = $$props => {
		if ('component' in $$props) $$invalidate(0, component = $$props.component);
		if ('component_props' in $$props) $$invalidate(1, component_props = $$props.component_props);
		if ('value' in $$props) $$invalidate(2, value = $$props.value);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [component, component_props, value];
}

class Interpretation extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance, create_fragment, safe_not_equal, {
			component: 0,
			component_props: 1,
			value: 2
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Interpretation",
			options,
			id: create_fragment.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*component*/ ctx[0] === undefined && !('component' in props)) {
			console.warn("<Interpretation> was created without expected prop 'component'");
		}

		if (/*component_props*/ ctx[1] === undefined && !('component_props' in props)) {
			console.warn("<Interpretation> was created without expected prop 'component_props'");
		}

		if (/*value*/ ctx[2] === undefined && !('value' in props)) {
			console.warn("<Interpretation> was created without expected prop 'value'");
		}
	}

	get component() {
		throw new Error("<Interpretation>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set component(value) {
		throw new Error("<Interpretation>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get component_props() {
		throw new Error("<Interpretation>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set component_props(value) {
		throw new Error("<Interpretation>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get value() {
		throw new Error("<Interpretation>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<Interpretation>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Interpretation$1 = Interpretation;

const modes = ["dynamic"];

export { Interpretation$1 as Component, modes };
