import { S as SvelteComponentDev, i as init, s as safe_not_equal, d as dispatch_dev, v as validate_slots, y as createEventDispatcher, h as element, w as space, k as text, b as attr_dev, c as add_location, t as toggle_class, e as insert_dev, f as append_dev, l as listen_dev, a9 as prop_dev, m as set_data_dev, n as noop, g as detach_dev, R as StatusTracker, T as assign, I as binding_callbacks, L as bind, B as create_component, C as mount_component, D as transition_in, E as transition_out, F as destroy_component, K as bubble, U as get_spread_update, V as get_spread_object, M as add_flush_callback } from './index.e70bf722.js';
import { c as create_classes } from './styles.d87a390f.js';
import { B as Block } from './Block.78dd9cf7.js';

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/form/src/Checkbox.svelte generated by Svelte v3.47.0 */
const file = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/form/src/Checkbox.svelte";

function create_fragment$1(ctx) {
	let label_1;
	let input;
	let t0;
	let span;
	let t1;
	let span_class_value;
	let mounted;
	let dispose;

	const block = {
		c: function create() {
			label_1 = element("label");
			input = element("input");
			t0 = space();
			span = element("span");
			t1 = text(/*label*/ ctx[3]);
			input.disabled = /*disabled*/ ctx[2];
			attr_dev(input, "type", "checkbox");
			attr_dev(input, "name", "test");
			attr_dev(input, "class", "gr-check-radio gr-checkbox");
			add_location(input, file, 19, 1, 578);
			attr_dev(span, "class", span_class_value = "ml-2" + create_classes(/*style*/ ctx[1]));
			add_location(span, file, 26, 1, 695);
			attr_dev(label_1, "class", "flex items-center text-gray-700 text-sm space-x-2 rounded-lg cursor-pointer bg-white dark:bg-transparent");
			toggle_class(label_1, "!cursor-not-allowed", /*disabled*/ ctx[2]);
			add_location(label_1, file, 15, 0, 416);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, label_1, anchor);
			append_dev(label_1, input);
			input.checked = /*value*/ ctx[0];
			append_dev(label_1, t0);
			append_dev(label_1, span);
			append_dev(span, t1);

			if (!mounted) {
				dispose = listen_dev(input, "change", /*input_change_handler*/ ctx[5]);
				mounted = true;
			}
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*disabled*/ 4) {
				prop_dev(input, "disabled", /*disabled*/ ctx[2]);
			}

			if (dirty & /*value*/ 1) {
				input.checked = /*value*/ ctx[0];
			}

			if (dirty & /*label*/ 8) set_data_dev(t1, /*label*/ ctx[3]);

			if (dirty & /*style*/ 2 && span_class_value !== (span_class_value = "ml-2" + create_classes(/*style*/ ctx[1]))) {
				attr_dev(span, "class", span_class_value);
			}

			if (dirty & /*disabled*/ 4) {
				toggle_class(label_1, "!cursor-not-allowed", /*disabled*/ ctx[2]);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(label_1);
			mounted = false;
			dispose();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$1.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$1($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Checkbox', slots, []);
	let { value } = $$props;
	let { style = {} } = $$props;
	let { disabled = false } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	const dispatch = createEventDispatcher();

	function handle_change() {
		dispatch("change", !value);
		$$invalidate(0, value = !value);
	}

	const writable_props = ['value', 'style', 'disabled', 'label', 'show_label'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Checkbox> was created with unknown prop '${key}'`);
	});

	function input_change_handler() {
		value = this.checked;
		$$invalidate(0, value);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(1, style = $$props.style);
		if ('disabled' in $$props) $$invalidate(2, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(4, show_label = $$props.show_label);
	};

	$$self.$capture_state = () => ({
		create_classes,
		createEventDispatcher,
		value,
		style,
		disabled,
		label,
		show_label,
		dispatch,
		handle_change
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(1, style = $$props.style);
		if ('disabled' in $$props) $$invalidate(2, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(4, show_label = $$props.show_label);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [value, style, disabled, label, show_label, input_change_handler];
}

class Checkbox extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 1,
			disabled: 2,
			label: 3,
			show_label: 4
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Checkbox",
			options,
			id: create_fragment$1.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*value*/ ctx[0] === undefined && !('value' in props)) {
			console.warn("<Checkbox> was created without expected prop 'value'");
		}

		if (/*label*/ ctx[3] === undefined && !('label' in props)) {
			console.warn("<Checkbox> was created without expected prop 'label'");
		}

		if (/*show_label*/ ctx[4] === undefined && !('show_label' in props)) {
			console.warn("<Checkbox> was created without expected prop 'show_label'");
		}
	}

	get value() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get style() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set style(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get disabled() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set disabled(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* src/components/Checkbox/Checkbox.svelte generated by Svelte v3.47.0 */

// (14:0) <Block {form_position} {elem_id} {style}>
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let checkbox;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[7]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({
			props: statustracker_props,
			$$inline: true
		});

	function checkbox_value_binding(value) {
		/*checkbox_value_binding*/ ctx[8](value);
	}

	let checkbox_props = {
		label: /*label*/ ctx[2],
		show_label: /*show_label*/ ctx[5],
		style: /*style*/ ctx[6],
		disabled: /*mode*/ ctx[3] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		checkbox_props.value = /*value*/ ctx[0];
	}

	checkbox = new Checkbox({ props: checkbox_props, $$inline: true });
	binding_callbacks.push(() => bind(checkbox, 'value', checkbox_value_binding));
	checkbox.$on("change", /*change_handler*/ ctx[9]);

	const block = {
		c: function create() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(checkbox.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert_dev(target, t, anchor);
			mount_component(checkbox, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 128)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[7])])
			: {};

			statustracker.$set(statustracker_changes);
			const checkbox_changes = {};
			if (dirty & /*label*/ 4) checkbox_changes.label = /*label*/ ctx[2];
			if (dirty & /*show_label*/ 32) checkbox_changes.show_label = /*show_label*/ ctx[5];
			if (dirty & /*style*/ 64) checkbox_changes.style = /*style*/ ctx[6];
			if (dirty & /*mode*/ 8) checkbox_changes.disabled = /*mode*/ ctx[3] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				checkbox_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			checkbox.$set(checkbox_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(checkbox.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(checkbox.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach_dev(t);
			destroy_component(checkbox, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot.name,
		type: "slot",
		source: "(14:0) <Block {form_position} {elem_id} {style}>",
		ctx
	});

	return block;
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				form_position: /*form_position*/ ctx[4],
				elem_id: /*elem_id*/ ctx[1],
				style: /*style*/ ctx[6],
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			},
			$$inline: true
		});

	const block_1 = {
		c: function create() {
			create_component(block.$$.fragment);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*form_position*/ 16) block_changes.form_position = /*form_position*/ ctx[4];
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*style*/ 64) block_changes.style = /*style*/ ctx[6];

			if (dirty & /*$$scope, label, show_label, style, mode, value, loading_status*/ 1261) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(block, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block: block_1,
		id: create_fragment.name,
		type: "component",
		source: "",
		ctx
	});

	return block_1;
}

function instance($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Checkbox', slots, []);
	let { elem_id = "" } = $$props;
	let { value = false } = $$props;
	let { label = "Checkbox" } = $$props;
	let { mode } = $$props;
	let { form_position = "single" } = $$props;
	let { show_label } = $$props;
	let { style = {} } = $$props;
	let { loading_status } = $$props;

	const writable_props = [
		'elem_id',
		'value',
		'label',
		'mode',
		'form_position',
		'show_label',
		'style',
		'loading_status'
	];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Checkbox> was created with unknown prop '${key}'`);
	});

	function checkbox_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('mode' in $$props) $$invalidate(3, mode = $$props.mode);
		if ('form_position' in $$props) $$invalidate(4, form_position = $$props.form_position);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('style' in $$props) $$invalidate(6, style = $$props.style);
		if ('loading_status' in $$props) $$invalidate(7, loading_status = $$props.loading_status);
	};

	$$self.$capture_state = () => ({
		Checkbox,
		Block,
		StatusTracker,
		elem_id,
		value,
		label,
		mode,
		form_position,
		show_label,
		style,
		loading_status
	});

	$$self.$inject_state = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('mode' in $$props) $$invalidate(3, mode = $$props.mode);
		if ('form_position' in $$props) $$invalidate(4, form_position = $$props.form_position);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('style' in $$props) $$invalidate(6, style = $$props.style);
		if ('loading_status' in $$props) $$invalidate(7, loading_status = $$props.loading_status);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [
		value,
		elem_id,
		label,
		mode,
		form_position,
		show_label,
		style,
		loading_status,
		checkbox_value_binding,
		change_handler
	];
}

class Checkbox_1 extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			value: 0,
			label: 2,
			mode: 3,
			form_position: 4,
			show_label: 5,
			style: 6,
			loading_status: 7
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Checkbox_1",
			options,
			id: create_fragment.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*mode*/ ctx[3] === undefined && !('mode' in props)) {
			console.warn("<Checkbox> was created without expected prop 'mode'");
		}

		if (/*show_label*/ ctx[5] === undefined && !('show_label' in props)) {
			console.warn("<Checkbox> was created without expected prop 'show_label'");
		}

		if (/*loading_status*/ ctx[7] === undefined && !('loading_status' in props)) {
			console.warn("<Checkbox> was created without expected prop 'loading_status'");
		}
	}

	get elem_id() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set elem_id(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get value() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get mode() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set mode(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get form_position() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set form_position(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get style() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set style(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get loading_status() {
		throw new Error("<Checkbox>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set loading_status(value) {
		throw new Error("<Checkbox>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Checkbox_1$1 = Checkbox_1;

const modes = ["static", "dynamic"];

export { Checkbox_1$1 as Component, modes };
