import { S as SvelteComponentDev, i as init, s as safe_not_equal, d as dispatch_dev, Z as create_slot, v as validate_slots, y as createEventDispatcher, h as element, w as space, b as attr_dev, c as add_location, t as toggle_class, e as insert_dev, f as append_dev, l as listen_dev, a1 as stop_propagation, p as prevent_default, _ as update_slot_base, $ as get_all_dirty_from_scope, a0 as get_slot_changes, D as transition_in, E as transition_out, g as detach_dev, r as run_all, K as bubble, I as binding_callbacks } from './index.50e14928.js';

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/upload/src/Upload.svelte generated by Svelte v3.47.0 */
const file = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/upload/src/Upload.svelte";

function create_fragment(ctx) {
	let div;
	let t;
	let input;
	let div_class_value;
	let current;
	let mounted;
	let dispose;
	const default_slot_template = /*#slots*/ ctx[16].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[15], null);

	const block = {
		c: function create() {
			div = element("div");
			if (default_slot) default_slot.c();
			t = space();
			input = element("input");
			attr_dev(input, "class", "hidden-upload hidden");
			attr_dev(input, "type", "file");
			attr_dev(input, "accept", /*filetype*/ ctx[0]);
			input.multiple = /*file_count*/ ctx[6] === "multiple" || undefined;
			attr_dev(input, "webkitdirectory", /*file_count*/ ctx[6] === "directory" || undefined);
			attr_dev(input, "mozdirectory", /*file_count*/ ctx[6] === "directory" || undefined);
			add_location(input, file, 81, 1, 2339);

			attr_dev(div, "class", div_class_value = "w-full cursor-pointer h-full items-center justify-center text-gray-400 md:text-xl " + (/*boundedheight*/ ctx[2]
			? 'min-h-[10rem] md:min-h-[15rem] max-h-[15rem] xl:max-h-[18rem] 2xl:max-h-[20rem]'
			: ''));

			attr_dev(div, "theme", /*theme*/ ctx[1]);
			toggle_class(div, "text-center", /*center*/ ctx[3]);
			toggle_class(div, "flex", /*flex*/ ctx[4]);
			add_location(div, file, 61, 0, 1651);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);

			if (default_slot) {
				default_slot.m(div, null);
			}

			append_dev(div, t);
			append_dev(div, input);
			/*input_binding*/ ctx[24](input);
			current = true;

			if (!mounted) {
				dispose = [
					listen_dev(input, "change", /*loadFilesFromUpload*/ ctx[9], false, false, false),
					listen_dev(div, "drag", stop_propagation(prevent_default(/*drag_handler*/ ctx[17])), false, true, true),
					listen_dev(div, "dragstart", stop_propagation(prevent_default(/*dragstart_handler*/ ctx[18])), false, true, true),
					listen_dev(div, "dragend", stop_propagation(prevent_default(/*dragend_handler*/ ctx[19])), false, true, true),
					listen_dev(div, "dragover", stop_propagation(prevent_default(/*dragover_handler*/ ctx[20])), false, true, true),
					listen_dev(div, "dragenter", stop_propagation(prevent_default(/*dragenter_handler*/ ctx[21])), false, true, true),
					listen_dev(div, "dragleave", stop_propagation(prevent_default(/*dragleave_handler*/ ctx[22])), false, true, true),
					listen_dev(div, "drop", stop_propagation(prevent_default(/*drop_handler*/ ctx[23])), false, true, true),
					listen_dev(div, "click", /*openFileUpload*/ ctx[8], false, false, false),
					listen_dev(div, "drop", /*loadFilesFromDrop*/ ctx[10], false, false, false),
					listen_dev(div, "dragenter", /*updateDragging*/ ctx[7], false, false, false),
					listen_dev(div, "dragleave", /*updateDragging*/ ctx[7], false, false, false)
				];

				mounted = true;
			}
		},
		p: function update(ctx, [dirty]) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty & /*$$scope*/ 32768)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[15],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[15])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[15], dirty, null),
						null
					);
				}
			}

			if (!current || dirty & /*filetype*/ 1) {
				attr_dev(input, "accept", /*filetype*/ ctx[0]);
			}

			if (!current || dirty & /*boundedheight*/ 4 && div_class_value !== (div_class_value = "w-full cursor-pointer h-full items-center justify-center text-gray-400 md:text-xl " + (/*boundedheight*/ ctx[2]
			? 'min-h-[10rem] md:min-h-[15rem] max-h-[15rem] xl:max-h-[18rem] 2xl:max-h-[20rem]'
			: ''))) {
				attr_dev(div, "class", div_class_value);
			}

			if (!current || dirty & /*theme*/ 2) {
				attr_dev(div, "theme", /*theme*/ ctx[1]);
			}

			if (dirty & /*boundedheight, center*/ 12) {
				toggle_class(div, "text-center", /*center*/ ctx[3]);
			}

			if (dirty & /*boundedheight, flex*/ 20) {
				toggle_class(div, "flex", /*flex*/ ctx[4]);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			if (default_slot) default_slot.d(detaching);
			/*input_binding*/ ctx[24](null);
			mounted = false;
			run_all(dispose);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Upload', slots, ['default']);
	let { filetype = undefined } = $$props;
	let { theme = "default" } = $$props;
	let { single_file = true } = $$props;
	let { include_file_metadata = true } = $$props;
	let { dragging = false } = $$props;
	let { boundedheight = true } = $$props;
	let { click = true } = $$props;
	let { center = true } = $$props;
	let { flex = true } = $$props;
	let hidden_upload;
	let file_count;
	const dispatch = createEventDispatcher();

	const updateDragging = () => {
		$$invalidate(11, dragging = !dragging);
	};

	const openFileUpload = () => {
		if (!click) return;
		hidden_upload.click();
	};

	const loadFiles = files => {
		let _files = Array.from(files);

		if (!files.length || !window.FileReader) {
			return;
		}

		if (file_count === "single") {
			_files = [files[0]];
		}

		var all_file_data = [];

		_files.forEach((f, i) => {
			let ReaderObj = new FileReader();
			ReaderObj.readAsDataURL(f);

			ReaderObj.onloadend = function () {
				all_file_data[i] = include_file_metadata
				? {
						name: f.name,
						size: f.size,
						data: this.result
					}
				: this.result;

				if (all_file_data.length === files.length) {
					dispatch("load", single_file ? all_file_data[0] : all_file_data);
				}
			};
		});
	};

	const loadFilesFromUpload = e => {
		const target = e.target;
		if (!target.files) return;
		loadFiles(target.files);
	};

	const loadFilesFromDrop = e => {
		$$invalidate(11, dragging = false);
		if (!e.dataTransfer?.files) return;
		loadFiles(e.dataTransfer.files);
	};

	const writable_props = [
		'filetype',
		'theme',
		'single_file',
		'include_file_metadata',
		'dragging',
		'boundedheight',
		'click',
		'center',
		'flex'
	];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Upload> was created with unknown prop '${key}'`);
	});

	function drag_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragstart_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragend_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragover_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragenter_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragleave_handler(event) {
		bubble.call(this, $$self, event);
	}

	function drop_handler(event) {
		bubble.call(this, $$self, event);
	}

	function input_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			hidden_upload = $$value;
			$$invalidate(5, hidden_upload);
		});
	}

	$$self.$$set = $$props => {
		if ('filetype' in $$props) $$invalidate(0, filetype = $$props.filetype);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
		if ('single_file' in $$props) $$invalidate(12, single_file = $$props.single_file);
		if ('include_file_metadata' in $$props) $$invalidate(13, include_file_metadata = $$props.include_file_metadata);
		if ('dragging' in $$props) $$invalidate(11, dragging = $$props.dragging);
		if ('boundedheight' in $$props) $$invalidate(2, boundedheight = $$props.boundedheight);
		if ('click' in $$props) $$invalidate(14, click = $$props.click);
		if ('center' in $$props) $$invalidate(3, center = $$props.center);
		if ('flex' in $$props) $$invalidate(4, flex = $$props.flex);
		if ('$$scope' in $$props) $$invalidate(15, $$scope = $$props.$$scope);
	};

	$$self.$capture_state = () => ({
		createEventDispatcher,
		filetype,
		theme,
		single_file,
		include_file_metadata,
		dragging,
		boundedheight,
		click,
		center,
		flex,
		hidden_upload,
		file_count,
		dispatch,
		updateDragging,
		openFileUpload,
		loadFiles,
		loadFilesFromUpload,
		loadFilesFromDrop
	});

	$$self.$inject_state = $$props => {
		if ('filetype' in $$props) $$invalidate(0, filetype = $$props.filetype);
		if ('theme' in $$props) $$invalidate(1, theme = $$props.theme);
		if ('single_file' in $$props) $$invalidate(12, single_file = $$props.single_file);
		if ('include_file_metadata' in $$props) $$invalidate(13, include_file_metadata = $$props.include_file_metadata);
		if ('dragging' in $$props) $$invalidate(11, dragging = $$props.dragging);
		if ('boundedheight' in $$props) $$invalidate(2, boundedheight = $$props.boundedheight);
		if ('click' in $$props) $$invalidate(14, click = $$props.click);
		if ('center' in $$props) $$invalidate(3, center = $$props.center);
		if ('flex' in $$props) $$invalidate(4, flex = $$props.flex);
		if ('hidden_upload' in $$props) $$invalidate(5, hidden_upload = $$props.hidden_upload);
		if ('file_count' in $$props) $$invalidate(6, file_count = $$props.file_count);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [
		filetype,
		theme,
		boundedheight,
		center,
		flex,
		hidden_upload,
		file_count,
		updateDragging,
		openFileUpload,
		loadFilesFromUpload,
		loadFilesFromDrop,
		dragging,
		single_file,
		include_file_metadata,
		click,
		$$scope,
		slots,
		drag_handler,
		dragstart_handler,
		dragend_handler,
		dragover_handler,
		dragenter_handler,
		dragleave_handler,
		drop_handler,
		input_binding
	];
}

class Upload extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance, create_fragment, safe_not_equal, {
			filetype: 0,
			theme: 1,
			single_file: 12,
			include_file_metadata: 13,
			dragging: 11,
			boundedheight: 2,
			click: 14,
			center: 3,
			flex: 4
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Upload",
			options,
			id: create_fragment.name
		});
	}

	get filetype() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set filetype(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get theme() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set theme(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get single_file() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set single_file(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get include_file_metadata() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set include_file_metadata(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get dragging() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set dragging(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get boundedheight() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set boundedheight(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get click() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set click(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get center() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set center(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get flex() {
		throw new Error("<Upload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set flex(value) {
		throw new Error("<Upload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

export { Upload as U };
