import { S as SvelteComponentDev, i as init, s as safe_not_equal, d as dispatch_dev, v as validate_slots, a as svg_element, b as attr_dev, c as add_location, e as insert_dev, f as append_dev, n as noop, g as detach_dev, af as add_render_callback, ab as tick, R as StatusTracker, T as assign, B as create_component, C as mount_component, l as listen_dev, D as transition_in, E as transition_out, F as destroy_component, I as binding_callbacks, w as space, q as empty, U as get_spread_update, V as get_spread_object, G as group_outros, H as check_outros, o as validate_each_argument, h as element, N as src_url_equal, t as toggle_class, u as destroy_each, r as run_all, aj as add_resize_listener } from './index.50e14928.js';
import { B as Block } from './Block.a61554cb.js';
import { B as BlockLabel } from './BlockLabel.ef852488.js';
import { M as ModifyUpload } from './ModifyUpload.a4d2175f.js';
import './styles.d87a390f.js';

/* src/components/Gallery/ImageIcon.svelte generated by Svelte v3.47.0 */

const file$1 = "src/components/Gallery/ImageIcon.svelte";

function create_fragment$1(ctx) {
	let svg;
	let rect;
	let circle;
	let polyline;

	const block = {
		c: function create() {
			svg = svg_element("svg");
			rect = svg_element("rect");
			circle = svg_element("circle");
			polyline = svg_element("polyline");
			attr_dev(rect, "x", "3");
			attr_dev(rect, "y", "3");
			attr_dev(rect, "width", "18");
			attr_dev(rect, "height", "18");
			attr_dev(rect, "rx", "2");
			attr_dev(rect, "ry", "2");
			add_location(rect, file$1, 11, 2, 227);
			attr_dev(circle, "cx", "8.5");
			attr_dev(circle, "cy", "8.5");
			attr_dev(circle, "r", "1.5");
			add_location(circle, file$1, 11, 59, 284);
			attr_dev(polyline, "points", "21 15 16 10 5 21");
			add_location(polyline, file$1, 15, 3, 327);
			attr_dev(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr_dev(svg, "width", "1em");
			attr_dev(svg, "height", "1em");
			attr_dev(svg, "viewBox", "0 0 24 24");
			attr_dev(svg, "fill", "none");
			attr_dev(svg, "stroke", "currentColor");
			attr_dev(svg, "stroke-width", "1.5");
			attr_dev(svg, "stroke-linecap", "round");
			attr_dev(svg, "stroke-linejoin", "round");
			attr_dev(svg, "class", "feather feather-image");
			add_location(svg, file$1, 0, 0, 0);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, svg, anchor);
			append_dev(svg, rect);
			append_dev(svg, circle);
			append_dev(svg, polyline);
		},
		p: noop,
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(svg);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$1.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$1($$self, $$props) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('ImageIcon', slots, []);
	const writable_props = [];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<ImageIcon> was created with unknown prop '${key}'`);
	});

	return [];
}

class ImageIcon extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$1, create_fragment$1, safe_not_equal, {});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "ImageIcon",
			options,
			id: create_fragment$1.name
		});
	}
}

var Gallery_svelte_svelte_type_style_lang = '';

/* src/components/Gallery/Gallery.svelte generated by Svelte v3.47.0 */
const file = "src/components/Gallery/Gallery.svelte";

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[26] = list[i];
	child_ctx[28] = i;
	return child_ctx;
}

function get_each_context_1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[26] = list[i];
	child_ctx[29] = list;
	child_ctx[28] = i;
	return child_ctx;
}

// (72:1) {:else}
function create_else_block(ctx) {
	let t;
	let div1;
	let div0;
	let div0_class_value;
	let div1_resize_listener;
	let current;
	let if_block = /*selected_image*/ ctx[6] !== null && create_if_block_1(ctx);
	let each_value = /*value*/ ctx[4];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	let each_1_else = null;

	if (!each_value.length) {
		each_1_else = create_else_block_1(ctx);
	}

	const block = {
		c: function create() {
			if (if_block) if_block.c();
			t = space();
			div1 = element("div");
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			if (each_1_else) {
				each_1_else.c();
			}

			attr_dev(div0, "class", div0_class_value = "grid gap-2 " + /*grid*/ ctx[12] + " s-QzgPMAMVqUOn");
			toggle_class(div0, "pt-6", /*show_label*/ ctx[1]);
			add_location(div0, file, 120, 3, 3801);
			attr_dev(div1, "class", "overflow-y-auto h-full p-2 s-QzgPMAMVqUOn");
			add_render_callback(() => /*div1_elementresize_handler*/ ctx[22].call(div1));
			toggle_class(div1, "min-h-[350px]", /*style*/ ctx[5].height !== "auto");
			toggle_class(div1, "max-h-[55vh]", /*style*/ ctx[5].height !== "auto");
			toggle_class(div1, "xl:min-h-[450px]", /*style*/ ctx[5].height !== "auto");
			add_location(div1, file, 113, 2, 3572);
		},
		m: function mount(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert_dev(target, t, anchor);
			insert_dev(target, div1, anchor);
			append_dev(div1, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div0, null);
			}

			if (each_1_else) {
				each_1_else.m(div0, null);
			}

			div1_resize_listener = add_resize_listener(div1, /*div1_elementresize_handler*/ ctx[22].bind(div1));
			current = true;
		},
		p: function update(ctx, dirty) {
			if (/*selected_image*/ ctx[6] !== null) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*selected_image*/ 64) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block_1(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(t.parentNode, t);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			if (dirty & /*selected_image, can_zoom, value*/ 2128) {
				each_value = /*value*/ ctx[4];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;

				if (!each_value.length && each_1_else) {
					each_1_else.p(ctx, dirty);
				} else if (!each_value.length) {
					each_1_else = create_else_block_1(ctx);
					each_1_else.c();
					each_1_else.m(div0, null);
				} else if (each_1_else) {
					each_1_else.d(1);
					each_1_else = null;
				}
			}

			if (!current || dirty & /*grid*/ 4096 && div0_class_value !== (div0_class_value = "grid gap-2 " + /*grid*/ ctx[12] + " s-QzgPMAMVqUOn")) {
				attr_dev(div0, "class", div0_class_value);
			}

			if (dirty & /*grid, show_label*/ 4098) {
				toggle_class(div0, "pt-6", /*show_label*/ ctx[1]);
			}

			if (dirty & /*style*/ 32) {
				toggle_class(div1, "min-h-[350px]", /*style*/ ctx[5].height !== "auto");
			}

			if (dirty & /*style*/ 32) {
				toggle_class(div1, "max-h-[55vh]", /*style*/ ctx[5].height !== "auto");
			}

			if (dirty & /*style*/ 32) {
				toggle_class(div1, "xl:min-h-[450px]", /*style*/ ctx[5].height !== "auto");
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			if (if_block) if_block.d(detaching);
			if (detaching) detach_dev(t);
			if (detaching) detach_dev(div1);
			destroy_each(each_blocks, detaching);
			if (each_1_else) each_1_else.d();
			div1_resize_listener();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block.name,
		type: "else",
		source: "(72:1) {:else}",
		ctx
	});

	return block;
}

// (68:1) {#if value === null}
function create_if_block(ctx) {
	let div;
	let imageicon;
	let current;
	imageicon = new ImageIcon({ $$inline: true });

	const block = {
		c: function create() {
			div = element("div");
			create_component(imageicon.$$.fragment);
			attr_dev(div, "class", "h-full min-h-[15rem] flex justify-center items-center s-QzgPMAMVqUOn");
			add_location(div, file, 68, 2, 2217);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
			mount_component(imageicon, div, null);
			current = true;
		},
		p: noop,
		i: function intro(local) {
			if (current) return;
			transition_in(imageicon.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(imageicon.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			destroy_component(imageicon);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block.name,
		type: "if",
		source: "(68:1) {#if value === null}",
		ctx
	});

	return block;
}

// (73:2) {#if selected_image !== null}
function create_if_block_1(ctx) {
	let div1;
	let modifyupload;
	let t0;
	let img;
	let img_src_value;
	let t1;
	let div0;
	let current;
	let mounted;
	let dispose;
	modifyupload = new ModifyUpload({ $$inline: true });
	modifyupload.$on("clear", /*clear_handler*/ ctx[16]);
	let each_value_1 = /*value*/ ctx[4];
	validate_each_argument(each_value_1);
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1(get_each_context_1(ctx, each_value_1, i));
	}

	const block = {
		c: function create() {
			div1 = element("div");
			create_component(modifyupload.$$.fragment);
			t0 = space();
			img = element("img");
			t1 = space();
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(img, "class", "w-full object-contain h-[calc(100%-50px)] s-QzgPMAMVqUOn");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[4][/*selected_image*/ ctx[6]])) attr_dev(img, "src", img_src_value);
			attr_dev(img, "alt", "");
			add_location(img, file, 82, 4, 2710);
			attr_dev(div0, "class", "absolute h-[60px] bg-white dark:bg-gray-900 overflow-x-scroll scroll-hide w-full bottom-0 flex gap-1.5 items-center py-2 text-sm px-3 justify-center s-QzgPMAMVqUOn");
			add_location(div0, file, 89, 4, 2873);
			attr_dev(div1, "class", "absolute inset-0 z-10 flex flex-col bg-white/90 dark:bg-gray-900 backdrop-blur h-full s-QzgPMAMVqUOn");
			toggle_class(div1, "min-h-[350px]", /*style*/ ctx[5].height !== "auto");
			toggle_class(div1, "max-h-[55vh]", /*style*/ ctx[5].height !== "auto");
			toggle_class(div1, "xl:min-h-[450px]", /*style*/ ctx[5].height !== "auto");
			add_location(div1, file, 73, 3, 2355);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div1, anchor);
			mount_component(modifyupload, div1, null);
			append_dev(div1, t0);
			append_dev(div1, img);
			append_dev(div1, t1);
			append_dev(div1, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div0, null);
			}

			/*div0_binding*/ ctx[20](div0);
			current = true;

			if (!mounted) {
				dispose = [
					listen_dev(img, "click", /*click_handler*/ ctx[17], false, false, false),
					listen_dev(div1, "keydown", /*on_keydown*/ ctx[14], false, false, false)
				];

				mounted = true;
			}
		},
		p: function update(ctx, dirty) {
			if (!current || dirty & /*value, selected_image*/ 80 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[4][/*selected_image*/ ctx[6]])) {
				attr_dev(img, "src", img_src_value);
			}

			if (dirty & /*selected_image, el, value*/ 592) {
				each_value_1 = /*value*/ ctx[4];
				validate_each_argument(each_value_1);
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_1.length;
			}

			if (dirty & /*style*/ 32) {
				toggle_class(div1, "min-h-[350px]", /*style*/ ctx[5].height !== "auto");
			}

			if (dirty & /*style*/ 32) {
				toggle_class(div1, "max-h-[55vh]", /*style*/ ctx[5].height !== "auto");
			}

			if (dirty & /*style*/ 32) {
				toggle_class(div1, "xl:min-h-[450px]", /*style*/ ctx[5].height !== "auto");
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(modifyupload.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(modifyupload.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div1);
			destroy_component(modifyupload);
			destroy_each(each_blocks, detaching);
			/*div0_binding*/ ctx[20](null);
			mounted = false;
			run_all(dispose);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block_1.name,
		type: "if",
		source: "(73:2) {#if selected_image !== null}",
		ctx
	});

	return block;
}

// (94:5) {#each value as image, i}
function create_each_block_1(ctx) {
	let button;
	let img;
	let img_src_value;
	let t;
	let button_class_value;
	let i = /*i*/ ctx[28];
	let mounted;
	let dispose;
	const assign_button = () => /*button_binding*/ ctx[18](button, i);
	const unassign_button = () => /*button_binding*/ ctx[18](null, i);

	function click_handler_1() {
		return /*click_handler_1*/ ctx[19](/*i*/ ctx[28]);
	}

	const block = {
		c: function create() {
			button = element("button");
			img = element("img");
			t = space();
			attr_dev(img, "alt", "");
			attr_dev(img, "class", "h-full w-full overflow-hidden object-contain s-QzgPMAMVqUOn");
			if (!src_url_equal(img.src, img_src_value = /*image*/ ctx[26])) attr_dev(img, "src", img_src_value);
			add_location(img, file, 102, 7, 3400);

			attr_dev(button, "class", button_class_value = "gallery-item !flex-none !h-9 !w-9 transition-all duration-75 " + (/*selected_image*/ ctx[6] === /*i*/ ctx[28]
			? '!ring-2 !ring-orange-500 hover:!ring-orange-500'
			: 'scale-90 transform') + " s-QzgPMAMVqUOn");

			add_location(button, file, 94, 6, 3110);
		},
		m: function mount(target, anchor) {
			insert_dev(target, button, anchor);
			append_dev(button, img);
			append_dev(button, t);
			assign_button();

			if (!mounted) {
				dispose = listen_dev(button, "click", click_handler_1, false, false, false);
				mounted = true;
			}
		},
		p: function update(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty & /*value*/ 16 && !src_url_equal(img.src, img_src_value = /*image*/ ctx[26])) {
				attr_dev(img, "src", img_src_value);
			}

			if (dirty & /*selected_image*/ 64 && button_class_value !== (button_class_value = "gallery-item !flex-none !h-9 !w-9 transition-all duration-75 " + (/*selected_image*/ ctx[6] === /*i*/ ctx[28]
			? '!ring-2 !ring-orange-500 hover:!ring-orange-500'
			: 'scale-90 transform') + " s-QzgPMAMVqUOn")) {
				attr_dev(button, "class", button_class_value);
			}

			if (i !== /*i*/ ctx[28]) {
				unassign_button();
				i = /*i*/ ctx[28];
				assign_button();
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(button);
			unassign_button();
			mounted = false;
			dispose();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block_1.name,
		type: "each",
		source: "(94:5) {#each value as image, i}",
		ctx
	});

	return block;
}

// (133:4) {:else}
function create_else_block_1(ctx) {
	let p;

	const block = {
		c: function create() {
			p = element("p");
			p.textContent = "Empty";
			attr_dev(p, "class", "s-QzgPMAMVqUOn");
			add_location(p, file, 133, 5, 4153);
		},
		m: function mount(target, anchor) {
			insert_dev(target, p, anchor);
		},
		p: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(p);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block_1.name,
		type: "else",
		source: "(133:4) {:else}",
		ctx
	});

	return block;
}

// (122:4) {#each value as image, i}
function create_each_block(ctx) {
	let button;
	let img;
	let img_src_value;
	let t;
	let mounted;
	let dispose;

	function click_handler_2() {
		return /*click_handler_2*/ ctx[21](/*i*/ ctx[28]);
	}

	const block = {
		c: function create() {
			button = element("button");
			img = element("img");
			t = space();
			attr_dev(img, "alt", "");
			attr_dev(img, "class", "h-full w-full overflow-hidden object-contain s-QzgPMAMVqUOn");
			if (!src_url_equal(img.src, img_src_value = /*image*/ ctx[26])) attr_dev(img, "src", img_src_value);
			add_location(img, file, 126, 6, 4014);
			attr_dev(button, "class", "gallery-item s-QzgPMAMVqUOn");
			add_location(button, file, 122, 5, 3894);
		},
		m: function mount(target, anchor) {
			insert_dev(target, button, anchor);
			append_dev(button, img);
			append_dev(button, t);

			if (!mounted) {
				dispose = listen_dev(button, "click", click_handler_2, false, false, false);
				mounted = true;
			}
		},
		p: function update(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty & /*value*/ 16 && !src_url_equal(img.src, img_src_value = /*image*/ ctx[26])) {
				attr_dev(img, "src", img_src_value);
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(button);
			mounted = false;
			dispose();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block.name,
		type: "each",
		source: "(122:4) {#each value as image, i}",
		ctx
	});

	return block;
}

// (65:0) <Block variant="solid" color="grey" padding={false} {elem_id}>
function create_default_slot(ctx) {
	let statustracker;
	let t0;
	let blocklabel;
	let t1;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[0]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({
			props: statustracker_props,
			$$inline: true
		});

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[1],
				Icon: ImageIcon,
				label: /*label*/ ctx[2] || "Gallery"
			},
			$$inline: true
		});

	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[4] === null) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	const block = {
		c: function create() {
			create_component(statustracker.$$.fragment);
			t0 = space();
			create_component(blocklabel.$$.fragment);
			t1 = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m: function mount(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert_dev(target, t0, anchor);
			mount_component(blocklabel, target, anchor);
			insert_dev(target, t1, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 1)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[0])])
			: {};

			statustracker.$set(statustracker_changes);
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 2) blocklabel_changes.show_label = /*show_label*/ ctx[1];
			if (dirty & /*label*/ 4) blocklabel_changes.label = /*label*/ ctx[2] || "Gallery";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach_dev(t0);
			destroy_component(blocklabel, detaching);
			if (detaching) detach_dev(t1);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot.name,
		type: "slot",
		source: "(65:0) <Block variant=\\\"solid\\\" color=\\\"grey\\\" padding={false} {elem_id}>",
		ctx
	});

	return block;
}

function create_fragment(ctx) {
	let block;
	let current;
	let mounted;
	let dispose;
	add_render_callback(/*onwindowresize*/ ctx[15]);

	block = new Block({
			props: {
				variant: "solid",
				color: "grey",
				padding: false,
				elem_id: /*elem_id*/ ctx[3],
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			},
			$$inline: true
		});

	const block_1 = {
		c: function create() {
			create_component(block.$$.fragment);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(block, target, anchor);
			current = true;

			if (!mounted) {
				dispose = listen_dev(window, "resize", /*onwindowresize*/ ctx[15]);
				mounted = true;
			}
		},
		p: function update(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*elem_id*/ 8) block_changes.elem_id = /*elem_id*/ ctx[3];

			if (dirty & /*$$scope, value, height, style, grid, show_label, selected_image, can_zoom, container, el, next, label, loading_status*/ 1073757943) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(block, detaching);
			mounted = false;
			dispose();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block: block_1,
		id: create_fragment.name,
		type: "component",
		source: "",
		ctx
	});

	return block_1;
}

function instance($$self, $$props, $$invalidate) {
	let previous;
	let next;
	let grid;
	let can_zoom;
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Gallery', slots, []);
	let { loading_status } = $$props;
	let { show_label } = $$props;
	let { label } = $$props;
	let { elem_id = "" } = $$props;
	let { value = null } = $$props;
	let { style = {} } = $$props;
	let selected_image = null;

	function on_keydown(e) {
		switch (e.code) {
			case "Escape":
				e.preventDefault();
				$$invalidate(6, selected_image = null);
				break;
			case "ArrowLeft":
				e.preventDefault();
				$$invalidate(6, selected_image = previous);
				break;
			case "ArrowRight":
				e.preventDefault();
				$$invalidate(6, selected_image = next);
				break;
		}
	}

	let el = [];
	let container;

	async function scroll_to_img(index) {
		if (typeof index !== "number") return;
		await tick();
		el[index].focus();
		const { left: container_left, width: container_width } = container.getBoundingClientRect();
		const { left, width } = el[index].getBoundingClientRect();
		const relative_left = left - container_left;
		const pos = relative_left + width / 2 - container_width / 2 + container.scrollLeft;

		container.scrollTo({
			left: pos < 0 ? 0 : pos,
			behavior: "smooth"
		});
	}

	let grid_map = ["", "sm:", "md:", "lg:", "xl:", "2xl:"];
	let height = 0;
	let window_height = 0;
	const writable_props = ['loading_status', 'show_label', 'label', 'elem_id', 'value', 'style'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Gallery> was created with unknown prop '${key}'`);
	});

	function onwindowresize() {
		$$invalidate(8, window_height = window.innerHeight);
	}

	const clear_handler = () => $$invalidate(6, selected_image = null);
	const click_handler = () => $$invalidate(6, selected_image = next);

	function button_binding($$value, i) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el[i] = $$value;
			$$invalidate(9, el);
		});
	}

	const click_handler_1 = i => $$invalidate(6, selected_image = i);

	function div0_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			container = $$value;
			$$invalidate(10, container);
		});
	}

	const click_handler_2 = i => $$invalidate(6, selected_image = can_zoom ? i : selected_image);

	function div1_elementresize_handler() {
		height = this.clientHeight;
		$$invalidate(7, height);
	}

	$$self.$$set = $$props => {
		if ('loading_status' in $$props) $$invalidate(0, loading_status = $$props.loading_status);
		if ('show_label' in $$props) $$invalidate(1, show_label = $$props.show_label);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('elem_id' in $$props) $$invalidate(3, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(4, value = $$props.value);
		if ('style' in $$props) $$invalidate(5, style = $$props.style);
	};

	$$self.$capture_state = () => ({
		Block,
		BlockLabel,
		ModifyUpload,
		tick,
		StatusTracker,
		ImageIcon,
		loading_status,
		show_label,
		label,
		elem_id,
		value,
		style,
		selected_image,
		on_keydown,
		el,
		container,
		scroll_to_img,
		grid_map,
		height,
		window_height,
		can_zoom,
		grid,
		next,
		previous
	});

	$$self.$inject_state = $$props => {
		if ('loading_status' in $$props) $$invalidate(0, loading_status = $$props.loading_status);
		if ('show_label' in $$props) $$invalidate(1, show_label = $$props.show_label);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('elem_id' in $$props) $$invalidate(3, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(4, value = $$props.value);
		if ('style' in $$props) $$invalidate(5, style = $$props.style);
		if ('selected_image' in $$props) $$invalidate(6, selected_image = $$props.selected_image);
		if ('el' in $$props) $$invalidate(9, el = $$props.el);
		if ('container' in $$props) $$invalidate(10, container = $$props.container);
		if ('grid_map' in $$props) $$invalidate(25, grid_map = $$props.grid_map);
		if ('height' in $$props) $$invalidate(7, height = $$props.height);
		if ('window_height' in $$props) $$invalidate(8, window_height = $$props.window_height);
		if ('can_zoom' in $$props) $$invalidate(11, can_zoom = $$props.can_zoom);
		if ('grid' in $$props) $$invalidate(12, grid = $$props.grid);
		if ('next' in $$props) $$invalidate(13, next = $$props.next);
		if ('previous' in $$props) previous = $$props.previous;
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*selected_image, value*/ 80) {
			previous = ((selected_image ?? 0) + (value?.length ?? 0) - 1) % (value?.length ?? 0);
		}

		if ($$self.$$.dirty & /*selected_image, value*/ 80) {
			$$invalidate(13, next = ((selected_image ?? 0) + 1) % (value?.length ?? 0));
		}

		if ($$self.$$.dirty & /*selected_image*/ 64) {
			scroll_to_img(selected_image);
		}

		if ($$self.$$.dirty & /*style*/ 32) {
			$$invalidate(12, grid = style.grid
			? Array(6).fill(0).map((_, i) => `${grid_map[i]}grid-cols-${style.grid[i] || style.grid[style.grid.length - 1]}`).join(" ")
			: `grid-cols-3 md:grid-cols-4 lg:grid-cols-6`);
		}

		if ($$self.$$.dirty & /*window_height, height*/ 384) {
			$$invalidate(11, can_zoom = window_height >= height);
		}
	};

	return [
		loading_status,
		show_label,
		label,
		elem_id,
		value,
		style,
		selected_image,
		height,
		window_height,
		el,
		container,
		can_zoom,
		grid,
		next,
		on_keydown,
		onwindowresize,
		clear_handler,
		click_handler,
		button_binding,
		click_handler_1,
		div0_binding,
		click_handler_2,
		div1_elementresize_handler
	];
}

class Gallery extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance, create_fragment, safe_not_equal, {
			loading_status: 0,
			show_label: 1,
			label: 2,
			elem_id: 3,
			value: 4,
			style: 5
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Gallery",
			options,
			id: create_fragment.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*loading_status*/ ctx[0] === undefined && !('loading_status' in props)) {
			console.warn("<Gallery> was created without expected prop 'loading_status'");
		}

		if (/*show_label*/ ctx[1] === undefined && !('show_label' in props)) {
			console.warn("<Gallery> was created without expected prop 'show_label'");
		}

		if (/*label*/ ctx[2] === undefined && !('label' in props)) {
			console.warn("<Gallery> was created without expected prop 'label'");
		}
	}

	get loading_status() {
		throw new Error("<Gallery>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set loading_status(value) {
		throw new Error("<Gallery>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<Gallery>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<Gallery>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<Gallery>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<Gallery>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get elem_id() {
		throw new Error("<Gallery>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set elem_id(value) {
		throw new Error("<Gallery>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get value() {
		throw new Error("<Gallery>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<Gallery>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get style() {
		throw new Error("<Gallery>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set style(value) {
		throw new Error("<Gallery>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Gallery$1 = Gallery;

const modes = ["static"];

export { Gallery$1 as Component, modes };
