import { S as SvelteComponentDev, i as init, s as safe_not_equal, d as dispatch_dev, v as validate_slots, a as svg_element, b as attr_dev, c as add_location, e as insert_dev, f as append_dev, n as noop, g as detach_dev, y as createEventDispatcher, ak as onMount, h as element, N as src_url_equal, I as binding_callbacks, x as globals, o as validate_each_argument, J as onDestroy, af as add_render_callback, al as create_bidirectional_transition, a2 as set_style, l as listen_dev, r as run_all, w as space, aj as add_resize_listener, D as transition_in, G as group_outros, E as transition_out, H as check_outros, u as destroy_each, B as create_component, C as mount_component, F as destroy_component, t as toggle_class, q as empty, L as bind, M as add_flush_callback, k as text, m as set_data_dev, P as validate_store, X, Q as component_subscribe, R as StatusTracker, T as assign, K as bubble, U as get_spread_update, V as get_spread_object } from './index.50e14928.js';
import { B as BlockLabel } from './BlockLabel.ef852488.js';
import { C as Cropper, i as index, I as ImageEditor, W as Webcam } from './Image.svelte_svelte_type_style_lang.b47b801e.js';
import { f as fade } from './index.3f002eda.js';
import { I as IconButton, C as Clear, M as ModifyUpload } from './ModifyUpload.a4d2175f.js';
import { U as Upload } from './Upload.6b2c09a6.js';
import { B as Block } from './Block.a61554cb.js';
export { E as ExampleComponent } from './Image.5cf350ec.js';
import './_commonjsHelpers.88e99c8f.js';
import './styles.d87a390f.js';

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/icons/src/Sketch.svelte generated by Svelte v3.47.0 */

const file$8 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/icons/src/Sketch.svelte";

function create_fragment$9(ctx) {
	let svg;
	let path;

	const block = {
		c: function create() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr_dev(path, "d", "M17 3a2.828 2.828 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5L17 3z");
			add_location(path, file$8, 11, 2, 230);
			attr_dev(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr_dev(svg, "width", "100%");
			attr_dev(svg, "height", "100%");
			attr_dev(svg, "viewBox", "0 0 24 24");
			attr_dev(svg, "fill", "none");
			attr_dev(svg, "stroke", "currentColor");
			attr_dev(svg, "stroke-width", "1.5");
			attr_dev(svg, "stroke-linecap", "round");
			attr_dev(svg, "stroke-linejoin", "round");
			attr_dev(svg, "class", "feather feather-edit-2");
			add_location(svg, file$8, 0, 0, 0);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, svg, anchor);
			append_dev(svg, path);
		},
		p: noop,
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(svg);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$9.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$9($$self, $$props) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Sketch', slots, []);
	const writable_props = [];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Sketch> was created with unknown prop '${key}'`);
	});

	return [];
}

class Sketch$1 extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$9, create_fragment$9, safe_not_equal, {});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Sketch",
			options,
			id: create_fragment$9.name
		});
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/icons/src/Undo.svelte generated by Svelte v3.47.0 */

const file$7 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/icons/src/Undo.svelte";

function create_fragment$8(ctx) {
	let svg;
	let polyline;
	let path;

	const block = {
		c: function create() {
			svg = svg_element("svg");
			polyline = svg_element("polyline");
			path = svg_element("path");
			attr_dev(polyline, "points", "1 4 1 10 7 10");
			add_location(polyline, file$7, 11, 2, 234);
			attr_dev(path, "d", "M3.51 15a9 9 0 1 0 2.13-9.36L1 10");
			add_location(path, file$7, 11, 37, 269);
			attr_dev(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr_dev(svg, "width", "100%");
			attr_dev(svg, "height", "100%");
			attr_dev(svg, "viewBox", "0 0 24 24");
			attr_dev(svg, "fill", "none");
			attr_dev(svg, "stroke", "currentColor");
			attr_dev(svg, "stroke-width", "1.5");
			attr_dev(svg, "stroke-linecap", "round");
			attr_dev(svg, "stroke-linejoin", "round");
			attr_dev(svg, "class", "feather feather-rotate-ccw");
			add_location(svg, file$7, 0, 0, 0);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, svg, anchor);
			append_dev(svg, polyline);
			append_dev(svg, path);
		},
		p: noop,
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(svg);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$8.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$8($$self, $$props) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Undo', slots, []);
	const writable_props = [];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Undo> was created with unknown prop '${key}'`);
	});

	return [];
}

class Undo extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$8, create_fragment$8, safe_not_equal, {});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Undo",
			options,
			id: create_fragment$8.name
		});
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/icons/src/Image.svelte generated by Svelte v3.47.0 */

const file$6 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/icons/src/Image.svelte";

function create_fragment$7(ctx) {
	let svg;
	let rect;
	let circle;
	let polyline;

	const block = {
		c: function create() {
			svg = svg_element("svg");
			rect = svg_element("rect");
			circle = svg_element("circle");
			polyline = svg_element("polyline");
			attr_dev(rect, "x", "3");
			attr_dev(rect, "y", "3");
			attr_dev(rect, "width", "18");
			attr_dev(rect, "height", "18");
			attr_dev(rect, "rx", "2");
			attr_dev(rect, "ry", "2");
			add_location(rect, file$6, 11, 2, 229);
			attr_dev(circle, "cx", "8.5");
			attr_dev(circle, "cy", "8.5");
			attr_dev(circle, "r", "1.5");
			add_location(circle, file$6, 11, 59, 286);
			attr_dev(polyline, "points", "21 15 16 10 5 21");
			add_location(polyline, file$6, 15, 3, 329);
			attr_dev(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr_dev(svg, "width", "100%");
			attr_dev(svg, "height", "100%");
			attr_dev(svg, "viewBox", "0 0 24 24");
			attr_dev(svg, "fill", "none");
			attr_dev(svg, "stroke", "currentColor");
			attr_dev(svg, "stroke-width", "1.5");
			attr_dev(svg, "stroke-linecap", "round");
			attr_dev(svg, "stroke-linejoin", "round");
			attr_dev(svg, "class", "feather feather-image");
			add_location(svg, file$6, 0, 0, 0);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, svg, anchor);
			append_dev(svg, rect);
			append_dev(svg, circle);
			append_dev(svg, polyline);
		},
		p: noop,
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(svg);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$7.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$7($$self, $$props) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Image', slots, []);
	const writable_props = [];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Image> was created with unknown prop '${key}'`);
	});

	return [];
}

class Image extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$7, create_fragment$7, safe_not_equal, {});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Image",
			options,
			id: create_fragment$7.name
		});
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/Cropper.svelte generated by Svelte v3.47.0 */
const file$5 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/Cropper.svelte";

function create_fragment$6(ctx) {
	let img;
	let img_src_value;

	const block = {
		c: function create() {
			img = element("img");
			if (!src_url_equal(img.src, img_src_value = /*image*/ ctx[0])) attr_dev(img, "src", img_src_value);
			attr_dev(img, "alt", "");
			add_location(img, file$5, 20, 0, 503);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, img, anchor);
			/*img_binding*/ ctx[2](img);
		},
		p: function update(ctx, [dirty]) {
			if (dirty & /*image*/ 1 && !src_url_equal(img.src, img_src_value = /*image*/ ctx[0])) {
				attr_dev(img, "src", img_src_value);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(img);
			/*img_binding*/ ctx[2](null);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$6.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$6($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Cropper', slots, []);
	let { image } = $$props;
	let el;
	const dispatch = createEventDispatcher();

	onMount(() => {
		const cropper = new Cropper(el,
		{
				autoCropArea: 1,
				cropend() {
					const image_data = cropper.getCroppedCanvas().toDataURL();
					dispatch("crop", image_data);
				}
			});

		dispatch("crop", image);

		return () => {
			cropper.destroy();
		};
	});

	const writable_props = ['image'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Cropper> was created with unknown prop '${key}'`);
	});

	function img_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(1, el);
		});
	}

	$$self.$$set = $$props => {
		if ('image' in $$props) $$invalidate(0, image = $$props.image);
	};

	$$self.$capture_state = () => ({
		Cropper,
		onMount,
		createEventDispatcher,
		image,
		el,
		dispatch
	});

	$$self.$inject_state = $$props => {
		if ('image' in $$props) $$invalidate(0, image = $$props.image);
		if ('el' in $$props) $$invalidate(1, el = $$props.el);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [image, el, img_binding];
}

class Cropper_1 extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$6, create_fragment$6, safe_not_equal, { image: 0 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Cropper_1",
			options,
			id: create_fragment$6.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*image*/ ctx[0] === undefined && !('image' in props)) {
			console.warn("<Cropper> was created without expected prop 'image'");
		}
	}

	get image() {
		throw new Error("<Cropper>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set image(value) {
		throw new Error("<Cropper>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

class Point {
  /**
   *
   * @param {number} x
   * @param {number} y
   */
  constructor(x, y) {
    this.x = x;
    this.y = y;
  }
}

class LazyPoint extends Point {
  /**
   * Update the x and y values
   *
   * @param {Point} point
   */
  update (point) {
    this.x = point.x;
    this.y = point.y;
  }

  /**
   * Move the point to another position using an angle and distance
   *
   * @param {number} angle The angle in radians
   * @param {number} distance How much the point should be moved
   */
  moveByAngle (angle, distance) {
    // Rotate the angle based on the browser coordinate system ([0,0] in the top left)
    const angleRotated = angle + (Math.PI / 2);

    this.x = this.x + (Math.sin(angleRotated) * distance),
    this.y = this.y - (Math.cos(angleRotated) * distance);
  }

  /**
   * Check if this point is the same as another point
   *
   * @param {Point} point
   * @returns {boolean}
   */
  equalsTo (point) {
    return this.x === point.x && this.y === point.y
  }

  /**
   * Get the difference for x and y axis to another point
   *
   * @param {Point} point
   * @returns {Point}
   */
  getDifferenceTo (point) {
    return new Point(this.x - point.x, this.y - point.y)
  }

  /**
   * Calculate distance to another point
   *
   * @param {Point} point
   * @returns {Point}
   */
  getDistanceTo (point) {
    const diff = this.getDifferenceTo(point);

    return Math.sqrt(Math.pow(diff.x, 2) + Math.pow(diff.y, 2))
  }

  /**
   * Calculate the angle to another point
   *
   * @param {Point} point
   * @returns {Point}
   */
  getAngleTo (point) {
    const diff = this.getDifferenceTo(point);

    return Math.atan2(diff.y, diff.x)
  }

  /**
   * Return a simple object with x and y properties
   *
   * @returns {object}
   */
  toObject () {
    return {
      x: this.x,
      y: this.y
    }
  }
}

const RADIUS_DEFAULT = 30;

class LazyBrush {
  /**
   * constructor
   *
   * @param {object} settings
   * @param {number} settings.radius The radius for the lazy area
   * @param {boolean} settings.enabled
   */
  constructor ({ radius = RADIUS_DEFAULT, enabled = true, initialPoint = { x: 0, y: 0 }} = {}) {
    this.radius = radius;
    this._isEnabled = enabled;

    this.pointer = new LazyPoint(initialPoint.x, initialPoint.y);
    this.brush = new LazyPoint(initialPoint.x, initialPoint.y);

    this.angle = 0;
    this.distance = 0;
    this._hasMoved = false;
  }

  /**
   * Enable lazy brush calculations.
   *
   */
  enable () {
    this._isEnabled = true;
  }

  /**
   * Disable lazy brush calculations.
   *
   */
  disable () {
    this._isEnabled = false;
  }

  /**
   * @returns {boolean}
   */
  isEnabled () {
    return this._isEnabled
  }

  /**
   * Update the radius
   *
   * @param {number} radius
   */
  setRadius (radius) {
    this.radius = radius;
  }

  /**
   * Return the current radius
   *
   * @returns {number}
   */
  getRadius () {
    return this.radius
  }

  /**
   * Return the brush coordinates as a simple object
   *
   * @returns {object}
   */
  getBrushCoordinates () {
    return this.brush.toObject()
  }

  /**
   * Return the pointer coordinates as a simple object
   *
   * @returns {object}
   */
  getPointerCoordinates () {
    return this.pointer.toObject()
  }

  /**
   * Return the brush as a LazyPoint
   *
   * @returns {LazyPoint}
   */
  getBrush () {
    return this.brush
  }

  /**
   * Return the pointer as a LazyPoint
   *
   * @returns {LazyPoint}
   */
  getPointer () {
    return this.pointer
  }

  /**
   * Return the angle between pointer and brush
   *
   * @returns {number} Angle in radians
   */
  getAngle () {
    return this.angle
  }

  /**
   * Return the distance between pointer and brush
   *
   * @returns {number} Distance in pixels
   */
  getDistance () {
    return this.distance
  }

  /**
   * Return if the previous update has moved the brush.
   *
   * @returns {boolean} Whether the brush moved previously.
   */
  brushHasMoved () {
    return this._hasMoved
  }

  /**
   * Updates the pointer point and calculates the new brush point.
   *
   * @param {Point} newPointerPoint
   * @param {Object} options
   * @param {Boolean} options.both Force update pointer and brush
   * @returns {Boolean} Whether any of the two points changed
   */
  update (newPointerPoint, { both = false } = {}) {
    this._hasMoved = false;
    if (this.pointer.equalsTo(newPointerPoint) && !both) {
      return false
    }

    this.pointer.update(newPointerPoint);

    if (both) {
      this._hasMoved = true;
      this.brush.update(newPointerPoint);
      return true
    }

    if (this._isEnabled) {
      this.distance = this.pointer.getDistanceTo(this.brush);
      this.angle = this.pointer.getAngleTo(this.brush);

      if (this.distance > this.radius) {
        this.brush.moveByAngle(this.angle, this.distance - this.radius);
        this._hasMoved = true;
      }
    } else {
      this.distance = 0;
      this.angle = 0;
      this.brush.update(newPointerPoint);
      this._hasMoved = true;
    }

    return true
  }
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/Sketch.svelte generated by Svelte v3.47.0 */

const { Error: Error_1, Object: Object_1 } = globals;
const file$4 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/Sketch.svelte";

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[44] = list[i].name;
	child_ctx[45] = list[i].zIndex;
	child_ctx[46] = list;
	child_ctx[47] = i;
	return child_ctx;
}

// (346:1) {#if line_count === 0}
function create_if_block$3(ctx) {
	let div;
	let div_transition;
	let current;

	const block = {
		c: function create() {
			div = element("div");
			div.textContent = "Start drawing";
			attr_dev(div, "class", "absolute inset-0 flex items-center justify-center z-40 pointer-events-none touch-none text-gray-400 md:text-xl");
			add_location(div, file$4, 346, 2, 8084);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
			current = true;
		},
		i: function intro(local) {
			if (current) return;

			add_render_callback(() => {
				if (!div_transition) div_transition = create_bidirectional_transition(div, fade, { duration: 50 }, true);
				div_transition.run(1);
			});

			current = true;
		},
		o: function outro(local) {
			if (!div_transition) div_transition = create_bidirectional_transition(div, fade, { duration: 50 }, false);
			div_transition.run(0);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			if (detaching && div_transition) div_transition.end();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block$3.name,
		type: "if",
		source: "(346:1) {#if line_count === 0}",
		ctx
	});

	return block;
}

// (354:1) {#each canvas_types as { name, zIndex }}
function create_each_block(ctx) {
	let canvas_1;
	let name = /*name*/ ctx[44];
	let mounted;
	let dispose;
	const assign_canvas_1 = () => /*canvas_1_binding*/ ctx[14](canvas_1, name);
	const unassign_canvas_1 = () => /*canvas_1_binding*/ ctx[14](null, name);

	const block = {
		c: function create() {
			canvas_1 = element("canvas");
			attr_dev(canvas_1, "key", /*name*/ ctx[44]);
			set_style(canvas_1, "display", "block");
			set_style(canvas_1, "position", "absolute");
			set_style(canvas_1, "z-index", /*zIndex*/ ctx[45]);
			set_style(canvas_1, "width", /*canvas_width*/ ctx[0] + "px");
			set_style(canvas_1, "height", /*canvas_height*/ ctx[1] + "px");
			add_location(canvas_1, file$4, 354, 2, 8330);
		},
		m: function mount(target, anchor) {
			insert_dev(target, canvas_1, anchor);
			assign_canvas_1();

			if (!mounted) {
				dispose = [
					listen_dev(
						canvas_1,
						"mousedown",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_start*/ ctx[6]
						: undefined,
						false,
						false,
						false
					),
					listen_dev(
						canvas_1,
						"mousemove",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_move*/ ctx[7]
						: undefined,
						false,
						false,
						false
					),
					listen_dev(
						canvas_1,
						"mouseup",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_end*/ ctx[8]
						: undefined,
						false,
						false,
						false
					),
					listen_dev(
						canvas_1,
						"mouseout",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_end*/ ctx[8]
						: undefined,
						false,
						false,
						false
					),
					listen_dev(
						canvas_1,
						"touchstart",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_start*/ ctx[6]
						: undefined,
						false,
						false,
						false
					),
					listen_dev(
						canvas_1,
						"touchmove",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_move*/ ctx[7]
						: undefined,
						false,
						false,
						false
					),
					listen_dev(
						canvas_1,
						"touchend",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_end*/ ctx[8]
						: undefined,
						false,
						false,
						false
					),
					listen_dev(
						canvas_1,
						"touchcancel",
						/*name*/ ctx[44] === "interface"
						? /*handle_draw_end*/ ctx[8]
						: undefined,
						false,
						false,
						false
					)
				];

				mounted = true;
			}
		},
		p: function update(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty[0] & /*canvas_width*/ 1) {
				set_style(canvas_1, "width", /*canvas_width*/ ctx[0] + "px");
			}

			if (dirty[0] & /*canvas_height*/ 2) {
				set_style(canvas_1, "height", /*canvas_height*/ ctx[1] + "px");
			}

			if (name !== /*name*/ ctx[44]) {
				unassign_canvas_1();
				name = /*name*/ ctx[44];
				assign_canvas_1();
			}
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(canvas_1);
			unassign_canvas_1();
			mounted = false;
			run_all(dispose);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_each_block.name,
		type: "each",
		source: "(354:1) {#each canvas_types as { name, zIndex }}",
		ctx
	});

	return block;
}

function create_fragment$5(ctx) {
	let div;
	let t;
	let div_resize_listener;
	let current;
	let if_block = /*line_count*/ ctx[4] === 0 && create_if_block$3(ctx);
	let each_value = /*canvas_types*/ ctx[5];
	validate_each_argument(each_value);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	const block = {
		c: function create() {
			div = element("div");
			if (if_block) if_block.c();
			t = space();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr_dev(div, "class", "touch-none relative bg-red-500 h-full w-full");
			add_render_callback(() => /*div_elementresize_handler*/ ctx[16].call(div));
			add_location(div, file$4, 339, 0, 7899);
		},
		l: function claim(nodes) {
			throw new Error_1("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
			if (if_block) if_block.m(div, null);
			append_dev(div, t);

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].m(div, null);
			}

			/*div_binding*/ ctx[15](div);
			div_resize_listener = add_resize_listener(div, /*div_elementresize_handler*/ ctx[16].bind(div));
			current = true;
		},
		p: function update(ctx, dirty) {
			if (/*line_count*/ ctx[4] === 0) {
				if (if_block) {
					if (dirty[0] & /*line_count*/ 16) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block$3(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(div, t);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			if (dirty[0] & /*canvas_types, canvas_width, canvas_height, canvas, handle_draw_start, handle_draw_move, handle_draw_end*/ 487) {
				each_value = /*canvas_types*/ ctx[5];
				validate_each_argument(each_value);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			if (if_block) if_block.d();
			destroy_each(each_blocks, detaching);
			/*div_binding*/ ctx[15](null);
			div_resize_listener();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$5.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function mid_point(p1, p2) {
	return {
		x: p1.x + (p2.x - p1.x) / 2,
		y: p1.y + (p2.y - p1.y) / 2
	};
}

function instance$5($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Sketch', slots, []);
	const dispatch = createEventDispatcher();
	let { value } = $$props;
	let mounted;
	let brush_radius = 50;
	let brush_color = "#090f1f";
	let catenary_color = "#aaa";
	let canvas_width = 400;
	let canvas_height = 400;

	const canvas_types = [
		{ name: "interface", zIndex: 15 },
		{ name: "drawing", zIndex: 11 },
		{ name: "temp", zIndex: 12 }
	];

	let canvas = {};
	let ctx = {};
	let points = [];
	let lines = [];
	let mouse_has_moved = true;
	let values_changed = true;
	let is_drawing = false;
	let is_pressing = false;
	let lazy = null;
	let chain_length = null;
	let canvas_container = null;
	let canvas_observer = null;
	let save_data = "";
	let line_count = 0;

	onMount(() => {
		Object.keys(canvas).forEach(key => {
			ctx[key] = canvas[key].getContext("2d");
		});

		lazy = new LazyBrush({
				radius: brush_radius / 1.5,
				enabled: true,
				initialPoint: {
					x: window.innerWidth / 2,
					y: window.innerHeight / 2
				}
			});

		chain_length = brush_radius;
		canvas_observer = new index((entries, observer) => handle_canvas_resize(entries, observer));
		canvas_observer.observe(canvas_container);
		loop();
		$$invalidate(13, mounted = true);

		window.setTimeout(
			() => {
				const initX = window.innerWidth / 2;
				const initY = window.innerHeight / 2;
				lazy.update({ x: initX - chain_length / 4, y: initY }, { both: true });
				lazy.update({ x: initX + chain_length / 4, y: initY }, { both: false });
				mouse_has_moved = true;
				values_changed = true;
				clear();

				if (save_data) {
					load_save_data(save_data);
				}
			},
			100
		);
	});

	onDestroy(() => {
		$$invalidate(13, mounted = false);
		canvas_observer.unobserve(canvas_container);
	});

	function undo() {
		const _lines = lines.slice(0, -1);
		clear();
		draw_lines({ lines: _lines });
		$$invalidate(4, line_count = lines.length);
		trigger_on_change();
	}

	let get_save_data = () => {
		return JSON.stringify({
			lines,
			width: canvas_width,
			height: canvas_height
		});
	};

	let load_save_data = save_data => {
		if (typeof save_data !== "string") {
			throw new Error("save_data needs to be of type string!");
		}

		const { lines, width, height } = JSON.parse(save_data);

		if (!lines || typeof lines.push !== "function") {
			throw new Error("save_data.lines needs to be an array!");
		}

		clear();

		if (width === canvas_width && height === canvas_height) {
			draw_lines({ lines });
		} else {
			const scaleX = canvas_width / width;
			const scaleY = canvas_height / height;

			draw_lines({
				lines: lines.map(line => ({
					...line,
					points: line.points.map(p => ({ x: p.x * scaleX, y: p.y * scaleY })),
					brush_radius: line.brush_radius
				}))
			});
		}
	};

	let draw_lines = ({ lines }) => {
		lines.forEach(line => {
			const { points: _points, brush_color, brush_radius } = line;

			draw_points({
				points: _points,
				brush_color,
				brush_radius
			});

			points = _points;
			saveLine({ brush_color, brush_radius });
			return;
		});
	};

	let handle_draw_start = e => {
		e.preventDefault();
		is_pressing = true;
		const { x, y } = get_pointer_pos(e);

		if (e.touches && e.touches.length > 0) {
			lazy.update({ x, y }, { both: true });
		}

		handle_pointer_move(x, y);
		$$invalidate(4, line_count += 1);
	};

	let handle_draw_move = e => {
		e.preventDefault();
		const { x, y } = get_pointer_pos(e);
		handle_pointer_move(x, y);
	};

	let handle_draw_end = e => {
		e.preventDefault();
		handle_draw_move(e);
		is_drawing = false;
		is_pressing = false;
		saveLine();
	};

	let handle_canvas_resize = entries => {
		const save_data = get_save_data();

		for (const entry of entries) {
			const { width, height } = entry.contentRect;
			set_canvas_size(canvas.interface, width, height);
			set_canvas_size(canvas.drawing, width, height);
			set_canvas_size(canvas.temp, width, height);
			loop({ once: true });
		}

		load_save_data(save_data, true);
	};

	let set_canvas_size = (canvas, width, height) => {
		canvas.width = width * 3;
		canvas.height = height * 3;
		canvas.style.width = width;
		canvas.style.height = height;
	};

	let get_pointer_pos = e => {
		const rect = canvas.interface.getBoundingClientRect();
		let clientX = e.clientX;
		let clientY = e.clientY;

		if (e.changedTouches && e.changedTouches.length > 0) {
			clientX = e.changedTouches[0].clientX;
			clientY = e.changedTouches[0].clientY;
		}

		return {
			x: clientX - rect.left,
			y: clientY - rect.top
		};
	};

	let handle_pointer_move = (x, y) => {
		lazy.update({ x: x * 3, y: y * 3 });
		const is_disabled = !lazy.isEnabled();

		if (is_pressing && !is_drawing || is_disabled && is_pressing) {
			is_drawing = true;
			points.push(lazy.brush.toObject());
		}

		if (is_drawing) {
			points.push(lazy.brush.toObject());
			draw_points({ points, brush_color, brush_radius });
		}

		mouse_has_moved = true;
	};

	let draw_points = ({ points, brush_color, brush_radius }) => {
		ctx.temp.lineJoin = "round";
		ctx.temp.lineCap = "round";
		ctx.temp.strokeStyle = brush_color;
		ctx.temp.clearRect(0, 0, ctx.temp.canvas.width, ctx.temp.canvas.height);
		ctx.temp.lineWidth = brush_radius;
		let p1 = points[0];
		let p2 = points[1];
		ctx.temp.moveTo(p2.x, p2.y);
		ctx.temp.beginPath();

		for (var i = 1, len = points.length; i < len; i++) {
			var midPoint = mid_point(p1, p2);
			ctx.temp.quadraticCurveTo(p1.x, p1.y, midPoint.x, midPoint.y);
			p1 = points[i];
			p2 = points[i + 1];
		}

		ctx.temp.lineTo(p1.x, p1.y);
		ctx.temp.stroke();
	};

	let saveLine = () => {
		if (points.length < 2) return;

		lines.push({
			points: [...points],
			brush_color,
			brush_radius
		});

		points.length = 0;
		const width = canvas.temp.width;
		const height = canvas.temp.height;
		ctx.drawing.drawImage(canvas.temp, 0, 0, width, height);
		ctx.temp.clearRect(0, 0, width, height);
		trigger_on_change();
	};

	let trigger_on_change = () => {
		dispatch("change", get_image_data());
	};

	function clear() {
		lines = [];
		values_changed = true;
		ctx.drawing.clearRect(0, 0, canvas.drawing.width, canvas.drawing.height);
		ctx.temp.clearRect(0, 0, canvas.temp.width, canvas.temp.height);
		ctx.drawing.fillStyle = "#FFFFFF";
		ctx.drawing.fillRect(0, 0, canvas.drawing.width, canvas.drawing.height);
		$$invalidate(4, line_count = 0);
	}

	let loop = ({ once = false } = {}) => {
		if (mouse_has_moved || values_changed) {
			const pointer = lazy.getPointerCoordinates();
			const brush = lazy.getBrushCoordinates();
			draw_interface(ctx.interface, pointer, brush);
			mouse_has_moved = false;
			values_changed = false;
		}

		if (!once) {
			window.requestAnimationFrame(() => {
				loop();
			});
		}
	};

	let draw_interface = (ctx, pointer, brush) => {
		ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		// brush preview
		ctx.beginPath();

		ctx.fillStyle = brush_color;
		ctx.arc(brush.x, brush.y, brush_radius / 2, 0, Math.PI * 2, true);
		ctx.fill();

		// mouse point dangler
		ctx.beginPath();

		ctx.fillStyle = catenary_color;
		ctx.arc(pointer.x, pointer.y, 4, 0, Math.PI * 2, true);
		ctx.fill();

		//  catenary
		if (lazy.isEnabled()) {
			ctx.beginPath();
			ctx.lineWidth = 2;
			ctx.lineCap = "round";
			ctx.setLineDash([2, 4]);
			ctx.strokeStyle = catenary_color;
			ctx.stroke();
		}

		// tiny brush point dot
		ctx.beginPath();

		ctx.fillStyle = catenary_color;
		ctx.arc(brush.x, brush.y, 2, 0, Math.PI * 2, true);
		ctx.fill();
	};

	function get_image_data() {
		return canvas.drawing.toDataURL("image/png");
	}

	const writable_props = ['value'];

	Object_1.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Sketch> was created with unknown prop '${key}'`);
	});

	function canvas_1_binding($$value, name) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			canvas[name] = $$value;
			$$invalidate(2, canvas);
		});
	}

	function div_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			canvas_container = $$value;
			$$invalidate(3, canvas_container);
		});
	}

	function div_elementresize_handler() {
		canvas_width = this.offsetWidth;
		canvas_height = this.offsetHeight;
		$$invalidate(0, canvas_width);
		$$invalidate(1, canvas_height);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(9, value = $$props.value);
	};

	$$self.$capture_state = () => ({
		onMount,
		onDestroy,
		createEventDispatcher,
		fade,
		LazyBrush,
		ResizeObserver: index,
		dispatch,
		value,
		mounted,
		brush_radius,
		brush_color,
		catenary_color,
		canvas_width,
		canvas_height,
		mid_point,
		canvas_types,
		canvas,
		ctx,
		points,
		lines,
		mouse_has_moved,
		values_changed,
		is_drawing,
		is_pressing,
		lazy,
		chain_length,
		canvas_container,
		canvas_observer,
		save_data,
		line_count,
		undo,
		get_save_data,
		load_save_data,
		draw_lines,
		handle_draw_start,
		handle_draw_move,
		handle_draw_end,
		handle_canvas_resize,
		set_canvas_size,
		get_pointer_pos,
		handle_pointer_move,
		draw_points,
		saveLine,
		trigger_on_change,
		clear,
		loop,
		draw_interface,
		get_image_data
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(9, value = $$props.value);
		if ('mounted' in $$props) $$invalidate(13, mounted = $$props.mounted);
		if ('brush_radius' in $$props) brush_radius = $$props.brush_radius;
		if ('brush_color' in $$props) brush_color = $$props.brush_color;
		if ('catenary_color' in $$props) catenary_color = $$props.catenary_color;
		if ('canvas_width' in $$props) $$invalidate(0, canvas_width = $$props.canvas_width);
		if ('canvas_height' in $$props) $$invalidate(1, canvas_height = $$props.canvas_height);
		if ('canvas' in $$props) $$invalidate(2, canvas = $$props.canvas);
		if ('ctx' in $$props) ctx = $$props.ctx;
		if ('points' in $$props) points = $$props.points;
		if ('lines' in $$props) lines = $$props.lines;
		if ('mouse_has_moved' in $$props) mouse_has_moved = $$props.mouse_has_moved;
		if ('values_changed' in $$props) values_changed = $$props.values_changed;
		if ('is_drawing' in $$props) is_drawing = $$props.is_drawing;
		if ('is_pressing' in $$props) is_pressing = $$props.is_pressing;
		if ('lazy' in $$props) lazy = $$props.lazy;
		if ('chain_length' in $$props) chain_length = $$props.chain_length;
		if ('canvas_container' in $$props) $$invalidate(3, canvas_container = $$props.canvas_container);
		if ('canvas_observer' in $$props) canvas_observer = $$props.canvas_observer;
		if ('save_data' in $$props) save_data = $$props.save_data;
		if ('line_count' in $$props) $$invalidate(4, line_count = $$props.line_count);
		if ('get_save_data' in $$props) get_save_data = $$props.get_save_data;
		if ('load_save_data' in $$props) load_save_data = $$props.load_save_data;
		if ('draw_lines' in $$props) draw_lines = $$props.draw_lines;
		if ('handle_draw_start' in $$props) $$invalidate(6, handle_draw_start = $$props.handle_draw_start);
		if ('handle_draw_move' in $$props) $$invalidate(7, handle_draw_move = $$props.handle_draw_move);
		if ('handle_draw_end' in $$props) $$invalidate(8, handle_draw_end = $$props.handle_draw_end);
		if ('handle_canvas_resize' in $$props) handle_canvas_resize = $$props.handle_canvas_resize;
		if ('set_canvas_size' in $$props) set_canvas_size = $$props.set_canvas_size;
		if ('get_pointer_pos' in $$props) get_pointer_pos = $$props.get_pointer_pos;
		if ('handle_pointer_move' in $$props) handle_pointer_move = $$props.handle_pointer_move;
		if ('draw_points' in $$props) draw_points = $$props.draw_points;
		if ('saveLine' in $$props) saveLine = $$props.saveLine;
		if ('trigger_on_change' in $$props) trigger_on_change = $$props.trigger_on_change;
		if ('loop' in $$props) loop = $$props.loop;
		if ('draw_interface' in $$props) draw_interface = $$props.draw_interface;
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*mounted, value*/ 8704) {
			mounted && !value && clear();
		}
	};

	return [
		canvas_width,
		canvas_height,
		canvas,
		canvas_container,
		line_count,
		canvas_types,
		handle_draw_start,
		handle_draw_move,
		handle_draw_end,
		value,
		undo,
		clear,
		get_image_data,
		mounted,
		canvas_1_binding,
		div_binding,
		div_elementresize_handler
	];
}

class Sketch extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(
			this,
			options,
			instance$5,
			create_fragment$5,
			safe_not_equal,
			{
				value: 9,
				undo: 10,
				clear: 11,
				get_image_data: 12
			},
			null,
			[-1, -1]
		);

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Sketch",
			options,
			id: create_fragment$5.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*value*/ ctx[9] === undefined && !('value' in props)) {
			console.warn("<Sketch> was created without expected prop 'value'");
		}
	}

	get value() {
		throw new Error_1("<Sketch>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error_1("<Sketch>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get undo() {
		return this.$$.ctx[10];
	}

	set undo(value) {
		throw new Error_1("<Sketch>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get clear() {
		return this.$$.ctx[11];
	}

	set clear(value) {
		throw new Error_1("<Sketch>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get get_image_data() {
		return this.$$.ctx[12];
	}

	set get_image_data(value) {
		throw new Error_1("<Sketch>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/ModifySketch.svelte generated by Svelte v3.47.0 */
const file$3 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/ModifySketch.svelte";

function create_fragment$4(ctx) {
	let div;
	let iconbutton0;
	let t;
	let iconbutton1;
	let current;
	iconbutton0 = new IconButton({ props: { Icon: Undo }, $$inline: true });
	iconbutton0.$on("click", /*click_handler*/ ctx[1]);
	iconbutton1 = new IconButton({ props: { Icon: Clear }, $$inline: true });
	iconbutton1.$on("click", /*click_handler_1*/ ctx[2]);

	const block = {
		c: function create() {
			div = element("div");
			create_component(iconbutton0.$$.fragment);
			t = space();
			create_component(iconbutton1.$$.fragment);
			attr_dev(div, "class", "z-50 top-2 right-2 justify-end flex gap-1 absolute");
			add_location(div, file$3, 6, 0, 208);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
			mount_component(iconbutton0, div, null);
			append_dev(div, t);
			mount_component(iconbutton1, div, null);
			current = true;
		},
		p: noop,
		i: function intro(local) {
			if (current) return;
			transition_in(iconbutton0.$$.fragment, local);
			transition_in(iconbutton1.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(iconbutton0.$$.fragment, local);
			transition_out(iconbutton1.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
			destroy_component(iconbutton0);
			destroy_component(iconbutton1);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$4.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$4($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('ModifySketch', slots, []);
	const dispatch = createEventDispatcher();
	const writable_props = [];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<ModifySketch> was created with unknown prop '${key}'`);
	});

	const click_handler = () => dispatch("undo");
	const click_handler_1 = () => dispatch("clear");

	$$self.$capture_state = () => ({
		createEventDispatcher,
		IconButton,
		Undo,
		Clear,
		dispatch
	});

	return [dispatch, click_handler, click_handler_1];
}

class ModifySketch extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$4, create_fragment$4, safe_not_equal, {});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "ModifySketch",
			options,
			id: create_fragment$4.name
		});
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/ImageEditor.svelte generated by Svelte v3.47.0 */
const file$2 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/ImageEditor.svelte";

function create_fragment$3(ctx) {
	let div2;
	let div0;
	let button0;
	let t1;
	let button1;
	let t3;
	let div1;
	let mounted;
	let dispose;

	const block = {
		c: function create() {
			div2 = element("div");
			div0 = element("div");
			button0 = element("button");
			button0.textContent = "Save";
			t1 = space();
			button1 = element("button");
			button1.textContent = "Cancel";
			t3 = space();
			div1 = element("div");
			add_location(button0, file$2, 35, 2, 925);
			add_location(button1, file$2, 36, 2, 1003);
			attr_dev(div0, "class", "image_editor_buttons");
			add_location(div0, file$2, 34, 1, 888);
			add_location(div1, file$2, 38, 1, 1072);
			attr_dev(div2, "class", "fixed w-screen h-screen top-0 left-0 bg-black bg-opacity-50 z-40 flex flex-col justify-center items-center");
			add_location(div2, file$2, 31, 0, 764);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			insert_dev(target, div2, anchor);
			append_dev(div2, div0);
			append_dev(div0, button0);
			append_dev(div0, t1);
			append_dev(div0, button1);
			append_dev(div2, t3);
			append_dev(div2, div1);
			/*div1_binding*/ ctx[6](div1);

			if (!mounted) {
				dispose = [
					listen_dev(button0, "click", /*click_handler*/ ctx[4], false, false, false),
					listen_dev(button1, "click", /*click_handler_1*/ ctx[5], false, false, false)
				];

				mounted = true;
			}
		},
		p: noop,
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(div2);
			/*div1_binding*/ ctx[6](null);
			mounted = false;
			run_all(dispose);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$3.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$3($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('ImageEditor', slots, []);
	let { value } = $$props;
	let el;
	let editor;
	const dispatch = createEventDispatcher();

	function create_editor() {
		$$invalidate(1, editor = new ImageEditor(el,
		{
				usageStatistics: false,
				includeUI: {
					loadImage: { path: value, name: "Edit Image" },
					menuBarPosition: "left",
					uiSize: { width: "800px", height: "600px" }
				},
				cssMaxWidth: 700,
				cssMaxHeight: 500,
				selectionStyle: { cornerSize: 20, rotatingPointOffset: 70 }
			}));
	}

	onMount(create_editor);
	const writable_props = ['value'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<ImageEditor> was created with unknown prop '${key}'`);
	});

	const click_handler = () => dispatch("save", editor.toDataURL());
	const click_handler_1 = () => dispatch("cancel");

	function div1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(0, el);
		});
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(3, value = $$props.value);
	};

	$$self.$capture_state = () => ({
		ImageEditor,
		createEventDispatcher,
		onMount,
		value,
		el,
		editor,
		dispatch,
		create_editor
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(3, value = $$props.value);
		if ('el' in $$props) $$invalidate(0, el = $$props.el);
		if ('editor' in $$props) $$invalidate(1, editor = $$props.editor);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [el, editor, dispatch, value, click_handler, click_handler_1, div1_binding];
}

class ImageEditor_1 extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$3, create_fragment$3, safe_not_equal, { value: 3 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "ImageEditor_1",
			options,
			id: create_fragment$3.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*value*/ ctx[3] === undefined && !('value' in props)) {
			console.warn("<ImageEditor> was created without expected prop 'value'");
		}
	}

	get value() {
		throw new Error("<ImageEditor>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<ImageEditor>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/Image.svelte generated by Svelte v3.47.0 */
const file$1 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/Image.svelte";

// (85:1) {:else}
function create_else_block$2(ctx) {
	let img;
	let img_src_value;

	const block = {
		c: function create() {
			img = element("img");
			attr_dev(img, "class", "w-full h-full object-contain s-jgfuGbX8tZTu");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) attr_dev(img, "src", img_src_value);
			attr_dev(img, "alt", "");
			add_location(img, file$1, 85, 2, 2311);
		},
		m: function mount(target, anchor) {
			insert_dev(target, img, anchor);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*value*/ 1 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) {
				attr_dev(img, "src", img_src_value);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(img);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block$2.name,
		type: "else",
		source: "(85:1) {:else}",
		ctx
	});

	return block;
}

// (70:29) 
function create_if_block_5(ctx) {
	let t0;
	let modifyupload;
	let t1;
	let img;
	let img_src_value;
	let current;
	let if_block = /*mode*/ ctx[9] === "edit" && create_if_block_6(ctx);

	modifyupload = new ModifyUpload({
			props: { editable: true },
			$$inline: true
		});

	modifyupload.$on("edit", /*edit_handler*/ ctx[19]);
	modifyupload.$on("clear", /*handle_clear*/ ctx[12]);

	const block = {
		c: function create() {
			if (if_block) if_block.c();
			t0 = space();
			create_component(modifyupload.$$.fragment);
			t1 = space();
			img = element("img");
			attr_dev(img, "class", "w-full h-full object-contain s-jgfuGbX8tZTu");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) attr_dev(img, "src", img_src_value);
			attr_dev(img, "alt", "");
			add_location(img, file$1, 83, 2, 2236);
		},
		m: function mount(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert_dev(target, t0, anchor);
			mount_component(modifyupload, target, anchor);
			insert_dev(target, t1, anchor);
			insert_dev(target, img, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			if (/*mode*/ ctx[9] === "edit") {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*mode*/ 512) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block_6(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(t0.parentNode, t0);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			if (!current || dirty & /*value*/ 1 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) {
				attr_dev(img, "src", img_src_value);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(if_block);
			transition_in(modifyupload.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(if_block);
			transition_out(modifyupload.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (if_block) if_block.d(detaching);
			if (detaching) detach_dev(t0);
			destroy_component(modifyupload, detaching);
			if (detaching) detach_dev(t1);
			if (detaching) detach_dev(img);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block_5.name,
		type: "if",
		source: "(70:29) ",
		ctx
	});

	return block;
}

// (68:29) 
function create_if_block_4(ctx) {
	let cropper;
	let current;

	cropper = new Cropper_1({
			props: { image: /*value*/ ctx[0] },
			$$inline: true
		});

	cropper.$on("crop", /*handle_save*/ ctx[13]);

	const block = {
		c: function create() {
			create_component(cropper.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(cropper, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const cropper_changes = {};
			if (dirty & /*value*/ 1) cropper_changes.image = /*value*/ ctx[0];
			cropper.$set(cropper_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(cropper.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(cropper.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(cropper, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block_4.name,
		type: "if",
		source: "(68:29) ",
		ctx
	});

	return block;
}

// (51:26) 
function create_if_block_1(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_2, create_if_block_3];
	const if_blocks = [];

	function select_block_type_1(ctx, dirty) {
		if (/*source*/ ctx[3] === "upload") return 0;
		if (/*source*/ ctx[3] === "webcam") return 1;
		return -1;
	}

	if (~(current_block_type_index = select_block_type_1(ctx))) {
		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	const block = {
		c: function create() {
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m: function mount(target, anchor) {
			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(target, anchor);
			}

			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_1(ctx);

			if (current_block_type_index === previous_block_index) {
				if (~current_block_type_index) {
					if_blocks[current_block_type_index].p(ctx, dirty);
				}
			} else {
				if (if_block) {
					group_outros();

					transition_out(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros();
				}

				if (~current_block_type_index) {
					if_block = if_blocks[current_block_type_index];

					if (!if_block) {
						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block.c();
					} else {
						if_block.p(ctx, dirty);
					}

					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				} else {
					if_block = null;
				}
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d(detaching);
			}

			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block_1.name,
		type: "if",
		source: "(51:26) ",
		ctx
	});

	return block;
}

// (45:1) {#if source === "canvas"}
function create_if_block$2(ctx) {
	let modifysketch;
	let t;
	let sketch_1;
	let current;
	modifysketch = new ModifySketch({ $$inline: true });
	modifysketch.$on("undo", /*undo_handler*/ ctx[14]);
	modifysketch.$on("clear", /*clear_handler*/ ctx[15]);
	let sketch_1_props = { value: /*value*/ ctx[0] };
	sketch_1 = new Sketch({ props: sketch_1_props, $$inline: true });
	/*sketch_1_binding*/ ctx[16](sketch_1);
	sketch_1.$on("change", /*handle_save*/ ctx[13]);

	const block = {
		c: function create() {
			create_component(modifysketch.$$.fragment);
			t = space();
			create_component(sketch_1.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(modifysketch, target, anchor);
			insert_dev(target, t, anchor);
			mount_component(sketch_1, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const sketch_1_changes = {};
			if (dirty & /*value*/ 1) sketch_1_changes.value = /*value*/ ctx[0];
			sketch_1.$set(sketch_1_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(modifysketch.$$.fragment, local);
			transition_in(sketch_1.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(modifysketch.$$.fragment, local);
			transition_out(sketch_1.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(modifysketch, detaching);
			if (detaching) detach_dev(t);
			/*sketch_1_binding*/ ctx[16](null);
			destroy_component(sketch_1, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block$2.name,
		type: "if",
		source: "(45:1) {#if source === \\\"canvas\\\"}",
		ctx
	});

	return block;
}

// (71:2) {#if mode === "edit"}
function create_if_block_6(ctx) {
	let imageeditor;
	let current;

	imageeditor = new ImageEditor_1({
			props: { value: /*value*/ ctx[0] },
			$$inline: true
		});

	imageeditor.$on("cancel", /*cancel_handler*/ ctx[18]);
	imageeditor.$on("save", /*handle_save*/ ctx[13]);

	const block = {
		c: function create() {
			create_component(imageeditor.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(imageeditor, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const imageeditor_changes = {};
			if (dirty & /*value*/ 1) imageeditor_changes.value = /*value*/ ctx[0];
			imageeditor.$set(imageeditor_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(imageeditor.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(imageeditor.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(imageeditor, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block_6.name,
		type: "if",
		source: "(71:2) {#if mode === \\\"edit\\\"}",
		ctx
	});

	return block;
}

// (65:32) 
function create_if_block_3(ctx) {
	let webcam;
	let current;
	webcam = new Webcam({ $$inline: true });
	webcam.$on("capture", /*handle_save*/ ctx[13]);

	const block = {
		c: function create() {
			create_component(webcam.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(webcam, target, anchor);
			current = true;
		},
		p: noop,
		i: function intro(local) {
			if (current) return;
			transition_in(webcam.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(webcam.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(webcam, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block_3.name,
		type: "if",
		source: "(65:32) ",
		ctx
	});

	return block;
}

// (52:2) {#if source === "upload"}
function create_if_block_2(ctx) {
	let upload;
	let updating_dragging;
	let current;

	function upload_dragging_binding(value) {
		/*upload_dragging_binding*/ ctx[17](value);
	}

	let upload_props = {
		filetype: "image/x-png,image/gif,image/jpeg",
		include_file_metadata: false,
		$$slots: { default: [create_default_slot$1] },
		$$scope: { ctx }
	};

	if (/*dragging*/ ctx[8] !== void 0) {
		upload_props.dragging = /*dragging*/ ctx[8];
	}

	upload = new Upload({ props: upload_props, $$inline: true });
	binding_callbacks.push(() => bind(upload, 'dragging', upload_dragging_binding));
	upload.$on("load", /*handle_upload*/ ctx[11]);

	const block = {
		c: function create() {
			create_component(upload.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(upload, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const upload_changes = {};

			if (dirty & /*$$scope, upload_text, or_text, drop_text*/ 2097376) {
				upload_changes.$$scope = { dirty, ctx };
			}

			if (!updating_dragging && dirty & /*dragging*/ 256) {
				updating_dragging = true;
				upload_changes.dragging = /*dragging*/ ctx[8];
				add_flush_callback(() => updating_dragging = false);
			}

			upload.$set(upload_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(upload.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(upload.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(upload, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block_2.name,
		type: "if",
		source: "(52:2) {#if source === \\\"upload\\\"}",
		ctx
	});

	return block;
}

// (53:3) <Upload     bind:dragging     filetype="image/x-png,image/gif,image/jpeg"     on:load={handle_upload}     include_file_metadata={false}    >
function create_default_slot$1(ctx) {
	let div;
	let t0;
	let t1;
	let span;
	let t2;
	let t3;
	let t4;
	let t5;
	let t6;

	const block = {
		c: function create() {
			div = element("div");
			t0 = text(/*drop_text*/ ctx[5]);
			t1 = space();
			span = element("span");
			t2 = text("- ");
			t3 = text(/*or_text*/ ctx[6]);
			t4 = text(" -");
			t5 = space();
			t6 = text(/*upload_text*/ ctx[7]);
			attr_dev(span, "class", "text-gray-300 s-jgfuGbX8tZTu");
			add_location(span, file$1, 60, 5, 1726);
			attr_dev(div, "class", "flex flex-col s-jgfuGbX8tZTu");
			add_location(div, file$1, 58, 4, 1676);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div, anchor);
			append_dev(div, t0);
			append_dev(div, t1);
			append_dev(div, span);
			append_dev(span, t2);
			append_dev(span, t3);
			append_dev(span, t4);
			append_dev(div, t5);
			append_dev(div, t6);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*drop_text*/ 32) set_data_dev(t0, /*drop_text*/ ctx[5]);
			if (dirty & /*or_text*/ 64) set_data_dev(t3, /*or_text*/ ctx[6]);
			if (dirty & /*upload_text*/ 128) set_data_dev(t6, /*upload_text*/ ctx[7]);
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot$1.name,
		type: "slot",
		source: "(53:3) <Upload     bind:dragging     filetype=\\\"image/x-png,image/gif,image/jpeg\\\"     on:load={handle_upload}     include_file_metadata={false}    >",
		ctx
	});

	return block;
}

function create_fragment$2(ctx) {
	let blocklabel;
	let t;
	let div;
	let current_block_type_index;
	let if_block;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[2],
				Icon: /*source*/ ctx[3] === "canvas" ? Sketch$1 : Image,
				label: /*label*/ ctx[1] || (/*source*/ ctx[3] === "canvas" ? "Sketch" : "Image")
			},
			$$inline: true
		});

	const if_block_creators = [
		create_if_block$2,
		create_if_block_1,
		create_if_block_4,
		create_if_block_5,
		create_else_block$2
	];

	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*source*/ ctx[3] === "canvas") return 0;
		if (/*value*/ ctx[0] === null) return 1;
		if (/*tool*/ ctx[4] === "select") return 2;
		if (/*tool*/ ctx[4] === "editor") return 3;
		return 4;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	const block = {
		c: function create() {
			create_component(blocklabel.$$.fragment);
			t = space();
			div = element("div");
			if_block.c();
			attr_dev(div, "class", "s-jgfuGbX8tZTu");
			toggle_class(div, "bg-gray-200", /*value*/ ctx[0]);
			toggle_class(div, "h-60", /*source*/ ctx[3] !== "webcam");
			add_location(div, file$1, 43, 0, 1228);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert_dev(target, t, anchor);
			insert_dev(target, div, anchor);
			if_blocks[current_block_type_index].m(div, null);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 4) blocklabel_changes.show_label = /*show_label*/ ctx[2];
			if (dirty & /*source*/ 8) blocklabel_changes.Icon = /*source*/ ctx[3] === "canvas" ? Sketch$1 : Image;
			if (dirty & /*label, source*/ 10) blocklabel_changes.label = /*label*/ ctx[1] || (/*source*/ ctx[3] === "canvas" ? "Sketch" : "Image");
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(div, null);
			}

			if (dirty & /*value*/ 1) {
				toggle_class(div, "bg-gray-200", /*value*/ ctx[0]);
			}

			if (dirty & /*source*/ 8) {
				toggle_class(div, "h-60", /*source*/ ctx[3] !== "webcam");
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach_dev(t);
			if (detaching) detach_dev(div);
			if_blocks[current_block_type_index].d();
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$2.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$2($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Image', slots, []);
	let { value } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	let { source = "upload" } = $$props;
	let { tool = "editor" } = $$props;
	let { drop_text = "Drop an image file" } = $$props;
	let { or_text = "or" } = $$props;
	let { upload_text = "click to upload" } = $$props;
	let mode = "view";
	let sketch;

	function handle_upload({ detail }) {
		$$invalidate(0, value = detail);
	}

	function handle_clear({ detail }) {
		$$invalidate(0, value = null);
		dispatch("clear");
	}

	function handle_save({ detail }) {
		$$invalidate(0, value = detail);
		$$invalidate(9, mode = "view");
		dispatch("edit");
	}

	const dispatch = createEventDispatcher();
	let dragging = false;

	const writable_props = [
		'value',
		'label',
		'show_label',
		'source',
		'tool',
		'drop_text',
		'or_text',
		'upload_text'
	];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Image> was created with unknown prop '${key}'`);
	});

	const undo_handler = () => sketch.undo();
	const clear_handler = () => sketch.clear();

	function sketch_1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			sketch = $$value;
			$$invalidate(10, sketch);
		});
	}

	function upload_dragging_binding(value) {
		dragging = value;
		$$invalidate(8, dragging);
	}

	const cancel_handler = () => $$invalidate(9, mode = "view");
	const edit_handler = () => $$invalidate(9, mode = "edit");

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
		if ('source' in $$props) $$invalidate(3, source = $$props.source);
		if ('tool' in $$props) $$invalidate(4, tool = $$props.tool);
		if ('drop_text' in $$props) $$invalidate(5, drop_text = $$props.drop_text);
		if ('or_text' in $$props) $$invalidate(6, or_text = $$props.or_text);
		if ('upload_text' in $$props) $$invalidate(7, upload_text = $$props.upload_text);
	};

	$$self.$capture_state = () => ({
		createEventDispatcher,
		BlockLabel,
		Image,
		SketchIcon: Sketch$1,
		Cropper: Cropper_1,
		Sketch,
		Webcam,
		ModifySketch,
		ImageEditor: ImageEditor_1,
		Upload,
		ModifyUpload,
		value,
		label,
		show_label,
		source,
		tool,
		drop_text,
		or_text,
		upload_text,
		mode,
		sketch,
		handle_upload,
		handle_clear,
		handle_save,
		dispatch,
		dragging
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
		if ('source' in $$props) $$invalidate(3, source = $$props.source);
		if ('tool' in $$props) $$invalidate(4, tool = $$props.tool);
		if ('drop_text' in $$props) $$invalidate(5, drop_text = $$props.drop_text);
		if ('or_text' in $$props) $$invalidate(6, or_text = $$props.or_text);
		if ('upload_text' in $$props) $$invalidate(7, upload_text = $$props.upload_text);
		if ('mode' in $$props) $$invalidate(9, mode = $$props.mode);
		if ('sketch' in $$props) $$invalidate(10, sketch = $$props.sketch);
		if ('dragging' in $$props) $$invalidate(8, dragging = $$props.dragging);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			dispatch("change", value);
		}

		if ($$self.$$.dirty & /*dragging*/ 256) {
			dispatch("drag", dragging);
		}
	};

	return [
		value,
		label,
		show_label,
		source,
		tool,
		drop_text,
		or_text,
		upload_text,
		dragging,
		mode,
		sketch,
		handle_upload,
		handle_clear,
		handle_save,
		undo_handler,
		clear_handler,
		sketch_1_binding,
		upload_dragging_binding,
		cancel_handler,
		edit_handler
	];
}

class Image_1$2 extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$2, create_fragment$2, safe_not_equal, {
			value: 0,
			label: 1,
			show_label: 2,
			source: 3,
			tool: 4,
			drop_text: 5,
			or_text: 6,
			upload_text: 7
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Image_1",
			options,
			id: create_fragment$2.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*value*/ ctx[0] === undefined && !('value' in props)) {
			console.warn("<Image> was created without expected prop 'value'");
		}

		if (/*show_label*/ ctx[2] === undefined && !('show_label' in props)) {
			console.warn("<Image> was created without expected prop 'show_label'");
		}
	}

	get value() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get source() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set source(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get tool() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set tool(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get drop_text() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set drop_text(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get or_text() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set or_text(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get upload_text() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set upload_text(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/StaticImage.svelte generated by Svelte v3.47.0 */
const file = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/image/src/StaticImage.svelte";

// (16:0) {:else}
function create_else_block$1(ctx) {
	let img;
	let img_src_value;

	const block = {
		c: function create() {
			img = element("img");
			attr_dev(img, "class", "w-full h-full object-contain");
			if (!src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) attr_dev(img, "src", img_src_value);
			attr_dev(img, "alt", "");
			add_location(img, file, 16, 1, 547);
		},
		m: function mount(target, anchor) {
			insert_dev(target, img, anchor);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*value*/ 1 && !src_url_equal(img.src, img_src_value = /*value*/ ctx[0])) {
				attr_dev(img, "src", img_src_value);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(img);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block$1.name,
		type: "else",
		source: "(16:0) {:else}",
		ctx
	});

	return block;
}

// (12:0) {#if value === null}
function create_if_block$1(ctx) {
	let div1;
	let div0;
	let image;
	let current;
	image = new Image({ $$inline: true });

	const block = {
		c: function create() {
			div1 = element("div");
			div0 = element("div");
			create_component(image.$$.fragment);
			attr_dev(div0, "class", "h-5 dark:text-white opacity-50");
			add_location(div0, file, 13, 2, 470);
			attr_dev(div1, "class", "h-full min-h-[15rem] flex justify-center items-center");
			add_location(div1, file, 12, 1, 400);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div1, anchor);
			append_dev(div1, div0);
			mount_component(image, div0, null);
			current = true;
		},
		p: noop,
		i: function intro(local) {
			if (current) return;
			transition_in(image.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(image.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div1);
			destroy_component(image);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block$1.name,
		type: "if",
		source: "(12:0) {#if value === null}",
		ctx
	});

	return block;
}

function create_fragment$1(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[2],
				Icon: Image,
				label: /*label*/ ctx[1] || "Image"
			},
			$$inline: true
		});

	const if_block_creators = [create_if_block$1, create_else_block$1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0] === null) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	const block = {
		c: function create() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert_dev(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 4) blocklabel_changes.show_label = /*show_label*/ ctx[2];
			if (dirty & /*label*/ 2) blocklabel_changes.label = /*label*/ ctx[1] || "Image";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach_dev(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$1.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$1($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('StaticImage', slots, []);
	let { value } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	const dispatch = createEventDispatcher();
	const writable_props = ['value', 'label', 'show_label'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<StaticImage> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
	};

	$$self.$capture_state = () => ({
		createEventDispatcher,
		BlockLabel,
		Image,
		value,
		label,
		show_label,
		dispatch
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			value && dispatch("change", value);
		}
	};

	return [value, label, show_label];
}

class StaticImage extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { value: 0, label: 1, show_label: 2 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "StaticImage",
			options,
			id: create_fragment$1.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*value*/ ctx[0] === undefined && !('value' in props)) {
			console.warn("<StaticImage> was created without expected prop 'value'");
		}

		if (/*show_label*/ ctx[2] === undefined && !('show_label' in props)) {
			console.warn("<StaticImage> was created without expected prop 'show_label'");
		}
	}

	get value() {
		throw new Error("<StaticImage>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<StaticImage>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<StaticImage>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<StaticImage>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<StaticImage>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<StaticImage>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* src/components/Image/Image.svelte generated by Svelte v3.47.0 */

// (30:1) {:else}
function create_else_block(ctx) {
	let image;
	let updating_value;
	let current;

	function image_value_binding(value) {
		/*image_value_binding*/ ctx[10](value);
	}

	let image_props = {
		source: /*source*/ ctx[2],
		tool: /*tool*/ ctx[3],
		label: /*label*/ ctx[4],
		show_label: /*show_label*/ ctx[5],
		drop_text: /*$_*/ ctx[9]("interface.drop_image"),
		or_text: /*$_*/ ctx[9]("or"),
		upload_text: /*$_*/ ctx[9]("interface.click_to_upload")
	};

	if (/*value*/ ctx[0] !== void 0) {
		image_props.value = /*value*/ ctx[0];
	}

	image = new Image_1$2({ props: image_props, $$inline: true });
	binding_callbacks.push(() => bind(image, 'value', image_value_binding));
	image.$on("edit", /*edit_handler*/ ctx[11]);
	image.$on("clear", /*clear_handler*/ ctx[12]);
	image.$on("change", /*change_handler*/ ctx[13]);
	image.$on("drag", /*drag_handler*/ ctx[14]);

	const block = {
		c: function create() {
			create_component(image.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(image, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const image_changes = {};
			if (dirty & /*source*/ 4) image_changes.source = /*source*/ ctx[2];
			if (dirty & /*tool*/ 8) image_changes.tool = /*tool*/ ctx[3];
			if (dirty & /*label*/ 16) image_changes.label = /*label*/ ctx[4];
			if (dirty & /*show_label*/ 32) image_changes.show_label = /*show_label*/ ctx[5];
			if (dirty & /*$_*/ 512) image_changes.drop_text = /*$_*/ ctx[9]("interface.drop_image");
			if (dirty & /*$_*/ 512) image_changes.or_text = /*$_*/ ctx[9]("or");
			if (dirty & /*$_*/ 512) image_changes.upload_text = /*$_*/ ctx[9]("interface.click_to_upload");

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				image_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			image.$set(image_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(image.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(image.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(image, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block.name,
		type: "else",
		source: "(30:1) {:else}",
		ctx
	});

	return block;
}

// (28:1) {#if mode === "static"}
function create_if_block(ctx) {
	let staticimage;
	let current;

	staticimage = new StaticImage({
			props: {
				value: /*value*/ ctx[0],
				label: /*label*/ ctx[4],
				show_label: /*show_label*/ ctx[5]
			},
			$$inline: true
		});

	const block = {
		c: function create() {
			create_component(staticimage.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(staticimage, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const staticimage_changes = {};
			if (dirty & /*value*/ 1) staticimage_changes.value = /*value*/ ctx[0];
			if (dirty & /*label*/ 16) staticimage_changes.label = /*label*/ ctx[4];
			if (dirty & /*show_label*/ 32) staticimage_changes.show_label = /*show_label*/ ctx[5];
			staticimage.$set(staticimage_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(staticimage.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(staticimage.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(staticimage, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block.name,
		type: "if",
		source: "(28:1) {#if mode === \\\"static\\\"}",
		ctx
	});

	return block;
}

// (19:0) <Block  variant={mode === "dynamic" && value === null && source === "upload"   ? "dashed"   : "solid"}  color={dragging ? "green" : "grey"}  padding={false}  {elem_id} >
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[6]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({
			props: statustracker_props,
			$$inline: true
		});

	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*mode*/ ctx[7] === "static") return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	const block = {
		c: function create() {
			create_component(statustracker.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m: function mount(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert_dev(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 64)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[6])])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach_dev(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot.name,
		type: "slot",
		source: "(19:0) <Block  variant={mode === \\\"dynamic\\\" && value === null && source === \\\"upload\\\"   ? \\\"dashed\\\"   : \\\"solid\\\"}  color={dragging ? \\\"green\\\" : \\\"grey\\\"}  padding={false}  {elem_id} >",
		ctx
	});

	return block;
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				variant: /*mode*/ ctx[7] === "dynamic" && /*value*/ ctx[0] === null && /*source*/ ctx[2] === "upload"
				? "dashed"
				: "solid",
				color: /*dragging*/ ctx[8] ? "green" : "grey",
				padding: false,
				elem_id: /*elem_id*/ ctx[1],
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			},
			$$inline: true
		});

	const block_1 = {
		c: function create() {
			create_component(block.$$.fragment);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const block_changes = {};

			if (dirty & /*mode, value, source*/ 133) block_changes.variant = /*mode*/ ctx[7] === "dynamic" && /*value*/ ctx[0] === null && /*source*/ ctx[2] === "upload"
			? "dashed"
			: "solid";

			if (dirty & /*dragging*/ 256) block_changes.color = /*dragging*/ ctx[8] ? "green" : "grey";
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];

			if (dirty & /*$$scope, value, label, show_label, mode, source, tool, $_, dragging, loading_status*/ 66557) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(block, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block: block_1,
		id: create_fragment.name,
		type: "component",
		source: "",
		ctx
	});

	return block_1;
}

function instance($$self, $$props, $$invalidate) {
	let $_;
	validate_store(X, '_');
	component_subscribe($$self, X, $$value => $$invalidate(9, $_ = $$value));
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('Image', slots, []);
	let { elem_id = "" } = $$props;
	let { value = null } = $$props;
	let { source = "upload" } = $$props;
	let { tool = "editor" } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	let { loading_status } = $$props;
	let { mode } = $$props;
	const dispatch = createEventDispatcher();
	let dragging;

	const writable_props = [
		'elem_id',
		'value',
		'source',
		'tool',
		'label',
		'show_label',
		'loading_status',
		'mode'
	];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<Image> was created with unknown prop '${key}'`);
	});

	function image_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function edit_handler(event) {
		bubble.call(this, $$self, event);
	}

	function clear_handler(event) {
		bubble.call(this, $$self, event);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	const drag_handler = ({ detail }) => $$invalidate(8, dragging = detail);

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('source' in $$props) $$invalidate(2, source = $$props.source);
		if ('tool' in $$props) $$invalidate(3, tool = $$props.tool);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(6, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(7, mode = $$props.mode);
	};

	$$self.$capture_state = () => ({
		createEventDispatcher,
		Image: Image_1$2,
		StaticImage,
		Block,
		_: X,
		StatusTracker,
		elem_id,
		value,
		source,
		tool,
		label,
		show_label,
		loading_status,
		mode,
		dispatch,
		dragging,
		$_
	});

	$$self.$inject_state = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('source' in $$props) $$invalidate(2, source = $$props.source);
		if ('tool' in $$props) $$invalidate(3, tool = $$props.tool);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(6, loading_status = $$props.loading_status);
		if ('mode' in $$props) $$invalidate(7, mode = $$props.mode);
		if ('dragging' in $$props) $$invalidate(8, dragging = $$props.dragging);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			(dispatch("change"));
		}
	};

	return [
		value,
		elem_id,
		source,
		tool,
		label,
		show_label,
		loading_status,
		mode,
		dragging,
		$_,
		image_value_binding,
		edit_handler,
		clear_handler,
		change_handler,
		drag_handler
	];
}

class Image_1 extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			value: 0,
			source: 2,
			tool: 3,
			label: 4,
			show_label: 5,
			loading_status: 6,
			mode: 7
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "Image_1",
			options,
			id: create_fragment.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*label*/ ctx[4] === undefined && !('label' in props)) {
			console.warn("<Image> was created without expected prop 'label'");
		}

		if (/*show_label*/ ctx[5] === undefined && !('show_label' in props)) {
			console.warn("<Image> was created without expected prop 'show_label'");
		}

		if (/*loading_status*/ ctx[6] === undefined && !('loading_status' in props)) {
			console.warn("<Image> was created without expected prop 'loading_status'");
		}

		if (/*mode*/ ctx[7] === undefined && !('mode' in props)) {
			console.warn("<Image> was created without expected prop 'mode'");
		}
	}

	get elem_id() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set elem_id(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get value() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get source() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set source(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get tool() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set tool(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get loading_status() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set loading_status(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get mode() {
		throw new Error("<Image>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set mode(value) {
		throw new Error("<Image>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var Image_1$1 = Image_1;

const modes = ["static", "dynamic"];

export { Image_1$1 as Component, modes };
