import { S as SvelteComponentDev, i as init, s as safe_not_equal, d as dispatch_dev, v as validate_slots, B as create_component, w as space, q as empty, C as mount_component, e as insert_dev, G as group_outros, E as transition_out, H as check_outros, D as transition_in, F as destroy_component, g as detach_dev, h as element, b as attr_dev, c as add_location, f as append_dev, n as noop, a as svg_element, k as text, m as set_data_dev, y as createEventDispatcher, ab as tick, I as binding_callbacks, L as bind, M as add_flush_callback, P as validate_store, X, Q as component_subscribe, R as StatusTracker, T as assign, K as bubble, U as get_spread_update, V as get_spread_object } from './index.50e14928.js';
import { B as BlockLabel } from './BlockLabel.ef852488.js';
import { F as File } from './File.740df8ae.js';
import { U as Upload } from './Upload.6b2c09a6.js';
import { M as ModifyUpload } from './ModifyUpload.a4d2175f.js';
import { B as Block } from './Block.a61554cb.js';
import { n as normalise_file } from './utils.49185b04.js';
import './styles.d87a390f.js';

const prettyBytes = (bytes) => {
  let units = ["B", "KB", "MB", "GB", "PB"];
  let i = 0;
  while (bytes > 1024) {
    bytes /= 1024;
    i++;
  }
  let unit = units[i];
  return bytes.toFixed(1) + " " + unit;
};

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/file/src/File.svelte generated by Svelte v3.47.0 */
const file$1 = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/file/src/File.svelte";

// (36:0) {:else}
function create_else_block$2(ctx) {
	let div1;
	let div0;
	let file_1;
	let current;
	file_1 = new File({ $$inline: true });

	const block = {
		c: function create() {
			div1 = element("div");
			div0 = element("div");
			create_component(file_1.$$.fragment);
			attr_dev(div0, "class", "h-5 dark:text-white opacity-50");
			add_location(div0, file$1, 37, 2, 1054);
			attr_dev(div1, "class", "h-full min-h-[15rem] flex justify-center items-center");
			add_location(div1, file$1, 36, 1, 984);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div1, anchor);
			append_dev(div1, div0);
			mount_component(file_1, div0, null);
			current = true;
		},
		p: noop,
		i: function intro(local) {
			if (current) return;
			transition_in(file_1.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(file_1.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div1);
			destroy_component(file_1);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block$2.name,
		type: "else",
		source: "(36:0) {:else}",
		ctx
	});

	return block;
}

// (11:0) {#if value}
function create_if_block$2(ctx) {
	let a;
	let svg;
	let path;
	let t0;
	let div0;
	let t1_value = /*value*/ ctx[0].name + "";
	let t1;
	let t2;
	let div1;

	let t3_value = (isNaN(/*value*/ ctx[0].size || NaN)
	? ""
	: prettyBytes(/*value*/ ctx[0].size || 0)) + "";

	let t3;
	let a_href_value;
	let a_download_value;

	const block = {
		c: function create() {
			a = element("a");
			svg = svg_element("svg");
			path = svg_element("path");
			t0 = space();
			div0 = element("div");
			t1 = text(t1_value);
			t2 = space();
			div1 = element("div");
			t3 = text(t3_value);
			attr_dev(path, "stroke-linecap", "round");
			attr_dev(path, "stroke-linejoin", "round");
			attr_dev(path, "stroke-width", "2");
			attr_dev(path, "d", "M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z");
			add_location(path, file$1, 23, 3, 570);
			attr_dev(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr_dev(svg, "class", "h-5 w-1/5");
			attr_dev(svg, "fill", "none");
			attr_dev(svg, "viewBox", "0 0 24 24");
			attr_dev(svg, "stroke", "currentColor");
			add_location(svg, file$1, 16, 2, 436);
			attr_dev(div0, "class", "file-name w-3/5 text-4xl p-6 break-all");
			add_location(div0, file$1, 30, 2, 794);
			attr_dev(div1, "class", "text-2xl p-2");
			add_location(div1, file$1, 31, 2, 867);
			attr_dev(a, "class", "output-file w-full h-full flex flex-row flex-wrap justify-center items-center relative");
			attr_dev(a, "href", a_href_value = /*value*/ ctx[0].data);
			attr_dev(a, "download", a_download_value = /*value*/ ctx[0].name);
			add_location(a, file$1, 11, 1, 287);
		},
		m: function mount(target, anchor) {
			insert_dev(target, a, anchor);
			append_dev(a, svg);
			append_dev(svg, path);
			append_dev(a, t0);
			append_dev(a, div0);
			append_dev(div0, t1);
			append_dev(a, t2);
			append_dev(a, div1);
			append_dev(div1, t3);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*value*/ 1 && t1_value !== (t1_value = /*value*/ ctx[0].name + "")) set_data_dev(t1, t1_value);

			if (dirty & /*value*/ 1 && t3_value !== (t3_value = (isNaN(/*value*/ ctx[0].size || NaN)
			? ""
			: prettyBytes(/*value*/ ctx[0].size || 0)) + "")) set_data_dev(t3, t3_value);

			if (dirty & /*value*/ 1 && a_href_value !== (a_href_value = /*value*/ ctx[0].data)) {
				attr_dev(a, "href", a_href_value);
			}

			if (dirty & /*value*/ 1 && a_download_value !== (a_download_value = /*value*/ ctx[0].name)) {
				attr_dev(a, "download", a_download_value);
			}
		},
		i: noop,
		o: noop,
		d: function destroy(detaching) {
			if (detaching) detach_dev(a);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block$2.name,
		type: "if",
		source: "(11:0) {#if value}",
		ctx
	});

	return block;
}

function create_fragment$2(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[2],
				Icon: File,
				label: /*label*/ ctx[1] || "File"
			},
			$$inline: true
		});

	const if_block_creators = [create_if_block$2, create_else_block$2];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	const block = {
		c: function create() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert_dev(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 4) blocklabel_changes.show_label = /*show_label*/ ctx[2];
			if (dirty & /*label*/ 2) blocklabel_changes.label = /*label*/ ctx[1] || "File";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach_dev(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$2.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function instance$2($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('File', slots, []);
	let { value } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	const writable_props = ['value', 'label', 'show_label'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<File> was created with unknown prop '${key}'`);
	});

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
	};

	$$self.$capture_state = () => ({
		BlockLabel,
		prettyBytes,
		File,
		value,
		label,
		show_label
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	return [value, label, show_label];
}

class File_1$2 extends SvelteComponentDev {
	constructor(options) {
		super(options);
		init(this, options, instance$2, create_fragment$2, safe_not_equal, { value: 0, label: 1, show_label: 2 });

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "File_1",
			options,
			id: create_fragment$2.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*value*/ ctx[0] === undefined && !('value' in props)) {
			console.warn("<File> was created without expected prop 'value'");
		}

		if (/*label*/ ctx[1] === undefined && !('label' in props)) {
			console.warn("<File> was created without expected prop 'label'");
		}

		if (/*show_label*/ ctx[2] === undefined && !('show_label' in props)) {
			console.warn("<File> was created without expected prop 'show_label'");
		}
	}

	get value() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/file/src/FileUpload.svelte generated by Svelte v3.47.0 */
const file = "mnt/c/Users/islam/dev/gradio-repos/gradio/ui/packages/file/src/FileUpload.svelte";

// (43:0) {:else}
function create_else_block$1(ctx) {
	let div3;
	let modifyupload;
	let t0;
	let div0;
	let t1_value = truncate(/*value*/ ctx[0].name) + "";
	let t1;
	let t2;
	let div1;
	let t3_value = prettyBytes(/*value*/ ctx[0].size || 0) + "";
	let t3;
	let t4;
	let div2;
	let a;
	let t5;
	let a_href_value;
	let current;

	modifyupload = new ModifyUpload({
			props: { absolute: true },
			$$inline: true
		});

	modifyupload.$on("clear", /*handle_clear*/ ctx[8]);

	const block = {
		c: function create() {
			div3 = element("div");
			create_component(modifyupload.$$.fragment);
			t0 = space();
			div0 = element("div");
			t1 = text(t1_value);
			t2 = space();
			div1 = element("div");
			t3 = text(t3_value);
			t4 = space();
			div2 = element("div");
			a = element("a");
			t5 = text("Download");
			attr_dev(div0, "class", "file-name p-2");
			add_location(div0, file, 48, 2, 1272);
			attr_dev(div1, "class", "file-size p-2");
			add_location(div1, file, 51, 2, 1337);
			attr_dev(a, "href", a_href_value = /*value*/ ctx[0].data);
			attr_dev(a, "download", "");
			attr_dev(a, "class", "text-indigo-600 hover:underline");
			add_location(a, file, 55, 3, 1458);
			attr_dev(div2, "class", "file-size p-2 hover:underline");
			add_location(div2, file, 54, 2, 1411);
			attr_dev(div3, "class", "file-preview w-full flex flex-row justify-between overflow-y-auto mt-7");
			add_location(div3, file, 43, 1, 1128);
		},
		m: function mount(target, anchor) {
			insert_dev(target, div3, anchor);
			mount_component(modifyupload, div3, null);
			append_dev(div3, t0);
			append_dev(div3, div0);
			append_dev(div0, t1);
			append_dev(div3, t2);
			append_dev(div3, div1);
			append_dev(div1, t3);
			append_dev(div3, t4);
			append_dev(div3, div2);
			append_dev(div2, a);
			append_dev(a, t5);
			current = true;
		},
		p: function update(ctx, dirty) {
			if ((!current || dirty & /*value*/ 1) && t1_value !== (t1_value = truncate(/*value*/ ctx[0].name) + "")) set_data_dev(t1, t1_value);
			if ((!current || dirty & /*value*/ 1) && t3_value !== (t3_value = prettyBytes(/*value*/ ctx[0].size || 0) + "")) set_data_dev(t3, t3_value);

			if (!current || dirty & /*value*/ 1 && a_href_value !== (a_href_value = /*value*/ ctx[0].data)) {
				attr_dev(a, "href", a_href_value);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(modifyupload.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(modifyupload.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(div3);
			destroy_component(modifyupload);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block$1.name,
		type: "else",
		source: "(43:0) {:else}",
		ctx
	});

	return block;
}

// (37:0) {#if value === null}
function create_if_block$1(ctx) {
	let upload;
	let updating_dragging;
	let current;

	function upload_dragging_binding(value) {
		/*upload_dragging_binding*/ ctx[10](value);
	}

	let upload_props = {
		filetype: "file",
		$$slots: { default: [create_default_slot$1] },
		$$scope: { ctx }
	};

	if (/*dragging*/ ctx[6] !== void 0) {
		upload_props.dragging = /*dragging*/ ctx[6];
	}

	upload = new Upload({ props: upload_props, $$inline: true });
	binding_callbacks.push(() => bind(upload, 'dragging', upload_dragging_binding));
	upload.$on("load", /*handle_upload*/ ctx[7]);

	const block = {
		c: function create() {
			create_component(upload.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(upload, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const upload_changes = {};

			if (dirty & /*$$scope, upload_text, or_text, drop_text*/ 4110) {
				upload_changes.$$scope = { dirty, ctx };
			}

			if (!updating_dragging && dirty & /*dragging*/ 64) {
				updating_dragging = true;
				upload_changes.dragging = /*dragging*/ ctx[6];
				add_flush_callback(() => updating_dragging = false);
			}

			upload.$set(upload_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(upload.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(upload.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(upload, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block$1.name,
		type: "if",
		source: "(37:0) {#if value === null}",
		ctx
	});

	return block;
}

// (38:1) <Upload on:load={handle_upload} filetype="file" bind:dragging>
function create_default_slot$1(ctx) {
	let t0;
	let t1;
	let br0;
	let t2;
	let t3;
	let t4;
	let br1;
	let t5;
	let t6;

	const block = {
		c: function create() {
			t0 = text(/*drop_text*/ ctx[1]);
			t1 = space();
			br0 = element("br");
			t2 = text("- ");
			t3 = text(/*or_text*/ ctx[2]);
			t4 = text(" -");
			br1 = element("br");
			t5 = space();
			t6 = text(/*upload_text*/ ctx[3]);
			add_location(br0, file, 39, 2, 1066);
			add_location(br1, file, 39, 21, 1085);
		},
		m: function mount(target, anchor) {
			insert_dev(target, t0, anchor);
			insert_dev(target, t1, anchor);
			insert_dev(target, br0, anchor);
			insert_dev(target, t2, anchor);
			insert_dev(target, t3, anchor);
			insert_dev(target, t4, anchor);
			insert_dev(target, br1, anchor);
			insert_dev(target, t5, anchor);
			insert_dev(target, t6, anchor);
		},
		p: function update(ctx, dirty) {
			if (dirty & /*drop_text*/ 2) set_data_dev(t0, /*drop_text*/ ctx[1]);
			if (dirty & /*or_text*/ 4) set_data_dev(t3, /*or_text*/ ctx[2]);
			if (dirty & /*upload_text*/ 8) set_data_dev(t6, /*upload_text*/ ctx[3]);
		},
		d: function destroy(detaching) {
			if (detaching) detach_dev(t0);
			if (detaching) detach_dev(t1);
			if (detaching) detach_dev(br0);
			if (detaching) detach_dev(t2);
			if (detaching) detach_dev(t3);
			if (detaching) detach_dev(t4);
			if (detaching) detach_dev(br1);
			if (detaching) detach_dev(t5);
			if (detaching) detach_dev(t6);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot$1.name,
		type: "slot",
		source: "(38:1) <Upload on:load={handle_upload} filetype=\\\"file\\\" bind:dragging>",
		ctx
	});

	return block;
}

function create_fragment$1(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[5],
				Icon: File,
				label: /*label*/ ctx[4] || "File"
			},
			$$inline: true
		});

	const if_block_creators = [create_if_block$1, create_else_block$1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0] === null) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	const block = {
		c: function create() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert_dev(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 32) blocklabel_changes.show_label = /*show_label*/ ctx[5];
			if (dirty & /*label*/ 16) blocklabel_changes.label = /*label*/ ctx[4] || "File";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach_dev(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_fragment$1.name,
		type: "component",
		source: "",
		ctx
	});

	return block;
}

function truncate(str) {
	if (str.length > 30) {
		return `${str.substr(0, 30)}...`;
	} else return str;
}

function instance$1($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('FileUpload', slots, []);
	let { value } = $$props;
	let { drop_text = "Drop a file" } = $$props;
	let { or_text = "or" } = $$props;
	let { upload_text = "click to upload" } = $$props;
	let { label = "" } = $$props;
	let { style } = $$props;
	let { show_label } = $$props;

	async function handle_upload({ detail }) {
		$$invalidate(0, value = detail);
		await tick();
		dispatch("change", value);
	}

	function handle_clear({ detail }) {
		$$invalidate(0, value = null);
		dispatch("change", value);
		dispatch("clear");
	}

	const dispatch = createEventDispatcher();
	let dragging = false;
	const writable_props = ['value', 'drop_text', 'or_text', 'upload_text', 'label', 'style', 'show_label'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<FileUpload> was created with unknown prop '${key}'`);
	});

	function upload_dragging_binding(value) {
		dragging = value;
		$$invalidate(6, dragging);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('drop_text' in $$props) $$invalidate(1, drop_text = $$props.drop_text);
		if ('or_text' in $$props) $$invalidate(2, or_text = $$props.or_text);
		if ('upload_text' in $$props) $$invalidate(3, upload_text = $$props.upload_text);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('style' in $$props) $$invalidate(9, style = $$props.style);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
	};

	$$self.$capture_state = () => ({
		createEventDispatcher,
		tick,
		Upload,
		ModifyUpload,
		BlockLabel,
		File,
		prettyBytes,
		value,
		drop_text,
		or_text,
		upload_text,
		label,
		style,
		show_label,
		handle_upload,
		handle_clear,
		dispatch,
		truncate,
		dragging
	});

	$$self.$inject_state = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('drop_text' in $$props) $$invalidate(1, drop_text = $$props.drop_text);
		if ('or_text' in $$props) $$invalidate(2, or_text = $$props.or_text);
		if ('upload_text' in $$props) $$invalidate(3, upload_text = $$props.upload_text);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('style' in $$props) $$invalidate(9, style = $$props.style);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('dragging' in $$props) $$invalidate(6, dragging = $$props.dragging);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*dragging*/ 64) {
			dispatch("drag", dragging);
		}
	};

	return [
		value,
		drop_text,
		or_text,
		upload_text,
		label,
		show_label,
		dragging,
		handle_upload,
		handle_clear,
		style,
		upload_dragging_binding
	];
}

class FileUpload extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			drop_text: 1,
			or_text: 2,
			upload_text: 3,
			label: 4,
			style: 9,
			show_label: 5
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "FileUpload",
			options,
			id: create_fragment$1.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*value*/ ctx[0] === undefined && !('value' in props)) {
			console.warn("<FileUpload> was created without expected prop 'value'");
		}

		if (/*style*/ ctx[9] === undefined && !('style' in props)) {
			console.warn("<FileUpload> was created without expected prop 'style'");
		}

		if (/*show_label*/ ctx[5] === undefined && !('show_label' in props)) {
			console.warn("<FileUpload> was created without expected prop 'show_label'");
		}
	}

	get value() {
		throw new Error("<FileUpload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<FileUpload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get drop_text() {
		throw new Error("<FileUpload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set drop_text(value) {
		throw new Error("<FileUpload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get or_text() {
		throw new Error("<FileUpload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set or_text(value) {
		throw new Error("<FileUpload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get upload_text() {
		throw new Error("<FileUpload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set upload_text(value) {
		throw new Error("<FileUpload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<FileUpload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<FileUpload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get style() {
		throw new Error("<FileUpload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set style(value) {
		throw new Error("<FileUpload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<FileUpload>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<FileUpload>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

/* src/components/File/File.svelte generated by Svelte v3.47.0 */

// (39:1) {:else}
function create_else_block(ctx) {
	let file_1;
	let current;

	file_1 = new File_1$2({
			props: {
				value: /*_value*/ ctx[6],
				label: /*label*/ ctx[3],
				show_label: /*show_label*/ ctx[4]
			},
			$$inline: true
		});

	const block = {
		c: function create() {
			create_component(file_1.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(file_1, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const file_1_changes = {};
			if (dirty & /*_value*/ 64) file_1_changes.value = /*_value*/ ctx[6];
			if (dirty & /*label*/ 8) file_1_changes.label = /*label*/ ctx[3];
			if (dirty & /*show_label*/ 16) file_1_changes.show_label = /*show_label*/ ctx[4];
			file_1.$set(file_1_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(file_1.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(file_1.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(file_1, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_else_block.name,
		type: "else",
		source: "(39:1) {:else}",
		ctx
	});

	return block;
}

// (26:1) {#if mode === "dynamic"}
function create_if_block(ctx) {
	let fileupload;
	let current;

	fileupload = new FileUpload({
			props: {
				label: /*label*/ ctx[3],
				show_label: /*show_label*/ ctx[4],
				value: /*_value*/ ctx[6],
				drop_text: /*$_*/ ctx[8]("interface.drop_file"),
				or_text: /*$_*/ ctx[8]("or"),
				upload_text: /*$_*/ ctx[8]("interface.click_to_upload")
			},
			$$inline: true
		});

	fileupload.$on("change", /*change_handler_1*/ ctx[10]);
	fileupload.$on("drag", /*drag_handler*/ ctx[11]);
	fileupload.$on("change", /*change_handler*/ ctx[12]);
	fileupload.$on("clear", /*clear_handler*/ ctx[13]);

	const block = {
		c: function create() {
			create_component(fileupload.$$.fragment);
		},
		m: function mount(target, anchor) {
			mount_component(fileupload, target, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const fileupload_changes = {};
			if (dirty & /*label*/ 8) fileupload_changes.label = /*label*/ ctx[3];
			if (dirty & /*show_label*/ 16) fileupload_changes.show_label = /*show_label*/ ctx[4];
			if (dirty & /*_value*/ 64) fileupload_changes.value = /*_value*/ ctx[6];
			if (dirty & /*$_*/ 256) fileupload_changes.drop_text = /*$_*/ ctx[8]("interface.drop_file");
			if (dirty & /*$_*/ 256) fileupload_changes.or_text = /*$_*/ ctx[8]("or");
			if (dirty & /*$_*/ 256) fileupload_changes.upload_text = /*$_*/ ctx[8]("interface.click_to_upload");
			fileupload.$set(fileupload_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(fileupload.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(fileupload.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(fileupload, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_if_block.name,
		type: "if",
		source: "(26:1) {#if mode === \\\"dynamic\\\"}",
		ctx
	});

	return block;
}

// (18:0) <Block  variant={mode === "dynamic" && value === null ? "dashed" : "solid"}  color={dragging ? "green" : "grey"}  padding={false}  {elem_id} >
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[5]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({
			props: statustracker_props,
			$$inline: true
		});

	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*mode*/ ctx[2] === "dynamic") return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	const block = {
		c: function create() {
			create_component(statustracker.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m: function mount(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert_dev(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert_dev(target, if_block_anchor, anchor);
			current = true;
		},
		p: function update(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 32)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[5])])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i: function intro(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o: function outro(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach_dev(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach_dev(if_block_anchor);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block,
		id: create_default_slot.name,
		type: "slot",
		source: "(18:0) <Block  variant={mode === \\\"dynamic\\\" && value === null ? \\\"dashed\\\" : \\\"solid\\\"}  color={dragging ? \\\"green\\\" : \\\"grey\\\"}  padding={false}  {elem_id} >",
		ctx
	});

	return block;
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				variant: /*mode*/ ctx[2] === "dynamic" && /*value*/ ctx[0] === null
				? "dashed"
				: "solid",
				color: /*dragging*/ ctx[7] ? "green" : "grey",
				padding: false,
				elem_id: /*elem_id*/ ctx[1],
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			},
			$$inline: true
		});

	const block_1 = {
		c: function create() {
			create_component(block.$$.fragment);
		},
		l: function claim(nodes) {
			throw new Error("options.hydrate only works if the component was compiled with the `hydratable: true` option");
		},
		m: function mount(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p: function update(ctx, [dirty]) {
			const block_changes = {};

			if (dirty & /*mode, value*/ 5) block_changes.variant = /*mode*/ ctx[2] === "dynamic" && /*value*/ ctx[0] === null
			? "dashed"
			: "solid";

			if (dirty & /*dragging*/ 128) block_changes.color = /*dragging*/ ctx[7] ? "green" : "grey";
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];

			if (dirty & /*$$scope, label, show_label, _value, $_, value, dragging, mode, loading_status*/ 16893) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i: function intro(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o: function outro(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d: function destroy(detaching) {
			destroy_component(block, detaching);
		}
	};

	dispatch_dev("SvelteRegisterBlock", {
		block: block_1,
		id: create_fragment.name,
		type: "component",
		source: "",
		ctx
	});

	return block_1;
}

function instance($$self, $$props, $$invalidate) {
	let $_;
	validate_store(X, '_');
	component_subscribe($$self, X, $$value => $$invalidate(8, $_ = $$value));
	let { $$slots: slots = {}, $$scope } = $$props;
	validate_slots('File', slots, []);
	let { elem_id = "" } = $$props;
	let { value = null } = $$props;
	let { mode } = $$props;
	let { root } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	let { loading_status } = $$props;
	let _value;
	let dragging = false;
	const writable_props = ['elem_id', 'value', 'mode', 'root', 'label', 'show_label', 'loading_status'];

	Object.keys($$props).forEach(key => {
		if (!~writable_props.indexOf(key) && key.slice(0, 2) !== '$$' && key !== 'slot') console.warn(`<File> was created with unknown prop '${key}'`);
	});

	const change_handler_1 = ({ detail }) => $$invalidate(0, value = detail);
	const drag_handler = ({ detail }) => $$invalidate(7, dragging = detail);

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function clear_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('mode' in $$props) $$invalidate(2, mode = $$props.mode);
		if ('root' in $$props) $$invalidate(9, root = $$props.root);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(4, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(5, loading_status = $$props.loading_status);
	};

	$$self.$capture_state = () => ({
		File: File_1$2,
		FileUpload,
		normalise_file,
		Block,
		StatusTracker,
		_: X,
		elem_id,
		value,
		mode,
		root,
		label,
		show_label,
		loading_status,
		_value,
		dragging,
		$_
	});

	$$self.$inject_state = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('mode' in $$props) $$invalidate(2, mode = $$props.mode);
		if ('root' in $$props) $$invalidate(9, root = $$props.root);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(4, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(5, loading_status = $$props.loading_status);
		if ('_value' in $$props) $$invalidate(6, _value = $$props._value);
		if ('dragging' in $$props) $$invalidate(7, dragging = $$props.dragging);
	};

	if ($$props && "$$inject" in $$props) {
		$$self.$inject_state($$props.$$inject);
	}

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value, root*/ 513) {
			$$invalidate(6, _value = normalise_file(value, root));
		}
	};

	return [
		value,
		elem_id,
		mode,
		label,
		show_label,
		loading_status,
		_value,
		dragging,
		$_,
		root,
		change_handler_1,
		drag_handler,
		change_handler,
		clear_handler
	];
}

class File_1 extends SvelteComponentDev {
	constructor(options) {
		super(options);

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			value: 0,
			mode: 2,
			root: 9,
			label: 3,
			show_label: 4,
			loading_status: 5
		});

		dispatch_dev("SvelteRegisterComponent", {
			component: this,
			tagName: "File_1",
			options,
			id: create_fragment.name
		});

		const { ctx } = this.$$;
		const props = options.props || {};

		if (/*mode*/ ctx[2] === undefined && !('mode' in props)) {
			console.warn("<File> was created without expected prop 'mode'");
		}

		if (/*root*/ ctx[9] === undefined && !('root' in props)) {
			console.warn("<File> was created without expected prop 'root'");
		}

		if (/*label*/ ctx[3] === undefined && !('label' in props)) {
			console.warn("<File> was created without expected prop 'label'");
		}

		if (/*show_label*/ ctx[4] === undefined && !('show_label' in props)) {
			console.warn("<File> was created without expected prop 'show_label'");
		}

		if (/*loading_status*/ ctx[5] === undefined && !('loading_status' in props)) {
			console.warn("<File> was created without expected prop 'loading_status'");
		}
	}

	get elem_id() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set elem_id(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get value() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set value(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get mode() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set mode(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get root() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set root(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get label() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set label(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get show_label() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set show_label(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	get loading_status() {
		throw new Error("<File>: Props cannot be read directly from the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}

	set loading_status(value) {
		throw new Error("<File>: Props cannot be set directly on the component instance unless compiling with 'accessors: true' or '<svelte:options accessors/>'");
	}
}

var File_1$1 = File_1;

const modes = ["static", "dynamic"];

export { File_1$1 as Component, modes };
