import { S as SvelteComponent, i as init, s as safe_not_equal, a as svg_element, b as attr, c as insert, d as append, n as noop, e as detach, q as create_component, m as space, k as empty, u as mount_component, y as group_outros, w as transition_out, z as check_outros, v as transition_in, x as destroy_component, A as createEventDispatcher, F as bubble, f as element, h as text, j as set_data, H as src_url_equal, l as listen, r as run_all, D as binding_callbacks, J as bind, G as add_flush_callback, K as component_subscribe, X, L as assign, M as StatusTracker, N as get_spread_update, O as get_spread_object } from './index.f7dca8f9.js';
import { B as Block } from './Block.c2fd6529.js';
import { n as normalise_file } from './utils.49185b04.js';
import { U as Upload } from './Upload.66ad8679.js';
import { M as ModifyUpload } from './ModifyUpload.9d1833c7.js';
import { B as BlockLabel } from './BlockLabel.4fe738e8.js';
import { W as Webcam } from './Webcam.c2644275.js';
import './styles.db46e346.js';

/* Users/aliabid/projects/gradio/ui/packages/icons/src/Video.svelte generated by Svelte v3.47.0 */

function create_fragment$3(ctx) {
	let svg;
	let polygon;
	let rect;

	return {
		c() {
			svg = svg_element("svg");
			polygon = svg_element("polygon");
			rect = svg_element("rect");
			attr(polygon, "points", "23 7 16 12 23 17 23 7");
			attr(rect, "x", "1");
			attr(rect, "y", "5");
			attr(rect, "width", "15");
			attr(rect, "height", "14");
			attr(rect, "rx", "2");
			attr(rect, "ry", "2");
			attr(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr(svg, "width", "100%");
			attr(svg, "height", "100%");
			attr(svg, "viewBox", "0 0 24 24");
			attr(svg, "fill", "none");
			attr(svg, "stroke", "currentColor");
			attr(svg, "stroke-width", "1.5");
			attr(svg, "stroke-linecap", "round");
			attr(svg, "stroke-linejoin", "round");
			attr(svg, "class", "feather feather-video");
		},
		m(target, anchor) {
			insert(target, svg, anchor);
			append(svg, polygon);
			append(svg, rect);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(svg);
		}
	};
}

class Video extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, null, create_fragment$3, safe_not_equal, {});
	}
}

const prettyBytes = (bytes) => {
  let units = ["B", "KB", "MB", "GB", "PB"];
  let i = 0;
  while (bytes > 1024) {
    bytes /= 1024;
    i++;
  }
  let unit = units[i];
  return bytes.toFixed(1) + " " + unit;
};
const playable = (filename) => {
  return true;
};

/* Users/aliabid/projects/gradio/ui/packages/video/src/Video.svelte generated by Svelte v3.47.0 */

function create_else_block$2(ctx) {
	let modifyupload;
	let t;
	let show_if;
	let if_block_anchor;
	let current;
	modifyupload = new ModifyUpload({});
	modifyupload.$on("clear", /*handle_clear*/ ctx[10]);

	function select_block_type_2(ctx, dirty) {
		if (dirty & /*value*/ 1) show_if = null;
		if (show_if == null) show_if = !!playable(/*value*/ ctx[0].name);
		if (show_if) return create_if_block_3;
		if (/*value*/ ctx[0].size) return create_if_block_4;
	}

	let current_block_type = select_block_type_2(ctx, -1);
	let if_block = current_block_type && current_block_type(ctx);

	return {
		c() {
			create_component(modifyupload.$$.fragment);
			t = space();
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(modifyupload, target, anchor);
			insert(target, t, anchor);
			if (if_block) if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type_2(ctx, dirty)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if (if_block) if_block.d(1);
				if_block = current_block_type && current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in(modifyupload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(modifyupload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(modifyupload, detaching);
			if (detaching) detach(t);

			if (if_block) {
				if_block.d(detaching);
			}

			if (detaching) detach(if_block_anchor);
		}
	};
}

// (29:0) {#if value === null}
function create_if_block$2(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_1, create_if_block_2];
	const if_blocks = [];

	function select_block_type_1(ctx, dirty) {
		if (/*source*/ ctx[1] === "upload") return 0;
		if (/*source*/ ctx[1] === "webcam") return 1;
		return -1;
	}

	if (~(current_block_type_index = select_block_type_1(ctx))) {
		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(target, anchor);
			}

			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_1(ctx);

			if (current_block_type_index === previous_block_index) {
				if (~current_block_type_index) {
					if_blocks[current_block_type_index].p(ctx, dirty);
				}
			} else {
				if (if_block) {
					group_outros();

					transition_out(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros();
				}

				if (~current_block_type_index) {
					if_block = if_blocks[current_block_type_index];

					if (!if_block) {
						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block.c();
					} else {
						if_block.p(ctx, dirty);
					}

					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				} else {
					if_block = null;
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d(detaching);
			}

			if (detaching) detach(if_block_anchor);
		}
	};
}

// (62:22) 
function create_if_block_4(ctx) {
	let div0;
	let t0_value = /*value*/ ctx[0].name + "";
	let t0;
	let t1;
	let div1;
	let t2_value = prettyBytes(/*value*/ ctx[0].size) + "";
	let t2;

	return {
		c() {
			div0 = element("div");
			t0 = text(t0_value);
			t1 = space();
			div1 = element("div");
			t2 = text(t2_value);
			attr(div0, "class", "file-name text-4xl p-6 break-all");
			attr(div1, "class", "file-size text-2xl p-2");
		},
		m(target, anchor) {
			insert(target, div0, anchor);
			append(div0, t0);
			insert(target, t1, anchor);
			insert(target, div1, anchor);
			append(div1, t2);
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && t0_value !== (t0_value = /*value*/ ctx[0].name + "")) set_data(t0, t0_value);
			if (dirty & /*value*/ 1 && t2_value !== (t2_value = prettyBytes(/*value*/ ctx[0].size) + "")) set_data(t2, t2_value);
		},
		d(detaching) {
			if (detaching) detach(div0);
			if (detaching) detach(t1);
			if (detaching) detach(div1);
		}
	};
}

// (50:1) {#if playable(value.name)}
function create_if_block_3(ctx) {
	let video;
	let video_src_value;
	let mounted;
	let dispose;

	return {
		c() {
			video = element("video");
			attr(video, "class", "w-full h-full object-contain bg-black");
			video.controls = true;
			video.playsInline = true;
			attr(video, "preload", "auto");
			if (!src_url_equal(video.src, video_src_value = /*value*/ ctx[0].data)) attr(video, "src", video_src_value);
		},
		m(target, anchor) {
			insert(target, video, anchor);

			if (!mounted) {
				dispose = [
					listen(video, "play", /*play_handler*/ ctx[11]),
					listen(video, "pause", /*pause_handler*/ ctx[12]),
					listen(video, "ended", /*ended_handler*/ ctx[13])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && !src_url_equal(video.src, video_src_value = /*value*/ ctx[0].data)) {
				attr(video, "src", video_src_value);
			}
		},
		d(detaching) {
			if (detaching) detach(video);
			mounted = false;
			run_all(dispose);
		}
	};
}

// (42:31) 
function create_if_block_2(ctx) {
	let webcam;
	let current;
	webcam = new Webcam({ props: { mode: "video" } });
	webcam.$on("capture", /*capture_handler*/ ctx[15]);

	return {
		c() {
			create_component(webcam.$$.fragment);
		},
		m(target, anchor) {
			mount_component(webcam, target, anchor);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(webcam.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(webcam.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(webcam, detaching);
		}
	};
}

// (30:1) {#if source === "upload"}
function create_if_block_1(ctx) {
	let upload;
	let updating_dragging;
	let current;

	function upload_dragging_binding(value) {
		/*upload_dragging_binding*/ ctx[14](value);
	}

	let upload_props = {
		filetype: "video/mp4,video/x-m4v,video/*",
		$$slots: { default: [create_default_slot$1] },
		$$scope: { ctx }
	};

	if (/*dragging*/ ctx[7] !== void 0) {
		upload_props.dragging = /*dragging*/ ctx[7];
	}

	upload = new Upload({ props: upload_props });
	binding_callbacks.push(() => bind(upload, 'dragging', upload_dragging_binding));
	upload.$on("load", /*handle_load*/ ctx[9]);

	return {
		c() {
			create_component(upload.$$.fragment);
		},
		m(target, anchor) {
			mount_component(upload, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const upload_changes = {};

			if (dirty & /*$$scope, upload_text, or_text, drop_text*/ 65648) {
				upload_changes.$$scope = { dirty, ctx };
			}

			if (!updating_dragging && dirty & /*dragging*/ 128) {
				updating_dragging = true;
				upload_changes.dragging = /*dragging*/ ctx[7];
				add_flush_callback(() => updating_dragging = false);
			}

			upload.$set(upload_changes);
		},
		i(local) {
			if (current) return;
			transition_in(upload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(upload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(upload, detaching);
		}
	};
}

// (31:2) <Upload    bind:dragging    filetype="video/mp4,video/x-m4v,video/*"    on:load={handle_load}   >
function create_default_slot$1(ctx) {
	let div;
	let t0;
	let t1;
	let span;
	let t2;
	let t3;
	let t4;
	let t5;
	let t6;

	return {
		c() {
			div = element("div");
			t0 = text(/*drop_text*/ ctx[4]);
			t1 = space();
			span = element("span");
			t2 = text("- ");
			t3 = text(/*or_text*/ ctx[5]);
			t4 = text(" -");
			t5 = space();
			t6 = text(/*upload_text*/ ctx[6]);
			attr(span, "class", "text-gray-300");
			attr(div, "class", "flex flex-col");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, t0);
			append(div, t1);
			append(div, span);
			append(span, t2);
			append(span, t3);
			append(span, t4);
			append(div, t5);
			append(div, t6);
		},
		p(ctx, dirty) {
			if (dirty & /*drop_text*/ 16) set_data(t0, /*drop_text*/ ctx[4]);
			if (dirty & /*or_text*/ 32) set_data(t3, /*or_text*/ ctx[5]);
			if (dirty & /*upload_text*/ 64) set_data(t6, /*upload_text*/ ctx[6]);
		},
		d(detaching) {
			if (detaching) detach(div);
		}
	};
}

function create_fragment$2(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[3],
				Icon: Video,
				label: /*label*/ ctx[2] || "Video"
			}
		});

	const if_block_creators = [create_if_block$2, create_else_block$2];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0] === null) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 8) blocklabel_changes.show_label = /*show_label*/ ctx[3];
			if (dirty & /*label*/ 4) blocklabel_changes.label = /*label*/ ctx[2] || "Video";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { value = null } = $$props;
	let { source } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	let { drop_text = "Drop a video file" } = $$props;
	let { or_text = "or" } = $$props;
	let { upload_text = "click to upload" } = $$props;
	const dispatch = createEventDispatcher();

	function handle_load({ detail }) {
		dispatch("change", detail);
		$$invalidate(0, value = detail);
	}

	function handle_clear({ detail }) {
		$$invalidate(0, value = null);
		dispatch("change", detail);
		dispatch("clear");
	}

	let dragging = false;

	function play_handler(event) {
		bubble.call(this, $$self, event);
	}

	function pause_handler(event) {
		bubble.call(this, $$self, event);
	}

	function ended_handler(event) {
		bubble.call(this, $$self, event);
	}

	function upload_dragging_binding(value) {
		dragging = value;
		$$invalidate(7, dragging);
	}

	const capture_handler = ({ detail }) => dispatch("change", detail);

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('source' in $$props) $$invalidate(1, source = $$props.source);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(3, show_label = $$props.show_label);
		if ('drop_text' in $$props) $$invalidate(4, drop_text = $$props.drop_text);
		if ('or_text' in $$props) $$invalidate(5, or_text = $$props.or_text);
		if ('upload_text' in $$props) $$invalidate(6, upload_text = $$props.upload_text);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*dragging*/ 128) {
			dispatch("drag", dragging);
		}
	};

	return [
		value,
		source,
		label,
		show_label,
		drop_text,
		or_text,
		upload_text,
		dragging,
		dispatch,
		handle_load,
		handle_clear,
		play_handler,
		pause_handler,
		ended_handler,
		upload_dragging_binding,
		capture_handler
	];
}

class Video_1$2 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$2, create_fragment$2, safe_not_equal, {
			value: 0,
			source: 1,
			label: 2,
			show_label: 3,
			drop_text: 4,
			or_text: 5,
			upload_text: 6
		});
	}
}

/* Users/aliabid/projects/gradio/ui/packages/video/src/StaticVideo.svelte generated by Svelte v3.47.0 */

function create_else_block$1(ctx) {
	let video;
	let video_src_value;
	let mounted;
	let dispose;

	return {
		c() {
			video = element("video");
			attr(video, "class", "w-full h-full object-contain bg-black");
			video.controls = true;
			video.playsInline = true;
			attr(video, "preload", "auto");
			if (!src_url_equal(video.src, video_src_value = /*value*/ ctx[0].data)) attr(video, "src", video_src_value);
		},
		m(target, anchor) {
			insert(target, video, anchor);

			if (!mounted) {
				dispose = [
					listen(video, "play", /*play_handler*/ ctx[3]),
					listen(video, "pause", /*pause_handler*/ ctx[4]),
					listen(video, "ended", /*ended_handler*/ ctx[5])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty & /*value*/ 1 && !src_url_equal(video.src, video_src_value = /*value*/ ctx[0].data)) {
				attr(video, "src", video_src_value);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(video);
			mounted = false;
			run_all(dispose);
		}
	};
}

// (12:0) {#if value === null}
function create_if_block$1(ctx) {
	let div1;
	let div0;
	let video;
	let current;
	video = new Video({});

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			create_component(video.$$.fragment);
			attr(div0, "class", "h-5 dark:text-white opacity-50");
			attr(div1, "class", "h-full min-h-[15rem] flex justify-center items-center");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			mount_component(video, div0, null);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(video.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(video.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			destroy_component(video);
		}
	};
}

function create_fragment$1(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[2],
				Icon: Video,
				label: /*label*/ ctx[1] || "Video"
			}
		});

	const if_block_creators = [create_if_block$1, create_else_block$1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0] === null) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 4) blocklabel_changes.show_label = /*show_label*/ ctx[2];
			if (dirty & /*label*/ 2) blocklabel_changes.label = /*label*/ ctx[1] || "Video";
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(blocklabel, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { value = null } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	const dispatch = createEventDispatcher();

	function play_handler(event) {
		bubble.call(this, $$self, event);
	}

	function pause_handler(event) {
		bubble.call(this, $$self, event);
	}

	function ended_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			value && dispatch("change", value);
		}
	};

	return [value, label, show_label, play_handler, pause_handler, ended_handler];
}

class StaticVideo extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { value: 0, label: 1, show_label: 2 });
	}
}

/* src/components/Video/Video.svelte generated by Svelte v3.47.0 */

function create_else_block(ctx) {
	let video;
	let current;

	video = new Video_1$2({
			props: {
				value: /*_value*/ ctx[9],
				label: /*label*/ ctx[3],
				show_label: /*show_label*/ ctx[5],
				source: /*source*/ ctx[4],
				drop_text: /*$_*/ ctx[11]("interface.drop_video"),
				or_text: /*$_*/ ctx[11]("or"),
				upload_text: /*$_*/ ctx[11]("interface.click_to_upload")
			}
		});

	video.$on("change", /*change_handler_1*/ ctx[13]);
	video.$on("drag", /*drag_handler*/ ctx[14]);
	video.$on("change", /*change_handler*/ ctx[15]);
	video.$on("clear", /*clear_handler*/ ctx[16]);
	video.$on("play", /*play_handler*/ ctx[17]);
	video.$on("pause", /*pause_handler*/ ctx[18]);

	return {
		c() {
			create_component(video.$$.fragment);
		},
		m(target, anchor) {
			mount_component(video, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const video_changes = {};
			if (dirty & /*_value*/ 512) video_changes.value = /*_value*/ ctx[9];
			if (dirty & /*label*/ 8) video_changes.label = /*label*/ ctx[3];
			if (dirty & /*show_label*/ 32) video_changes.show_label = /*show_label*/ ctx[5];
			if (dirty & /*source*/ 16) video_changes.source = /*source*/ ctx[4];
			if (dirty & /*$_*/ 2048) video_changes.drop_text = /*$_*/ ctx[11]("interface.drop_video");
			if (dirty & /*$_*/ 2048) video_changes.or_text = /*$_*/ ctx[11]("or");
			if (dirty & /*$_*/ 2048) video_changes.upload_text = /*$_*/ ctx[11]("interface.click_to_upload");
			video.$set(video_changes);
		},
		i(local) {
			if (current) return;
			transition_in(video.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(video.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(video, detaching);
		}
	};
}

// (33:1) {#if mode === "static"}
function create_if_block(ctx) {
	let staticvideo;
	let current;

	staticvideo = new StaticVideo({
			props: {
				value: /*_value*/ ctx[9],
				label: /*label*/ ctx[3],
				show_label: /*show_label*/ ctx[5]
			}
		});

	return {
		c() {
			create_component(staticvideo.$$.fragment);
		},
		m(target, anchor) {
			mount_component(staticvideo, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const staticvideo_changes = {};
			if (dirty & /*_value*/ 512) staticvideo_changes.value = /*_value*/ ctx[9];
			if (dirty & /*label*/ 8) staticvideo_changes.label = /*label*/ ctx[3];
			if (dirty & /*show_label*/ 32) staticvideo_changes.show_label = /*show_label*/ ctx[5];
			staticvideo.$set(staticvideo_changes);
		},
		i(local) {
			if (current) return;
			transition_in(staticvideo.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(staticvideo.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(staticvideo, detaching);
		}
	};
}

// (21:0) <Block  {visible}  variant={mode === "dynamic" && value === null && source === "upload"   ? "dashed"   : "solid"}  color={dragging ? "green" : "grey"}  padding={false}  {elem_id}  style={{ rounded: style.rounded, height: style.height, width: style.width }} >
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[6]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });
	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*mode*/ ctx[8] === "static") return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 64)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[6])])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			if_blocks[current_block_type_index].d(detaching);
			if (detaching) detach(if_block_anchor);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[2],
				variant: /*mode*/ ctx[8] === "dynamic" && /*value*/ ctx[0] === null && /*source*/ ctx[4] === "upload"
				? "dashed"
				: "solid",
				color: /*dragging*/ ctx[10] ? "green" : "grey",
				padding: false,
				elem_id: /*elem_id*/ ctx[1],
				style: {
					rounded: /*style*/ ctx[7].rounded,
					height: /*style*/ ctx[7].height,
					width: /*style*/ ctx[7].width
				},
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];

			if (dirty & /*mode, value, source*/ 273) block_changes.variant = /*mode*/ ctx[8] === "dynamic" && /*value*/ ctx[0] === null && /*source*/ ctx[4] === "upload"
			? "dashed"
			: "solid";

			if (dirty & /*dragging*/ 1024) block_changes.color = /*dragging*/ ctx[10] ? "green" : "grey";
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];

			if (dirty & /*style*/ 128) block_changes.style = {
				rounded: /*style*/ ctx[7].rounded,
				height: /*style*/ ctx[7].height,
				width: /*style*/ ctx[7].width
			};

			if (dirty & /*$$scope, _value, label, show_label, mode, source, $_, value, dragging, loading_status*/ 528249) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let $_;
	component_subscribe($$self, X, $$value => $$invalidate(11, $_ = $$value));
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = null } = $$props;
	let { label } = $$props;
	let { source } = $$props;
	let { root } = $$props;
	let { show_label } = $$props;
	let { loading_status } = $$props;
	let { style = {} } = $$props;
	let { mode } = $$props;
	let _value;
	let dragging = false;
	const change_handler_1 = ({ detail }) => $$invalidate(0, value = detail);
	const drag_handler = ({ detail }) => $$invalidate(10, dragging = detail);

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	function clear_handler(event) {
		bubble.call(this, $$self, event);
	}

	function play_handler(event) {
		bubble.call(this, $$self, event);
	}

	function pause_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('source' in $$props) $$invalidate(4, source = $$props.source);
		if ('root' in $$props) $$invalidate(12, root = $$props.root);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(6, loading_status = $$props.loading_status);
		if ('style' in $$props) $$invalidate(7, style = $$props.style);
		if ('mode' in $$props) $$invalidate(8, mode = $$props.mode);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value, root*/ 4097) {
			$$invalidate(9, _value = normalise_file(value, root));
		}
	};

	return [
		value,
		elem_id,
		visible,
		label,
		source,
		show_label,
		loading_status,
		style,
		mode,
		_value,
		dragging,
		$_,
		root,
		change_handler_1,
		drag_handler,
		change_handler,
		clear_handler,
		play_handler,
		pause_handler
	];
}

class Video_1 extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 0,
			label: 3,
			source: 4,
			root: 12,
			show_label: 5,
			loading_status: 6,
			style: 7,
			mode: 8
		});
	}
}

var Video_1$1 = Video_1;

const modes = ["static", "dynamic"];

export { Video_1$1 as Component, modes };
